/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.update.handler.odds.config;

import com.kingdee.eas.client.startup.config.ClientConfigUtil;
import com.kingdee.eas.client.startup.exception.EASClientException;
import com.kingdee.eas.client.startup.log.ClientStartLogger;
import com.kingdee.eas.client.startup.update.handler.odds.config.DownloadUtil;
import com.kingdee.eas.client.startup.update.handler.odds.config.OddsJar;
import com.kingdee.eas.client.startup.update.handler.odds.config.PropertiesFileUtil;
import com.kingdee.eas.client.startup.util.StringUtil;
import java.io.File;
import java.util.Properties;
import org.apache.log4j.Logger;

class UpdateOddsList {
    private static final String logTitle = "[\u589e\u91cf\u66f4\u65b0] ";
    private static final Logger logger = ClientStartLogger.getLogger();
    private Properties updateOddsListProperties;

    UpdateOddsList() {
        DownloadUtil.download("classloader/updateodds.lst");
        String baseDirPath = ClientConfigUtil.getLocalDirPath();
        File file = new File(baseDirPath + "/classloader/updateodds.lst");
        if (!file.exists()) {
            throw new EASClientException("Properties\u6587\u4ef6[" + file.getAbsolutePath() + "]\u4e0b\u8f7d\u5931\u8d25");
        }
        this.updateOddsListProperties = PropertiesFileUtil.read(file);
    }

    private String getOddsList(String filePath) {
        return this.updateOddsListProperties.getProperty("/" + filePath);
    }

    boolean existOddsFile(String filePath) {
        return !StringUtil.isEmptyValue(this.getOddsList(filePath));
    }

    private String[] getOddsFileList(String filePath) {
        String oddsList = this.getOddsList(filePath);
        if (StringUtil.isEmptyValue(oddsList)) {
            return new String[0];
        }
        return oddsList.split(";");
    }

    OddsJar findOddJar(String filePath, String localVersion, String newestVersion) {
        String[] updateOddsArray = this.getOddsFileList(filePath);
        String keyword = localVersion + "-" + newestVersion + ".jar";
        for (int i = 0; i < updateOddsArray.length; ++i) {
            if (updateOddsArray[i].indexOf(keyword) <= 0) continue;
            int index = updateOddsArray[i].indexOf(",");
            String relativePath = updateOddsArray[i].substring(0, index);
            String md5 = updateOddsArray[i].substring(index + 1);
            logger.info((Object)("[\u589e\u91cf\u66f4\u65b0] \u627e\u5230\u5408\u9002\u7684\u5dee\u5f02\u5305\uff0c\u4e0b\u8f7d\u5dee\u5f02\u5305\uff1a" + relativePath));
            return new OddsJar(relativePath, md5);
        }
        logger.info((Object)("[\u589e\u91cf\u66f4\u65b0] \u670d\u52a1\u7aef\u5dee\u5f02\u6587\u4ef6client/classloader/updateodds.lst\u4e2d \u6ca1\u6709[" + filePath + "]\u5bf9\u5e94\u7684[" + localVersion + "]\u7248\u672c\u5dee\u5f02\u4fe1\u606f\uff0c\u53ef\u80fd\u662f\u7248\u672c\u5dee\u5f02\u592a\u5927, \u8be5\u6587\u4ef6\u4f7f\u7528\u539f\u6709\u903b\u8f91\u8fdb\u884c\u66f4\u65b0"));
        return null;
    }
}

