/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.BizDataCheckInfo;
import com.kingdee.eas.basedata.org.IOrgDataReference;
import org.apache.log4j.Logger;

public class BizDataChecker {
    private static Logger logger = Logger.getLogger((String)BizDataChecker.class.getName());
    private static String[] bizDataClassNames = new String[]{"com.kingdee.eas.fi.fa.manage.FaOrgDaReferenceImp", "com.kingdee.eas.fi.lcm.LCMOrgDaReferenceImp", "com.kingdee.eas.fi.gl.GLOrgDaReferenceImp"};

    public BizDataCheckInfo[] checkBizRefrenceForAdmin(Context ctx, BOSUuid id, BOSObjectType orgType) {
        BizDataCheckInfo[] bdinfos = new BizDataCheckInfo[bizDataClassNames.length];
        for (int i = 0; i < bizDataClassNames.length; ++i) {
            try {
                IOrgDataReference odr = (IOrgDataReference)Class.forName(bizDataClassNames[i]).newInstance();
                bdinfos[i] = odr.checkReferenceForAdminOrg(ctx, id, orgType);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("check reference error:" + e));
            }
        }
        return bdinfos;
    }

    public void updateBizDataForAdmin(Context ctx, BOSUuid parentID, BOSUuid newID, BOSObjectType orgType) {
        for (int i = 0; i < bizDataClassNames.length; ++i) {
            try {
                IOrgDataReference odr = (IOrgDataReference)Class.forName(bizDataClassNames[i]).newInstance();
                odr.updateBizDataForAdminOrg(ctx, parentID, newID, orgType);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("update biz data error:" + e));
            }
        }
    }
}

