/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class ObjectValueForOrgUnitUtils {
    public static boolean fullOrgUnitInfoEquals(FullOrgUnitInfo source, FullOrgUnitInfo target) {
        if (source == target) {
            return true;
        }
        if (source == null || target == null) {
            return false;
        }
        EntityObjectInfo entity = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(source.getBOSType());
        PropertyCollection pc = entity.getInheritedNoDuplicatedProperties();
        for (PropertyInfo property : pc) {
            if (property instanceof OwnPropertyInfo) {
                if (ObjectValueForOrgUnitUtils.ownPropertyEquals((IObjectValue)source, (IObjectValue)target, (OwnPropertyInfo)property)) continue;
                return false;
            }
            if (!(property instanceof LinkPropertyInfo)) continue;
            boolean composite = ObjectValueForOrgUnitUtils.isComposite(entity, (LinkPropertyInfo)property);
            if (ObjectValueForOrgUnitUtils.isAggregation(entity, (LinkPropertyInfo)property, (IObjectValue)source)) {
                IObjectCollection sourceChildCollection = (IObjectCollection)source.get(property.getName());
                IObjectCollection targetChildCollection = (IObjectCollection)target.get(property.getName());
                if (sourceChildCollection.size() != targetChildCollection.size()) {
                    return false;
                }
                for (int i = 0; i < sourceChildCollection.size(); ++i) {
                    IObjectValue sourceChildObject = sourceChildCollection.getObject(i);
                    IObjectValue targetChildObject = targetChildCollection.getObject(i);
                    if (!(composite ? !ObjectValueForOrgUnitUtils.objectValueEquals(sourceChildObject, targetChildObject) : !ObjectValueForOrgUnitUtils.objectValueEqualsPk(sourceChildObject, targetChildObject))) continue;
                    return false;
                }
                continue;
            }
            IObjectValue sourceChildObject = (IObjectValue)source.get(property.getName());
            IObjectValue targetChildObject = (IObjectValue)target.get(property.getName());
            if (!(composite ? !ObjectValueForOrgUnitUtils.objectValueEquals(sourceChildObject, targetChildObject) : !ObjectValueForOrgUnitUtils.objectValueEquals(sourceChildObject, targetChildObject))) continue;
            return false;
        }
        return true;
    }

    public static boolean objectValueEquals(IObjectValue source, IObjectValue target) {
        if (source == target) {
            return true;
        }
        if (source == null || target == null) {
            return false;
        }
        if (!source.getBOSType().equals((Object)target.getBOSType())) {
            return false;
        }
        EntityObjectInfo entity = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(source.getBOSType());
        PropertyCollection pc = entity.getInheritedNoDuplicatedProperties();
        for (PropertyInfo property : pc) {
            if (property instanceof OwnPropertyInfo) {
                if (ObjectValueForOrgUnitUtils.ownPropertyEquals(source, target, (OwnPropertyInfo)property)) continue;
                return false;
            }
            if (!(property instanceof LinkPropertyInfo)) continue;
            boolean composite = ObjectValueForOrgUnitUtils.isComposite(entity, (LinkPropertyInfo)property);
            if (ObjectValueForOrgUnitUtils.isAggregation(entity, (LinkPropertyInfo)property, source)) {
                IObjectCollection sourceChildCollection = (IObjectCollection)source.get(property.getName());
                IObjectCollection targetChildCollection = (IObjectCollection)target.get(property.getName());
                if (sourceChildCollection.size() != targetChildCollection.size()) {
                    return false;
                }
                for (int i = 0; i < sourceChildCollection.size(); ++i) {
                    IObjectValue sourceChildObject = sourceChildCollection.getObject(i);
                    IObjectValue targetChildObject = targetChildCollection.getObject(i);
                    if (!(composite ? !ObjectValueForOrgUnitUtils.objectValueEquals(sourceChildObject, targetChildObject) : !ObjectValueForOrgUnitUtils.objectValueEqualsPk(sourceChildObject, targetChildObject))) continue;
                    return false;
                }
                continue;
            }
            IObjectValue sourceChildObject = (IObjectValue)source.get(property.getName());
            IObjectValue targetChildObject = (IObjectValue)target.get(property.getName());
            if (!(composite ? !ObjectValueForOrgUnitUtils.objectValueEquals(sourceChildObject, targetChildObject) : !ObjectValueForOrgUnitUtils.objectValueEqualsPk(sourceChildObject, targetChildObject))) continue;
            return false;
        }
        return true;
    }

    public static boolean fullOrgUnitInfoEquals(Context ctx, FullOrgUnitInfo source, FullOrgUnitInfo target) {
        if (ctx == null) {
            return false;
        }
        if (source == target) {
            return true;
        }
        if (source == null || target == null) {
            return false;
        }
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(source.getBOSType());
        PropertyCollection pc = entity.getInheritedNoDuplicatedProperties();
        for (PropertyInfo property : pc) {
            if (property instanceof OwnPropertyInfo) {
                if (ObjectValueForOrgUnitUtils.ownPropertyEquals((IObjectValue)source, (IObjectValue)target, (OwnPropertyInfo)property)) continue;
                return false;
            }
            if (!(property instanceof LinkPropertyInfo)) continue;
            boolean composite = ObjectValueForOrgUnitUtils.isComposite(entity, (LinkPropertyInfo)property);
            if (ObjectValueForOrgUnitUtils.isAggregation(entity, (LinkPropertyInfo)property, (IObjectValue)source)) {
                IObjectCollection sourceChildCollection = (IObjectCollection)source.get(property.getName());
                IObjectCollection targetChildCollection = (IObjectCollection)target.get(property.getName());
                if (sourceChildCollection.size() != targetChildCollection.size()) {
                    return false;
                }
                for (int i = 0; i < sourceChildCollection.size(); ++i) {
                    IObjectValue sourceChildObject = sourceChildCollection.getObject(i);
                    IObjectValue targetChildObject = targetChildCollection.getObject(i);
                    if (!(composite ? !ObjectValueForOrgUnitUtils.objectValueEquals(ctx, sourceChildObject, targetChildObject) : !ObjectValueForOrgUnitUtils.objectValueEqualsPk(ctx, sourceChildObject, targetChildObject))) continue;
                    return false;
                }
                continue;
            }
            IObjectValue sourceChildObject = (IObjectValue)source.get(property.getName());
            IObjectValue targetChildObject = (IObjectValue)target.get(property.getName());
            if (!(composite ? !ObjectValueForOrgUnitUtils.objectValueEquals(ctx, sourceChildObject, targetChildObject) : !ObjectValueForOrgUnitUtils.objectValueEquals(ctx, sourceChildObject, targetChildObject))) continue;
            return false;
        }
        return true;
    }

    public static boolean objectValueEquals(Context ctx, IObjectValue source, IObjectValue target) {
        if (ctx == null) {
            return false;
        }
        if (source == target) {
            return true;
        }
        if (source == null || target == null) {
            return false;
        }
        if (!source.getBOSType().equals((Object)target.getBOSType())) {
            return false;
        }
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(source.getBOSType());
        PropertyCollection pc = entity.getInheritedNoDuplicatedProperties();
        for (PropertyInfo property : pc) {
            if (property instanceof OwnPropertyInfo) {
                if (ObjectValueForOrgUnitUtils.ownPropertyEquals(source, target, (OwnPropertyInfo)property)) continue;
                return false;
            }
            if (!(property instanceof LinkPropertyInfo)) continue;
            boolean composite = ObjectValueForOrgUnitUtils.isComposite(entity, (LinkPropertyInfo)property);
            if (ObjectValueForOrgUnitUtils.isAggregation(entity, (LinkPropertyInfo)property, source)) {
                IObjectCollection sourceChildCollection = (IObjectCollection)source.get(property.getName());
                IObjectCollection targetChildCollection = (IObjectCollection)target.get(property.getName());
                if (sourceChildCollection.size() != targetChildCollection.size()) {
                    return false;
                }
                for (int i = 0; i < sourceChildCollection.size(); ++i) {
                    IObjectValue sourceChildObject = sourceChildCollection.getObject(i);
                    IObjectValue targetChildObject = targetChildCollection.getObject(i);
                    if (!(composite ? !ObjectValueForOrgUnitUtils.objectValueEquals(ctx, sourceChildObject, targetChildObject) : !ObjectValueForOrgUnitUtils.objectValueEqualsPk(ctx, sourceChildObject, targetChildObject))) continue;
                    return false;
                }
                continue;
            }
            IObjectValue sourceChildObject = (IObjectValue)source.get(property.getName());
            IObjectValue targetChildObject = (IObjectValue)target.get(property.getName());
            if (!(composite ? !ObjectValueForOrgUnitUtils.objectValueEquals(ctx, sourceChildObject, targetChildObject) : !ObjectValueForOrgUnitUtils.objectValueEqualsPk(ctx, sourceChildObject, targetChildObject))) continue;
            return false;
        }
        return true;
    }

    public static boolean objectValueEqualsPk(Context ctx, IObjectValue source, IObjectValue target) {
        if (ctx == null) {
            return false;
        }
        return ObjectValueForOrgUnitUtils.objectValueEqualsPk(source, target);
    }

    public static boolean objectValueEqualsPk(IObjectValue source, IObjectValue target) {
        if (source == null && target == null) {
            return true;
        }
        if (source != null && target != null) {
            Object sourceId = source.get(source.getPKField());
            Object targetId = target.get(target.getPKField());
            if (sourceId == null && targetId == null) {
                return true;
            }
            if (sourceId != null && targetId != null) {
                return sourceId.toString().equals(targetId.toString());
            }
            return false;
        }
        return false;
    }

    public static boolean isAggregation(EntityObjectInfo entity, LinkPropertyInfo property, IObjectValue source) {
        return source.get(property.getName()) instanceof IObjectCollection;
    }

    public static boolean isComposite(EntityObjectInfo entity, LinkPropertyInfo property) {
        return property.getRelationship().getType().equals((Object)RelationshipType.COMPOSITION) && property.getRelationship().getClientObject().getType().equals((Object)entity.getType());
    }

    public static boolean ownPropertyEquals(IObjectValue source, IObjectValue target, OwnPropertyInfo property) {
        if (property.getDataType().equals((Object)DataType.SHORT)) {
            short targetProperty;
            short sourceProperty = source.getShort(property.getName());
            return sourceProperty == (targetProperty = target.getShort(property.getName()));
        }
        if (property.getDataType().equals((Object)DataType.INTEGER)) {
            int targetProperty;
            int sourceProperty = source.getInt(property.getName());
            return sourceProperty == (targetProperty = target.getInt(property.getName()));
        }
        if (property.getDataType().equals((Object)DataType.LONG)) {
            long targetProperty;
            long sourceProperty = source.getLong(property.getName());
            return sourceProperty == (targetProperty = target.getLong(property.getName()));
        }
        if (property.getDataType().equals((Object)DataType.FLOAT)) {
            float targetProperty;
            float sourceProperty = source.getFloat(property.getName());
            return sourceProperty == (targetProperty = target.getFloat(property.getName()));
        }
        if (property.getDataType().equals((Object)DataType.DOUBLE)) {
            double targetProperty;
            double sourceProperty = source.getDouble(property.getName());
            return sourceProperty == (targetProperty = target.getDouble(property.getName()));
        }
        if (property.getDataType().equals((Object)DataType.ENUM)) {
            Object sourceobj = source.get(property.getName());
            Object targetObj = target.get(property.getName());
            if (sourceobj != null) {
                return sourceobj.equals(targetObj);
            }
            if (targetObj != null) {
                return targetObj.equals(sourceobj);
            }
            return true;
        }
        if (property.getDataType().equals((Object)DataType.BOOLEAN)) {
            boolean targetProperty;
            boolean sourceProperty = source.getBoolean(property.getName());
            return sourceProperty == (targetProperty = target.getBoolean(property.getName()));
        }
        if (property.getDataType().equals((Object)DataType.BYTE)) {
            byte targetProperty;
            byte sourceProperty = source.getByte(property.getName());
            return sourceProperty == (targetProperty = target.getByte(property.getName()));
        }
        if (property.getDataType().equals((Object)DataType.DECIMAL)) {
            BigDecimal sourceProperty = source.getBigDecimal(property.getName());
            BigDecimal targetProperty = target.getBigDecimal(property.getName());
            return ObjectValueForOrgUnitUtils.bigDecimalEquals(sourceProperty, targetProperty);
        }
        if (property.getDataType().equals((Object)DataType.STRING)) {
            String sourceProperty = source.getString(property.getName());
            String targetProperty = target.getString(property.getName());
            return ObjectValueForOrgUnitUtils.stringEquals(sourceProperty, targetProperty);
        }
        if (property.getDataType().equals((Object)DataType.BYTEARRAY)) {
            byte[] sourceProperty = source.getBytes(property.getName());
            byte[] targetProperty = target.getBytes(property.getName());
            return ObjectValueForOrgUnitUtils.byteArrayEquals(sourceProperty, targetProperty);
        }
        if (property.getDataType().equals((Object)DataType.DATE)) {
            Date sourceProperty = source.getDate(property.getName());
            Date targetProperty = target.getDate(property.getName());
            return ObjectValueForOrgUnitUtils.objectEquals(sourceProperty, targetProperty);
        }
        if (property.getDataType().equals((Object)DataType.TIME)) {
            Time sourceProperty = source.getTime(property.getName());
            Time targetProperty = target.getTime(property.getName());
            return ObjectValueForOrgUnitUtils.objectEquals(sourceProperty, targetProperty);
        }
        if (property.getDataType().equals((Object)DataType.TIMESTAMP)) {
            Timestamp sourceProperty = source.getTimestamp(property.getName());
            Timestamp targetProperty = target.getTimestamp(property.getName());
            return ObjectValueForOrgUnitUtils.objectEquals(sourceProperty, targetProperty);
        }
        if (property.getDataType().equals((Object)DataType.CHAR)) {
            Character sourceProperty = (Character)source.get(property.getName());
            Character targetProperty = (Character)target.get(property.getName());
            return ObjectValueForOrgUnitUtils.objectEquals(sourceProperty, targetProperty);
        }
        if (property.getDataType().equals((Object)DataType.BOSUUID)) {
            BOSUuid sourceProperty = source.getBOSUuid(property.getName());
            BOSUuid targetProperty = target.getBOSUuid(property.getName());
            return ObjectValueForOrgUnitUtils.objectEquals(sourceProperty, targetProperty);
        }
        if (property.getDataType().equals((Object)DataType.UUID)) {
            Uuid sourceProperty = source.getUuid(property.getName());
            Uuid targetProperty = target.getUuid(property.getName());
            return ObjectValueForOrgUnitUtils.objectEquals(sourceProperty, targetProperty);
        }
        Object sourceProperty = source.get(property.getName());
        Object targetProperty = target.get(property.getName());
        return ObjectValueForOrgUnitUtils.objectEquals(sourceProperty, targetProperty);
    }

    protected static final boolean stringEquals(String source, String target) {
        return StringUtils.equals((String)source, (String)target);
    }

    protected static final boolean bigDecimalEquals(BigDecimal source, BigDecimal target) {
        if (source == null) {
            source = SysConstant.BIGZERO;
        }
        if (target == null) {
            target = SysConstant.BIGZERO;
        }
        return source.compareTo(target) == 0;
    }

    protected static final boolean byteArrayEquals(byte[] source, byte[] target) {
        if (source == target) {
            return true;
        }
        if (source == null || target == null) {
            return false;
        }
        String tempSource = new String(source);
        String tempTarget = new String(target);
        return ObjectValueForOrgUnitUtils.objectEquals(tempSource, tempTarget);
    }

    protected static final boolean objectEquals(Object source, Object target) {
        if (source == null && target == null) {
            return true;
        }
        if (source != null && target != null) {
            return source.equals(target);
        }
        return false;
    }
}

