/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CUBDControlCollection;
import com.kingdee.eas.basedata.org.CUBDControlFactory;
import com.kingdee.eas.basedata.org.CUBDControlInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.app.AbstractCUBDControlControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import org.apache.log4j.Logger;

public class CUBDControlControllerBean
extends AbstractCUBDControlControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.org.app.CUBDControlControllerBean");

    @Override
    protected IObjectValue _getBDCtrlInfo(Context ctx, String bosType, String cuID) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("BDBOSType", (Object)bosType, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuID, CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        if (!this.exists(ctx, filter)) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        CUBDControlCollection col = this.getCUBDControlCollection(ctx, viewInfo);
        return col.get(0);
    }

    @Override
    protected void _syncDataToSub(Context ctx, String bdControlId, String cuLongNumber) throws BOSException, EASBizException {
        String oql = "select id where LongNumber like '" + cuLongNumber + "!%' and IsAssistantOrg = 0 and IsCU = 1";
        FullOrgUnitCollection fullOrgUnitInfos = FullOrgUnitFactory.getLocalInstance(ctx).getFullOrgUnitCollection(oql);
        String[] ids = new String[fullOrgUnitInfos.size()];
        for (int i = 0; i < fullOrgUnitInfos.size(); ++i) {
            FullOrgUnitInfo fullOrgUnitInfo = fullOrgUnitInfos.get(i);
            ids[i] = fullOrgUnitInfo.getId().toString();
        }
        this.syncDataExecute(ctx, bdControlId, ids);
    }

    @Override
    protected void _syncDataToCu(Context ctx, String id, String[] cus) throws BOSException, EASBizException {
        this.syncDataExecute(ctx, id, cus);
    }

    private void syncDataExecute(Context ctx, String id, String[] ids) throws EASBizException, BOSException {
        if (ids.length > 0) {
            CUBDControlInfo cubdControlInfo = CUBDControlFactory.getLocalInstance(ctx).getCUBDControlInfo((IObjectPK)new ObjectUuidPK(id));
            String sql = "update T_ORG_CUBDControl set FIsSuperiorViewable = " + (cubdControlInfo.isIsSuperiorViewable() ? 1 : 0) + ", FIsSubordinateAddnewable = " + (cubdControlInfo.isIsSubordinateAddnewable() ? 1 : 0) + ", FIsSubordinateEditable =  " + (cubdControlInfo.isIsSubordinateEditable() ? 1 : 0) + ", FIsSubordinateDeletable =  " + (cubdControlInfo.isIsSubordinateDeletable() ? 1 : 0) + ", FIsSubordinateUpgradable =  " + (cubdControlInfo.isIsSubordinateUpgradable() ? 1 : 0) + ", FDispatchPattern =  " + cubdControlInfo.getDispatchPattern().getValue() + ", FIsSubordinateAssign =  " + (cubdControlInfo.isIsSubordinateAssign() ? 1 : 0) + " where FControlUnitId in " + this.getSqlINCondition(ids) + "  and FBDBOSType = '" + cubdControlInfo.getBDBOSType() + "'";
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    private String getSqlINCondition(Object[] items) {
        if (items != null && items.length > 0) {
            StringBuffer condition = new StringBuffer("(");
            for (int i = 0; i < items.length; ++i) {
                condition.append("'").append(items[i]).append("'");
                if (i >= items.length - 1) continue;
                condition.append(",");
            }
            return condition.append(")").toString();
        }
        return "('')";
    }
}

