/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOUInnerFacade;
import com.kingdee.eas.basedata.org.IOUPartFI;
import com.kingdee.eas.basedata.org.IOrgUnitLayer;
import com.kingdee.eas.basedata.org.IOrgUnitLayerType;
import com.kingdee.eas.basedata.org.IOrgVersionMgrFacade;
import com.kingdee.eas.basedata.org.IOrgView;
import com.kingdee.eas.basedata.org.NewOUInnerFacadeFactory;
import com.kingdee.eas.basedata.org.NewOrgUnitFacadeFactory;
import com.kingdee.eas.basedata.org.OUPartCoreBaseCollection;
import com.kingdee.eas.basedata.org.OUPartFIFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitLayerCollection;
import com.kingdee.eas.basedata.org.OrgUnitLayerFactory;
import com.kingdee.eas.basedata.org.OrgUnitLayerTypeCollection;
import com.kingdee.eas.basedata.org.OrgUnitLayerTypeFactory;
import com.kingdee.eas.basedata.org.OrgUnitLayerTypeInfo;
import com.kingdee.eas.basedata.org.OrgVersionMgrFacadeFactory;
import com.kingdee.eas.basedata.org.OrgViewFactory;
import com.kingdee.eas.basedata.org.app.AbstractOUEditUIHandler;
import com.kingdee.eas.basedata.org.service.OrgCommonUtils;
import com.kingdee.eas.basedata.orgext.IOUPartMarket;
import com.kingdee.eas.basedata.orgext.IOUPartService;
import com.kingdee.eas.basedata.orgext.MarketOrgTypeAddNewInfo;
import com.kingdee.eas.basedata.orgext.OUPartMarketFactory;
import com.kingdee.eas.basedata.orgext.OUPartServiceCollection;
import com.kingdee.eas.basedata.orgext.OUPartServiceFactory;
import com.kingdee.eas.basedata.orgext.ServiceOrgTypeAddNewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.books.AcountSchemeFactory;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.framework.bireport.bimanager.util.StringUtils;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.apache.log4j.Logger;

public class OUEditUIHandler
extends AbstractOUEditUIHandler {
    Logger logger = Logger.getLogger(OUEditUIHandler.class);

    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleInit(request, response, context);
    }

    private boolean isShowOrgNumber(Context ctx) {
        boolean showOrgNumber = false;
        String paramkey = "ShowOrgNumber";
        try {
            String paravalue = ParamManager.getParamValue((Context)ctx, null, (String)paramkey);
            if (paravalue != null && paravalue.equals("true")) {
                showOrgNumber = true;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return showOrgNumber;
    }

    public void _handleBeforeLoadFields(RequestContext request, ResponseContext response, Context context) throws Exception {
        IOrgUnitLayerType iLayerType = OrgUnitLayerTypeFactory.getLocalInstance(context);
        OrgUnitLayerTypeCollection col = iLayerType.getOrgUnitLayerTypeCollection();
        this.loadBizSuperiorAndDelegate(request, response, context);
        FullOrgUnitInfo editData = (FullOrgUnitInfo)request.get("editData");
        CtrlUnitInfo ctrlInfo = (CtrlUnitInfo)request.get("ctrlInfo");
        this.checkCodingRule(context, ctrlInfo.getId().toString());
        this.getFullOrgUnitOUpartInfo(context, editData, request);
        ParamManager.getParamValue((Context)context, null, (String)"G001");
        String value = ParamManager.getParamValue((Context)context, null, (String)"G012");
        if ("true".equalsIgnoreCase(value)) {
            AcountSchemeFactory.getLocalInstance((Context)context).getValue("where id = '00000000-0000-0000-0000-000000000000DDF8E923'");
        }
        IOUPartFI iCom = OUPartFIFactory.getLocalInstance((Context)context);
        String oql = "Select * Where isGroup = 1";
        iCom.exists(oql);
        INewOUInnerFacade iNOUI = NewOUInnerFacadeFactory.getLocalInstance(context);
        HashMap fiProperty = iNOUI.getFIPropertiesOfCU((IObjectPK)new ObjectUuidPK(ctrlInfo.getId()));
        ParamManager.getParamValue((Context)context, null, (String)"isFilterByUserAdminOrgRange");
    }

    private void getFullOrgUnitOUpartInfo(Context context, FullOrgUnitInfo editData, RequestContext request) throws Exception {
        if (editData == null) {
            return;
        }
        boolean isCurVersion = (Boolean)request.get("isCurVersion");
        Set orgTypes = OrgCommonUtils.getOrgTypeCol(editData);
        for (OrgType type : orgTypes) {
            OUPartServiceCollection oUPartServiceCollection;
            String oql;
            if (request.get(type.toString()) != null) {
                SelectorItemCollection selectors = (SelectorItemCollection)request.get(type.toString());
                this.getOUpartInfo(isCurVersion, editData, selectors, type, context);
            }
            if (type.equals((Object)ServiceOrgTypeAddNewInfo.newOrgType)) {
                IOUPartService iOUPartService = OUPartServiceFactory.getLocalInstance((Context)context);
                oql = "select * where unit = '" + editData.getId().toString() + "'";
                oUPartServiceCollection = iOUPartService.getOUPartServiceCollection(oql);
            }
            if (!type.equals((Object)MarketOrgTypeAddNewInfo.newOrgType)) continue;
            IOUPartMarket iOUPartMarket = OUPartMarketFactory.getLocalInstance((Context)context);
            oql = "select * where unit = '" + editData.getId().toString() + "'";
            oUPartServiceCollection = iOUPartMarket.getOUPartMarketCollection(oql);
        }
    }

    protected void _handleActionSubmit(RequestContext request, ResponseContext response, Context context) throws Exception {
        FullOrgUnitInfo editData = (FullOrgUnitInfo)request.get("editData");
        String oprtState = (String)request.get("oprtState");
        this.existFullOrgUnitByName(context, editData);
        if ("ADDNEW".equals(oprtState) && editData.isIsAdminOrgUnit()) {
            NewOrgUnitFacadeFactory.getLocalInstance(context).getXMLOrgBizClasses("clientOrgAddNew", null);
        }
    }

    private void existFullOrgUnitByName(Context context, FullOrgUnitInfo editData) throws Exception {
        if (editData == null || StringUtils.isEmpty((String)editData.getName())) {
            return;
        }
        if (this.isNeedShowOrgNameDup(context)) {
            String oql = "where name = '" + editData.getName().replaceAll("'", "''") + "'";
            if (editData.getId() != null) {
                oql = oql + " and id <> '" + editData.getId().toString() + "'";
            }
            FullOrgUnitFactory.getLocalInstance(context).exists(oql);
        }
    }

    private boolean isNeedShowOrgNameDup(Context context) throws Exception {
        String value = ParamManager.getParamValue((Context)context, null, (String)"ORG001");
        return !"false".equalsIgnoreCase(value);
    }

    private void checkCodingRule(Context context, String currentCtrlUnitId) throws EASBizException, BOSException {
        FullOrgUnitInfo orgUnitInfo = new FullOrgUnitInfo();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)context);
        boolean hasCodeRule = iCodingRuleManager.isExist((IObjectValue)orgUnitInfo, currentCtrlUnitId);
        if (hasCodeRule) {
            iCodingRuleManager.isAddView((IObjectValue)orgUnitInfo, currentCtrlUnitId);
            iCodingRuleManager.isModifiable((IObjectValue)orgUnitInfo, currentCtrlUnitId);
        }
    }

    private IObjectValue getPartDetailInfo(FullOrgUnitInfo fullOrgInfo, OrgType orgType, SelectorItemCollection selector, Context context) throws BOSException, EASBizException {
        IOrgView iOrgView = OrgViewFactory.getLocalInstance(context);
        ArrayList<String> orgIdList = new ArrayList<String>();
        orgIdList.add(fullOrgInfo.getId().toString());
        OUPartCoreBaseCollection oupartCol = iOrgView.getOUPartByOrgInfo(orgIdList, orgType, selector);
        if (oupartCol == null || oupartCol.isEmpty()) {
            throw new IllegalArgumentException("oupart info is not found!");
        }
        return oupartCol.getObject(0);
    }

    private IObjectValue getOUpartInfo(boolean curVersion, FullOrgUnitInfo orgUnitInfo, SelectorItemCollection selector, OrgType orgType, Context context) throws Exception {
        if (curVersion) {
            return this.getPartDetailInfo(orgUnitInfo, orgType, selector, context);
        }
        IOrgVersionMgrFacade iOrgVersion = OrgVersionMgrFacadeFactory.getLocalInstance(context);
        return iOrgVersion.getOUPartVersionInfo(orgType, orgUnitInfo.getVersionNumber(), (IObjectPK)new ObjectStringPK(orgUnitInfo.getId().toString()));
    }

    private void loadBizSuperiorAndDelegate(RequestContext request, ResponseContext response, Context context) throws Exception {
        String oprtState = (String)request.get("oprtState");
        if (!"ADDNEW".equals(oprtState)) {
            ObjectUuidPK pk = (ObjectUuidPK)request.get("pk");
            boolean isCurVersion = (Boolean)request.get("isCurVersion");
            if (isCurVersion) {
                INewOUInnerFacade iNOUI = NewOUInnerFacadeFactory.getLocalInstance(context);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("toUnit.number"));
                sic.add(new SelectorItemInfo("toUnit.name"));
                sic.add(new SelectorItemInfo("isDefault"));
                sic.add(new SelectorItemInfo("typeRelation.toType"));
                sic.add(new SelectorItemInfo("typeRelation.fromType"));
                sic.add(new SelectorItemInfo("typeRelation.existReverseDelegate"));
                iNOUI.loadSuperiorAndDelegateUnits((IObjectPK)pk);
            } else {
                FullOrgUnitInfo editData = (FullOrgUnitInfo)request.get("editData");
                IOrgVersionMgrFacade iOrgVersionMgr = OrgVersionMgrFacadeFactory.getLocalInstance(context);
                iOrgVersionMgr.loadSuperiorAndDelegateUnits(editData);
            }
        }
    }

    private boolean setIsGroup(Context context) throws BOSException, EASBizException {
        String oql;
        IOUPartFI iCom = OUPartFIFactory.getLocalInstance((Context)context);
        return !iCom.exists(oql = "Select * Where isGroup = 1");
    }

    private void setFIProperties(Context context) throws BOSException, EASBizException {
        INewOUInnerFacade iNOUI = NewOUInnerFacadeFactory.getLocalInstance(context);
        CtrlUnitInfo ctrlInfo = ContextUtil.getCurrentCtrlUnit((Context)context);
        HashMap fiProperty = iNOUI.getFIPropertiesOfCU((IObjectPK)new ObjectUuidPK(ctrlInfo.getId()));
    }

    private void loadLayerType(Context context) throws BOSException {
        IOrgUnitLayerType iLayerType = OrgUnitLayerTypeFactory.getLocalInstance(context);
        OrgUnitLayerTypeCollection col = iLayerType.getOrgUnitLayerTypeCollection();
    }

    private OrgUnitLayerCollection getLayerCollection(Context context, OrgUnitLayerTypeInfo typeInfo) throws BOSException, EASBizException {
        if (typeInfo != null) {
            IOrgUnitLayer iLayer = OrgUnitLayerFactory.getLocalInstance(context);
            return iLayer.getOrgUnitLayerCollection("Select * Where layerType.id = '" + typeInfo.getId() + "'");
        }
        return null;
    }

    private void checkPrermission(BOSUuid userId, BOSUuid orgId, Context context) {
        boolean flag_Com = this.checkFunctionPermission("OU_Com_Update", userId, orgId, context);
        boolean flag_Admin = this.checkFunctionPermission("OU_Admin_Update", userId, orgId, context);
        boolean flag_Purchase = this.checkFunctionPermission("OU_Purchase_Update", userId, orgId, context);
        boolean flag_Sale = this.checkFunctionPermission("OU_Sale_Update", userId, orgId, context);
        boolean flag_Storage = this.checkFunctionPermission("OU_Storage_Update", userId, orgId, context);
        boolean flag_Profit = this.checkFunctionPermission("OU_Profit_Update", userId, orgId, context);
        boolean flag_Cost = this.checkFunctionPermission("OU_Cost_Update", userId, orgId, context);
        boolean flag_HRO = this.checkFunctionPermission("OU_HRO_Update", userId, orgId, context);
        boolean flag_Transport = this.checkFunctionPermission("OU_Transport_Update", userId, orgId, context);
        boolean flag_Quality = this.checkFunctionPermission("OU_Quality_Update", userId, orgId, context);
    }

    private boolean checkFunctionPermission(String permItemName, BOSUuid userId, BOSUuid orgId, Context context) {
        IPermission permission = null;
        boolean flag = false;
        try {
            ObjectUuidPK userPk = new ObjectUuidPK("id", userId);
            ObjectUuidPK orgPk = new ObjectUuidPK("id", orgId);
            permission = PermissionFactory.getLocalInstance((Context)context);
            flag = permission.hasFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, permItemName);
        }
        catch (Throwable ex) {
            if (ex instanceof Exception) {
                // empty if block
            }
        }
        return flag;
    }

    @Override
    protected void _handleActionBizSealUp(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionEditAdminOrgType(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionBizUnSealUp(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionViewOrgLog(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionMaintainAssistantOrg(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void _handleActionComUpdate(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void _handleActionAdminUpdate(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void _handleActionSaleUpdate(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void _handleActionPurchaseUpdate(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void _handleActionStorageUpdate(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void _handleActionProfitUpdate(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void _handleActionCostUpdate(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void _handleActionHROUpdate(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void _handleActionTransportUpdate(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void _handleActionQualityUpdate(RequestContext request, ResponseContext response, Context context) throws Exception {
    }
}

