/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AbstractOrgStructureInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.IOtherDealUpdateSortCode;
import com.kingdee.eas.basedata.org.OrgException;
import com.kingdee.eas.basedata.org.OrgSortCodeInfo;
import com.kingdee.eas.basedata.org.OrgSpecialTablesRebuildFacadeFactory;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUtils;
import com.kingdee.eas.basedata.org.app.AbstractOrgStructureControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.dao.RefCheckersDAO;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.StringUtil;
import com.kingdee.eas.util.ToolUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class OrgStructureControllerBean
extends AbstractOrgStructureControllerBean {
    private static Logger logger = Logger.getLogger((String)OrgStructureControllerBean.class.getName());
    public static final Locale locale_L1 = LocaleUtils.getLocale((String)"L1");
    public static final Locale locale_L2 = LocaleUtils.getLocale((String)"L2");
    public static final Locale locale_L3 = LocaleUtils.getLocale((String)"L3");

    public IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        OrgStructureInfo structInfo = (OrgStructureInfo)model;
        String index = "";
        if (structInfo.getParent() == null) {
            structInfo.setLevel(1);
            structInfo.setIsLeaf(true);
            structInfo.setLongNumber(index + structInfo.getUnit().getNumber());
            this.checkLongNumberLen(ctx, structInfo);
            structInfo.setDisplayName(structInfo.getUnit().getName(locale_L1), locale_L1);
            this.limitDisplayNameLength(structInfo, locale_L1);
            structInfo.setDisplayName(structInfo.getUnit().getName(locale_L2), locale_L2);
            this.limitDisplayNameLength(structInfo, locale_L2);
            structInfo.setDisplayName(structInfo.getUnit().getName(locale_L3), locale_L3);
            this.limitDisplayNameLength(structInfo, locale_L3);
        } else {
            OrgStructureInfo parentStructInfo = structInfo.getParent();
            parentStructInfo.setIsLeaf(false);
            super.innerUpdate(ctx, (IObjectPK)new ObjectUuidPK(parentStructInfo.getId()), (IObjectValue)parentStructInfo);
            structInfo.setLevel(parentStructInfo.getLevel() + 1);
            structInfo.setIsLeaf(true);
            structInfo.setLongNumber(parentStructInfo.getLongNumber() + "!" + index + structInfo.getUnit().getNumber());
            if (parentStructInfo.getSortCode() != null && "00000000-0000-0000-0000-0000000000034F2827FD".equals(StringUtils.cnulls((Object)structInfo.getTree().getId()))) {
                int temp2;
                EntityViewInfo entityView = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)parentStructInfo.getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)"00000000-0000-0000-0000-0000000000034F2827FD"));
                SorterItemCollection sorters = new SorterItemCollection();
                SorterItemInfo sorter = new SorterItemInfo("sortcode");
                sorter.setSortType(SortType.DESCEND);
                sorters.add(sorter);
                entityView.setFilter(filter);
                entityView.getSelector().add(new SelectorItemInfo("sortcode"));
                entityView.setTopCount(1);
                entityView.setSorter(sorters);
                OrgStructureCollection structColTemp = this.getOrgStructureCollection(ctx, entityView);
                if (structColTemp != null && structColTemp.size() != 0 && structColTemp.get(0).getSortCode() != null) {
                    String[] temp = structColTemp.get(0).getSortCode().split("!");
                    temp2 = Integer.parseInt(temp[temp.length - 1]);
                } else {
                    temp2 = 0;
                }
                structInfo.setSortCode(parentStructInfo.getSortCode() + "!" + OrgSortCodeInfo.getSortCodeSuffix(temp2 + 1));
            }
            this.checkLongNumberLen(ctx, structInfo);
            this.linkDisplayName(parentStructInfo, structInfo, locale_L1);
            this.limitDisplayNameLength(structInfo, locale_L1);
            this.linkDisplayName(parentStructInfo, structInfo, locale_L2);
            this.limitDisplayNameLength(structInfo, locale_L2);
            this.linkDisplayName(parentStructInfo, structInfo, locale_L3);
            this.limitDisplayNameLength(structInfo, locale_L3);
        }
        IObjectPK pk = this.innerAddnew(ctx, (IObjectValue)structInfo);
        return pk;
    }

    void _checkExistFirst(Context ctx, IObjectValue model) throws BOSException, OrgException {
        OrgStructureInfo structInfo = (OrgStructureInfo)model;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (structInfo.getParent() == null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("tree.id", (Object)structInfo.getTree().getId()));
            filterInfo.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(1)));
            view.setFilter(filterInfo);
            IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
            OrgStructureCollection structCol = iStruct.getOrgStructureCollection(view);
            if (structCol.size() != 0) {
                throw new OrgException(OrgException.ONE_TREE_ONLY_ONECHILDRENTREE);
            }
        }
    }

    protected IObjectValue _getParentOrgUnit(Context ctx, IObjectValue treeInfo, IObjectValue unitInfo) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("tree.id", treeInfo.get("id")));
        filter.getFilterItems().add(new FilterItemInfo("unit.id", unitInfo.get("id")));
        view.setFilter(filter);
        OrgStructureCollection structCol = super.getOrgStructureCollection(ctx, view);
        return structCol.get(0).getUnit();
    }

    @Override
    public IObjectValue _getValue(Context ctx, IObjectValue treeInfo, IObjectValue unitInfo) throws BOSException, EASBizException {
        OrgStructureInfo structInfo = null;
        try {
            StringBuffer selectSql = new StringBuffer("SELECT FID,FIsLeaf,FLevel,FLongNumber,FIsValid,FDisplayName_L1,FDisplayName_L2");
            selectSql.append(",FDisplayName_L3,FParentID,FSortCode FROM T_Org_Structure");
            selectSql.append(" where FTreeID=?");
            selectSql.append(" AND FUnitID =?");
            Object[] params = new String[]{((CoreBaseInfo)treeInfo).getId().toString(), ((CoreBaseInfo)unitInfo).getId().toString()};
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString(), (Object[])params);
            if (rs.next()) {
                if (structInfo == null) {
                    structInfo = new OrgStructureInfo();
                }
                structInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                structInfo.setIsLeaf(rs.getInt("FIsLeaf") != 0);
                structInfo.setLevel(rs.getInt("FLevel"));
                structInfo.setLongNumber(rs.getString("FLongNumber"));
                structInfo.setIsValid(rs.getInt("FIsValid") != 0);
                structInfo.setDisplayName(rs.getString("FDisplayName_L1"), locale_L1);
                structInfo.setDisplayName(rs.getString("FDisplayName_L2"), locale_L2);
                structInfo.setDisplayName(rs.getString("FDisplayName_L3"), locale_L3);
                structInfo.setSortCode(rs.getString("FSortCode"));
                String parentStructID = rs.getString("FParentID");
                if (parentStructID != null && (parentStructID.length() == 44 || parentStructID.length() == 28)) {
                    ObjectUuidPK newParentPK = new ObjectUuidPK(parentStructID);
                    OrgStructureInfo parentStructInfo = (OrgStructureInfo)this._getValue(ctx, (IObjectPK)newParentPK);
                    structInfo.setParent(parentStructInfo);
                }
                structInfo.setTree((OrgTreeInfo)treeInfo);
                structInfo.setUnit((FullOrgUnitInfo)unitInfo);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return structInfo;
    }

    public void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ObjectUuidPK newParentPK;
        OrgStructureInfo newParentStructInfo;
        String strParent;
        this._checkIsUnionForCompany(ctx, model);
        OrgStructureInfo newStructInfo = (OrgStructureInfo)model;
        OrgStructureInfo oldStructInfo = (OrgStructureInfo)this._getValue(ctx, pk);
        AbstractOrgStructureInfo parentStructInfo = null;
        if (newStructInfo.getParent() != null) {
            parentStructInfo = this.getValue(ctx, oldStructInfo.getTree(), newStructInfo.getParent().getUnit());
            newStructInfo.setParent((OrgStructureInfo)parentStructInfo);
        }
        if (parentStructInfo != null && parentStructInfo.getLongNumber().indexOf(oldStructInfo.getLongNumber()) >= 0 && ((strParent = parentStructInfo.getLongNumber().trim().substring(oldStructInfo.getLongNumber().length())) == null || strParent != null && strParent.trim().length() == 0 || strParent != null && strParent.substring(0, 1).equals("!"))) {
            throw new OrgException(OrgException.PARENTNODE_CANNOT_BE_CHILD);
        }
        this.setSelfStructureInfo(ctx, newStructInfo);
        OrgStructureCollection structColTemp = null;
        if ("00000000-0000-0000-0000-0000000000034F2827FD".equals(StringUtils.cnulls((Object)newStructInfo.getTree().getId())) && newStructInfo.getParent() != null) {
            EntityViewInfo entityView = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)newStructInfo.getParent().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)"00000000-0000-0000-0000-0000000000034F2827FD"));
            SorterItemCollection sorters = new SorterItemCollection();
            SorterItemInfo sorter = new SorterItemInfo("sortcode");
            sorter.setSortType(SortType.DESCEND);
            sorters.add(sorter);
            entityView.setFilter(filter);
            entityView.getSelector().add(new SelectorItemInfo("sortcode"));
            entityView.setTopCount(1);
            entityView.setSorter(sorters);
            structColTemp = this.getOrgStructureCollection(ctx, entityView);
        }
        this.innerUpdate(ctx, pk, (IObjectValue)newStructInfo);
        if (newStructInfo.getParent() != null && oldStructInfo.getParent() != null && !newStructInfo.getParent().getId().equals((Object)oldStructInfo.getParent().getId()) && newStructInfo.getParent().getSortCode() != null) {
            int temp2;
            if (structColTemp != null && structColTemp.size() != 0) {
                String[] temp = structColTemp.get(0).getSortCode().split("!");
                temp2 = Integer.parseInt(temp[temp.length - 1]);
            } else {
                temp2 = 0;
            }
            String temp3 = OrgSortCodeInfo.getSortCodeSuffix(temp2 + 1);
            String newCode = newStructInfo.getParent().getSortCode() + "!" + temp3;
            String update = "update t_org_structure set fsortCode ='" + newCode + "' where fid='" + newStructInfo.getId().toString() + "'";
            String old = oldStructInfo.getSortCode();
            StringBuilder sb = new StringBuilder();
            sb.append("update  t_org_structure ").append("set fsortCode= replace(").append("left(FsortCode,").append("LEN('" + old + "!')").append("),'").append(old + "!").append("','").append(newCode + "!").append("') ").append("||").append("right(FsortCode,").append("LEN(FsortCode)-LEN('").append(old + "!'))").append(" where flongnumber like '").append(oldStructInfo.getLongNumber()).append("!%'");
            DbUtil.execute((Context)ctx, (String)sb.toString());
            DbUtil.execute((Context)ctx, (String)update);
        }
        if ("00000000-0000-0000-0000-0000000000024F2827FD".equals(StringUtils.cnulls((Object)newStructInfo.getTree().getId()))) {
            this.updateFIStructure(ctx, newStructInfo);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("tree.id", (Object)oldStructInfo.getTree().getId()));
        filterInfo.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(oldStructInfo.getLongNumber() + "!" + "%"), CompareType.LIKE));
        view.setFilter(filterInfo);
        OrgStructureCollection structCol = this.getOrgStructureCollection(ctx, view);
        OrgStructureCollection newStructCol = new OrgStructureCollection();
        boolean levelChange = newStructInfo.getLevel() != oldStructInfo.getLevel();
        int size = structCol.size();
        for (int i = 0; i < size; ++i) {
            OrgStructureInfo _info = structCol.get(i);
            if (!newStructInfo.getLongNumber().equals(oldStructInfo.getLongNumber())) {
                _info.setLongNumber(OrgUtils.changeLongNumber(_info.getLongNumber(), oldStructInfo.getLongNumber(), newStructInfo.getLongNumber()));
                this.checkLongNumberLen(ctx, _info);
            }
            if (!(StringUtils.equals((String)newStructInfo.getDisplayName(locale_L1), (String)oldStructInfo.getDisplayName(locale_L1)) && StringUtils.equals((String)newStructInfo.getDisplayName(locale_L2), (String)oldStructInfo.getDisplayName(locale_L2)) && StringUtils.equals((String)newStructInfo.getDisplayName(locale_L3), (String)oldStructInfo.getDisplayName(locale_L3)))) {
                String oldDisplayName = _info.getDisplayName(locale_L1);
                String oldParentDisplayName = oldStructInfo.getDisplayName(locale_L1);
                String newParentDisplayName = newStructInfo.getDisplayName(locale_L1);
                if (oldDisplayName != null && oldParentDisplayName != null && newParentDisplayName != null) {
                    _info.setDisplayName(OrgUtils.changeDisplayName(oldDisplayName, oldParentDisplayName, newParentDisplayName), locale_L1);
                    this.limitDisplayNameLength(_info, locale_L1);
                }
                oldDisplayName = _info.getDisplayName(locale_L2);
                oldParentDisplayName = oldStructInfo.getDisplayName(locale_L2);
                newParentDisplayName = newStructInfo.getDisplayName(locale_L2);
                if (oldDisplayName != null && oldParentDisplayName != null && newParentDisplayName != null) {
                    _info.setDisplayName(OrgUtils.changeDisplayName(oldDisplayName, oldParentDisplayName, newParentDisplayName), locale_L2);
                    this.limitDisplayNameLength(_info, locale_L2);
                }
                oldDisplayName = _info.getDisplayName(locale_L3);
                oldParentDisplayName = oldStructInfo.getDisplayName(locale_L3);
                newParentDisplayName = newStructInfo.getDisplayName(locale_L3);
                if (oldDisplayName != null && oldParentDisplayName != null && newParentDisplayName != null) {
                    _info.setDisplayName(OrgUtils.changeDisplayName(oldDisplayName, oldParentDisplayName, newParentDisplayName), locale_L3);
                    this.limitDisplayNameLength(_info, locale_L3);
                }
            }
            if (levelChange) {
                int tempLevel = _info.getLongNumber().split("!").length;
                _info.setLevel(tempLevel);
            }
            newStructCol.add(_info);
        }
        this.batchUpdate(ctx, newStructCol, false);
        if (newStructInfo.getParent() != null && (newParentStructInfo = (OrgStructureInfo)this._getValue(ctx, (IObjectPK)(newParentPK = new ObjectUuidPK(newStructInfo.getParent().getId())))).isIsLeaf()) {
            newParentStructInfo.setIsLeaf(false);
            this.innerUpdate(ctx, (IObjectPK)newParentPK, (IObjectValue)newParentStructInfo);
        }
        if (oldStructInfo.getParent() != null) {
            OrgStructureInfo oldParentStructInfo = oldStructInfo.getParent();
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("tree.id", (Object)oldStructInfo.getTree().getId()));
            fi.getFilterItems().add(new FilterItemInfo("parent.id", (Object)oldParentStructInfo.getId()));
            evi.setFilter(fi);
            OrgStructureCollection tmpStructCol = this.getOrgStructureCollection(ctx, evi);
            if (tmpStructCol.size() == 0) {
                ObjectUuidPK oldParentPK = new ObjectUuidPK(oldParentStructInfo.getId());
                oldParentStructInfo.setIsLeaf(true);
                this.innerUpdate(ctx, (IObjectPK)oldParentPK, (IObjectValue)oldParentStructInfo);
            }
        }
    }

    private void updateFIStructure(Context ctx, OrgStructureInfo newStructInfo) throws BOSException, EASBizException {
        IFullOrgUnit iOrgUnit = FullOrgUnitFactory.getLocalInstance(ctx);
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("mainOrg.id", (Object)newStructInfo.getUnit().getId().toString()));
        entityView.setFilter(filter);
        entityView.getSelector().add(new SelectorItemInfo("id"));
        FullOrgUnitCollection orgUnitCol = iOrgUnit.getFullOrgUnitCollection(entityView);
        ArrayList<String> unitIdList = new ArrayList<String>();
        for (int i = 0; i < orgUnitCol.size(); ++i) {
            FullOrgUnitInfo orgUnitInfo = orgUnitCol.get(i);
            unitIdList.add(orgUnitInfo.getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("tree.id", (Object)"00000000-0000-0000-0000-0000000000024F2827FD"));
        filterInfo.getFilterItems().add(new FilterItemInfo("unit.id", (Object)ToolUtils.aryToStr(unitIdList, (boolean)false), CompareType.INCLUDE));
        view.setFilter(filterInfo);
        view.getSelector().add(new SelectorItemInfo("longNumber"));
        view.getSelector().add(new SelectorItemInfo("level"));
        view.getSelector().add(new SelectorItemInfo("parent"));
        view.getSelector().add(new SelectorItemInfo("displayName"));
        view.getSelector().add(new SelectorItemInfo("unit.number"));
        view.getSelector().add(new SelectorItemInfo("unit.name"));
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
        OrgStructureCollection orgStructCol = iStruct.getOrgStructureCollection(view);
        OrgStructureCollection structureCol = new OrgStructureCollection();
        for (int i = 0; i < orgStructCol.size(); ++i) {
            OrgStructureInfo info = orgStructCol.get(i);
            info.setParent(newStructInfo.getParent());
            this.setSelfStructureInfo(ctx, info);
            structureCol.add(info);
        }
        this.batchUpdate(ctx, structureCol, true);
    }

    private void setSelfStructureInfo(Context ctx, OrgStructureInfo info) throws EASBizException, BOSException {
        String index = "";
        if (info.getParent() == null) {
            info.setLongNumber(index + info.getUnit().getNumber());
            this.checkLongNumberLen(ctx, info);
            info.setLevel(1);
            info.setDisplayName(info.getUnit().getName(locale_L1), locale_L1);
            this.limitDisplayNameLength(info, locale_L1);
            info.setDisplayName(info.getUnit().getName(locale_L2), locale_L2);
            this.limitDisplayNameLength(info, locale_L2);
            info.setDisplayName(info.getUnit().getName(locale_L3), locale_L3);
            this.limitDisplayNameLength(info, locale_L3);
        } else {
            info.setLongNumber(info.getParent().getLongNumber() + "!" + index + info.getUnit().getNumber());
            this.checkLongNumberLen(ctx, info);
            info.setLevel(info.getParent().getLevel() + 1);
            this.linkDisplayName(info.getParent(), info, locale_L1);
            this.limitDisplayNameLength(info, locale_L1);
            this.linkDisplayName(info.getParent(), info, locale_L2);
            this.limitDisplayNameLength(info, locale_L2);
            this.linkDisplayName(info.getParent(), info, locale_L3);
            this.limitDisplayNameLength(info, locale_L3);
        }
    }

    private void batchUpdate(Context ctx, OrgStructureCollection coll, boolean isUpdateParent) throws BOSException {
        if (coll == null || coll.size() == 0) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        StringBuffer updateSql = new StringBuffer("");
        if (isUpdateParent) {
            updateSql.append("update T_Org_Structure set FLongNumber = ? ").append(",FLevel=?,FDisplayName_L1=?,FDisplayName_L2=?,FDisplayName_L3=?,FParentID=? where FID=?");
        } else {
            updateSql.append("update T_Org_Structure set FLongNumber = ? ").append(",FLevel=?,FDisplayName_L1=?,FDisplayName_L2=?,FDisplayName_L3=? where FID=?");
        }
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(updateSql.toString());
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                OrgStructureInfo tmpinfo = coll.get(i);
                pstmt.setString(1, tmpinfo.getLongNumber());
                pstmt.setInt(2, tmpinfo.getLevel());
                pstmt.setString(3, tmpinfo.getDisplayName(locale_L1));
                pstmt.setString(4, tmpinfo.getDisplayName(locale_L2));
                pstmt.setString(5, tmpinfo.getDisplayName(locale_L3));
                if (isUpdateParent) {
                    pstmt.setString(6, tmpinfo.getParent().getId().toString());
                    pstmt.setString(7, tmpinfo.getId().toString());
                } else {
                    pstmt.setString(6, tmpinfo.getId().toString());
                }
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (Exception e) {
            try {
                SQLException sqle;
                logger.error((Object)"batch update OrgStructure error! \n", (Throwable)e);
                if (e instanceof SQLException && (sqle = ((SQLException)e).getNextException()) != null) {
                    logger.error((Object)"**************************** Next exception is: ***************************");
                    logger.error((Object)"sql exception :", (Throwable)sqle);
                }
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void checkLongNumberLen(Context ctx, OrgStructureInfo info) throws EASBizException, BOSException {
        int len;
        int n = len = info.getLongNumber() == null ? -1 : info.getLongNumber().length();
        if (len > 200) {
            throw new OrgException(OrgException.CHECKLONGNUMBERLEN);
        }
    }

    private void linkDisplayName(OrgStructureInfo parent, OrgStructureInfo info, Locale locale) {
        String disPlayName = null;
        String parentDisplayName = parent.getDisplayName(locale);
        disPlayName = parentDisplayName != null ? parentDisplayName + "_" + info.getUnit().getName(locale) : info.getUnit().getName(locale);
        info.setDisplayName(disPlayName, locale);
    }

    private void limitDisplayNameLength(OrgStructureInfo info, Locale locale) {
        String displayName = info.getDisplayName(locale);
        String[] displayNameVar = StringUtil.split((String)displayName, (String)"_");
        if (displayNameVar == null) {
            return;
        }
        if (displayNameVar.length > 1) {
            if (displayName.length() > 500) {
                int len = displayName.indexOf("_");
                displayName = displayName.substring(len + 1);
                info.setDisplayName(displayName, locale);
                this.limitDisplayNameLength(info, locale);
            }
        } else if (displayNameVar.length == 1 && displayName.length() > 500) {
            displayName = displayName.substring(0, 500);
            info.setDisplayName(displayName, locale);
        }
    }

    @Override
    public IObjectValue _getValue(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        return this._getValue(ctx, pk, selector);
    }

    void _checkIsUnionForCompany(Context ctx, IObjectValue model) throws EASBizException, BOSException {
    }

    void _checkOrgHasUnion(Context ctx, OrgStructureInfo strucInfo) throws BOSException, OrgException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("tree.id", (Object)strucInfo.getTree().getId()));
        filterInfo.getFilterItems().add(new FilterItemInfo("unit.id", (Object)strucInfo.getUnit().getId()));
        view.setFilter(filterInfo);
        IOrgStructure iOrgStruct = OrgStructureFactory.getLocalInstance(ctx);
        OrgStructureCollection structCol = iOrgStruct.getOrgStructureCollection(view);
        if (structCol.size() != 0) {
            throw new OrgException(OrgException.NOT_EXIST_SAME_UNIT_ONETREE);
        }
    }

    public String _getCollection(Context ctx, String oql) throws BOSException {
        return null;
    }

    @Override
    public IObjectCollection _getTreeCollection(Context ctx, IObjectValue strucInfo, IObjectValue treeInfo, boolean isInAvailGroup, boolean isGroup) throws BOSException, EASBizException {
        OrgStructureInfo parentNodeInfo = (OrgStructureInfo)strucInfo;
        OrgTreeInfo tInfo = (OrgTreeInfo)treeInfo;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(new FilterInfo());
        if (parentNodeInfo != null) {
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("longNumber", (Object)(parentNodeInfo.getLongNumber() + "%"), CompareType.LIKE));
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("tree.id", (Object)tInfo.getId(), CompareType.EQUALS));
        } else {
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("tree.id", (Object)tInfo.getId(), CompareType.EQUALS));
        }
        if (isGroup) {
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("unit.isGrouping", (Object)new Integer(1), CompareType.EQUALS));
        }
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("unit.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("unit.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("unit.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("unit.isGrouping"));
        viewInfo.getSelector().add(new SelectorItemInfo("unit.isFreeze"));
        viewInfo.getSelector().add(new SelectorItemInfo("unit.effectDate"));
        viewInfo.getSelector().add(new SelectorItemInfo("unit.invalidDate"));
        viewInfo.getSelector().add(new SelectorItemInfo("tree.id"));
        viewInfo.getSorter().add(new SorterItemInfo("longNumber"));
        IOrgStructure iStruc = OrgStructureFactory.getLocalInstance(ctx);
        return iStruc.getCollection(viewInfo);
    }

    protected IObjectPK[] _delete(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        OrgStructureCollection structCol = this.getOrgStructureCollection(ctx, view);
        if (structCol.size() > 0) {
            this._isReferenced(ctx, (IObjectPK)new ObjectUuidPK(structCol.get(0).getId()));
            OrgStructureInfo parentStructInfo = null;
            String parentStructID = null;
            OrgStructureCollection childStructCol = null;
            int n = structCol.size();
            for (int i = 0; i < n; ++i) {
                parentStructInfo = structCol.get(i).getParent();
                if (parentStructInfo == null || parentStructInfo.getId() == null) continue;
                parentStructID = parentStructInfo.getId().toString();
                childStructCol = this.getOrgStructureCollection(ctx, "select id where parent.id = '" + parentStructID + "'");
                if (childStructCol.size() != 1) continue;
                DbUtil.execute((Context)ctx, (String)("update t_org_structure set fisleaf = 1 where fid = '" + parentStructID + "'"));
            }
        }
        return super._delete(ctx, filter);
    }

    @Override
    protected void _updateSortCode(Context ctx, List sortCodeInfoList) throws BOSException {
        if (sortCodeInfoList.size() == 0) {
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        Connection conn = null;
        Statement stm = null;
        try {
            conn = this.getConnection(ctx);
            stm = conn.createStatement();
            for (OrgSortCodeInfo info : sortCodeInfoList) {
                String sortCode = info.getNewSortCode();
                String id = info.getId();
                idList.add(id);
                StringBuffer selectSql = new StringBuffer("SELECT FunitID FROM T_ORG_Structure where FID =?");
                Object[] params = new String[]{id};
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString(), (Object[])params);
                if (rs.next() && !StringUtils.isEmpty((String)rs.getString(1))) {
                    stm.addBatch("UPDATE T_ORG_ADMIN SET FSortCode = '" + sortCode + "' where Fid = '" + rs.getString(1) + "'");
                }
                stm.addBatch("UPDATE T_ORG_Structure SET FSortCode = '" + sortCode + "' where Fid = '" + id + "'");
            }
            stm.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, stm, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(null, (Statement)stm, (Connection)conn);
        Statement stmt = null;
        Statement stmt2 = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.createStatement();
            stmt2 = conn.createStatement();
            for (OrgSortCodeInfo info : sortCodeInfoList) {
                String longNumber = info.getLongNumber();
                String oldSortCode = info.getOldSortCode();
                String newSortCode = info.getNewSortCode();
                int len = oldSortCode.length();
                ResultSet rs = stmt.executeQuery("select fsortcode from T_ORG_Structure where flongnumber like '" + longNumber + "!%'");
                if (!rs.next() || StringUtils.isEmpty((String)rs.getString(1))) continue;
                StringBuffer updateChilds = new StringBuffer("UPDATE T_ORG_Structure SET FSortCode = ");
                updateChilds.append("CONCAT('").append(newSortCode).append("', SUBSTRING(FSortCode, ").append(len + 1).append(", LEN(FSortCode)-").append(len).append(")) WHERE FLongNumber LIKE '").append(longNumber + "!%'").append(" AND FTreeID = '").append("00000000-0000-0000-0000-0000000000034F2827FD").append("'");
                StringBuffer updateChilds2 = new StringBuffer("UPDATE T_ORG_ADMIN SET FSortCode = ");
                updateChilds2.append("CONCAT('").append(newSortCode).append("', SUBSTRING(FSortCode, ").append(len + 1).append(", LEN(FSortCode)-").append(len).append(")) WHERE FLongNumber LIKE '").append(longNumber + "!%'");
                stmt2.addBatch(updateChilds.toString());
                stmt2.addBatch(updateChilds2.toString());
            }
            stmt2.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, stmt, (Connection)conn);
                SQLUtils.cleanup(stmt2);
                throw throwable;
            }
        }
        SQLUtils.cleanup(null, (Statement)stmt, (Connection)conn);
        SQLUtils.cleanup((Statement)stmt2);
        try {
            this.otherDealupdateSortCode(ctx, idList);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void otherDealupdateSortCode(Context ctx, List idList) throws EASBizException, BOSException {
        try {
            String[] checks = RefCheckersDAO.getCheckers((Context)ctx, (String)"32B85C74", IOtherDealUpdateSortCode.class);
            if (checks != null && checks.length > 0) {
                IOtherDealUpdateSortCode otherDealUpdateSortCodeCheck = null;
                for (int i = 0; i < checks.length; ++i) {
                    otherDealUpdateSortCodeCheck = (IOtherDealUpdateSortCode)Class.forName(checks[i]).newInstance();
                    otherDealUpdateSortCodeCheck.afterDeal(ctx, idList);
                }
            }
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _initSortCode(Context ctx) throws BOSException {
        if (this._hasInitSortCode(ctx)) {
            return;
        }
        OrgStructureCollection structCol = new OrgStructureCollection();
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.createStatement();
            rs = stmt.executeQuery("SELECT FID, FParentID, FLongNumber FROM T_ORG_Structure WHERE FTreeID = '00000000-0000-0000-0000-0000000000034F2827FD' ORDER BY FLongNumber");
            OrgStructureInfo structInfo = null;
            while (rs.next()) {
                String id = rs.getString(1);
                String parentId = rs.getString(2);
                String longNumber = rs.getString(3);
                structInfo = new OrgStructureInfo();
                structInfo.setId(BOSUuid.read((String)id));
                if (parentId != null) {
                    OrgStructureInfo parentStructInfo = new OrgStructureInfo();
                    parentStructInfo.setId(BOSUuid.read((String)parentId));
                    structInfo.setParent(parentStructInfo);
                }
                structInfo.setLongNumber(longNumber);
                structCol.add(structInfo);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        for (int i = 0; i < structCol.size(); ++i) {
            OrgStructureInfo structInfo = structCol.get(i);
            OrgStructureInfo parentStructInfo = structInfo.getParent();
            if (parentStructInfo == null) {
                structInfo.setSortCode("1");
                continue;
            }
            String parentId = parentStructInfo.getId().toString();
            for (int j = 0; j < i; ++j) {
                OrgStructureInfo info = structCol.get(j);
                if (!parentId.equals(info.getId().toString())) continue;
                parentStructInfo = info;
                String parentSortCode = parentStructInfo.getSortCode();
                int childNum = parentStructInfo.getInt("childNum");
                String sortCodeSuffix = OrgSortCodeInfo.getSortCodeSuffix(++childNum);
                structInfo.setSortCode(parentSortCode + "!" + sortCodeSuffix);
                parentStructInfo.setInt("childNum", childNum);
            }
        }
        PreparedStatement pstmt = null;
        String update = "UPDATE T_ORG_Structure SET FSortCode = ? WHERE FID = ?";
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(update);
            for (int i = 0; i < structCol.size(); ++i) {
                OrgStructureInfo structInfo = structCol.get(i);
                String id = structInfo.getId().toString();
                String sortCode = structInfo.getSortCode();
                pstmt.setString(1, sortCode);
                pstmt.setString(2, id);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        try {
            OrgSpecialTablesRebuildFacadeFactory.getLocalInstance(ctx).rebuildSpecialTables(2);
            this.otherDealupdateSortCode(ctx, new ArrayList());
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected boolean _hasInitSortCode(Context ctx) throws BOSException {
        boolean bl;
        ResultSet rs;
        Statement stmt;
        Connection conn;
        block5: {
            conn = null;
            stmt = null;
            rs = null;
            conn = this.getConnection(ctx);
            stmt = conn.createStatement();
            rs = stmt.executeQuery("SELECT 1 FROM T_ORG_Structure WHERE FParentID IS NULL AND FSortCode IS NULL AND FTreeID = '00000000-0000-0000-0000-0000000000034F2827FD'");
            if (!rs.next()) break block5;
            boolean bl2 = false;
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
            return bl2;
        }
        try {
            bl = true;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return bl;
    }

    @Override
    protected void _clearAllSortCode(Context ctx, OrgStructureInfo selectNode) throws BOSException {
        String sql2;
        String sql1;
        if ("00000000-0000-0000-0000-000000000000CCE7AED4".equals(selectNode.getUnit().getId().toString())) {
            sql1 = "UPDATE T_ORG_ADMIN SET FsortCode=null ";
            sql2 = "UPDATE T_ORG_STRUCTURE SET FsortCode=null";
        } else {
            String longnumber = selectNode.getLongNumber();
            sql1 = "UPDATE T_ORG_ADMIN SET FsortCode=null  WHERE Flongnumber like '" + longnumber + "!%'";
            sql2 = "UPDATE T_ORG_STRUCTURE SET FsortCode=null WHERE Flongnumber like '" + longnumber + "!%'";
        }
        DbUtil.execute((Context)ctx, (String)sql1);
        DbUtil.execute((Context)ctx, (String)sql2);
    }
}

