/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.app.helper.OrgTypeAppCenter;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import java.sql.ResultSet;
import java.util.List;

public class OrgVersionServerUtils {
    public static LanguageCollection langCol = null;

    public static List getOrgVersionInsertSql() {
        List sourceList = OrgTypeAppCenter.getInstance().getInsertHisDataSql();
        sourceList.add("INSERT INTO T_ORG_UnitRelation_His(FID, FFromUnitID, FToUnitID, FTypeRelationID, FIsDefault, FVersionNumber) SELECT FID, FFromUnitID, FToUnitID, FTypeRelationID, FIsDefault, FVersionNumber FROM T_ORG_UnitRelation");
        return sourceList;
    }

    public static List getOrgUpdateStmts(String versionNumber) {
        List sourceList = OrgTypeAppCenter.getInstance().getOrgUpdateStmts(versionNumber);
        sourceList.add(new StringBuffer().append("UPDATE T_ORG_UnitRelation SET FVersionNumber = '").append(versionNumber).append("'").toString());
        return sourceList;
    }

    public static List getOrgVersioningUpdateStmts(String versionNumber) {
        List sourceList = OrgTypeAppCenter.getInstance().getOrgVersioningUpdateStmts(versionNumber);
        return sourceList;
    }

    public static LanguageCollection getLanguageCollection(Context ctx) {
        if (langCol == null) {
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            SolutionInfo solutionInfo = loader.getSolution();
            langCol = solutionInfo.getLanguages();
        }
        return langCol;
    }

    public static OrgUnitInfo createOrgUnitVersionInfo(Context ctx, OrgUnitInfo orgVersionInfo, ResultSet rs) throws Exception {
        String versionNumber = rs.getString("FVersionNumber");
        orgVersionInfo.setVersionNumber(versionNumber);
        orgVersionInfo.setId(BOSUuid.read((String)rs.getString("FID")));
        orgVersionInfo.setIsGrouping(rs.getBoolean("FIsGrouping"));
        orgVersionInfo.setEffectDate(rs.getDate("FEffectDate"));
        orgVersionInfo.setInvalidDate(rs.getDate("FInvalidDate"));
        orgVersionInfo.setIsFreeze(rs.getBoolean("FIsFreeze"));
        orgVersionInfo.setOrgTypeStr(rs.getString("forgTypeStr"));
        OrgTypeHelper.createOrgType4FullOrg(orgVersionInfo, orgVersionInfo.getOrgTypeStr());
        orgVersionInfo.setIsStart(rs.getBoolean("FIsStart"));
        orgVersionInfo.setIsOUSealUp(rs.getBoolean("FIsOUSealUp"));
        LanguageCollection lc = OrgVersionServerUtils.getLanguageCollection(ctx);
        orgVersionInfo.setIsLeaf(rs.getBoolean("FIsLeaf"));
        orgVersionInfo.setLevel(rs.getInt("FLevel"));
        orgVersionInfo.setLongNumber(rs.getString("FLongNumber"));
        String strDisplayName = "FDisplayName_";
        for (int i = 0; i < lc.size(); ++i) {
            LanguageInfo langInfo = lc.get(i);
            String displayName = strDisplayName + langInfo.getPostfix();
            orgVersionInfo.setDisplayName(rs.getString(displayName), langInfo.getLocale());
        }
        String strName = "FName_";
        for (int i = 0; i < lc.size(); ++i) {
            LanguageInfo langInfo = lc.get(i);
            String name = strName + langInfo.getPostfix();
            orgVersionInfo.setName(rs.getString(name), langInfo.getLocale());
        }
        orgVersionInfo.setNumber(rs.getString("FNumber"));
        String strDescription = "FDescription_";
        for (int i = 0; i < lc.size(); ++i) {
            LanguageInfo langInfo = lc.get(i);
            String description = strDescription + langInfo.getPostfix();
            orgVersionInfo.setDescription(rs.getString(description), langInfo.getLocale());
        }
        orgVersionInfo.setSimpleName(rs.getString("FSimpleName"));
        String creatorId = rs.getString("FCreatorID");
        if (creatorId != null && creatorId.trim().length() != 0) {
            UserInfo creatorInfo = new UserInfo();
            creatorInfo.setId(BOSUuid.read((String)creatorId));
            orgVersionInfo.setCreator(creatorInfo);
        }
        orgVersionInfo.setCreateTime(rs.getTimestamp("FCreateTime"));
        String lastUpdateUserId = rs.getString("FLastUpdateUserID");
        if (lastUpdateUserId != null && lastUpdateUserId.trim().length() != 0) {
            UserInfo lastUpdateUserInfo = new UserInfo();
            lastUpdateUserInfo.setId(BOSUuid.read((String)lastUpdateUserId));
            orgVersionInfo.setLastUpdateUser(lastUpdateUserInfo);
        }
        orgVersionInfo.setLastUpdateTime(rs.getTimestamp("FLastUpdateTime"));
        String cuId = rs.getString("FControlUnitID");
        if (cuId != null && cuId.trim().length() != 0) {
            CtrlUnitInfo cuVersionInfo = new CtrlUnitInfo(versionNumber, BOSUuid.read((String)cuId));
            orgVersionInfo.setCU(cuVersionInfo);
        }
        orgVersionInfo.setCode(rs.getString("FCode"));
        return orgVersionInfo;
    }
}

