/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgDelegateFacade;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OrgDelegateFacadeFactory;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class OrgDBHelper {
    private static Logger logger = Logger.getLogger((String)OrgDBHelper.class.getName());

    public static void lockOrg(Context ctx) throws BOSException {
        try {
            String sql = "update T_ORG_BaseUnit set FNumber = FNumber where FID = '00000000-0000-0000-0000-000000000000CCE7AED4'";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static Map getAllSubLongNumberSet(Context ctx, FullOrgUnitInfo oldOrgInfo) throws EASBizException, BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        String oql = "select longnumber,tree.id where unit.id = '" + oldOrgInfo.getId().toString() + "'";
        OrgStructureCollection orgStrColl = OrgStructureFactory.getLocalInstance(ctx).getOrgStructureCollection(oql);
        for (int i = 0; i < orgStrColl.size(); ++i) {
            OrgStructureInfo info = orgStrColl.get(i);
            map.put(info.getTree().getId().toString(), info.getLongNumber());
        }
        return map;
    }

    public static void checkNumberInUnionTree(Context ctx, boolean isNew, String unitId, String number, String treeId) throws BOSException, EASBizException {
        String select = null;
        select = !isNew ? new StringBuffer("select b.fnumber from t_org_structure s ").append("join t_org_baseunit b on s.funitid = b.fid where s.ftreeid = '").append(treeId).append("'").append(" and b.fid != '").append(unitId).append("'").toString() : new StringBuffer("select b.fnumber from t_org_structure s ").append("join t_org_baseunit b on s.funitid = b.fid where s.ftreeid = '").append(treeId).append("'").toString();
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)select);
            while (rs.next()) {
                if (!number.equalsIgnoreCase(rs.getString(1))) continue;
                throw new OUException(OUException.NUMBER_DUP_IN_UNIONTREE);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static void checkStockControlCompany(Context ctx, String treeID, String unionGroupID, String comID) throws BOSException, EASBizException {
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)treeID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("unit.isUnion", (Object)new Integer(1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("unit.partUnionGroup.stockControlCompany.id", (Object)comID, CompareType.EQUALS));
        if (unionGroupID != null) {
            filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)unionGroupID, CompareType.NOTEQUALS));
        }
        if (iStruct.exists(filter)) {
            throw new OUException(OUException.STOCKCONTROLCOMPANY_EXISTINUNIONGROUP);
        }
    }

    public static boolean isDelegatedByOthers(Context ctx, FullOrgUnitInfo unit, int orgTypeValue) throws BOSException, EASBizException {
        IOrgDelegateFacade iDelegateFacade = OrgDelegateFacadeFactory.getLocalInstance(ctx);
        return iDelegateFacade.isDelegatedByOthers(unit.getId().toString(), orgTypeValue);
    }

    public static void updateParameter(Context ctx) throws BOSException, EASBizException {
        IParamControl pm = ParamControlFactory.getLocalInstance((Context)ctx);
        pm.paramReferenced("G001", null);
    }
}

