/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.f7;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.basedata.org.NewOrgF7FacadeFactory;
import com.kingdee.eas.basedata.org.OrgAssistInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.f7.OrgF7Helper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class PermItemFilterService {
    private static Logger logger = Logger.getLogger((String)PermItemFilterService.class.getName());

    public static FilterInfo getPermItemFilter(OrgAssistInfo assistInfo, OrgViewType viewType, OrgTreeInfo treeInfo) throws BOSException {
        FilterInfo filter = null;
        try {
            filter = OrgF7Helper.isAdminType(null, assistInfo.getUserPK()) ? PermItemFilterService.buildAdminFilter(assistInfo, viewType, treeInfo) : (StringUtils.isEmpty((String)assistInfo.getPermItem()) ? PermItemFilterService.buildOrgRangeFilter(assistInfo, viewType, treeInfo) : PermItemFilterService.buildPermItemFilter(assistInfo, viewType, treeInfo));
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return filter;
    }

    private static FilterInfo buildPermItemFilter(OrgAssistInfo assistInfo, OrgViewType viewType, OrgTreeInfo treeInfo) throws BOSException, EASBizException {
        FilterInfo filter = null;
        String paramSQL = NewOrgF7FacadeFactory.getRemoteInstance().getPermSQLByPermItem(assistInfo.getPermItem(), assistInfo.getUserPK(), viewType);
        try {
            filter = new FilterInfo("unit.id in (" + paramSQL + ")");
        }
        catch (ParserException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return filter;
    }

    private static FilterInfo buildOrgRangeFilter(OrgAssistInfo assistInfo, OrgViewType viewType, OrgTreeInfo treeInfo) throws BOSException {
        return OrgF7Helper.getFilterByOrgRange("unit.id", assistInfo.getUserPK().toString(), OrgF7Helper.getOrgRangeType(viewType));
    }

    private static FilterInfo buildAdminFilter(OrgAssistInfo assistInfo, OrgViewType viewType, OrgTreeInfo treeInfo) throws BOSException {
        return OrgF7Helper.getFilterByOrgRange("unit.cu.id", assistInfo.getUserPK().toString(), 10);
    }
}

