/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.helper;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.ImportCompayFieldsEnum;
import com.kingdee.util.StringUtils;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;

public class OrgFilterHelper {
    private static final String DEFAULT_SPLIT = ",";
    private static Set<ImportCompayFieldsEnum> supportFields = new HashSet<ImportCompayFieldsEnum>();

    public static boolean isSupportSplit(String value, ImportCompayFieldsEnum field) {
        return !StringUtils.isEmpty((String)value) && value.contains(DEFAULT_SPLIT) && !DEFAULT_SPLIT.equals(value.trim()) && supportFields.contains((Object)field);
    }

    public static String getProNameStr(String prefix, int ImportCompayFieldsEnumValue) {
        switch (ImportCompayFieldsEnumValue) {
            case 2: {
                return prefix + "name";
            }
            case 1: {
                return prefix + "number";
            }
            case 8: {
                return prefix + "number" + DEFAULT_SPLIT + prefix + "name";
            }
            case 5: {
                return prefix + "code";
            }
        }
        return "";
    }

    public static String getFieldNameStr(String prefix, int ImportCompayFieldsEnumValue, Locale local) {
        switch (ImportCompayFieldsEnumValue) {
            case 2: {
                return prefix + " .FNAME_" + local.toString();
            }
            case 1: {
                return prefix + " .FNUMBER";
            }
            case 8: {
                return prefix + " .FNUMBER" + DEFAULT_SPLIT + prefix + " .FNAME_" + local.toString();
            }
            case 5: {
                return prefix + " .FCODE";
            }
        }
        return "";
    }

    public static FilterInfo getFilterBySplit(String proNameStr, String value, boolean isBlured, boolean isCapitalSensitive) {
        FilterInfo filter = new FilterInfo();
        if (StringUtils.isEmpty((String)value) || StringUtils.isEmpty((String)proNameStr)) {
            return null;
        }
        proNameStr = proNameStr.trim();
        value = value.trim();
        String[] proNames = proNameStr.split(DEFAULT_SPLIT);
        TreeSet valuesSet = new TreeSet(Arrays.asList((Object[])value.split(DEFAULT_SPLIT)));
        ArrayList<String> values = new ArrayList<String>(valuesSet);
        values.add(value);
        int i = 0;
        StringBuilder maskString = new StringBuilder();
        if (isBlured) {
            for (String proName : proNames) {
                for (String str : values) {
                    if (isCapitalSensitive) {
                        filter.getFilterItems().add(new FilterItemInfo(proName, (Object)("%" + str + "%"), CompareType.LIKE));
                    } else {
                        filter.getFilterItems().add(new FilterItemInfo("upper(" + proName + ")", (Object)("%" + str.toUpperCase() + "%"), CompareType.LIKE, false, true));
                    }
                    if (i == 0) {
                        maskString.append("#" + i++);
                        continue;
                    }
                    maskString.append(" or #" + i++);
                }
            }
        } else {
            for (String proName : proNames) {
                filter.getFilterItems().add(new FilterItemInfo(proName, valuesSet, CompareType.INCLUDE));
                if (i == 0) {
                    maskString.append("#" + i++);
                    continue;
                }
                maskString.append(" or #" + i++);
            }
        }
        filter.setMaskString(maskString.toString());
        return filter;
    }

    public static CompareWhereSqlInfo getSqlBySplit(String fieldNameStr, String value, boolean isBlured, boolean isCapitalSensitive) {
        if (StringUtils.isEmpty((String)value) || StringUtils.isEmpty((String)fieldNameStr)) {
            return null;
        }
        fieldNameStr = fieldNameStr.trim();
        value = value.trim();
        StringBuilder whereSqlBuilder = new StringBuilder();
        ArrayList<Object> objParams = new ArrayList<Object>();
        String[] fieldNames = fieldNameStr.split(DEFAULT_SPLIT);
        TreeSet valuesSet = new TreeSet(Arrays.asList((Object[])value.split(DEFAULT_SPLIT)));
        ArrayList<String> values = new ArrayList<String>(valuesSet);
        if (values.size() > 1) {
            values.add(value);
        }
        whereSqlBuilder.append("(");
        if (isBlured) {
            boolean isHead = true;
            for (String fieldName : fieldNames) {
                for (String str : values) {
                    whereSqlBuilder.append(isHead ? "" : " or ");
                    whereSqlBuilder.append(isCapitalSensitive ? fieldName + " like ? " : "upper(" + fieldName + ") like ? ");
                    objParams.add(str);
                    isHead = false;
                }
            }
        } else {
            boolean isHead = true;
            for (String fieldName : fieldNames) {
                whereSqlBuilder.append(isHead ? fieldName + " in ( " : " or " + fieldName + " in ( ");
                boolean isHead2 = true;
                for (String str : values) {
                    whereSqlBuilder.append(isHead2 ? "?" : ",?");
                    objParams.add(str);
                    isHead2 = false;
                }
                whereSqlBuilder.append(" ) ");
                isHead = false;
            }
        }
        whereSqlBuilder.append(")");
        return new CompareWhereSqlInfo(whereSqlBuilder.toString(), objParams);
    }

    public static void main(String[] args) {
        System.out.println(DEFAULT_SPLIT.split(" ,").length);
        System.out.println(OrgFilterHelper.getSqlBySplit((String)"name", (String)"cc", (boolean)true, (boolean)false).whereSql);
        System.out.println(OrgFilterHelper.getSqlBySplit((String)"name", (String)"cc", (boolean)true, (boolean)true).whereSql);
        System.out.println(OrgFilterHelper.getSqlBySplit((String)"name,number", (String)"cc", (boolean)true, (boolean)false).whereSql);
        System.out.println(OrgFilterHelper.getSqlBySplit((String)"name,number", (String)"cc", (boolean)true, (boolean)true).whereSql);
        System.out.println(OrgFilterHelper.getSqlBySplit((String)"name", (String)"cc,dd,ee", (boolean)true, (boolean)false).whereSql);
        System.out.println(OrgFilterHelper.getSqlBySplit((String)"name", (String)"cc,dd,ee", (boolean)true, (boolean)true).whereSql);
        System.out.println(OrgFilterHelper.getSqlBySplit((String)"name,number", (String)"cc,dd,ee", (boolean)true, (boolean)false).whereSql);
        System.out.println(OrgFilterHelper.getSqlBySplit((String)"name,number", (String)"cc,dd,ee", (boolean)true, (boolean)true).whereSql);
        System.out.println(OrgFilterHelper.getSqlBySplit((String)"name", (String)"cc,dd,ee", (boolean)false, (boolean)false).whereSql);
        System.out.println(OrgFilterHelper.getSqlBySplit((String)"name", (String)"cc,dd,ee", (boolean)false, (boolean)true).whereSql);
        System.out.println(OrgFilterHelper.getSqlBySplit((String)"name,number", (String)"cc,dd,ee", (boolean)false, (boolean)false).whereSql);
        System.out.println(OrgFilterHelper.getSqlBySplit((String)"name,number", (String)"cc,dd,ee", (boolean)false, (boolean)true).whereSql);
        System.out.println(ImportCompayFieldsEnum.NAME == ImportCompayFieldsEnum.getEnum("NAME"));
    }

    static {
        supportFields.add(ImportCompayFieldsEnum.NAME);
        supportFields.add(ImportCompayFieldsEnum.NUMBER);
        supportFields.add(ImportCompayFieldsEnum.NUMBERANDNAME);
        supportFields.add(ImportCompayFieldsEnum.CODE);
    }

    public static class CompareWhereSqlInfo {
        public String whereSql = "";
        public List<Object> whereParams = null;

        public CompareWhereSqlInfo(String whereSql, List<Object> whereParams) {
            this.whereSql = whereSql;
            this.whereParams = whereParams;
        }
    }
}

