/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.helper;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.helper.OrgUIDataUtil;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class OrgTableHelper {
    private static Logger logger = Logger.getLogger((String)OrgTableHelper.class.getName());

    public static void addTalbeOrgCol(KDTable sourceTable) {
        Collection orgTypeCol = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo();
        Iterator it = orgTypeCol.iterator();
        while (it.hasNext()) {
            OrgType curOrgType = ((OrgTypeInfo)it.next()).getOrgType();
            if (OrgType.NONE == curOrgType || sourceTable.getColumnIndex(curOrgType.getName()) != -1) continue;
            IColumn iCol = sourceTable.addColumn();
            iCol.setWidth(60);
            iCol.setKey(curOrgType.getName());
            iCol.getStyleAttributes().setLocked(true);
            IRow iRow = sourceTable.getHeadRow(0);
            iRow.getCell(curOrgType.getName()).setValue((Object)curOrgType.getAlias());
        }
    }

    public static void setTableRowValue(OrgUnitInfo orgInfo, IRow iRow) {
        OrgTypeHelper orgTypeHelper = new OrgTypeHelper(orgInfo);
        OrgTableHelper.setTableRowValue(orgTypeHelper, null, iRow, null, null);
    }

    public static void setTableRowValue(String orgTypeStr, IRow iRow) {
        OrgTypeHelper orgTypeHelper = new OrgTypeHelper(orgTypeStr);
        OrgTableHelper.setTableRowValue(orgTypeHelper, null, iRow, null, null);
    }

    public static void setTableRowValue(OrgUIDataUtil orgUIData, String orgTypeStr, IRow iRow, String orgIdCellName, Color orgSealColor) {
        OrgTypeHelper orgTypeHelper = new OrgTypeHelper(orgTypeStr);
        OrgTableHelper.setTableRowValue(orgTypeHelper, orgUIData, iRow, orgIdCellName, orgSealColor);
    }

    private static void setTableRowValue(OrgTypeHelper orgTypeHelper, OrgUIDataUtil orgUIData, IRow iRow, String orgIdCellName, Color orgSealUpColor) {
        Collection orgTypeCol = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo();
        Iterator it = orgTypeCol.iterator();
        while (it.hasNext()) {
            OrgType curOrgType = ((OrgTypeInfo)it.next()).getOrgType();
            if (OrgType.NONE == curOrgType) continue;
            Boolean check = new Boolean(orgTypeHelper.isOrgType(curOrgType));
            ICell orgTypecell = iRow.getCell(curOrgType.getName());
            orgTypecell.setValue((Object)check);
            if (orgSealUpColor == null || orgUIData == null || StringUtils.isEmpty((String)orgIdCellName) || !check.booleanValue()) continue;
            boolean isSealUp = false;
            try {
                isSealUp = orgUIData.isSealUpOrg(iRow.getCell(orgIdCellName).getValue().toString(), curOrgType);
                if (!isSealUp) continue;
                orgTypecell.getStyleAttributes().setBackground(orgSealUpColor);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }
}

