/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.json.adapter;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateTypeAdapter
implements JsonSerializer<Date>,
JsonDeserializer<Date> {
    public static final String DATEFORMAT = "yyyy-MM-dd HH:mm:ss";

    public JsonElement serialize(Date object, Type type, JsonSerializationContext context) {
        SimpleDateFormat format = new SimpleDateFormat(DATEFORMAT);
        String dateStr = format.format(object);
        return new JsonPrimitive(dateStr);
    }

    public Date deserialize(JsonElement object, Type type, JsonDeserializationContext context) throws JsonParseException {
        String dateStr = object.getAsString();
        SimpleDateFormat format = new SimpleDateFormat(DATEFORMAT);
        try {
            return format.parse(dateStr);
        }
        catch (Exception ex) {
            return null;
        }
    }
}

