/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.json.adapter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.kingdee.util.enums.DoubleEnum;
import com.kingdee.util.enums.DynamicEnum;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.lang.reflect.Type;

public class EnumTypeAdapter
implements JsonSerializer<Enum> {
    public static final String WAF_ENUM_VALUE_KEY = "isenum";

    public JsonElement serialize(Enum object, Type type, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(WAF_ENUM_VALUE_KEY, Boolean.valueOf(true));
        String strAlias = null;
        strAlias = object.getAlias();
        jsonObject.addProperty("alias", strAlias);
        if (object instanceof StringEnum) {
            jsonObject.addProperty("value", ((StringEnum)object).getValue());
        } else if (object instanceof IntEnum) {
            jsonObject.addProperty("value", (Number)((IntEnum)object).getValue());
        } else if (object instanceof DoubleEnum) {
            jsonObject.addProperty("value", (Number)((DoubleEnum)object).getValue());
        } else if (object instanceof FloatEnum) {
            jsonObject.addProperty("value", (Number)Float.valueOf(((FloatEnum)object).getValue()));
        } else if (object instanceof DynamicEnum) {
            jsonObject.addProperty("value", ((DynamicEnum)object).getValue());
        }
        if (object.getName() != null) {
            jsonObject.addProperty("name", object.getName());
        }
        return jsonObject;
    }

    private boolean isNumberValue(String value) {
        boolean blnResult = true;
        try {
            Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        try {
            Float.parseFloat(value);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        try {
            Double.parseDouble(value);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return blnResult;
    }
}

