/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.json.adapter;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.io.IOException;

public class EnumTypeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        Class rawType = typeToken.getRawType();
        if (!Enum.class.isAssignableFrom(rawType)) {
            return null;
        }
        Adapter result = new Adapter(gson, rawType);
        return result;
    }

    private static final class Adapter<T extends Enum>
    extends TypeAdapter<T> {
        private final Class<T> type;
        private final Gson gson;

        public Adapter(Gson gson, Class<T> type) {
            this.type = type;
            this.gson = gson;
        }

        public T read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            if (StringEnum.class.isAssignableFrom(this.type)) {
                String s = (String)this.gson.getAdapter(String.class).read(in);
                return (T)EnumUtils.getEnumByValue(this.type, (String)s);
            }
            if (IntEnum.class.isAssignableFrom(this.type)) {
                int s = (Integer)this.gson.getAdapter(Integer.TYPE).read(in);
                return (T)EnumUtils.getEnum(this.type, (int)s);
            }
            EnumUtils.getEnumList(this.type);
            String s = (String)this.gson.getAdapter(String.class).read(in);
            return (T)EnumUtils.getEnum(this.type, (String)s);
        }

        public void write(JsonWriter out, T enu) throws IOException {
            if (enu == null) {
                out.nullValue();
                return;
            }
            if (enu instanceof StringEnum) {
                this.gson.getAdapter(String.class).write(out, (Object)((StringEnum)enu).getValue());
            } else if (enu instanceof IntEnum) {
                this.gson.getAdapter(Integer.TYPE).write(out, (Object)((IntEnum)enu).getValue());
            } else {
                this.gson.getAdapter(String.class).write(out, (Object)enu.getName());
            }
        }
    }
}

