/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.rabbitmq.entity.RabbitAPIInvokeEntity;
import com.kingdee.bos.rabbitmq.util.BASE64Encoder;
import com.kingdee.bos.rabbitmq.util.StringUtils;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.rabbitmq.rabbit.app.api.QueueDetailAPI;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMQHttpAPIUtils {
    private static Logger logger = LoggerFactory.getLogger(RabbitMQHttpAPIUtils.class);

    public static List<String> doGet(RabbitAPIInvokeEntity param, List<String> queueList) throws BOSException {
        ArrayList<String> result = new ArrayList<String>();
        for (String queue : queueList) {
            param.setHttpApi(QueueDetailAPI.getURL(param, queue));
            result.add(RabbitMQHttpAPIUtils.doGet(param));
        }
        return result;
    }

    public static String doGet(RabbitAPIInvokeEntity reqParam) throws BOSException {
        JSONObject errorResult;
        if (null == reqParam) {
            logger.error("isc_rabbitmq:the Rabbitmq monitor request http api request parameter is null.");
            throw new BOSException("the Rabbitmq monitor request http api request parameter is null.");
        }
        String strResult = null;
        CloseableHttpResponse response = null;
        try {
            CloseableHttpClient client = HttpClients.createDefault();
            String ip = reqParam.getIp();
            String port = reqParam.getPort();
            String httpApi = reqParam.getHttpApi();
            String userName = reqParam.getUserName();
            String pwd = reqParam.getPassword();
            String protocol = reqParam.getProcotol();
            if (null != httpApi && 0 != httpApi.indexOf("/")) {
                httpApi = httpApi + "/";
            }
            if (StringUtils.isEmpty(protocol)) {
                throw new BOSException("\u8bf7\u6307\u5b9a\u534f\u8bae\u4e3ahttp\u6216https\u3002");
            }
            String url = protocol + "://" + ip + ":" + port + httpApi;
            HttpGet request = new HttpGet(url);
            String up = userName + ":" + pwd;
            String credentials = new BASE64Encoder().encode(up.getBytes("UTF-8"));
            request.setHeader("Authorization", "Basic " + credentials);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(3000).setConnectionRequestTimeout(1000).setSocketTimeout(2000).build();
            request.setConfig(requestConfig);
            response = client.execute((HttpUriRequest)request);
            strResult = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (Exception e) {
            logger.error("the invoke RabbitMQ Http api exception,exception info:", (Object)ThrowableHelper.toString((Exception)e));
            throw new BOSException("\u8c03\u7528MQ\u63a5\u53e3\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
        }
        if (null != response && response.getStatusLine().getStatusCode() == 401) {
            errorResult = (JSONObject)JSONObject.parse((String)strResult);
            if (errorResult.containsKey((Object)"reason")) {
                String errorTip = errorResult.getString("reason");
                if ("User not authorised to access virtual host".equals(errorTip)) {
                    throw new BOSException("\u7528\u6237\uff1a[" + reqParam.getUserName() + "]\uff0c\u6ca1\u6709\u8bbf\u95ee\u865a\u62df\u4e3b\u673a\uff1a[" + reqParam.getVhost() + "]\u7684\u6743\u9650\uff01");
                }
                if ("Login failed".equals(errorTip)) {
                    throw new BOSException("\u7528\u6237\uff1a[" + reqParam.getUserName() + "]\uff0c\u767b\u5f55MQ\u670d\u52a1\u5668\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7528\u6237\u540d\uff0c\u5bc6\u7801\u662f\u5426\u6709\u8bef\uff01");
                }
                if ("Not management user".equals(errorTip)) {
                    throw new BOSException("\u7528\u6237\uff1a[" + reqParam.getUserName() + "]\uff0c\u6743\u9650\u7b49\u7ea7\u8f83\u4f4e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u91cd\u65b0\u5206\u914d\u6743\u9650\uff01");
                }
            }
        } else {
            if (null != response && response.getStatusLine().getStatusCode() == 404) {
                throw new BOSException("\u7528\u6237\uff1a[" + reqParam.getUserName() + "]\uff0c\u8bbf\u95ee\u7684\u961f\u5217\u4e0d\u5b58\u5728\uff0c\u6216\u865a\u62df\u4e3b\u673a\u6709\u8bef\uff01");
            }
            if (null != response && response.getStatusLine().getStatusCode() != 200) {
                errorResult = null;
                try {
                    errorResult = (JSONObject)JSONObject.parse((String)strResult);
                }
                catch (Throwable t) {
                    throw new BOSException("\u7528\u6237\uff1a[" + reqParam.getUserName() + "]\uff0c\u6ca1\u6709\u8bbf\u95ee\u865a\u62df\u4e3b\u673a\uff1a[" + reqParam.getVhost() + "]\u7684\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u865a\u62df\u4e3b\u673a\u662f\u5426\u586b\u5199\u6b63\u786e\uff01");
                }
                StringBuilder errSb = new StringBuilder("RabbitMQ invoke http api error:");
                if (null != errorResult) {
                    if (errorResult.containsKey((Object)"error")) {
                        errSb.append(errorResult.get((Object)"error")).append(",");
                    }
                    if (errorResult.containsKey((Object)"reason")) {
                        errSb.append("reason:").append(errorResult.get((Object)"reason"));
                    }
                    throw new BOSException(errSb.toString());
                }
            }
        }
        return strResult;
    }

    public static int getSingleQueueConsumerCount(RabbitAPIInvokeEntity reqParam) throws BOSException {
        String result = RabbitMQHttpAPIUtils.doGet(reqParam);
        int consumerCount = 0;
        try {
            JSONObject rJson = JSON.parseObject((String)result);
            if (null != rJson && rJson.containsKey((Object)"consumers")) {
                consumerCount = rJson.getIntValue("consumers");
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528RabbitMQ Http API\u83b7\u53d6\u865a\u62df\u4e3b\u673a\u4e0b\u67d0\u4e2a\u961f\u5217\u7684\u6d88\u8d39\u8005\u6570\u91cf\u5f02\u5e38\u3002", (Object)ThrowableHelper.toString((Exception)e));
            throw new BOSException("\u8c03\u7528RabbitMQ Http API\u83b7\u53d6\u865a\u62df\u4e3b\u673a\u4e0b\u67d0\u4e2a\u961f\u5217\u7684\u6d88\u8d39\u8005\u6570\u91cf\u5f02\u5e38\u3002", (Throwable)e);
        }
        return consumerCount;
    }

    public static List<String> getQueueNameByVhost(RabbitAPIInvokeEntity reqParam) throws BOSException {
        String result = RabbitMQHttpAPIUtils.doGet(reqParam);
        ArrayList<String> queueNames = new ArrayList<String>();
        try {
            JSONArray array = JSONObject.parseArray((String)result);
            for (int i = 0; i < array.size(); ++i) {
                JSONObject o = array.getJSONObject(i);
                queueNames.add(o.getString("name"));
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528RabbitMQ Http API\u83b7\u53d6\u865a\u62df\u4e3b\u673a\u4e0b\u961f\u5217\u540d\u79f0\u5f02\u5e38\u3002", (Object)ThrowableHelper.toString((Exception)e));
            throw new BOSException("\u8c03\u7528RabbitMQ Http API\u83b7\u53d6\u865a\u62df\u4e3b\u673a\u4e0b\u961f\u5217\u540d\u79f0\u5f02\u5e38\u3002", (Throwable)e);
        }
        return queueNames;
    }

    public static void main(String[] args) throws BOSException {
        RabbitAPIInvokeEntity reqParam = new RabbitAPIInvokeEntity("172.19.85.200", "15672", "/api/queues/vh_cgh", "cgh", "123456", "http", null);
        List<String> names = RabbitMQHttpAPIUtils.getQueueNameByVhost(reqParam);
        System.out.println(names);
    }
}

