/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.utility;

import java.util.concurrent.TimeoutException;

public class BlockingCell<T> {
    private boolean _filled = false;
    private T _value;
    private static final long NANOS_IN_MILLI = 1000000L;
    private static final long INFINITY = -1L;

    public synchronized T get() throws InterruptedException {
        while (!this._filled) {
            this.wait();
        }
        return this._value;
    }

    public synchronized T get(long timeout) throws InterruptedException, TimeoutException {
        if (timeout == -1L) {
            return this.get();
        }
        if (timeout < 0L) {
            throw new AssertionError((Object)"Timeout cannot be less than zero");
        }
        long now = System.nanoTime() / 1000000L;
        long maxTime = now + timeout;
        while (!this._filled && (now = System.nanoTime() / 1000000L) < maxTime) {
            this.wait(maxTime - now);
        }
        if (!this._filled) {
            throw new TimeoutException();
        }
        return this._value;
    }

    public synchronized T uninterruptibleGet() {
        boolean wasInterrupted = false;
        while (true) {
            try {
                T t = this.get();
                return t;
            }
            catch (InterruptedException ex) {
                wasInterrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized T uninterruptibleGet(int timeout) throws TimeoutException {
        block7: {
            long now = System.nanoTime() / 1000000L;
            long runTime = now + (long)timeout;
            boolean wasInterrupted = false;
            while (true) {
                try {
                    T t = this.get(runTime - now);
                    return t;
                }
                catch (InterruptedException e) {
                    wasInterrupted = true;
                    if ((long)timeout == -1L || (now = System.nanoTime() / 1000000L) < runTime) continue;
                    break block7;
                }
                break;
            }
            finally {
                if (wasInterrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        throw new TimeoutException();
    }

    public synchronized void set(T newValue) {
        if (this._filled) {
            throw new AssertionError((Object)"BlockingCell can only be set once");
        }
        this._value = newValue;
        this._filled = true;
        this.notifyAll();
    }

    public synchronized boolean setIfUnset(T newValue) {
        if (this._filled) {
            return false;
        }
        this.set(newValue);
        return true;
    }
}

