/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.billdigest.tools.app;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.billdigest.BillDigestUtil;
import com.kingdee.bos.billdigest.tools.AbEntityInfo;
import com.kingdee.bos.billdigest.tools.AbTreeNode;
import com.kingdee.bos.billdigest.tools.IBillDigestHelper;
import com.kingdee.bos.billdigest.tools.IBillDigestProvider;
import com.kingdee.bos.billdigest.tools.app.BillDigestHelperUtil;
import com.kingdee.bos.billdigest.tools.app.TreeNodeComparator;
import com.kingdee.bos.billdigest.tools.app.uiobjectgeneractor.UIObjectGeneractor;
import com.kingdee.bos.billdigest.util.format.BillDigestCache;
import com.kingdee.bos.billdigest.util.format.Format;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.dao.xml.impl.DynamicStateManager;
import com.kingdee.bos.dao.xml.impl.IProxyStateManager;
import com.kingdee.bos.dao.xml.impl.IStateManager;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataNotFoundException;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.monitor.BillDigestInfo;
import com.kingdee.bos.workflow.monitor.BillDigestSchemaFactory;
import com.kingdee.bos.workflow.monitor.BillDigestSchemaInfo;
import com.kingdee.bos.workflow.monitor.IBillDigestSchema;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class BillDigestHelper
extends AbstractBOSObject
implements IBillDigestHelper {
    static final Logger logger;
    private static final BOSObjectType BOSTYPE;
    private static SimpleDateFormat simpleDateFormat;
    private static String[] providers;
    private static Comparator<AbTreeNode> cmp;

    public BOSObjectType getType() {
        return BOSTYPE;
    }

    public BillDigestHelper() {
    }

    public BillDigestHelper(Context ctx) {
        super(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadPropertie(String file, Properties map) throws Exception {
        File f = new File(file);
        if (!f.exists()) {
            return;
        }
        Properties properties = new Properties();
        try (FileInputStream fis = new FileInputStream(file);){
            properties.load(fis);
        }
        Enumeration<Object> em = properties.keys();
        while (em.hasMoreElements()) {
            Object o;
            Object key = em.nextElement();
            Object value = properties.get(key);
            if (value instanceof String) {
                try {
                    value = new String(((String)value).getBytes("ISO8859-1"), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    value = properties.get(key);
                }
                value = ((String)value).trim();
            }
            if ((o = map.put(key, value)) == null) continue;
            StringBuffer msg = new StringBuffer();
            msg.append("wf_billabstract config {").append(key).append("=").append(o).append("} is overridden by {").append(file).append("}, with new value{").append(value).append("}");
            logger.info((Object)msg);
        }
    }

    private IBillDigestProvider getProvider(String clzName) throws Exception {
        Class<?> clz = Class.forName(clzName);
        Constructor<?> con = clz.getConstructor(Context.class);
        return (IBillDigestProvider)con.newInstance(this.getContext());
    }

    @Override
    public AbTreeNode getRootNode() {
        AbTreeNode rtn = new AbTreeNode(this, null, "EAS", "EAS");
        boolean flag = false;
        for (int i = 0; i < providers.length; ++i) {
            if (providers[i] == null) continue;
            IBillDigestProvider provider = null;
            try {
                provider = this.getProvider(providers[i]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (provider == null) {
                BillDigestHelper.providers[i] = null;
                continue;
            }
            AbTreeNode tmp = null;
            try {
                tmp = provider.getRootNode();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tmp == null) continue;
            if ("eas".equalsIgnoreCase(tmp.getAlias())) {
                rtn.getChildren().addAll(tmp.getChildren());
            } else {
                rtn.getChildren().add(tmp);
            }
            flag = true;
        }
        if (flag) {
            Collections.sort(rtn.getChildren(), cmp);
        }
        return rtn;
    }

    @Override
    public AbEntityInfo getEntityInfo(String pk) {
        AbEntityInfo rtn = null;
        String[] pks = pk.split(";", 2);
        String providerType = "EAS";
        if (pks.length == 2) {
            pk = pks[0];
            providerType = pks[1];
        }
        IBillDigestProvider easprovider = null;
        IBillDigestProvider curprovider = null;
        for (int i = 0; i < providers.length; ++i) {
            if (providers[i] == null) continue;
            IBillDigestProvider provider = null;
            try {
                provider = this.getProvider(providers[i]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (provider == null) {
                BillDigestHelper.providers[i] = null;
                continue;
            }
            if (curprovider == null && providerType.equalsIgnoreCase(provider.getClass().getName())) {
                curprovider = provider;
            }
            if (easprovider != null || !"EAS".equalsIgnoreCase(provider.getProviderType())) continue;
            easprovider = provider;
        }
        if (curprovider != null) {
            try {
                rtn = curprovider.getEntityInfo(pk);
            }
            catch (Exception e) {
                logger.error((Object)(curprovider.getClass().getName() + " getEntityInfo error!"), (Throwable)e);
                rtn = null;
            }
        }
        if (rtn == null && easprovider != null && curprovider != easprovider) {
            try {
                if (easprovider != null) {
                    rtn = easprovider.getEntityInfo(pk);
                }
            }
            catch (Exception e) {
                rtn = null;
            }
        }
        return rtn;
    }

    @Override
    public boolean addnew(String bostype, String name, String entityName, String purpose, String template) {
        Timestamp createdtime;
        String creatorid;
        String sql = "insert into T_BAS_BILLDIGESTTMP (fid,fname,fbostype,fpurpose,fentityname,ftemplate,fcreatorid,fcreatedtime,flastupdateduserid,flastupdatedtime)values(?,?,?,?,?,?,?,?,?,?)";
        boolean rtn = false;
        Context ctx = this.getContext();
        String id = Uuid.create().toString();
        String lastupdateduserid = creatorid = ctx.getCaller().toString();
        Timestamp lastupdatedtime = createdtime = new Timestamp(System.currentTimeMillis());
        try {
            SQL.executeUpdate((Context)ctx, (String)sql, (int[])new int[]{12, 12, 12, 12, 12, 12, 12, 93, 12, 93}, (Object[])new Object[]{id, name, bostype, purpose, entityName, template, creatorid, createdtime, lastupdateduserid, lastupdatedtime});
            rtn = true;
        }
        catch (Exception ex) {
            logger.error((Object)(BillDigestHelper.class.getName() + ".update(" + bostype + "," + entityName + "," + purpose + ",...) occured error!"), (Throwable)ex);
            rtn = false;
        }
        BillDigestCache.clear();
        return rtn;
    }

    @Override
    public boolean update(String bostype, String name, String entityName, String purpose, String template) {
        String sql = "update T_BAS_BILLDIGESTTMP set fname=?,ftemplate=?,flastupdateduserid=?,flastupdatedtime=? where fbostype=? and fpurpose=?";
        boolean rtn = false;
        try {
            Context ctx = this.getContext();
            String lastupdateduserid = ctx.getCaller().toString();
            Timestamp lastupdatedtime = new Timestamp(System.currentTimeMillis());
            int i = SQL.executeUpdate((Context)ctx, (String)sql, (int[])new int[]{12, 12, 12, 93, 12, 12}, (Object[])new Object[]{name, template, lastupdateduserid, lastupdatedtime, bostype, purpose});
            if (i > 0) {
                rtn = true;
            }
        }
        catch (Exception ex) {
            logger.error((Object)(BillDigestHelper.class.getName() + ".update(" + bostype + "," + entityName + "," + purpose + ",...) occured error!"), (Throwable)ex);
            rtn = false;
        }
        BillDigestCache.clear();
        return rtn;
    }

    @Override
    public boolean delete(String bostype, String entityName, String purpose) {
        String sql = "delete from T_BAS_BILLDIGESTTMP where fbostype=? and fpurpose=?";
        boolean rtn = false;
        try {
            int i = SQL.executeUpdate((Context)this.getContext(), (String)sql, (int[])new int[]{12, 12}, (Object[])new Object[]{bostype, purpose});
            if (i > 0) {
                rtn = true;
            }
        }
        catch (Exception ex) {
            logger.error((Object)(BillDigestHelper.class.getName() + ".delete(" + bostype + "," + entityName + "," + purpose + ") occured error!"), (Throwable)ex);
            rtn = false;
        }
        BillDigestCache.clear();
        return rtn;
    }

    @Override
    public boolean deleteById(String id) {
        String sql = "delete from T_BAS_BILLDIGESTTMP where fid=?";
        boolean rtn = false;
        try {
            int i = SQL.executeUpdate((Context)this.getContext(), (String)sql, (int[])new int[]{12}, (Object[])new Object[]{id});
            if (i > 0) {
                rtn = true;
            }
        }
        catch (Exception ex) {
            logger.error((Object)(BillDigestHelper.class.getName() + ".deleteByID(" + id + ") occured error!"), (Throwable)ex);
            rtn = false;
        }
        BillDigestCache.clear();
        return rtn;
    }

    @Override
    public boolean exists(String bostype, String entityName, String purpose) {
        String sql = "select fid from T_BAS_BILLDIGESTTMP where fbostype=? and fpurpose=?";
        boolean rtn = false;
        try {
            ArrayList list = SQL.executeQuery((Context)this.getContext(), (String)sql, (int[])new int[]{12, 12}, (Object[])new Object[]{bostype, purpose});
            rtn = list.size() > 0;
        }
        catch (Exception ex) {
            logger.error((Object)(BillDigestHelper.class.getName() + ".exists(" + bostype + "," + entityName + "," + purpose + ") occured error!"), (Throwable)ex);
            rtn = false;
        }
        return rtn;
    }

    public String getLastUpdateTime(String bostype, String entityName, String purpose) {
        String sql = "select flastupdatedtime from T_BAS_BILLDIGESTTMP where fbostype=? and fpurpose=?";
        String rtn = "";
        try {
            ArrayList list = SQL.executeQuery((Context)this.getContext(), (String)sql, (int[])new int[]{12, 12}, (Object[])new Object[]{bostype, purpose});
            if (list.size() > 0) {
                Object obj = ((Map)list.get(0)).get("flastupdatedtime");
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                if (obj instanceof Date) {
                    rtn = rtn + sdf.format(obj);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)(BillDigestHelper.class.getName() + ".exists(" + bostype + "," + entityName + "," + purpose + ") occured error!"), (Throwable)ex);
            rtn = "";
        }
        return rtn;
    }

    @Override
    public String getProviderType() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<?> list(int start, int end, String name, String bostype, String entityName, String purpose) {
        ArrayList rtn = null;
        String sql = "select fid as \"id\",fname as \"name\",fbostype as \"bostype\",fpurpose as \"purpose\",fentityname as \"entityname\",fcreatedtime as \"createdtime\",flastupdatedtime as \"lastupdatedtime\" from T_BAS_BILLDIGESTTMP";
        String where = " where ";
        boolean flag = false;
        if (!StringUtils.isEmpty((String)name)) {
            if (flag) {
                where = where + " and ";
            }
            where = where + "fentityname like ?";
            name = "%" + name + "%";
            flag = true;
        }
        if (!StringUtils.isEmpty((String)bostype)) {
            if (flag) {
                where = where + " and ";
            }
            where = where + "fbostype=?";
            flag = true;
        }
        if (!StringUtils.isEmpty((String)entityName)) {
            if (flag) {
                where = where + " and ";
            }
            where = where + "fentityname like ?";
            entityName = "%" + entityName + "%";
            flag = true;
        }
        if (!StringUtils.isEmpty((String)purpose)) {
            if (flag) {
                where = where + " and ";
            }
            where = where + "fpurpose=?";
            flag = true;
        }
        if (flag) {
            sql = sql + where;
        }
        sql = sql + " order by \"lastupdatedtime\" desc";
        Connection cn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            cn = EJBFactory.getConnection((Context)this.getContext());
            int dbType = KSqlUtil.getDbType((Connection)cn);
            sql = this.getLimitSQLForPage(dbType, sql, start, end);
            ps = cn.prepareStatement(sql);
            if (flag) {
                int i = 1;
                if (!StringUtils.isEmpty((String)name)) {
                    ps.setString(i, name);
                    ++i;
                }
                if (!StringUtils.isEmpty((String)bostype)) {
                    ps.setString(i, bostype);
                    ++i;
                }
                if (!StringUtils.isEmpty((String)entityName)) {
                    ps.setString(i, entityName);
                    ++i;
                }
                if (!StringUtils.isEmpty((String)purpose)) {
                    ps.setString(i, purpose);
                    ++i;
                }
            }
            rs = ps.executeQuery();
            rtn = SQL.toArray((ResultSet)rs);
        }
        catch (Exception ex) {
            try {
                logger.error((Object)(BillDigestHelper.class.getName() + ".list(" + start + "," + end + "," + bostype + "," + entityName + "," + purpose + ") occured error!"), (Throwable)ex);
                rtn = null;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)cn);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)cn);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)cn);
        return rtn;
    }

    private String getLimitSQLForPage(int dbType, String sql, int start, int top) {
        if (dbType == 2 || dbType == 7 || dbType == 8) {
            sql = this.getLimitSQLForPageFrOracle(dbType, sql, start, top);
        } else if (dbType == 1 || dbType == 9) {
            sql = this.getLimitSQLForPageFrBD2(dbType, sql, start, top);
        } else if (dbType == 3) {
            sql = this.getLimitSQLForPageFrMS(dbType, sql, start, top);
        }
        return sql;
    }

    private String getLimitSQLForPageFrMS(int dbType, String sql, int start, int top) {
        StringBuffer Sqllimit = new StringBuffer();
        Sqllimit.append("/*dialect*/");
        int orderByIndex = sql.toLowerCase().indexOf("order by");
        if (orderByIndex > 0) {
            String orderby = sql.substring(orderByIndex);
            String orderbyRflex = this.formatRflexOrder(orderby);
            sql = sql.substring(0, orderByIndex);
            Sqllimit.append("SELECT * FROM (SELECT TOP ").append(top - start).append(" * FROM (").append("SELECT TOP ").append(top).append(" * FROM (").append(sql).append(") AS T1 ").append(orderby).append(") AS T2 ").append(orderbyRflex).append(")AS T3 ").append(orderby);
            return Sqllimit.toString();
        }
        Sqllimit.append("SELECT * FROM (SELECT TOP ").append(top).append(" * FROM (").append(sql).append(")AS T1 ").append(")AS T2 ");
        return Sqllimit.toString();
    }

    private String formatRflexOrder(String OrderSql) {
        String regEx1 = " asc";
        Pattern pat1 = Pattern.compile(regEx1);
        Matcher mat1 = pat1.matcher(OrderSql);
        String s1 = mat1.replaceAll("#RlexAC#");
        String regEx2 = " desc";
        Pattern pat2 = Pattern.compile(regEx2);
        Matcher mat2 = pat2.matcher(s1);
        String s2 = mat2.replaceAll(" asc");
        String regEx3 = "#RlexAC#";
        Pattern pat3 = Pattern.compile(regEx3);
        Matcher mat3 = pat3.matcher(s2);
        String s3 = mat3.replaceAll(" desc");
        return s3;
    }

    private String getLimitSQLForPageFrOracle(int dbType, String sql, int start, int top) {
        StringBuffer sqlLimit = new StringBuffer();
        return sqlLimit.append("/*dialect*/").append(" SELECT * FROM(SELECT tableA.*, ROWNUM RN  FROM ( ").append(sql).append(" )tableA )WHERE RN >").append(start).append(" AND RN <= ").append(top).toString();
    }

    private String getLimitSQLForPageFrBD2(int dbType, String sql, int start, int top) {
        int startOfSelect = sql.toLowerCase().indexOf("select");
        StringBuffer pagingSelect = new StringBuffer(sql.length() + 100).append("/*dialect*/").append("SELECT * from ( SELECT tableA.*,").append(this.getRowNumberForDB2(sql));
        if (sql.toLowerCase().indexOf("select distinct") >= 0) {
            pagingSelect.append(" row_.* from ( ").append(sql.substring(startOfSelect)).append(" ) as row_");
        } else {
            pagingSelect.append(sql.substring(startOfSelect + 6));
        }
        pagingSelect.append(")AS tableA) as temp_ where rownumber_ ");
        pagingSelect.append("between ");
        pagingSelect.append(start);
        pagingSelect.append("+1 and ");
        pagingSelect.append(top);
        return pagingSelect.toString();
    }

    private String getRowNumberForDB2(String sql) {
        StringBuffer rownumber = new StringBuffer(50).append("rownumber() over(");
        int orderByIndex = sql.toLowerCase().indexOf("order by");
        if (orderByIndex > 0 && sql.toLowerCase().indexOf("select distinct") < 0) {
            rownumber.append(sql.substring(orderByIndex));
        }
        rownumber.append(") as rownumber_ FROM (SELECT");
        return rownumber.toString();
    }

    @Override
    public Map<?, ?> getById(String id) {
        String sql = "select fid as \"id\",fname as \"name\",fbostype as \"bostype\",fpurpose as \"purpose\",fentityname as \"entityname\",ftemplate as \"template\" from T_BAS_BILLDIGESTTMP where fid = ?";
        try {
            ArrayList list = SQL.executeQuery((Context)this.getContext(), (String)sql, (int[])new int[]{12}, (Object[])new Object[]{id});
            if (list.size() == 1) {
                Map data = (Map)list.get(0);
                return data;
            }
        }
        catch (Exception ex) {
            logger.error((Object)(BillDigestHelper.class.getName() + ".getById(" + id + ") occured error!"), (Throwable)ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCount() {
        int rtn;
        ResultSet rs;
        PreparedStatement ps;
        Connection cn;
        block4: {
            String sql = "select count(fid) c from T_BAS_BILLDIGESTTMP";
            cn = null;
            ps = null;
            rs = null;
            rtn = 0;
            try {
                cn = EJBFactory.getConnection((Context)this.getContext());
                ps = cn.prepareStatement(sql);
                rs = ps.executeQuery();
                if (!rs.next()) break block4;
                rtn = rs.getInt(1);
            }
            catch (Exception ex) {
                try {
                    logger.error((Object)(BillDigestHelper.class.getName() + ".getCount() occured error!"), (Throwable)ex);
                    rtn = 0;
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, ps, (Connection)cn);
                    throw throwable;
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)cn);
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)cn);
        return rtn;
    }

    @Override
    public AbTreeNode getNodeByPk(String pk) {
        AbTreeNode rtn = null;
        if (pk == null) {
            rtn = new AbTreeNode(this, null, "EAS", "EAS");
            boolean flag = false;
            for (int i = 0; i < providers.length; ++i) {
                if (providers[i] == null) continue;
                IBillDigestProvider provider = null;
                try {
                    provider = this.getProvider(providers[i]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (provider == null) {
                    BillDigestHelper.providers[i] = null;
                    continue;
                }
                AbTreeNode tmp = null;
                try {
                    tmp = provider.getNodeByPk(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (tmp == null) continue;
                if ("eas".equalsIgnoreCase(tmp.getAlias())) {
                    rtn.getChildren().addAll(tmp.getChildren());
                } else {
                    rtn.getChildren().add(tmp);
                }
                flag = true;
            }
            if (flag) {
                Collections.sort(rtn.getChildren(), cmp);
            }
        } else {
            String[] pks = pk.split(";", 2);
            String providerType = "EAS";
            if (pks.length == 2) {
                pk = pks[0];
                providerType = pks[1];
            }
            IBillDigestProvider easprovider = null;
            IBillDigestProvider curprovider = null;
            for (int i = 0; i < providers.length; ++i) {
                if (providers[i] == null) continue;
                IBillDigestProvider provider = null;
                try {
                    provider = this.getProvider(providers[i]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (provider == null) {
                    BillDigestHelper.providers[i] = null;
                    continue;
                }
                if (curprovider == null && providerType.equalsIgnoreCase(provider.getClass().getName())) {
                    curprovider = provider;
                }
                if (easprovider != null || !"EAS".equalsIgnoreCase(provider.getProviderType())) continue;
                easprovider = provider;
            }
            if (curprovider != null) {
                try {
                    rtn = curprovider.getNodeByPk(pk);
                }
                catch (Exception e) {
                    logger.error((Object)(curprovider.getClass().getName() + " getEntityInfo error!"), (Throwable)e);
                    rtn = null;
                }
            }
            if (rtn == null && easprovider != null && curprovider != easprovider) {
                try {
                    if (easprovider != null) {
                        rtn = easprovider.getNodeByPk(pk);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)(easprovider.getClass().getName() + " getEntityInfo error!"), (Throwable)e);
                    rtn = null;
                }
            }
        }
        return rtn;
    }

    @Override
    public AbTreeNode getUITreeNodeByPk(String pk) {
        AbTreeNode rtn = BillDigestHelperUtil.getNode(this.getContext(), this, MetaDataTypeList.UIOBJECT, MetaDataPK.create((String)"com_kingdee_eas_base_ui"), cmp, pk, new String[]{"listui"});
        return rtn;
    }

    @Override
    public String UIObjectGeneracte(String pk) {
        return UIObjectGeneractor.Generactor(this.getContext(), pk);
    }

    @Override
    public Map<?, ?> getDataByUIObjectPk(String pk) {
        DataObjectInfo doi;
        String billdigest = this.UIObjectGeneracte(pk);
        HashMap<String, String> rtn = new HashMap<String, String>();
        IMetaDataLoader mdloader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.getContext());
        UIObjectInfo ui = (UIObjectInfo)mdloader.get(MetaDataTypeList.UIOBJECT, (IMetaDataPK)MetaDataPK.create((String)pk));
        if (ui != null && ui.getDataObjects() != null && ui.getDataObjects().size() > 0 && (doi = ui.getDataObjects().get(0)).getType() != null) {
            String bostype = this.getBosTypeByPk(doi.getType());
            rtn.put("template", billdigest);
            rtn.put("name", ui.getAlias());
            rtn.put("entityname", doi.getType());
            rtn.put("bostype", bostype);
        }
        return rtn;
    }

    private String getBosTypeByPk(String pk) {
        int hash = pk.hashCode();
        String type = Integer.toHexString(hash).toUpperCase();
        if (type.length() > 8) {
            type = type.substring(0, 8);
        } else if (type.length() < 8) {
            int n = type.length();
            for (int i = 0; i < 8 - n; ++i) {
                type = "0" + type;
            }
        }
        return type;
    }

    @Override
    public boolean isExistDigest(BOSObjectType bosType, String scene) throws Exception {
        return BillDigestUtil.isExistDigest((Context)this.getContext(), (BOSObjectType)bosType, (String)scene);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public String export(String[] ids) {
        sql = "select fid as \"id\",fname as \"name\",fbostype as \"bostype\",fpurpose as \"purpose\",fentityname as \"entityname\",ftemplate as \"template\", flastupdatedtime as \"lastupdatedtime\" from T_BAS_BILLDIGESTTMP";
        if (ids != null && ids.length > 0) {
            sql = sql + " where fid in (?";
            for (i = 1; i < ids.length; ++i) {
                sql = sql + ",?";
            }
            sql = sql + ")";
        }
        try {
            tmpfile = File.createTempFile("digest_export_", ".xml");
            osw = new OutputStreamWriter((OutputStream)new FileOutputStream(tmpfile), "UTF-8");
            bw = new BufferedWriter(osw);
            bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            bw.write("<digests>");
            cn = null;
            ps = null;
            rs = null;
            try {
                cn = EJBFactory.getConnection((Context)this.getContext());
                ps = cn.prepareStatement(sql);
                if (ids != null) {
                    for (i = 0; i < ids.length; ++i) {
                        ps.setString(i + 1, ids[i]);
                    }
                }
                rs = ps.executeQuery();
                d = new Date();
                while (rs.next()) {
                    bw.write("<digest>");
                    bw.write("<name><![CDATA[" + BillDigestHelper.convert(rs.getObject("name")) + "]]></name>");
                    bw.write("<bostype>" + BillDigestHelper.convert(rs.getObject("bostype")) + "</bostype>");
                    bw.write("<purpose>" + BillDigestHelper.convert(rs.getObject("purpose")) + "</purpose>");
                    bw.write("<updatetime>" + BillDigestHelper.convert(d) + "</updatetime>");
                    bw.write("<entityname><![CDATA[" + BillDigestHelper.convert(rs.getObject("entityname")) + "]]></entityname>");
                    bw.write("<template><![CDATA[" + BillDigestHelper.convert(rs.getObject("template")) + "]]></template>");
                    bw.write("</digest>");
                    bw.flush();
                }
            }
            catch (Exception ex) {
                try {
                    BillDigestHelper.logger.error((Object)(BillDigestHelper.class.getName() + ".getCount() occured error!"), (Throwable)ex);
                }
                catch (Throwable var10_14) {
                    SQLUtils.cleanup(rs, ps, (Connection)cn);
                    if (bw != null) {
                        bw.close();
                    }
                    if (osw != null) {
                        osw.close();
                    }
                    throw var10_14;
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)cn);
                if (bw != null) {
                    bw.close();
                }
                if (osw != null) {
                    osw.close();
                } else {
                    ** GOTO lbl59
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)cn);
            if (bw != null) {
                bw.close();
            }
            if (osw != null) {
                osw.close();
            }
            bw.write("</digests>");
            bw.close();
            return tmpfile.getAbsolutePath();
        }
        catch (Exception e) {
            BillDigestHelper.logger.error((Object)(BillDigestHelper.class.getName() + "Digest export error! " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    private static Object convert(Object o) throws SQLException, IOException {
        if (o instanceof Clob) {
            return BillDigestHelper.clobToString((Clob)o);
        }
        if (o instanceof Blob) {
            return BillDigestHelper.fromBlob((Blob)o);
        }
        if (o instanceof Date) {
            return simpleDateFormat.format((Date)o);
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object fromBlob(Blob blob) throws SQLException, IOException {
        if (blob == null) {
            return null;
        }
        int len = (int)blob.length();
        if (len == 0) {
            return null;
        }
        byte[] bytes = new byte[len];
        try (InputStream is = blob.getBinaryStream();){
            is.read(bytes);
        }
        return bytes;
    }

    private static String clobToString(Clob clob) throws SQLException, IOException {
        StringBuffer sb = new StringBuffer();
        try (Reader r = clob.getCharacterStream();){
            int ch22;
            while ((ch22 = r.read()) >= 0) {
                sb.append((char)ch22);
            }
            String ch22 = sb.toString();
            return ch22;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean importData(String file, boolean isOverride) throws Exception {
        try (FileInputStream is = new FileInputStream(file);){
            File tmpfile = new File(file);
            if (!tmpfile.exists()) {
                boolean bl = false;
                return bl;
            }
            SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser");
            Document doc = builder.build((InputStream)is);
            Element element = doc.getRootElement();
            List eleList = element.getChildren("digest");
            int len = eleList.size();
            for (int i = 0; i < len; ++i) {
                Element ele = (Element)eleList.get(i);
                String name = ele.getChildText("name");
                String bostype = ele.getChildText("bostype");
                String purpose = ele.getChildText("purpose");
                String template = ele.getChildText("template");
                String entityname = ele.getChildText("entityname");
                String lastupdatetime = ele.getChildText("updatetime");
                String oldLastupdatetime = this.getLastUpdateTime(bostype, entityname, purpose);
                if (oldLastupdatetime != null && oldLastupdatetime.length() > 0) {
                    Date d2;
                    if (lastupdatetime == null || lastupdatetime.length() == 0 || isOverride) {
                        this.update(bostype, name, entityname, purpose, template);
                        continue;
                    }
                    Date d1 = simpleDateFormat.parse(lastupdatetime);
                    if (!d1.after(d2 = simpleDateFormat.parse(oldLastupdatetime))) continue;
                    this.update(bostype, name, entityname, purpose, template);
                    continue;
                }
                this.addnew(bostype, name, entityname, purpose, template);
            }
            boolean bl = true;
            return bl;
        }
        return false;
    }

    @Override
    public List<?> getUpgrateDigest() throws Exception {
        String sql = "select fid as \"id\",fname as \"name\",fbostype as \"bostype\",fpurpose as \"purpose\",fentityname as \"entityname\",fcreatedtime as \"createdtime\",flastupdatedtime as \"lastupdatedtime\" from T_BAS_BILLDIGESTTMP tmp where FPURPOSE ='wf' and not EXISTS (select FID from T_WM_BILLDIGEST where FMETADATAPK = tmp.FENTITYNAME) order by \"lastupdatedtime\" desc";
        ArrayList list = SQL.executeQuery((Context)this.getContext(), (String)sql);
        return list;
    }

    @Override
    public String Upgrate(String ids) throws BOSException {
        String[] idArr = ids.split(",");
        IBillDigestSchema instance = BillDigestSchemaFactory.getLocalInstance((Context)this.getContext());
        for (String id : idArr) {
            Map<?, ?> data = this.getById(id);
            String digest = (String)data.get("template");
            String metaDataPk = (String)data.get("entityname");
            Format format = new Format(digest);
            CoreBaseInfo col = this.createDigestCollection(format.getReferences(), metaDataPk);
            try {
                instance.save(col);
            }
            catch (EASBizException e) {
                logger.error((Object)("upgrate : " + id + "failed"), (Throwable)e);
                return id;
            }
        }
        return "true";
    }

    private CoreBaseInfo createDigestCollection(Collection<String> col, String metaDataPk) throws BOSException {
        CoreBaseCollection digest = new CoreBaseCollection();
        EntityObjectInfo entity = this.loadEntity(this.getContext(), metaDataPk);
        BillDigestInfo root = new BillDigestInfo();
        root.setMetadataPK(entity.getFullName());
        root.setIsOABill(this.isOABill(entity.getBOSType()).booleanValue());
        root.setAlias(entity.getAlias());
        digest.add((CoreBaseInfo)root);
        int i = 0;
        BillDigestInfo root1 = new BillDigestInfo();
        for (String property : col) {
            BillDigestInfo digestInfo = new BillDigestInfo();
            root1.setMetadataPK(entity.getFullName());
            root1.setPropertyName(property);
            root1.setPropertyGroup(null);
            root1.setAlias(null);
            digestInfo.setMetadataPK(entity.getFullName());
            this.createDigest(property, entity, digestInfo, root1, digest);
            if (StringUtils.isEmpty((String)digestInfo.getPropertyName()) && StringUtils.isEmpty((String)digestInfo.getAlias()) && StringUtils.isEmpty((String)digestInfo.getPropertyGroup())) continue;
            digestInfo.setIndex(i);
            digest.add((CoreBaseInfo)digestInfo);
            ++i;
        }
        BillDigestSchemaInfo schema = new BillDigestSchemaInfo();
        schema.setBillMetadataPk(entity.getFullName());
        schema.getBilldigest().addObjectCollection((IObjectCollection)digest);
        schema.setShcema_alias(entity.getAlias());
        return schema;
    }

    private void createDigest(String propertyName, EntityObjectInfo entity, BillDigestInfo info, BillDigestInfo rootInfo, CoreBaseCollection cols) {
        String[] strings;
        PropertyCollection properties = entity.getInheritedNoDuplicatedPropertiesRuntime();
        PropertyInfo property = (PropertyInfo)properties.getObject((Object)(strings = StringUtils.split((String)propertyName, (String)"."))[0]);
        if (property instanceof LinkPropertyInfo) {
            LinkPropertyInfo lp = (LinkPropertyInfo)property;
            if (this.isEntry(lp)) {
                BillDigestInfo parentInfo = new BillDigestInfo();
                EntityObjectInfo lpEntity = lp.getRelationship().getSupplierObject();
                parentInfo.setMetadataPK(info.getMetadataPK());
                rootInfo.setPropertyGroup(parentInfo.getPropertyGroup());
                parentInfo.setAlias(lpEntity.getAlias());
                if (!StringUtils.isEmpty((String)rootInfo.getPropertyGroup())) {
                    parentInfo.setPropertyGroup(rootInfo.getPropertyGroup() + "." + strings[0]);
                    rootInfo.setPropertyGroup(rootInfo.getPropertyGroup() + "." + strings[0]);
                } else {
                    parentInfo.setPropertyGroup(strings[0]);
                    rootInfo.setPropertyGroup(strings[0]);
                }
                parentInfo.setPreviewNum(3);
                if (!cols.contains((CoreBaseInfo)parentInfo)) {
                    cols.add((CoreBaseInfo)parentInfo);
                }
                String lpName = propertyName.substring(propertyName.indexOf(".") + 1);
                rootInfo.setPropertyName(lpName);
                this.createDigest(lpName, lpEntity, info, rootInfo, cols);
            } else {
                EntityObjectInfo lpEntity = lp.getRelationship().getSupplierObject();
                String lpName = "name";
                if (propertyName.indexOf(".") > 0) {
                    lpName = propertyName.substring(propertyName.indexOf(".") + 1);
                }
                if (!StringUtils.isEmpty((String)rootInfo.getAlias())) {
                    rootInfo.setAlias(rootInfo.getAlias() + lpEntity.getAlias());
                } else {
                    rootInfo.setAlias(lpEntity.getAlias());
                }
                this.createDigest(lpName, lpEntity, info, rootInfo, cols);
            }
        } else if (property instanceof OwnPropertyInfo) {
            OwnPropertyInfo op = (OwnPropertyInfo)property;
            info.setMetadataPK(rootInfo.getMetadataPK());
            info.setPropertyName(rootInfo.getPropertyName());
            if (!StringUtils.isEmpty((String)rootInfo.getAlias())) {
                info.setAlias(rootInfo.getAlias() + "." + op.getAlias());
            } else {
                info.setAlias(op.getAlias());
            }
            info.setPropertyGroup(rootInfo.getPropertyGroup());
            DataType dataType = op.getDataType();
            this.setShowFormat(dataType, info);
        }
    }

    private EntityObjectInfo loadEntity(Context ctx, String pk) {
        MetaDataPK mdpk;
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = loader.getEntity((IMetaDataPK)(mdpk = MetaDataPK.create((String)pk)));
        if (this.isEmptyMD((AbstractMDValue)entity)) {
            throw new MetaDataNotFoundException();
        }
        return entity;
    }

    private boolean isEmptyMD(AbstractMDValue amd) {
        if (amd == null) {
            return true;
        }
        IStateManager sm = amd.getStateManager();
        if (sm == null) {
            return true;
        }
        if (sm instanceof IProxyStateManager) {
            sm = ((IProxyStateManager)sm).getNoProxyDelegate();
        }
        return sm instanceof DynamicStateManager && ((DynamicStateManager)sm).isNull();
    }

    private Boolean isOABill(BOSObjectType BOSType) throws BOSException {
        String querySql = "select FID from T_BAS_FormEntity where FBosType='" + BOSType.toString() + "' and  FFormID  in (select fid from t_bas_form where FTemplateID  in ('tqAoxLV0TguihBZ6eqU8bZp+rpI=','C/T4g3UCStmKrMRuH4ErO5p+rpI=')) ";
        ArrayList rowSet = SQL.executeQuery((Context)this.getContext(), (String)querySql);
        if (rowSet.size() > 0) {
            return true;
        }
        return false;
    }

    private boolean isEntry(LinkPropertyInfo property) {
        RelationshipInfo relationship = property.getRelationship();
        return Boolean.TRUE.toString().equalsIgnoreCase(property.getExtendedProperty("isEntries")) || relationship != null && relationship.getClientObject() != null && RelationshipType.COMPOSITION.equals((Object)relationship.getType()) && CardinalityType.ONE.equals((Object)relationship.getClientCardinality()) && (CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)relationship.getSupplierCardinality()) || CardinalityType.ONE_TO_UNBOUNDED.equals((Object)relationship.getSupplierCardinality()));
    }

    public void setShowFormat(DataType dataType, BillDigestInfo info) {
        if (DataType.DATE.equals((Object)dataType) || DataType.TIMESTAMP.equals((Object)dataType) || DataType.TIME.equals((Object)dataType)) {
            info.setShowFormate("yyyy-MM-dd");
        } else if (DataType.DECIMAL.equals((Object)dataType) || DataType.DOUBLE.equals((Object)dataType) || DataType.FLOAT.equals((Object)dataType) || DataType.INTEGER.equals((Object)dataType) || DataType.LONG.equals((Object)dataType) || DataType.SHORT.equals((Object)dataType)) {
            info.setShowFormate("###,##0.00");
        }
    }

    static {
        int i;
        logger = Logger.getLogger((String)BillDigestHelper.class.getName());
        BOSTYPE = BOSObjectType.create((String)"BAHFACAD");
        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        cmp = new TreeNodeComparator<AbTreeNode>();
        Properties properties = new Properties();
        String tmp = System.getProperty("java.security.auth.login.config");
        int n = i = tmp == null ? -1 : tmp.lastIndexOf("/");
        if (i < 0) {
            providers = new String[0];
            logger.error((Object)"System.getProperty('java.security.auth.login.config') not found!");
        } else {
            String path = tmp.substring(0, i) + "/";
            String file = path + "wf_billdigest.properties";
            try {
                BillDigestHelper.loadPropertie(file, properties);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            file = path + "wf_billdigest-sp.properties";
            try {
                BillDigestHelper.loadPropertie(file, properties);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add("com.kingdee.bos.billdigest.tools.app.EasBillDigestProvider");
            Enumeration<Object> em = properties.keys();
            while (em.hasMoreElements()) {
                Object key = em.nextElement();
                Object value = properties.get(key);
                if (value == null || !"true".equalsIgnoreCase(value.toString())) continue;
                try {
                    String str = key.toString();
                    if (list.contains(str)) continue;
                    list.add(str);
                }
                catch (Exception exception) {}
            }
            providers = list.toArray(new String[list.size()]);
        }
    }
}

