/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bot.engine.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRuleInfo;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;

public class BotEntityUtils {
    public static String getColumnNameByOwnerPropName(Context ctx, EntityObjectInfo entity, String ownerPropName) throws BOSException {
        String columnName = null;
        if (entity == null) {
            throw new BOSException("Illegal Argument Error!  entity is null.");
        }
        if (StringUtils.isEmpty((String)ownerPropName)) {
            throw new BOSException("Illegal Argument Error!  ownerPropName is empty.");
        }
        PropertyCollection props = entity.getInheritedPropertiesRuntime();
        if (!props.containsKey((Object)ownerPropName)) {
            throw new BOSException("Can't found propertyUnit: [" + ownerPropName + "] in [" + entity.getPackage() + "." + entity.getName() + "]!");
        }
        PropertyInfo prop = (PropertyInfo)props.getObject((Object)ownerPropName);
        ColumnInfo column = prop.getMappingField();
        if (column != null) {
            columnName = column.getName();
            if (column.isMultilingual()) {
                columnName = columnName + "_" + ctx.getLocale().toString();
            }
        }
        return columnName;
    }

    public static EntityObjectInfo getEntity(Context ctx, BOSObjectType objectType) {
        IMetaDataLoader loader = null;
        loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        return loader.getEntity(objectType);
    }

    public static EntityObjectInfo getEntity(Context ctx, IMetaDataPK entityPK) {
        IMetaDataLoader loader = null;
        loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        return loader.getEntity(entityPK);
    }

    public static Object getFieldValueByDeepPropName(EntityObjectInfo entity, IObjectValue bill, String propertyName) throws BOSException {
        if (StringUtils.isEmpty((String)propertyName)) {
            throw new BOSException("Error, propertyName is null!");
        }
        if (bill == null || entity == null) {
            throw new BOSException("Error, entity=" + entity + ",  bill=" + bill);
        }
        String[] names = StringUtils.split((String)propertyName, (String)".");
        IObjectValue currObj = bill;
        String name = null;
        for (int i = 0; i < names.length - 1; ++i) {
            name = names[i];
            currObj = (IObjectValue)currObj.get(name);
        }
        name = names[names.length - 1];
        Object val = currObj.get(name);
        return val;
    }

    public static String getTempTableFilterByRuleInfo(BOTMappingInfo mappingInfo, BOTRuleInfo botRuleInfo) {
        StringBuffer buffFilter = new StringBuffer();
        buffFilter.append(" bot_tmp_MappingID ='" + mappingInfo.getId().toString() + "'");
        buffFilter.append(" AND ");
        buffFilter.append(" bot_tmp_RuleID ='" + botRuleInfo.getId().toString() + "'");
        return buffFilter.toString();
    }
}

