/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bot.engine.common;

import com.kingdee.eas.base.botp.util.BOTPDBlockTools;
import java.io.File;
import java.io.IOException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class LogUtils {
    private static final LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
    private static final Configuration config = context.getConfiguration();

    private LogUtils() {
    }

    private static void start(String directoryName) {
        String fileName;
        File file;
        Configuration config = context.getConfiguration();
        PatternLayout layout = PatternLayout.newBuilder().withConfiguration(config).withPattern("[%t %d{HH:mm:ss}]%m%n").build();
        SizeBasedTriggeringPolicy policy = SizeBasedTriggeringPolicy.createPolicy((String)"10MB");
        DefaultRolloverStrategy strategy = DefaultRolloverStrategy.newBuilder().withMax("2147483647").withMin("1").build();
        String tempInstanceHome = System.getProperty(BOTPDBlockTools.EAS_INSTANCE_HOME);
        String dirName = tempInstanceHome + "/logs/botpTrace/" + directoryName;
        File dir = new File(dirName = dirName.replace("/", File.separator));
        if (!dir.exists() && !dir.isDirectory()) {
            dir.mkdirs();
        }
        if (!(file = new File(fileName = dirName + File.separator + "BotpTrace.log")).exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        RollingFileAppender appender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().withName(directoryName)).withFileName(fileName).withFilePattern(fileName + ".%d{yyyy-MM-dd}.%i").withAppend(true).withPolicy((TriggeringPolicy)policy).withLayout((Layout)layout)).withStrategy((RolloverStrategy)strategy).withConfiguration(config)).build();
        appender.start();
        config.addAppender((Appender)appender);
        AppenderRef ref = AppenderRef.createAppenderRef((String)directoryName, null, null);
        AppenderRef[] refs = new AppenderRef[]{ref};
        LoggerConfig loggerConfig = LoggerConfig.createLogger((boolean)false, (Level)Level.ALL, (String)directoryName, (String)"true", (AppenderRef[])refs, null, (Configuration)config, null);
        loggerConfig.addAppender((Appender)appender, null, null);
        config.addLogger(directoryName, loggerConfig);
        context.updateLoggers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop(String loggerName) {
        Configuration configuration = config;
        synchronized (configuration) {
            Appender appender = config.getAppender(loggerName);
            if (appender != null) {
                appender.stop();
                config.getLoggerConfig(loggerName).removeAppender(loggerName);
                config.removeLogger(loggerName);
                context.updateLoggers();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(String loggerName) {
        Configuration configuration = config;
        synchronized (configuration) {
            if (!config.getLoggers().containsKey(loggerName)) {
                LogUtils.start(loggerName);
            }
        }
        return LogManager.getLogger((String)loggerName);
    }
}

