/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bot.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTExtMappingInfo;
import com.kingdee.bos.metadata.bot.BOTGroupingCollection;
import com.kingdee.bos.metadata.bot.BOTGroupingInfo;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRuleCollection;
import com.kingdee.bos.metadata.bot.BOTRuleInfo;
import com.kingdee.bos.metadata.bot.BOTRuleSegmentCollection;
import com.kingdee.bos.metadata.bot.BOTRuleSegmentInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.bot.MappingTypeEnum;
import com.kingdee.bos.metadata.bot.app.BOTMappingControllerBean;
import com.kingdee.bos.metadata.bot.app.BOTRuleFilterTools;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.botp.util.BOTPTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BOTMappingHelper {
    private static final Logger logger = Logger.getLogger(BOTMappingHelper.class);
    private static final String SEPERATOR = ",";

    public static ArrayList getTargetBillTypeList(Context ctx, String sourceBillType) throws BOSException {
        ArrayList<String> result = new ArrayList<String>();
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String sqlToGetTargetBillTypeList = "SELECT FDESTENTITYNAME FROM T_BOT_MAPPING MAPPING INNER JOIN T_BOT_EXTMAPPING EM ON MAPPING.FEXTMAPPINGID=EM.FID WHERE (MAPPING.FUIDisable=0 OR MAPPING.FUIDisable IS NULL)  AND MAPPING.FSRCENTITYNAME=? AND MAPPING.FDEFINESYS=? AND EM.FISEFFECTED=? AND EM.FTRANSMODE<>?" + BOTMappingHelper.getOrderTypeSql(ctx);
            IRowSet rsToGetTargetBillTypeList = DbUtil.executeQuery((Context)ctx, (String)sqlToGetTargetBillTypeList, (Object[])new Object[]{sourceBillType, new Integer(20), Boolean.TRUE, new Integer(20)});
            while (rsToGetTargetBillTypeList.next()) {
                String destEntityName = rsToGetTargetBillTypeList.getString("FDESTENTITYNAME");
                if (map.containsKey(destEntityName)) continue;
                result.add(destEntityName);
                map.put(destEntityName, destEntityName);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    public static ArrayList getSourceBillTypeList(Context ctx, String targetBillType) throws BOSException {
        ArrayList<String> result = new ArrayList<String>();
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String sqlToGetTargetBillTypeList = "SELECT FSRCENTITYNAME FROM T_BOT_MAPPING MAPPING INNER JOIN T_BOT_EXTMAPPING EM ON MAPPING.FEXTMAPPINGID=EM.FID WHERE (MAPPING.FUIDisable=0 OR MAPPING.FUIDisable IS NULL)  AND MAPPING.FDESTENTITYNAME=? AND MAPPING.FDEFINESYS=? AND EM.FISEFFECTED=? AND EM.FTRANSMODE<>?" + BOTMappingHelper.getOrderTypeSql(ctx);
            IRowSet rsToGetTargetBillTypeList = DbUtil.executeQuery((Context)ctx, (String)sqlToGetTargetBillTypeList, (Object[])new Object[]{targetBillType, new Integer(20), Boolean.TRUE, new Integer(20)});
            while (rsToGetTargetBillTypeList.next()) {
                String srcEntityName = rsToGetTargetBillTypeList.getString("FSRCENTITYNAME");
                if (map.containsKey(srcEntityName)) continue;
                result.add(srcEntityName);
                map.put(srcEntityName, srcEntityName);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCanVoucher(Context ctx, String sourceBillType) throws BOSException {
        boolean result;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("srcEntityName", (Object)sourceBillType));
        filterInfo.getFilterItems().add(new FilterItemInfo("defineSys", (Object)new Integer(DefineSysEnum.DAP.getValue())));
        filterInfo.getFilterItems().add(new FilterItemInfo("destEntityName", (Object)"2652E01E"));
        filterInfo.getFilterItems().add(new FilterItemInfo("extRule.transMode", (Object)new Integer(20), CompareType.NOTEQUALS));
        Connection conn = null;
        try {
            conn = BOTMappingHelper.getConnection(ctx);
            ORMappingDAO dao = new ORMappingDAO(new BOTMappingControllerBean().getBOSType(), ctx, conn);
            result = dao.exists(filterInfo);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return result;
    }

    private static Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    public static BOTMappingInfo getMapping(Context ctx, IObjectValue sourceBill, String targetBillType) throws BOSException, BOTPException {
        return BOTMappingHelper.getMapping(ctx, sourceBill, targetBillType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BOTMappingInfo getMapping(Context ctx, IObjectValue sourceBill, String targetBillType, DefineSysEnum defineSys) throws BOSException, BOTPException {
        String sourceBillType = sourceBill.getBOSType().toString();
        LowTimer t = new LowTimer();
        t.reset();
        BOTMappingCollection mappingCol = BOTMappingHelper.getBOTMappingCollection(ctx, sourceBillType, targetBillType, defineSys);
        if (mappingCol.size() == 0) {
            throw new BOTPException(BOTPException.NOMAPPING);
        }
        Iterator iter = mappingCol.iterator();
        ArrayList<BOTMappingInfo> companyMappings = new ArrayList<BOTMappingInfo>();
        while (iter.hasNext()) {
            String currentOrgId;
            BOTMappingInfo mappingInfo = (BOTMappingInfo)iter.next();
            String string = currentOrgId = ContextUtil.getCurrentFIUnit((Context)ctx) == null ? "" : ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
            if (mappingInfo.getExtRule() != null && mappingInfo.getExtRule().getOrg() != null && !mappingInfo.getExtRule().getOrg().getId().toString().equals(currentOrgId)) continue;
            companyMappings.add(mappingInfo);
        }
        if (companyMappings.size() == 0) {
            throw new BOTPException(BOTPException.NOCOMPANYMAPPING);
        }
        for (BOTMappingInfo mappingInfo : companyMappings) {
            CoreBillBaseCollection sourceBillCollection = new CoreBillBaseCollection();
            sourceBillCollection.addObject(sourceBill);
            try {
                BOTMappingHelper.acceptMapping(ctx, (IObjectCollection)sourceBillCollection, mappingInfo);
                t.reset();
                Connection conn = null;
                try {
                    conn = BOTMappingHelper.getConnection(ctx);
                    ORMappingDAO dao = new ORMappingDAO(new BOTMappingControllerBean().getBOSType(), ctx, conn);
                    mappingInfo = (BOTMappingInfo)dao.getValue((IObjectPK)new ObjectUuidPK(mappingInfo.getId()));
                }
                finally {
                    SQLUtils.cleanup((Connection)conn);
                }
                return mappingInfo;
            }
            catch (BOTPException e) {
                logger.error((Object)"acceptMapping error!", (Throwable)((Object)e));
            }
        }
        throw new BOTPException(BOTPException.MAPPINGNUMZERO);
    }

    private static BOTMappingCollection getBOTMappingCollection(Context ctx, String sourceBillType, String targetBillType, DefineSysEnum defineSys) throws BOSException, BOTPException {
        BOTMappingCollection result = new BOTMappingCollection();
        try {
            IRowSet rowset = BOTMappingHelper.getMappingByCU(ctx, sourceBillType, targetBillType, defineSys);
            while (rowset.next()) {
                BOTMappingInfo mappingInfo = new BOTMappingInfo();
                mappingInfo.setId(BOSUuid.read((String)rowset.getString("FID")));
                mappingInfo.setSrcEntityName(rowset.getString("FSRCENTITYNAME"));
                mappingInfo.setDestEntityName(rowset.getString("FDESTENTITYNAME"));
                mappingInfo.setDefineSys(DefineSysEnum.getEnum(rowset.getInt("FDEFINESYS")));
                BOTExtMappingInfo extRule = new BOTExtMappingInfo();
                extRule.setFilter(rowset.getString("FFILTER"));
                String orgId = rowset.getString("FORGID");
                if (!StringUtils.isEmpty((String)orgId)) {
                    CompanyOrgUnitInfo org = new CompanyOrgUnitInfo();
                    org.setId(BOSUuid.read((String)orgId));
                    extRule.setOrg(org);
                }
                mappingInfo.setExtRule(extRule);
                result.add(mappingInfo);
            }
        }
        catch (SQLException exc) {
            throw new BOTPException(BOTPException.MAPPINGNUMZERO, exc);
        }
        return result;
    }

    private static BOTMappingCollection getBOTMappingCollectionForSelect(Context ctx, String sourceBillType, String targetBillType, DefineSysEnum defineSys, Map transmitCtx) throws BOSException, BOTPException {
        return BOTMappingHelper.getBOTMappingCollectionForSelect(ctx, sourceBillType, targetBillType, defineSys, transmitCtx, false);
    }

    private static BOTMappingCollection getBOTMappingCollectionForSelect(Context ctx, String sourceBillType, String targetBillType, DefineSysEnum defineSys, Map transmitCtx, boolean isAllCUMode) throws BOSException, BOTPException {
        BOTMappingCollection result = new BOTMappingCollection();
        try {
            IRowSet rowset = null;
            String transmitCuId = null;
            if (!isAllCUMode) {
                if (transmitCtx == null) {
                    transmitCuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
                } else {
                    transmitCuId = (String)transmitCtx.get("TRANSMITCU_ID");
                    if (StringUtils.isEmpty((String)transmitCuId)) {
                        Object transmitCu = transmitCtx.get("TRANSMITCU");
                        transmitCuId = transmitCu != null && transmitCu instanceof CtrlUnitInfo ? ((CtrlUnitInfo)transmitCu).getId().toString() : ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
                    }
                }
                if (!BOTPTools.isCtrlUintAuthor(ctx)) {
                    rowset = BOTMappingHelper.getMappingByCUForSelect(ctx, sourceBillType, targetBillType, defineSys, transmitCuId);
                } else {
                    String[] orgIDs = null;
                    try {
                        CtrlUnitInfo orgCu = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo("select id,longNumber where id ='" + transmitCuId + "'");
                        String orglongNumber = orgCu.getLongNumber().toString();
                        Object[] orgNumbers = orglongNumber.split("!");
                        orgIDs = new String[orgNumbers.length];
                        FilterInfo filterInfo = new FilterInfo();
                        String strNumberLists = StringUtils.arrayToString((Object[])orgNumbers, (String)SEPERATOR);
                        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)strNumberLists, CompareType.INCLUDE));
                        EntityViewInfo entityViewInfo = new EntityViewInfo();
                        entityViewInfo.getSelector().add(new SelectorItemInfo("id"));
                        entityViewInfo.setFilter(filterInfo);
                        SorterItemCollection sic = new SorterItemCollection();
                        SorterItemInfo sortInfo = new SorterItemInfo("longnumber");
                        sortInfo.setSortType(SortType.DESCEND);
                        sic.add(sortInfo);
                        entityViewInfo.setSorter(sic);
                        CtrlUnitCollection cucol = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitCollection(entityViewInfo);
                        for (int i = 0; i < orgIDs.length; ++i) {
                            orgIDs[i] = cucol.get(i).getId().toString();
                        }
                    }
                    catch (EASBizException e) {
                        throw new BOSException(e.getMessage());
                    }
                    BOTMappingCollection result4AllCu = new BOTMappingCollection();
                    boolean hasSuperCtrlUnit = BOTRuleFilterTools.hasSuperCtrlUnit(ctx);
                    for (int i = 0; i < orgIDs.length; ++i) {
                        rowset = BOTMappingHelper.getMappingByOneCUForSelect(ctx, sourceBillType, targetBillType, defineSys, orgIDs[i]);
                        if (hasSuperCtrlUnit) {
                            if (rowset.size() > 0) {
                                BOTMappingCollection mappingResult = BOTMappingHelper.getMappingCollectionFromRowSet(ctx, rowset);
                                result4AllCu.addCollection(mappingResult);
                            }
                            if (i != orgIDs.length - 1) continue;
                            return result4AllCu;
                        }
                        if (rowset.size() <= 0) {
                            continue;
                        }
                        break;
                    }
                }
            } else {
                rowset = BOTMappingHelper.getMappingAllCUForSelect(ctx, sourceBillType, targetBillType, defineSys);
            }
            result = BOTMappingHelper.getMappingCollectionFromRowSet(ctx, rowset);
        }
        catch (SQLException exc) {
            throw new BOTPException(BOTPException.MAPPINGNUMZERO, exc);
        }
        return result;
    }

    private static String getOrderSql(Context ctx) {
        return " ORDER BY MAPPING.FAlias_" + ctx.getLocale().toString() + " schinese_pinyin ASC";
    }

    private static String getOrderTypeSql(Context ctx) {
        return " ORDER BY MAPPING.FAlias_" + ctx.getLocale().toString() + " schinese_pinyin ASC";
    }

    private static IRowSet getMappingByCUForSelect(Context ctx, String sourceBillType, String targetBillType, DefineSysEnum defineSys, String transmitCuId) throws BOSException {
        IRowSet rs;
        if (defineSys != null) {
            ArrayList<Object> paramsWithDefineSys = new ArrayList<Object>();
            paramsWithDefineSys.add(transmitCuId);
            paramsWithDefineSys.add(sourceBillType);
            paramsWithDefineSys.add(new Integer(1));
            paramsWithDefineSys.add(new Integer(10));
            paramsWithDefineSys.add(new Integer(30));
            paramsWithDefineSys.add(new Integer(defineSys.getValue()));
            String sql = "SELECT MAPPING.FNAME,MAPPING.FMAPPINGTYPE,MAPPING.FDESCRIPTION_" + ctx.getLocale().toString() + ",MAPPING.FAlias_" + ctx.getLocale().toString() + ",MAPPING.FControlUnitID CUID,MAPPING.FID, MAPPING.FSRCENTITYNAME, MAPPING.FDESTENTITYNAME, MAPPING.FDEFINESYS, MAPPING.FISTEMPSAVE, MAPPING.FISSHOWEDITUI,MAPPING.FEXTCONFIG,MAPPING.FLASTUPDATETIME, EXTRULE.FFILTER, EXTRULE.FDATAFILTER, EXTRULE.FORGID  FROM T_BOT_MAPPING MAPPING LEFT OUTER JOIN T_BOT_EXTMAPPING EXTRULE ON MAPPING.FEXTMAPPINGID = EXTRULE.FID  WHERE (MAPPING.FUIDisable=0 OR MAPPING.FUIDisable IS NULL)  AND MAPPING.FControlUnitID = ?  AND MAPPING.FSRCENTITYNAME = ? AND EXTRULE.FISEFFECTED = ? AND (EXTRULE.FTRANSMODE = ? OR EXTRULE.FTRANSMODE = ?) AND MAPPING.FDEFINESYS = ?";
            if (targetBillType != null && targetBillType.length() > 0) {
                sql = sql + " AND MAPPING.FDESTENTITYNAME = ? " + BOTMappingHelper.getOrderSql(ctx);
                paramsWithDefineSys.add(targetBillType);
            } else {
                sql = sql + BOTMappingHelper.getOrderSql(ctx);
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])paramsWithDefineSys.toArray());
            if (rs == null || rs.size() < 1) {
                paramsWithDefineSys.remove(0);
                paramsWithDefineSys.add(0, "00000000-0000-0000-0000-000000000000CCE7AED4");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])paramsWithDefineSys.toArray());
            }
        } else {
            ArrayList<Object> paramsWithoutDefineSys = new ArrayList<Object>();
            paramsWithoutDefineSys.add(transmitCuId);
            paramsWithoutDefineSys.add(sourceBillType);
            paramsWithoutDefineSys.add(new Integer(1));
            paramsWithoutDefineSys.add(new Integer(10));
            paramsWithoutDefineSys.add(new Integer(30));
            String sql = "SELECT MAPPING.FNAME,MAPPING.FMAPPINGTYPE,MAPPING.FDESCRIPTION_" + ctx.getLocale().toString() + ",MAPPING.FAlias_" + ctx.getLocale().toString() + ",MAPPING.FControlUnitID CUID,MAPPING.FID, MAPPING.FSRCENTITYNAME, MAPPING.FDESTENTITYNAME, MAPPING.FDEFINESYS, MAPPING.FISTEMPSAVE, MAPPING.FISSHOWEDITUI,MAPPING.FEXTCONFIG, MAPPING.FLASTUPDATETIME, EXTRULE.FFILTER, EXTRULE.FDATAFILTER, EXTRULE.FORGID  FROM T_BOT_MAPPING MAPPING LEFT OUTER JOIN T_BOT_EXTMAPPING EXTRULE ON MAPPING.FEXTMAPPINGID = EXTRULE.FID  WHERE (MAPPING.FUIDisable=0 OR MAPPING.FUIDisable IS NULL)  AND MAPPING.FControlUnitID = ?  AND MAPPING.FSRCENTITYNAME = ? AND EXTRULE.FISEFFECTED = ? AND (EXTRULE.FTRANSMODE = ? OR EXTRULE.FTRANSMODE = ?) ";
            if (targetBillType != null && targetBillType.length() > 0) {
                sql = sql + " AND MAPPING.FDESTENTITYNAME = ? " + BOTMappingHelper.getOrderSql(ctx);
                paramsWithoutDefineSys.add(targetBillType);
            } else {
                sql = sql + BOTMappingHelper.getOrderSql(ctx);
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])paramsWithoutDefineSys.toArray());
            if (rs == null || rs.size() < 1) {
                paramsWithoutDefineSys.remove(0);
                paramsWithoutDefineSys.add(0, "00000000-0000-0000-0000-000000000000CCE7AED4");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])paramsWithoutDefineSys.toArray());
            }
        }
        return rs;
    }

    private static IRowSet getMappingAllCUForSelect(Context ctx, String sourceBillType, String targetBillType, DefineSysEnum defineSys) throws BOSException {
        IRowSet rs;
        if (defineSys != null) {
            ArrayList<Object> paramsWithDefineSys = new ArrayList<Object>();
            paramsWithDefineSys.add(sourceBillType);
            paramsWithDefineSys.add(new Integer(1));
            paramsWithDefineSys.add(new Integer(10));
            paramsWithDefineSys.add(new Integer(30));
            paramsWithDefineSys.add(new Integer(defineSys.getValue()));
            String sql = "SELECT MAPPING.FNAME,MAPPING.FMAPPINGTYPE,MAPPING.FDESCRIPTION_" + ctx.getLocale().toString() + ",MAPPING.FAlias_" + ctx.getLocale().toString() + ",MAPPING.FControlUnitID CUID,MAPPING.FID, MAPPING.FSRCENTITYNAME, MAPPING.FDESTENTITYNAME, MAPPING.FDEFINESYS, MAPPING.FISTEMPSAVE, MAPPING.FISSHOWEDITUI,MAPPING.FEXTCONFIG,MAPPING.FLASTUPDATETIME, EXTRULE.FFILTER, EXTRULE.FDATAFILTER,EXTRULE.FFILTER4PRE, EXTRULE.FORGID  FROM T_BOT_MAPPING MAPPING LEFT OUTER JOIN T_BOT_EXTMAPPING EXTRULE ON MAPPING.FEXTMAPPINGID = EXTRULE.FID  WHERE (MAPPING.FUIDisable=0 OR MAPPING.FUIDisable IS NULL)  AND  MAPPING.FSRCENTITYNAME = ? AND EXTRULE.FISEFFECTED = ? AND (EXTRULE.FTRANSMODE = ? OR EXTRULE.FTRANSMODE = ?) AND MAPPING.FDEFINESYS = ?";
            if (targetBillType != null && targetBillType.length() > 0) {
                sql = sql + " AND MAPPING.FDESTENTITYNAME = ? " + BOTMappingHelper.getOrderSql(ctx);
                paramsWithDefineSys.add(targetBillType);
            } else {
                sql = sql + BOTMappingHelper.getOrderSql(ctx);
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])paramsWithDefineSys.toArray());
        } else {
            ArrayList<Object> paramsWithoutDefineSys = new ArrayList<Object>();
            paramsWithoutDefineSys.add(sourceBillType);
            paramsWithoutDefineSys.add(new Integer(1));
            paramsWithoutDefineSys.add(new Integer(10));
            paramsWithoutDefineSys.add(new Integer(30));
            String sql = "SELECT MAPPING.FNAME,MAPPING.FMAPPINGTYPE,MAPPING.FDESCRIPTION_" + ctx.getLocale().toString() + ",MAPPING.FAlias_" + ctx.getLocale().toString() + ",MAPPING.FControlUnitID CUID,MAPPING.FID, MAPPING.FSRCENTITYNAME, MAPPING.FDESTENTITYNAME, MAPPING.FDEFINESYS, MAPPING.FISTEMPSAVE, MAPPING.FISSHOWEDITUI,MAPPING.FEXTCONFIG, MAPPING.FLASTUPDATETIME, EXTRULE.FFILTER, EXTRULE.FDATAFILTER,EXTRULE.FFILTER4PRE, EXTRULE.FORGID  FROM T_BOT_MAPPING MAPPING LEFT OUTER JOIN T_BOT_EXTMAPPING EXTRULE ON MAPPING.FEXTMAPPINGID = EXTRULE.FID  WHERE (MAPPING.FUIDisable=0 OR MAPPING.FUIDisable IS NULL)  AND  MAPPING.FSRCENTITYNAME = ? AND EXTRULE.FISEFFECTED = ? AND (EXTRULE.FTRANSMODE = ? OR EXTRULE.FTRANSMODE = ?) ";
            if (targetBillType != null && targetBillType.length() > 0) {
                sql = sql + " AND MAPPING.FDESTENTITYNAME = ? " + BOTMappingHelper.getOrderSql(ctx);
                paramsWithoutDefineSys.add(targetBillType);
            } else {
                sql = sql + BOTMappingHelper.getOrderSql(ctx);
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])paramsWithoutDefineSys.toArray());
        }
        return rs;
    }

    private static IRowSet getMappingByCU(Context ctx, String sourceBillType, String targetBillType, DefineSysEnum defineSys) throws SQLException, BOSException {
        IRowSet rs;
        String currentCuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        if (defineSys != null) {
            ArrayList<Object> paramsWithDefineSys = new ArrayList<Object>();
            paramsWithDefineSys.add(currentCuId);
            paramsWithDefineSys.add(sourceBillType);
            paramsWithDefineSys.add(targetBillType);
            paramsWithDefineSys.add(new Integer(1));
            paramsWithDefineSys.add(new Integer(10));
            paramsWithDefineSys.add(new Integer(30));
            paramsWithDefineSys.add(new Integer(defineSys.getValue()));
            String sql = "SELECT MAPPING.FControlUnitID CUID,MAPPING.FMAPPINGTYPE, MAPPING.FID, MAPPING.FSRCENTITYNAME, MAPPING.FDESTENTITYNAME, MAPPING.FDEFINESYS, EXTRULE.FFILTER, EXTRULE.FORGID FROM T_BOT_MAPPING MAPPING LEFT OUTER JOIN T_BOT_EXTMAPPING EXTRULE ON MAPPING.FEXTMAPPINGID = EXTRULE.FID WHERE (MAPPING.FUIDisable=0 OR MAPPING.FUIDisable IS NULL)  AND MAPPING.FControlUnitID = ?  AND MAPPING.FSRCENTITYNAME = ? AND MAPPING.FDESTENTITYNAME = ? AND EXTRULE.FISEFFECTED = ? AND (EXTRULE.FTRANSMODE = ? OR EXTRULE.FTRANSMODE = ?) AND MAPPING.FDEFINESYS = ? " + BOTMappingHelper.getOrderSql(ctx);
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])paramsWithDefineSys.toArray());
            if (rs == null || rs.size() < 1) {
                paramsWithDefineSys.remove(0);
                paramsWithDefineSys.add(0, "00000000-0000-0000-0000-000000000000CCE7AED4");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])paramsWithDefineSys.toArray());
            }
        } else {
            ArrayList<Object> paramsWithoutDefineSys = new ArrayList<Object>();
            paramsWithoutDefineSys.add(currentCuId);
            paramsWithoutDefineSys.add(sourceBillType);
            paramsWithoutDefineSys.add(targetBillType);
            paramsWithoutDefineSys.add(new Integer(1));
            paramsWithoutDefineSys.add(new Integer(10));
            paramsWithoutDefineSys.add(new Integer(30));
            String sql = "SELECT MAPPING.FControlUnitID CUID,MAPPING.FMAPPINGTYPE, MAPPING.FID, MAPPING.FSRCENTITYNAME, MAPPING.FDESTENTITYNAME, MAPPING.FDEFINESYS, EXTRULE.FFILTER, EXTRULE.FORGID FROM T_BOT_MAPPING MAPPING LEFT OUTER JOIN T_BOT_EXTMAPPING EXTRULE ON MAPPING.FEXTMAPPINGID = EXTRULE.FID WHERE (MAPPING.FUIDisable=0 OR MAPPING.FUIDisable IS NULL)  AND MAPPING.FControlUnitID = ?  AND MAPPING.FSRCENTITYNAME = ? AND MAPPING.FDESTENTITYNAME = ? AND EXTRULE.FISEFFECTED = ? AND (EXTRULE.FTRANSMODE = ? OR EXTRULE.FTRANSMODE = ?) " + BOTMappingHelper.getOrderSql(ctx);
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])paramsWithoutDefineSys.toArray());
            if (rs == null || rs.size() < 1) {
                paramsWithoutDefineSys.remove(0);
                paramsWithoutDefineSys.add(0, "00000000-0000-0000-0000-000000000000CCE7AED4");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])paramsWithoutDefineSys.toArray());
            }
        }
        return rs;
    }

    public static void checkBillVouchered(IObjectCollection sourceBillCollection, String targetBillType, DefineSysEnum defineSys) throws BOTPException {
    }

    public static BOTMappingInfo getMapping(Context ctx, IObjectCollection sourceBillCollection, String targetBillType) throws BOSException, BOTPException {
        return BOTMappingHelper.getMapping(ctx, sourceBillCollection, targetBillType, null);
    }

    public static BOTMappingInfo getMapping(Context ctx, IObjectCollection sourceBillCollection, String targetBillType, DefineSysEnum defineSys) throws BOSException, BOTPException {
        if (sourceBillCollection.size() == 0) {
            throw new BOTPException(BOTPException.NOBILL);
        }
        IObjectValue sourceBill = sourceBillCollection.getObject(0);
        BOTMappingInfo mappingInfo = BOTMappingHelper.getMapping(ctx, sourceBill, targetBillType, defineSys);
        BOTMappingHelper.acceptMapping(ctx, sourceBillCollection, mappingInfo);
        return mappingInfo;
    }

    public static ArrayList getGroupingProperties(Context ctx, BOTMappingInfo mappingInfo) throws BOSException, BOTPException {
        if (mappingInfo.getRules().size() == 0) {
            throw new BOTPException(BOTPException.RULENUMZERO);
        }
        BOTRuleInfo rule = mappingInfo.getRules().get(0);
        BOTGroupingCollection groupCol = rule.getGroups();
        ArrayList<String> result = new ArrayList<String>();
        Iterator iter = groupCol.iterator();
        block0: while (iter.hasNext()) {
            BOTGroupingInfo group = (BOTGroupingInfo)iter.next();
            if (group.getGroupingLevel() != 1) continue;
            Iterator ruleIter = rule.getRuleSegments().iterator();
            while (ruleIter.hasNext()) {
                BOTRuleSegmentInfo botRuleSegmentInfo = (BOTRuleSegmentInfo)ruleIter.next();
                if (!botRuleSegmentInfo.getDestPropertyName().equals(group.getGroupingProperty())) continue;
                result.add(botRuleSegmentInfo.getSrcPropertyName());
                continue block0;
            }
        }
        return result;
    }

    public static ArrayList getRelationProperties(Context ctx, BOTMappingInfo mappingInfo) throws BOSException, BOTPException {
        if (mappingInfo.getRules().size() == 0) {
            throw new BOTPException(BOTPException.RULENUMZERO);
        }
        BOTRuleInfo rule = mappingInfo.getRules().get(0);
        BOTRuleSegmentCollection ruleSegs = rule.getRuleSegments();
        ArrayList<String> result = new ArrayList<String>();
        Iterator iter = ruleSegs.iterator();
        while (iter.hasNext()) {
            BOTRuleSegmentInfo ruleSeg = (BOTRuleSegmentInfo)iter.next();
            if (!ruleSeg.isRegInRelation() || ruleSeg.getSrcPropertyName() == null || ruleSeg.getSrcPropertyName().length() == 0) continue;
            result.add(ruleSeg.getSrcPropertyName());
        }
        return result;
    }

    public static ArrayList getMatchProperties(Context ctx, BOTMappingInfo mappingInfo) throws BOSException, BOTPException {
        if (mappingInfo.getRules().size() == 0) {
            throw new BOTPException(BOTPException.RULENUMZERO);
        }
        BOTRuleInfo rule = mappingInfo.getRules().get(0);
        BOTRuleSegmentCollection ruleSegs = rule.getRuleSegments();
        ArrayList<String> result = new ArrayList<String>();
        Iterator iter = ruleSegs.iterator();
        while (iter.hasNext()) {
            BOTRuleSegmentInfo ruleSeg = (BOTRuleSegmentInfo)iter.next();
            if (!ruleSeg.isRegInRelation()) continue;
            result.add(ruleSeg.getDestPropertyName());
        }
        return result;
    }

    public static String listToString(ArrayList list) {
        return BOTMappingHelper.listToString(list, SEPERATOR);
    }

    public static String listToString(ArrayList list, String sep) {
        int i = 0;
        StringBuffer result = new StringBuffer("");
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            if (i > 0) {
                result.append(sep);
            }
            result.append(iter.next().toString());
            ++i;
        }
        return result.toString();
    }

    private static boolean acceptMapping(Context ctx, IObjectValue sourceBill, BOTMappingInfo mappingInfo) throws BOSException {
        EntityViewInfo evi = BOTMappingHelper.getBOTMappingFilter(ctx, mappingInfo);
        FilterInfo filterInfo = evi.getFilter();
        if (filterInfo == null || filterInfo.getFilterItems().size() == 0) {
            return true;
        }
        return BOTMappingHelper.accept(ctx, sourceBill.getBOSType(), (IObjectPK)new ObjectUuidPK(sourceBill.getBOSUuid(sourceBill.getPKField())), evi);
    }

    private static void acceptMapping(Context ctx, IObjectCollection sourceBillCollection, BOTMappingInfo mappingInfo) throws BOSException, BOTPException {
        int i;
        IObjectValue sourceBill0 = sourceBillCollection.getObject(0);
        boolean hasEntryFilter = false;
        EntityViewInfo evi = BOTMappingHelper.getBOTMappingFilter(ctx, mappingInfo);
        evi.getSelector().add("id");
        FilterInfo filterInfo = evi.getFilter();
        if (evi.getEntryFilters() != null && evi.getEntryFilters().size() > 0) {
            hasEntryFilter = true;
            int count = evi.getEntryFilters().size();
            for (int i2 = 0; i2 < count; ++i2) {
                FilterInfo entryFilter = evi.getEntryFilters().get(i2);
                String entryName = entryFilter.getEntryName();
                evi.getSelector().add(entryName + ".id");
            }
        }
        if (!(filterInfo != null && filterInfo.getFilterItems().size() != 0 || evi.getEntryFilters() != null && evi.getEntryFilters().size() != 0)) {
            return;
        }
        ArrayList<Object> billIdList = new ArrayList<Object>();
        int count = sourceBillCollection.size();
        for (int i3 = 0; i3 < count; ++i3) {
            billIdList.add(sourceBillCollection.getObject(i3).get("id"));
        }
        FilterInfo newHeadFilterInfo = BOTMappingHelper.mergeFilterWithIdList(billIdList, filterInfo);
        if (filterInfo == null) {
            filterInfo = newHeadFilterInfo;
            evi.setFilter(newHeadFilterInfo);
        }
        if (hasEntryFilter) {
            int es = evi.getEntryFilters().size();
            for (int e = 0; e < es; ++e) {
                FilterInfo entryFilterInfo = evi.getEntryFilters().get(e);
                String entryName = entryFilterInfo.getEntryName();
                ArrayList<Object> entryIdList = new ArrayList<Object>();
                int count2 = sourceBillCollection.size();
                for (i = 0; i < count2; ++i) {
                    IObjectValue srcBillInfo = sourceBillCollection.getObject(i);
                    if (srcBillInfo.get(entryName) == null || !(srcBillInfo.get(entryName) instanceof IObjectCollection)) continue;
                    IObjectCollection entryCols = (IObjectCollection)srcBillInfo.get(entryName);
                    int entryCount = entryCols.size();
                    for (int j = 0; j < entryCount; ++j) {
                        entryIdList.add(entryCols.getObject(j).get("id"));
                    }
                }
                BOTMappingHelper.mergeFilterWithIdList(entryIdList, entryFilterInfo);
            }
        }
        ArrayList<CoreBillBaseInfo> errorBillCollection = new ArrayList<CoreBillBaseInfo>();
        IDynamicObject iDynObj = DynamicObjectFactory.getLocalInstance((Context)ctx);
        IObjectCollection filteredCols = iDynObj.getCollection(sourceBill0.getBOSType(), evi);
        ArrayList<String> filteredIdList = new ArrayList<String>();
        int count3 = filteredCols.size();
        for (int i4 = 0; i4 < count3; ++i4) {
            IObjectValue filteredInfo = filteredCols.getObject(i4);
            boolean flag = true;
            if (hasEntryFilter) {
                int es = evi.getEntryFilters().size();
                for (int e = 0; e < es; ++e) {
                    FilterInfo entryFilterInfo = evi.getEntryFilters().get(e);
                    String entryName = entryFilterInfo.getEntryName();
                    if (filteredInfo.get(entryName) != null && filteredInfo.get(entryName) instanceof IObjectCollection && ((IObjectCollection)filteredInfo.get(entryName)).size() > 0) continue;
                    flag = false;
                    break;
                }
                if (!flag) continue;
                filteredIdList.add(filteredInfo.get("id").toString());
                continue;
            }
            filteredIdList.add(filteredInfo.get("id").toString());
        }
        HashMap pkListMap = new HashMap();
        for (i = 0; i < filteredIdList.size(); ++i) {
            pkListMap.put(filteredIdList.get(i), null);
        }
        for (CoreBillBaseInfo sourceBillInfo : sourceBillCollection) {
            if (pkListMap.containsKey(sourceBillInfo.getId().toString())) continue;
            errorBillCollection.add(sourceBillInfo);
        }
        if (errorBillCollection.size() > 0) {
            StringBuffer billNumberList = new StringBuffer();
            for (CoreBillBaseInfo sourceBillInfo : errorBillCollection) {
                billNumberList.append(sourceBillInfo.getNumber());
                billNumberList.append(" ");
            }
            throw new BOTPException(BOTPException.ILLEGALBILLLIST, new Object[]{billNumberList.toString()});
        }
    }

    private static FilterInfo mergeFilterWithIdList(List idList, FilterInfo filterInfo) {
        int index = 0;
        StringBuffer sbMaskString = new StringBuffer();
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        if (filterInfo.getMaskString() == null || filterInfo.getMaskString().length() == 0) {
            Iterator iterFilter = filterInfo.getFilterItems().iterator();
            while (iterFilter.hasNext()) {
                if (index != 0) {
                    sbMaskString.append(" and ");
                }
                iterFilter.next();
                sbMaskString.append("#" + String.valueOf(index));
                ++index;
            }
            filterInfo.setMaskString(sbMaskString.toString());
        }
        StringBuffer sbNewMaskString = new StringBuffer();
        index = 0;
        String strIdLists = BOTMappingHelper.objectArray2String(idList.toArray(), SEPERATOR);
        sbNewMaskString.append("#" + String.valueOf(filterInfo.getFilterItems().size()));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
        if (filterInfo.getMaskString() == null || filterInfo.getMaskString().length() == 0) {
            filterInfo.setMaskString(sbNewMaskString.toString());
        } else if (sbNewMaskString.length() > 0) {
            filterInfo.setMaskString("(" + filterInfo.getMaskString() + ") and (" + sbNewMaskString.toString() + ")");
        }
        return filterInfo;
    }

    public static final String objectArray2String(Object[] objs, String split) {
        if (objs == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < objs.length; ++i) {
            buffer.append(objs[i] == null ? "null" : objs[i].toString());
            buffer.append(split);
        }
        if (buffer.length() > 0) {
            return buffer.substring(0, buffer.length() - split.length());
        }
        return buffer.toString();
    }

    public static EntityViewInfo getBOTMappingFilter(Context ctx, BOTMappingInfo mappingInfo) throws BOSException {
        EntityViewInfo entityViewInfo;
        if (StringUtils.isEmpty((String)mappingInfo.getExtRule().getFilter())) {
            entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            entityViewInfo.setFilter(filterInfo);
        } else {
            try {
                entityViewInfo = BOTPTools.getEntityViewInfoFromMapping(mappingInfo, 0);
            }
            catch (BOSException exc) {
                throw new BOSException(exc.getMessage(), (Throwable)exc);
            }
        }
        return entityViewInfo;
    }

    private static boolean accept(Context ctx, BOSObjectType bosType, IObjectPK pk, EntityViewInfo evi) throws DataAccessException {
        FilterInfo rule = evi.getFilter();
        int index = 0;
        StringBuffer sbMaskString = new StringBuffer();
        if (rule.getMaskString() == null || rule.getMaskString().length() == 0) {
            Iterator iterFilter = rule.getFilterItems().iterator();
            while (iterFilter.hasNext()) {
                if (index != 0) {
                    sbMaskString.append(" and ");
                }
                iterFilter.next();
                sbMaskString.append("#" + String.valueOf(index));
                ++index;
            }
            rule.setMaskString(sbMaskString.toString());
        }
        rule.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString()));
        rule.setMaskString("(" + rule.getMaskString() + ") and #" + (rule.getFilterItems().size() - 1));
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ORMappingDAO dao = new ORMappingDAO(bosType, ctx, conn);
            boolean bl = dao.exists(evi.toString());
            return bl;
        }
        catch (SQLException sqle) {
            throw new SQLAccessException(sqle);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    public static IObjectCollection getMappingForSelect(Context ctx, String srcBosType, String destBosType, Map transmitCtx) throws BOTPException, BOSException {
        LowTimer t = new LowTimer();
        t.reset();
        BOTMappingCollection mappingCol = BOTMappingHelper.getBOTMappingCollectionForSelect(ctx, srcBosType, destBosType, null, transmitCtx);
        logger.debug((Object)("getBOTMappingCollection time: " + t.msValue()));
        if (mappingCol.size() == 0) {
            logger.error((Object)("destBosType:" + destBosType), (Throwable)((Object)new BOTPException(BOTPException.NOMAPPING)));
        }
        return mappingCol;
    }

    public static IObjectCollection getMappingForSelectAllCU(Context ctx, String srcBosType, String destBosType, Map transmitCtx) throws BOTPException, BOSException {
        LowTimer t = new LowTimer();
        t.reset();
        BOTMappingCollection mappingCol = BOTMappingHelper.getBOTMappingCollectionForSelect(ctx, srcBosType, destBosType, null, transmitCtx, true);
        logger.debug((Object)("getBOTMappingCollection time: " + t.msValue()));
        if (mappingCol.size() == 0) {
            logger.error((Object)("destBosType:" + destBosType), (Throwable)((Object)new BOTPException(BOTPException.NOMAPPING)));
        }
        return mappingCol;
    }

    public static BOTMappingCollection getMappingForSelect(Context ctx, String srcBillType, String targetBillType, DefineSysEnum defineSys, Map transmitCtx) throws BOSException, BOTPException {
        LowTimer t = new LowTimer();
        t.reset();
        BOTMappingCollection mappingCol = BOTMappingHelper.getBOTMappingCollectionForSelect(ctx, srcBillType, targetBillType, defineSys, transmitCtx);
        logger.debug((Object)("getBOTMappingCollection time: " + t.msValue()));
        if (mappingCol.size() == 0) {
            logger.error((Object)("destBosType:" + targetBillType), (Throwable)((Object)new BOTPException(BOTPException.NOMAPPING)));
        }
        return mappingCol;
    }

    public static BOTMappingCollection getMappingForSelectNew(Context ctx, IObjectCollection sourceBillCollection, String targetBillType, DefineSysEnum defineSys) throws BOSException, BOTPException {
        return BOTMappingHelper.getMappingForSelectNew(ctx, sourceBillCollection, targetBillType, defineSys, null);
    }

    public static BOTMappingCollection getMappingForSelectNew(Context ctx, IObjectCollection sourceBillCollection, String targetBillType, DefineSysEnum defineSys, CtrlUnitInfo transmitCU) throws BOSException, BOTPException {
        if (sourceBillCollection.size() == 0) {
            throw new BOTPException(BOTPException.NOBILL);
        }
        CoreBillBaseInfo sourceBill = (CoreBillBaseInfo)sourceBillCollection.getObject(0);
        String sourceBillType = sourceBill.getBOSType().toString();
        String orglongNumber = null;
        BOTMappingCollection newBotMappingCols = new BOTMappingCollection();
        String transmitCuId = null;
        transmitCuId = transmitCU == null ? ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString() : transmitCU.getId().toString();
        String[] orgIDs = null;
        if (!BOTPTools.isCtrlUintAuthor(ctx)) {
            orgIDs = new String[]{transmitCuId, "00000000-0000-0000-0000-000000000000CCE7AED4"};
        } else {
            try {
                CtrlUnitInfo orgCu = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo("select id,longNumber where id ='" + transmitCuId + "'");
                orglongNumber = orgCu.getLongNumber().toString();
                Object[] orgNumbers = orglongNumber.split("!");
                orgIDs = new String[orgNumbers.length];
                FilterInfo filterInfo = new FilterInfo();
                String strNumberLists = StringUtils.arrayToString((Object[])orgNumbers, (String)SEPERATOR);
                filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)strNumberLists, CompareType.INCLUDE));
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                entityViewInfo.getSelector().add(new SelectorItemInfo("id"));
                entityViewInfo.setFilter(filterInfo);
                SorterItemCollection sic = new SorterItemCollection();
                SorterItemInfo sortInfo = new SorterItemInfo("longnumber");
                sortInfo.setSortType(SortType.DESCEND);
                sic.add(sortInfo);
                entityViewInfo.setSorter(sic);
                CtrlUnitCollection cucol = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitCollection(entityViewInfo);
                for (int i = 0; i < orgIDs.length; ++i) {
                    orgIDs[i] = cucol.get(i).getId().toString();
                }
            }
            catch (EASBizException e) {
                throw new BOSException(e.getMessage());
            }
        }
        BOTMappingCollection retBotMappingCols = new BOTMappingCollection();
        for (int i = 0; i < orgIDs.length; ++i) {
            newBotMappingCols = BOTMappingHelper.getMappingByOneCUAfterCheck(ctx, sourceBillCollection, sourceBillType, targetBillType, defineSys, orgIDs[i]);
            if (newBotMappingCols.size() <= 0) continue;
            if (BOTRuleFilterTools.hasSuperCtrlUnit(ctx)) {
                for (int j = 0; j < newBotMappingCols.size(); ++j) {
                    retBotMappingCols.add(newBotMappingCols.get(j));
                }
                continue;
            }
            return newBotMappingCols;
        }
        return retBotMappingCols;
    }

    private static BOTMappingCollection getMappingByOneCUAfterCheck(Context ctx, IObjectCollection sourceBillCollection, String sourceBillType, String targetBillType, DefineSysEnum defineSys, String transmitCuId) throws BOTPException, BOSException {
        BOTMappingCollection botMappingCols = new BOTMappingCollection();
        BOTMappingCollection result = new BOTMappingCollection();
        try {
            IRowSet rowset = BOTMappingHelper.getMappingByOneCUForSelect(ctx, sourceBillType, targetBillType, defineSys, transmitCuId);
            while (rowset.next()) {
                BOTMappingInfo mappingInfo = new BOTMappingInfo();
                mappingInfo.setId(BOSUuid.read((String)rowset.getString("FID")));
                mappingInfo.setName(rowset.getString("FNAME"));
                mappingInfo.setAlias(rowset.getString("FALIAS_" + ctx.getLocale().toString()), ctx.getLocale());
                mappingInfo.setSrcEntityName(rowset.getString("FSRCENTITYNAME"));
                mappingInfo.setDestEntityName(rowset.getString("FDESTENTITYNAME"));
                mappingInfo.setDescription(rowset.getString("FDESCRIPTION_" + ctx.getLocale().toString()), ctx.getLocale());
                mappingInfo.setDefineSys(DefineSysEnum.getEnum(rowset.getInt("FDEFINESYS")));
                mappingInfo.setLastUpdateTime(rowset.getTimestamp("FLASTUPDATETIME"));
                mappingInfo.setIsTempSave(rowset.getInt("FISTEMPSAVE"));
                mappingInfo.setIsShowEditUI(rowset.getInt("FISSHOWEDITUI"));
                mappingInfo.setExtConfig(rowset.getString("FEXTCONFIG"));
                mappingInfo.setMappingType(MappingTypeEnum.getEnum(rowset.getInt("FMappingType")));
                IRowSet ruleRS = DbUtil.executeQuery((Context)ctx, (String)"SELECT BotRule.FID AS FRuleID, Segment.FID AS FSegmentID, Segment.FSrcPropertyName, Segment.FExpression FROM T_BOT_RULE BotRule INNER JOIN T_BOT_RULESEGMENT Segment ON BotRule.FID = Segment.FRuleID WHERE BotRule.FMappingID = ?", (Object[])new Object[]{rowset.getString("FID")});
                BOTRuleCollection ruleColl = mappingInfo.getRules();
                while (ruleRS.next()) {
                    BOTRuleInfo rule;
                    if (!ruleColl.containsKey(BOSUuid.read((String)ruleRS.getString("FRuleID")))) {
                        rule = new BOTRuleInfo();
                        rule.setId(BOSUuid.read((String)ruleRS.getString("FRuleID")));
                        ruleColl.add(rule);
                    } else {
                        rule = ruleColl.get(BOSUuid.read((String)ruleRS.getString("FRuleID")));
                    }
                    BOTRuleSegmentInfo segment = new BOTRuleSegmentInfo();
                    segment.setId(BOSUuid.read((String)ruleRS.getString("FSegmentID")));
                    segment.setSrcPropertyName(ruleRS.getString("FSrcPropertyName"));
                    segment.setExpression(ruleRS.getString("FExpression"));
                    rule.getRuleSegments().add(segment);
                }
                BOTExtMappingInfo extRule = new BOTExtMappingInfo();
                extRule.setFilter(rowset.getString("FFILTER"));
                extRule.setDataFilter(rowset.getString("FDATAFILTER"));
                extRule.setIsEffected(true);
                String orgId = rowset.getString("FORGID");
                if (!StringUtils.isEmpty((String)orgId)) {
                    CompanyOrgUnitInfo org = new CompanyOrgUnitInfo();
                    org.setId(BOSUuid.read((String)orgId));
                    extRule.setOrg(org);
                }
                mappingInfo.setExtRule(extRule);
                result.add(mappingInfo);
            }
        }
        catch (SQLException exc) {
            throw new BOTPException(BOTPException.MAPPINGNUMZERO, exc);
        }
        if (!BOTRuleFilterTools.isShowBOTPWithRuleFilter(ctx)) {
            return result;
        }
        Iterator iter = result.iterator();
        ArrayList<BOTMappingInfo> companyMappings = new ArrayList<BOTMappingInfo>();
        while (iter.hasNext()) {
            String currentOrgId;
            BOTMappingInfo mappingInfo = (BOTMappingInfo)iter.next();
            String string = currentOrgId = ContextUtil.getCurrentFIUnit((Context)ctx) == null ? "" : ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
            if (mappingInfo.getExtRule() != null && mappingInfo.getExtRule().getOrg() != null && !mappingInfo.getExtRule().getOrg().getId().toString().equals(currentOrgId)) continue;
            companyMappings.add(mappingInfo);
        }
        for (BOTMappingInfo mappingInfo : companyMappings) {
            try {
                BOTMappingHelper.acceptMapping(ctx, sourceBillCollection, mappingInfo);
                botMappingCols.add(mappingInfo);
            }
            catch (BOTPException bOTPException) {}
        }
        return botMappingCols;
    }

    public static BOTMappingCollection getMappingForSelect(Context ctx, IObjectCollection sourceBillCollection, String targetBillType, DefineSysEnum defineSys, Map transmitCtx) throws BOSException, BOTPException {
        BOTMappingCollection botMappingCols = new BOTMappingCollection();
        if (sourceBillCollection.size() == 0) {
            throw new BOTPException(BOTPException.NOBILL);
        }
        try {
            CoreBillBaseInfo sourceBill = (CoreBillBaseInfo)sourceBillCollection.getObject(0);
            String sourceBillType = sourceBill.getBOSType().toString();
            LowTimer t = new LowTimer();
            t.reset();
            BOTMappingCollection mappingCol = BOTMappingHelper.getBOTMappingCollectionForSelect(ctx, sourceBillType, targetBillType, defineSys, transmitCtx);
            if (mappingCol.size() == 0) {
                throw new BOTPException(BOTPException.NOMAPPING);
            }
            Iterator iter = mappingCol.iterator();
            ArrayList<BOTMappingInfo> companyMappings = new ArrayList<BOTMappingInfo>();
            while (iter.hasNext()) {
                String currentOrgId;
                BOTMappingInfo mappingInfo = (BOTMappingInfo)iter.next();
                String string = currentOrgId = ContextUtil.getCurrentFIUnit((Context)ctx) == null ? "" : ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
                if (mappingInfo.getExtRule() != null && mappingInfo.getExtRule().getOrg() != null && !mappingInfo.getExtRule().getOrg().getId().toString().equals(currentOrgId)) continue;
                companyMappings.add(mappingInfo);
            }
            if (companyMappings.size() == 0) {
                throw new BOTPException(BOTPException.NOCOMPANYMAPPING);
            }
            for (BOTMappingInfo mappingInfo : companyMappings) {
                try {
                    BOTMappingHelper.acceptMapping(ctx, sourceBillCollection, mappingInfo);
                }
                catch (BOTPException e) {
                    continue;
                }
                botMappingCols.add(mappingInfo);
            }
            if (botMappingCols.size() <= 0) {
                throw new BOTPException(BOTPException.MAPPINGNUMZERO);
            }
        }
        catch (BOTPException e) {
            logger.error((Object)("targetBillType:" + targetBillType), (Throwable)((Object)e));
        }
        return botMappingCols;
    }

    public static boolean isMappingEnabled(BOTMappingInfo mappingInfo) throws BOSException, BOTPException {
        return mappingInfo != null && mappingInfo.getExtRule() != null && mappingInfo.getExtRule().isIsEffected();
    }

    public static BOTMappingCollection getBOTMappingCollection(Context ctx, List mappingIdList) throws BOSException, BOTPException {
        int iStep;
        if (ctx == null) {
            return null;
        }
        int iMax = 100;
        int iTotal = mappingIdList.size();
        if (iTotal > (iStep = iTotal / iMax) * iMax) {
            ++iStep;
        }
        BOTMappingCollection mappings = new BOTMappingCollection();
        IBOTMapping iBotMapping = BOTMappingFactory.getLocalInstance(ctx);
        for (int k = 1; k <= iStep; ++k) {
            HashSet<String> set = new HashSet<String>();
            int lCurrStart = (k - 1) * iMax;
            int lCurrEnd = k * iMax;
            if (lCurrEnd > iTotal) {
                lCurrEnd = iTotal;
            }
            for (int i = lCurrStart; i < lCurrEnd; ++i) {
                String id = (String)mappingIdList.get(i);
                set.add(id);
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            CoreBaseCollection mappingInfos = iBotMapping.getCollection(view);
            mappings.addObjectCollection((IObjectCollection)mappingInfos);
        }
        return mappings;
    }

    private static BOTMappingCollection getBOTMappingCollectionForSelectByCU(Context ctx, String sourceBillType, String targetBillType, DefineSysEnum defineSys, String transmitID) throws BOSException, BOTPException {
        return BOTMappingHelper.getBOTMappingCollectionForSelectByCU(ctx, sourceBillType, targetBillType, defineSys, transmitID, false);
    }

    private static BOTMappingCollection getBOTMappingCollectionForSelectByCU(Context ctx, String sourceBillType, String targetBillType, DefineSysEnum defineSys, String transmitID, boolean isAllCUMode) throws BOSException, BOTPException {
        BOTMappingCollection result = new BOTMappingCollection();
        try {
            IRowSet rowset = null;
            rowset = !isAllCUMode ? BOTMappingHelper.getMappingByOneCUForSelect(ctx, sourceBillType, targetBillType, defineSys, transmitID) : BOTMappingHelper.getMappingAllCUForSelect(ctx, sourceBillType, targetBillType, defineSys);
            if (rowset != null && rowset.size() > 0) {
                while (rowset.next()) {
                    BOTMappingInfo mappingInfo = new BOTMappingInfo();
                    mappingInfo.setId(BOSUuid.read((String)rowset.getString("FID")));
                    mappingInfo.setName(rowset.getString("FNAME"));
                    mappingInfo.setAlias(rowset.getString("FALIAS_" + ctx.getLocale().toString()), ctx.getLocale());
                    mappingInfo.setSrcEntityName(rowset.getString("FSRCENTITYNAME"));
                    mappingInfo.setDestEntityName(rowset.getString("FDESTENTITYNAME"));
                    mappingInfo.setDescription(rowset.getString("FDESCRIPTION_" + ctx.getLocale().toString()), ctx.getLocale());
                    mappingInfo.setDefineSys(DefineSysEnum.getEnum(rowset.getInt("FDEFINESYS")));
                    mappingInfo.setLastUpdateTime(rowset.getTimestamp("FLASTUPDATETIME"));
                    mappingInfo.setIsTempSave(rowset.getInt("FISTEMPSAVE"));
                    mappingInfo.setIsShowEditUI(rowset.getInt("FISSHOWEDITUI"));
                    mappingInfo.setExtConfig(rowset.getString("FEXTCONFIG"));
                    mappingInfo.setMappingType(MappingTypeEnum.getEnum(rowset.getInt("FMappingType")));
                    BOTExtMappingInfo extRule = new BOTExtMappingInfo();
                    extRule.setFilter(rowset.getString("FFILTER"));
                    extRule.setDataFilter(rowset.getString("FDATAFILTER"));
                    extRule.setFilter4Pre(rowset.getString("FFILTER4PRE"));
                    extRule.setIsEffected(true);
                    String orgId = rowset.getString("FORGID");
                    if (!StringUtils.isEmpty((String)orgId)) {
                        CompanyOrgUnitInfo org = new CompanyOrgUnitInfo();
                        org.setId(BOSUuid.read((String)orgId));
                        extRule.setOrg(org);
                    }
                    mappingInfo.setExtRule(extRule);
                    result.add(mappingInfo);
                }
            }
        }
        catch (SQLException exc) {
            throw new BOTPException(BOTPException.MAPPINGNUMZERO, exc);
        }
        return result;
    }

    private static IRowSet getMappingByOneCUForSelect(Context ctx, String sourceBillType, String targetBillType, DefineSysEnum defineSys, String transmitCuId) throws BOSException {
        IRowSet rs;
        if (defineSys != null) {
            ArrayList<Object> paramsWithDefineSys = new ArrayList<Object>();
            paramsWithDefineSys.add(transmitCuId);
            paramsWithDefineSys.add(sourceBillType);
            paramsWithDefineSys.add(new Integer(1));
            paramsWithDefineSys.add(new Integer(10));
            paramsWithDefineSys.add(new Integer(30));
            paramsWithDefineSys.add(new Integer(defineSys.getValue()));
            String sql = "SELECT MAPPING.FNAME,MAPPING.FMAPPINGTYPE,MAPPING.FDESCRIPTION_" + ctx.getLocale().toString() + ",MAPPING.FAlias_" + ctx.getLocale().toString() + ",MAPPING.FControlUnitID CUID,MAPPING.FID, MAPPING.FSRCENTITYNAME, MAPPING.FDESTENTITYNAME, MAPPING.FDEFINESYS, MAPPING.FISTEMPSAVE, MAPPING.FISSHOWEDITUI,MAPPING.FEXTCONFIG,MAPPING.FLASTUPDATETIME, EXTRULE.FFILTER, EXTRULE.FDATAFILTER,EXTRULE.FFILTER4PRE, EXTRULE.FORGID  FROM T_BOT_MAPPING MAPPING LEFT OUTER JOIN T_BOT_EXTMAPPING EXTRULE ON MAPPING.FEXTMAPPINGID = EXTRULE.FID  WHERE (MAPPING.FUIDisable=0 OR MAPPING.FUIDisable IS NULL)  AND MAPPING.FControlUnitID = ?  AND MAPPING.FSRCENTITYNAME = ? AND EXTRULE.FISEFFECTED = ? AND (EXTRULE.FTRANSMODE = ? OR EXTRULE.FTRANSMODE = ?) AND MAPPING.FDEFINESYS = ?";
            if (targetBillType != null && targetBillType.length() > 0) {
                sql = sql + " AND MAPPING.FDESTENTITYNAME = ? " + BOTMappingHelper.getOrderSql(ctx);
                paramsWithDefineSys.add(targetBillType);
            } else {
                sql = sql + BOTMappingHelper.getOrderSql(ctx);
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])paramsWithDefineSys.toArray());
        } else {
            ArrayList<Object> paramsWithoutDefineSys = new ArrayList<Object>();
            paramsWithoutDefineSys.add(transmitCuId);
            paramsWithoutDefineSys.add(sourceBillType);
            paramsWithoutDefineSys.add(new Integer(1));
            paramsWithoutDefineSys.add(new Integer(10));
            paramsWithoutDefineSys.add(new Integer(30));
            String sql = "SELECT MAPPING.FNAME,MAPPING.FMAPPINGTYPE,MAPPING.FDESCRIPTION_" + ctx.getLocale().toString() + ",MAPPING.FAlias_" + ctx.getLocale().toString() + ",MAPPING.FControlUnitID CUID,MAPPING.FID, MAPPING.FSRCENTITYNAME, MAPPING.FDESTENTITYNAME, MAPPING.FDEFINESYS, MAPPING.FISTEMPSAVE, MAPPING.FISSHOWEDITUI,MAPPING.FEXTCONFIG, MAPPING.FLASTUPDATETIME, EXTRULE.FFILTER, EXTRULE.FDATAFILTER,EXTRULE.FFILTER4PRE, EXTRULE.FORGID  FROM T_BOT_MAPPING MAPPING LEFT OUTER JOIN T_BOT_EXTMAPPING EXTRULE ON MAPPING.FEXTMAPPINGID = EXTRULE.FID  WHERE (MAPPING.FUIDisable=0 OR MAPPING.FUIDisable IS NULL)  AND MAPPING.FControlUnitID = ?  AND MAPPING.FSRCENTITYNAME = ? AND EXTRULE.FISEFFECTED = ? AND (EXTRULE.FTRANSMODE = ? OR EXTRULE.FTRANSMODE = ?) ";
            if (targetBillType != null && targetBillType.length() > 0) {
                sql = sql + " AND MAPPING.FDESTENTITYNAME = ? " + BOTMappingHelper.getOrderSql(ctx);
                paramsWithoutDefineSys.add(targetBillType);
            } else {
                sql = sql + BOTMappingHelper.getOrderSql(ctx);
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])paramsWithoutDefineSys.toArray());
        }
        return rs;
    }

    public static BOTMappingCollection getMappingForSelectByCU(Context ctx, String srcBillType, String targetBillType, DefineSysEnum defineSys, String transmitID) throws BOSException, BOTPException {
        LowTimer t = new LowTimer();
        t.reset();
        BOTMappingCollection mappingCol = BOTMappingHelper.getBOTMappingCollectionForSelectByCU(ctx, srcBillType, targetBillType, defineSys, transmitID);
        logger.debug((Object)("getBOTMappingCollection time: " + t.msValue()));
        if (mappingCol.size() == 0) {
            logger.error((Object)("destBosType:" + targetBillType + ",transmitID:" + transmitID), (Throwable)((Object)new BOTPException(BOTPException.NOMAPPING)));
        }
        return mappingCol;
    }

    private static BOTMappingCollection getMappingCollectionFromRowSet(Context ctx, IRowSet rowset) throws SQLException, BOSException {
        BOTMappingCollection result = new BOTMappingCollection();
        while (rowset.next()) {
            BOTMappingInfo mappingInfo = new BOTMappingInfo();
            mappingInfo.setId(BOSUuid.read((String)rowset.getString("FID")));
            mappingInfo.setName(rowset.getString("FNAME"));
            mappingInfo.setAlias(rowset.getString("FALIAS_" + ctx.getLocale().toString()), ctx.getLocale());
            mappingInfo.setSrcEntityName(rowset.getString("FSRCENTITYNAME"));
            mappingInfo.setDestEntityName(rowset.getString("FDESTENTITYNAME"));
            mappingInfo.setDescription(rowset.getString("FDESCRIPTION_" + ctx.getLocale().toString()), ctx.getLocale());
            mappingInfo.setDefineSys(DefineSysEnum.getEnum(rowset.getInt("FDEFINESYS")));
            mappingInfo.setLastUpdateTime(rowset.getTimestamp("FLASTUPDATETIME"));
            mappingInfo.setIsTempSave(rowset.getInt("FISTEMPSAVE"));
            mappingInfo.setIsShowEditUI(rowset.getInt("FISSHOWEDITUI"));
            mappingInfo.setExtConfig(rowset.getString("FEXTCONFIG"));
            mappingInfo.setMappingType(MappingTypeEnum.getEnum(rowset.getInt("FMappingType")));
            IRowSet ruleRS = DbUtil.executeQuery((Context)ctx, (String)"SELECT BotRule.FID AS FRuleID, Segment.FID AS FSegmentID, Segment.FSrcPropertyName, Segment.FExpression FROM T_BOT_RULE BotRule INNER JOIN T_BOT_RULESEGMENT Segment ON BotRule.FID = Segment.FRuleID WHERE BotRule.FMappingID = ?", (Object[])new Object[]{rowset.getString("FID")});
            BOTRuleCollection ruleColl = mappingInfo.getRules();
            while (ruleRS.next()) {
                BOTRuleInfo rule;
                if (!ruleColl.containsKey(BOSUuid.read((String)ruleRS.getString("FRuleID")))) {
                    rule = new BOTRuleInfo();
                    rule.setId(BOSUuid.read((String)ruleRS.getString("FRuleID")));
                    ruleColl.add(rule);
                } else {
                    rule = ruleColl.get(BOSUuid.read((String)ruleRS.getString("FRuleID")));
                }
                BOTRuleSegmentInfo segment = new BOTRuleSegmentInfo();
                segment.setId(BOSUuid.read((String)ruleRS.getString("FSegmentID")));
                segment.setSrcPropertyName(ruleRS.getString("FSrcPropertyName"));
                segment.setExpression(ruleRS.getString("FExpression"));
                rule.getRuleSegments().add(segment);
            }
            BOTExtMappingInfo extRule = new BOTExtMappingInfo();
            extRule.setFilter(rowset.getString("FFILTER"));
            extRule.setDataFilter(rowset.getString("FDATAFILTER"));
            extRule.setIsEffected(true);
            String orgId = rowset.getString("FORGID");
            if (!StringUtils.isEmpty((String)orgId)) {
                CompanyOrgUnitInfo org = new CompanyOrgUnitInfo();
                org.setId(BOSUuid.read((String)orgId));
                extRule.setOrg(org);
            }
            mappingInfo.setExtRule(extRule);
            result.add(mappingInfo);
        }
        return result;
    }
}

