/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.botp.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.cache.CacheEngine;
import com.kingdee.bos.cache.CacheRegion;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.kscript.IFunctionProvider;
import com.kingdee.bos.kscript.KScriptException;
import com.kingdee.bos.kscript.dom.expr.BigDecimalExpr;
import com.kingdee.bos.kscript.dom.expr.BoolExpr;
import com.kingdee.bos.kscript.dom.expr.CodeExpr;
import com.kingdee.bos.kscript.dom.expr.DoubleExpr;
import com.kingdee.bos.kscript.dom.expr.FloatExpr;
import com.kingdee.bos.kscript.dom.expr.IdentifierExpr;
import com.kingdee.bos.kscript.dom.expr.IntExpr;
import com.kingdee.bos.kscript.dom.expr.LongExpr;
import com.kingdee.bos.kscript.dom.expr.MethodInvokeExpr;
import com.kingdee.bos.kscript.dom.expr.NullExpr;
import com.kingdee.bos.kscript.dom.expr.StringExpr;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.BOTTransform;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.EntryFilterType;
import com.kingdee.bos.metadata.entity.FilterCollection;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.openapi.third.OpenApi;
import com.kingdee.bos.openapi.third.OpenApiFactory;
import com.kingdee.bos.openapi.third.OpenApiInfo;
import com.kingdee.bos.openapi.third.exception.BizException;
import com.kingdee.bos.openapi.third.exception.InvokeNetworkException;
import com.kingdee.bos.openapi.third.exception.LoginException;
import com.kingdee.bos.openapi.third.invoker.AbstractLoginContext;
import com.kingdee.bos.openapi.third.login.LoginContext;
import com.kingdee.bos.openapi.util.json.JSONUtils;
import com.kingdee.bos.service.formula.api.IFormulaFunctions;
import com.kingdee.bos.spi.SPInfo;
import com.kingdee.bos.spi.SPManager;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.bos.ui.face.AbstractUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.rpc.ObjectFactory;
import com.kingdee.eas.base.botp.util.BOTObjectCache;
import com.kingdee.eas.base.botp.util.BotpDynamicFormulaFunctions;
import com.kingdee.eas.base.botp.util.BotpFormulaFunctions;
import com.kingdee.eas.base.botp.util.BotpScriptAnalyzeUtils;
import com.kingdee.eas.base.botp.util.BotpScriptFuncDeclare;
import com.kingdee.eas.base.botp.util.BotpScriptUtils;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BotpBatchFuncHandler;
import com.kingdee.eas.base.btp.BotpBatchFuncResultCollection;
import com.kingdee.eas.base.btp.IBotpBatchFormulaFunctions;
import com.kingdee.eas.base.btp.app.BOTPConfigInfo;
import com.kingdee.eas.base.commonquery.QueryUtils;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaTokenManager;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.ThreadLocalCache;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class BOTPTools {
    private static Logger logger = Logger.getLogger(BOTPTools.class);
    private static String ROOTCACHE = "BOTCACHE";
    public static String localInstance = "getLocalInstance";
    private static Boolean SQLDAP_HGUI_INSTALLED = null;
    private static String BOTP_ENABLE_SQLENGINE = "BOTP_ENABLE_SQLENGINE";
    private static String BOTP_ALLENTRIES_SELECTED = "BOTP_ALLENTRIES_SELECTED";
    private static String BOTP_CTRLUNIT_AUTHOR = "BOTP_CTRLUNIT_AUTHOR";
    private static String DAP_ENABLE_CrossSystem = "DAP_ENABLE_CrossSystem";
    private static String BOTP_ENABLE_DBLOCK = "BOTP_ENABLE_DBLOCK";
    private static String BOTP_ENABLE_EngineNew2 = "BOTP_ENABLE_EngineNew2";

    public static void execDataFilterByScript(Context ctx, IObjectCollection srcBillCols, String dataFilter) throws ParserException {
        if (dataFilter == null || dataFilter.equals("")) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo(dataFilter);
        evi.getEntryFilters().clear();
        String billHeadFilter = evi.toString();
        StringBuffer sbForBillHeadFilter = new StringBuffer();
        while (true) {
            int index;
            if ((index = billHeadFilter.indexOf("=")) == -1) break;
            if (billHeadFilter.charAt(index + 1) == '=') {
                sbForBillHeadFilter.append(billHeadFilter.substring(0, index + 1));
                billHeadFilter = billHeadFilter.substring(index + 2);
                continue;
            }
            sbForBillHeadFilter.append(billHeadFilter.substring(0, index));
            sbForBillHeadFilter.append("=");
            billHeadFilter = billHeadFilter.substring(index + 1);
        }
        sbForBillHeadFilter.append(billHeadFilter);
    }

    public static void execDataFilter(Context ctx, CoreBillBaseCollection srcCoreBillCollection, String dataFilter, String entriesName) throws BOSException {
        int size;
        if (dataFilter == null || "".equals(dataFilter)) {
            return;
        }
        EntityViewInfo evi = null;
        try {
            evi = new EntityViewInfo(dataFilter);
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer filterMask = new StringBuffer();
        StringBuffer strIdLists = new StringBuffer();
        int size2 = srcCoreBillCollection.size();
        for (int i = 0; i < size2; ++i) {
            if (i > 0) {
                strIdLists.append(",");
            }
            strIdLists.append(srcCoreBillCollection.get(i).getId().toString());
        }
        if (strIdLists.length() > 0) {
            filterMask.append("#" + String.valueOf(filterInfo.getFilterItems().size()));
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists.toString(), CompareType.INCLUDE));
        }
        if (filterMask.length() > 0) {
            filterInfo.setMaskString(filterMask.toString());
        }
        if (evi.getFilter() != null && evi.getFilter().getFilterItems().size() > 0) {
            evi.getFilter().mergeFilter(filterInfo, "and");
        } else {
            evi.setFilter(filterInfo);
        }
        if (entriesName != null) {
            FilterInfo entryFilterInfo = new FilterInfo();
            entryFilterInfo.setEntryName(entriesName);
            entryFilterInfo.setEntryilterType(EntryFilterType.NORMAL);
            StringBuffer entryFilterMask = new StringBuffer();
            StringBuffer strEntryIdLists = new StringBuffer();
            size = srcCoreBillCollection.size();
            for (int i = 0; i < size; ++i) {
                CoreBillBaseInfo srcCoreBillInfo = srcCoreBillCollection.get(i);
                IObjectCollection srcCoreBillEntryCols = (IObjectCollection)srcCoreBillInfo.get(entriesName);
                if (srcCoreBillEntryCols == null) continue;
                int count = srcCoreBillEntryCols.size();
                for (int j = 0; j < count; ++j) {
                    IObjectValue srcCoreBillEntryInfo = srcCoreBillEntryCols.getObject(j);
                    if (i + j > 0) {
                        strEntryIdLists.append(",");
                    }
                    strEntryIdLists.append(srcCoreBillEntryInfo.get("id").toString());
                }
            }
            if (strEntryIdLists.length() > 0) {
                entryFilterMask.append("#" + String.valueOf(entryFilterInfo.getFilterItems().size()));
                entryFilterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strEntryIdLists.toString(), CompareType.INCLUDE));
            }
            if (filterMask.length() > 0) {
                entryFilterInfo.setMaskString(entryFilterMask.toString());
            }
            if (evi.getEntryFilters() != null && evi.getEntryFilters().size() > 0) {
                FilterInfo botEntryFilter = evi.getEntryFilters().get(0);
                if (botEntryFilter.getFilterItems().size() > 0) {
                    botEntryFilter.mergeFilter(entryFilterInfo, "and");
                } else {
                    evi.getEntryFilters().remove(botEntryFilter);
                    evi.getEntryFilters().add(entryFilterInfo);
                }
            } else {
                evi.getEntryFilters().add(entryFilterInfo);
            }
        }
        dataFilter = evi.toString();
        if (srcCoreBillCollection.size() > 0) {
            IDynamicObject iDynObj = DynamicObjectFactory.getLocalInstance((Context)ctx);
            IObjectCollection billCollection = iDynObj.getCollection(srcCoreBillCollection.get(0).getBOSType(), dataFilter);
            CoreBillBaseCollection filteredCollection = new CoreBillBaseCollection();
            size = billCollection.size();
            for (int i = 0; i < size; ++i) {
                filteredCollection.add((CoreBillBaseInfo)billCollection.getObject(i));
            }
            int count = srcCoreBillCollection.size();
            for (int t = 0; t < count; ++t) {
                BOSUuid filteredBillId;
                int s;
                BOSUuid srcBillId = srcCoreBillCollection.get(t).getId();
                int fCount = filteredCollection.size();
                for (s = 0; s < fCount && !srcBillId.equals((Object)(filteredBillId = filteredCollection.get(s).getId())); ++s) {
                }
                if (s == fCount) {
                    srcCoreBillCollection.removeObject(t);
                    --t;
                    --count;
                    continue;
                }
                if (entriesName == null) continue;
                CoreBillBaseInfo filteredInfo = filteredCollection.get(s);
                CoreBillBaseInfo srcBillInfo = srcCoreBillCollection.get(t);
                IObjectCollection billEntries = (IObjectCollection)srcBillInfo.get(entriesName);
                IObjectCollection filterEntries = (IObjectCollection)filteredInfo.get(entriesName);
                int beCount = billEntries.size();
                for (int z = 0; z < beCount; ++z) {
                    IObjectValue billEntry = billEntries.getObject(z);
                    boolean flag = false;
                    int fBeCount = filterEntries.size();
                    for (int fz = 0; fz < fBeCount; ++fz) {
                        IObjectValue feBillEntry = filterEntries.getObject(fz);
                        if (!billEntry.get("id").toString().equals(feBillEntry.get("id").toString())) continue;
                        flag = true;
                        break;
                    }
                    if (flag) continue;
                    billEntries.removeObject(z);
                    --z;
                    --beCount;
                }
                if (billEntries.size() >= 1) continue;
                srcCoreBillCollection.removeObject(t);
                --t;
                --count;
            }
        }
    }

    public static BOTTransform getBOTTransform(Context ctx, BOTMappingInfo botMappingInfo) throws DataAccessException, IOException, KScriptException {
        BOTTransform botTransform = new BOTTransform(ctx);
        BOTPTools.addBOTPFormulaFunction(ctx, botTransform);
        EntityObjectInfo destEntity = botMappingInfo.getDestEntity();
        List formulaFuncsDestList = BOTPTools.getFormulaFuncsList(destEntity);
        int formulaFuncSize = formulaFuncsDestList.size();
        for (int formualFuncIndex = 0; formualFuncIndex < formulaFuncSize; ++formualFuncIndex) {
            botTransform.addFunctionProvider((IFunctionProvider)formulaFuncsDestList.get(formualFuncIndex));
        }
        List formulaFuncsSrcList = BOTPTools.getFormulaFuncsList(botMappingInfo.getSrcEntity());
        int formulaFuncSize2 = formulaFuncsSrcList.size();
        for (int formualFuncIndex = 0; formualFuncIndex < formulaFuncSize2; ++formualFuncIndex) {
            botTransform.addFunctionProvider((IFunctionProvider)formulaFuncsSrcList.get(formualFuncIndex));
        }
        return botTransform;
    }

    private static List getFormulaFuncsList(EntityObjectInfo destEntity) {
        String billFormulaClassStr;
        ArrayList<IFormulaFunctions> formulaFuncsSrcList = new ArrayList<IFormulaFunctions>();
        if (destEntity != null && (billFormulaClassStr = destEntity.getExtendedProperty("billFormulaClass")) != null && billFormulaClassStr.length() > 0) {
            String[] billFormulaClass = StringUtils.split((String)billFormulaClassStr, (String)";");
            for (int i = 0; i < billFormulaClass.length; ++i) {
                if (billFormulaClass[i].trim().equals("")) continue;
                try {
                    Class<?> billFormula = Class.forName(billFormulaClass[i].trim());
                    IFormulaFunctions funcInstance = (IFormulaFunctions)billFormula.newInstance();
                    if (funcInstance == null) continue;
                    formulaFuncsSrcList.add(funcInstance);
                    continue;
                }
                catch (ClassNotFoundException ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                    continue;
                }
                catch (InstantiationException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    continue;
                }
                catch (IllegalAccessException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return formulaFuncsSrcList;
    }

    public static BOTTransform getBOTTransform(Context ctx, BOTMappingCollection botMappingCols) throws DataAccessException, IOException, KScriptException {
        BOTTransform botTransform = new BOTTransform(ctx);
        BOTPTools.addBOTPFormulaFunction(ctx, botTransform);
        BOTPTools.addEntityFormulaFunction(ctx, botTransform, botMappingCols);
        return botTransform;
    }

    private static void addEntityFormulaFunction(Context ctx, BOTTransform botTransform, BOTMappingCollection botMappingCols) throws DataAccessException, IOException, KScriptException {
        Iterator botMappingIter = botMappingCols.iterator();
        while (botMappingIter.hasNext()) {
            BOTMappingInfo botMappingInfo = (BOTMappingInfo)botMappingIter.next();
            BOTPTools.innerAddEntityFormulaFunction(ctx, botTransform, botMappingInfo.getDestEntity());
            BOTPTools.innerAddEntityFormulaFunction(ctx, botTransform, botMappingInfo.getSrcEntity());
            botTransform.addFunctionProvider((IFunctionProvider)new BotpDynamicFormulaFunctions(ctx, botMappingInfo.getSrcEntity(), botMappingInfo.getDestEntity()));
        }
    }

    private static void innerAddEntityFormulaFunction(Context ctx, BOTTransform botTransform, EntityObjectInfo entity) throws DataAccessException, IOException, KScriptException {
        if (entity == null) {
            return;
        }
        String baseClass = "com.kingdee.eas.framework.app";
        EntityObjectInfo entityObjectInfo = entity;
        do {
            String billFormulaClassStr;
            if ((billFormulaClassStr = entityObjectInfo.getExtendedProperty("billFormulaClass")) == null || billFormulaClassStr.length() <= 0) continue;
            String[] billFormulaClass = StringUtils.split((String)billFormulaClassStr, (String)";");
            for (int i = 0; i < billFormulaClass.length; ++i) {
                if (billFormulaClass[i].trim().equals("")) continue;
                try {
                    Class<?> billFormula = Class.forName(billFormulaClass[i].trim());
                    IFormulaFunctions funcInstance = (IFormulaFunctions)billFormula.newInstance();
                    if (funcInstance == null) continue;
                    botTransform.addFunctionProvider((IFunctionProvider)((IFormulaFunctions)billFormula.newInstance()));
                    continue;
                }
                catch (ClassNotFoundException ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                    continue;
                }
                catch (InstantiationException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    continue;
                }
                catch (IllegalAccessException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        } while ((entityObjectInfo = entityObjectInfo.getParent()) != null && entityObjectInfo.getFullName() != null && entityObjectInfo.getFullName().indexOf(baseClass) < 0);
    }

    public static void clearCache(Context ctx, String sessionId) {
        CacheRegion botCurrentCache;
        CacheRegion botRootCache;
        CacheRegion root = CacheEngine.getLocalRootRegion();
        if (root.exists((Object)ROOTCACHE) && (botRootCache = root.getRegion(ROOTCACHE)) != null && botRootCache.exists((Object)sessionId) && (botCurrentCache = botRootCache.getRegion(sessionId)) != null) {
            botCurrentCache.destroy();
        }
    }

    public static void prepareCache(Context ctx, List sourceBillColsList, IObjectCollection botMappingCols) throws BOSException {
        if (sourceBillColsList != null && botMappingCols != null) {
            assert (sourceBillColsList.size() == botMappingCols.size());
            BOTPTools.checkRisk(ctx, sourceBillColsList, botMappingCols);
            int count = sourceBillColsList.size();
            for (int i = 0; i < count; ++i) {
                IObjectCollection srcBillCols = (IObjectCollection)sourceBillColsList.get(i);
                BOTMappingInfo botMappingInfo = (BOTMappingInfo)botMappingCols.getObject(i);
                try {
                    BOTPTools.preProcessMappingScript(ctx, null, srcBillCols, botMappingInfo);
                    continue;
                }
                catch (KScriptException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    continue;
                }
                catch (DataAccessException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static void prepareCache(Context ctx, BOTTransform botTransform, List sourceBillColsList, IObjectCollection botMappingCols) throws Exception {
        ThreadLocalCache.detroyRegion((String)"__BOT");
        ThreadLocalCache.detroyRegion((String)"__DYNBOT");
        if (sourceBillColsList != null && botMappingCols != null) {
            assert (sourceBillColsList.size() == botMappingCols.size());
            BOTPTools.checkRisk(ctx, sourceBillColsList, botMappingCols);
            int count = sourceBillColsList.size();
            for (int i = 0; i < count; ++i) {
                IObjectCollection srcBillCols = (IObjectCollection)sourceBillColsList.get(i);
                BOTMappingInfo botMappingInfo = (BOTMappingInfo)botMappingCols.getObject(i);
                BOTObjectCache cache = BOTObjectCache.getInstance(ctx);
                cache.setMappingId(botMappingInfo.getId().toString());
                try {
                    BOTPTools.preProcessMappingScript(ctx, botTransform, srcBillCols, botMappingInfo);
                    continue;
                }
                catch (KScriptException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    continue;
                }
                catch (DataAccessException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static void checkRisk(Context ctx, List sourceBillColsList, IObjectCollection botMappingCols) throws BOSException {
        HashMap<String, ArrayList<IObjectCollection>> srcBillMap = new HashMap<String, ArrayList<IObjectCollection>>();
        HashMap<String, BOTMappingCollection> botMappingMap = new HashMap<String, BOTMappingCollection>();
        int count = sourceBillColsList.size();
        for (int i = 0; i < count; ++i) {
            IObjectCollection srcObjCols = (IObjectCollection)sourceBillColsList.get(i);
            BOTMappingInfo botMappingInfo = (BOTMappingInfo)botMappingCols.getObject(i);
            EntityObjectInfo srcEntity = botMappingInfo.getSrcEntity();
            EntityObjectInfo destEntity = botMappingInfo.getDestEntity();
            String key = srcEntity.getType().toString() + "&&" + destEntity.getType().toString();
            ArrayList<IObjectCollection> srcBillList = (ArrayList<IObjectCollection>)srcBillMap.get(key);
            if (srcBillList == null) {
                srcBillList = new ArrayList<IObjectCollection>();
                srcBillMap.put(key, srcBillList);
            }
            srcBillList.add(srcObjCols);
            BOTMappingCollection botMappingCol = (BOTMappingCollection)((Object)botMappingMap.get(key));
            if (botMappingCol == null) {
                botMappingCol = new BOTMappingCollection();
                botMappingMap.put(key, botMappingCol);
            }
            botMappingCol.add(botMappingInfo);
        }
        for (String key : srcBillMap.keySet()) {
            String[] temp = key.split("&&");
            ICoreBillBase iBillBase = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSObjectType.create((String)temp[0]));
            iBillBase.checkRiskForBotp((List)srcBillMap.get(key), temp[0], temp[1], (BOTMappingCollection)((Object)botMappingMap.get(key)));
        }
    }

    private static void prepareCacheForSingleBillType(Context ctx, IObjectCollection srcBillCols, BOTMappingInfo botMappingInfo) {
        HashMap propertyToEntity = new HashMap();
        ArrayList<String> propertyList = new ArrayList<String>();
        HashMap<String, List<String>> entityToSelectorList = new HashMap<String, List<String>>();
        String botMappingXml = botMappingInfo.toXml();
        Pattern pattern = Pattern.compile("&quot;");
        StringBuffer sb = new StringBuffer();
        Matcher match = pattern.matcher(botMappingXml);
        while (match.find()) {
            match.appendReplacement(sb, "");
        }
        match.appendTail(sb);
        botMappingXml = sb.toString();
        pattern = Pattern.compile("__BOTGetProperty\\(([\\s\\w\\.]+),[\\s]?(#[\\s\\w\\.]+#)?([\\s\\w\\.]+)\\)");
        match = pattern.matcher(botMappingXml);
        while (match.find()) {
            List<String> selectorListForFullEntity;
            List<String> selectorList;
            Map entityToSelector;
            int grpCount = match.groupCount();
            assert (grpCount == 3);
            String property = match.group(1);
            String entity = match.group(3);
            if (!propertyList.contains(property = StringUtils.trim((String)property))) {
                propertyList.add(property);
            }
            if (propertyToEntity.get(property) == null) {
                entityToSelector = new HashMap();
                propertyToEntity.put(property, entityToSelector);
            } else {
                entityToSelector = (Map)propertyToEntity.get(property);
            }
            if (entity.indexOf(46) == -1) {
                entity = "__src." + entity;
            }
            int dotIndex = entity.indexOf(46);
            assert (dotIndex > -1);
            String entityName = entity.substring(0, dotIndex).trim().toLowerCase();
            String entitySelector = entity.substring(dotIndex + 1, entity.length());
            if (entityToSelector.get(entityName) == null) {
                selectorList = new ArrayList();
                entityToSelector.put(entityName, selectorList);
            } else {
                selectorList = (List)entityToSelector.get(entityName);
            }
            if (!selectorList.contains(entitySelector)) {
                selectorList.add(entitySelector);
            }
            if (entityToSelectorList.get(entityName) == null) {
                selectorListForFullEntity = new ArrayList();
                entityToSelectorList.put(entityName, selectorListForFullEntity);
            } else {
                selectorListForFullEntity = (List)entityToSelectorList.get(entityName);
            }
            if (selectorListForFullEntity.contains(entitySelector)) continue;
            selectorListForFullEntity.add(entitySelector);
        }
        HashMap entityToIdList = new HashMap();
        for (String fullPropertyName : propertyList) {
            int dotIndex = fullPropertyName.indexOf(46);
            assert (dotIndex > -1);
            String prefix = fullPropertyName.substring(0, dotIndex);
            String propName = fullPropertyName.substring(dotIndex + 1, fullPropertyName.length());
            assert (prefix.equals("__src"));
            int count = srcBillCols.size();
            for (int i = 0; i < count; ++i) {
                IObjectValue srcBillInfo = srcBillCols.getObject(i);
                BOTPTools.getWeakId(ctx, srcBillInfo, propName, entityToIdList);
            }
        }
        for (String bosType : entityToIdList.keySet()) {
            String bosEntityName = BOTPTools.getEntityName(ctx, bosType).toLowerCase();
            List idList = (List)entityToIdList.get(bosType);
            EntityViewInfo evi = new EntityViewInfo();
            evi.getSelector().add("id");
            if (entityToSelectorList.containsKey(bosEntityName)) {
                List selectorList = (List)entityToSelectorList.get(bosEntityName);
                for (String selector : selectorList) {
                    selector = selector.trim();
                    evi.getSelector().add(selector);
                }
            }
            FilterInfo filter = new FilterInfo();
            evi.setFilter(filter);
            Iterator idIter = idList.iterator();
            int index = 0;
            StringBuffer mask = new StringBuffer();
            while (idIter.hasNext()) {
                String id = (String)idIter.next();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)id));
                if (index != 0) {
                    mask.append(" or #");
                    mask.append(index);
                } else {
                    mask.append("#");
                    mask.append(index);
                }
                ++index;
            }
            filter.setMaskString(mask.toString());
            try {
                BOSObjectType bosTypeObj = new BOSObjectType(bosType);
                IDynamicObject iDynObj = DynamicObjectFactory.getLocalInstance((Context)ctx);
                IObjectCollection weakBillCols = iDynObj.getCollection(bosTypeObj, evi);
                BOTObjectCache.getInstance(ctx).prepare(weakBillCols);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private static String getEntityName(Context ctx, String bosType) {
        IMetaDataLoader metaDataLoader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = metaDataLoader.getEntity(new BOSObjectType(bosType));
        return entity.getName();
    }

    private static void getWeakId(Context ctx, Object srcBillInfo, String propNameList, Map entityToIdList) {
        String nextProp;
        String currentProp;
        int dotIndex = propNameList.indexOf(46);
        if (dotIndex == -1) {
            currentProp = propNameList.trim();
            nextProp = null;
        } else {
            currentProp = propNameList.substring(0, dotIndex).trim();
            nextProp = propNameList.substring(dotIndex + 1, propNameList.length()).trim();
        }
        if (srcBillInfo instanceof IObjectCollection || srcBillInfo instanceof Collection) {
            for (Object srcBillIterInfo : (IObjectCollection)srcBillInfo) {
                BOTPTools.getWeakId(ctx, srcBillIterInfo, propNameList, entityToIdList);
            }
        } else {
            Object currentObject = null;
            if (srcBillInfo instanceof IObjectValue && ((IObjectValue)srcBillInfo).containsKey(currentProp) && ((IObjectValue)srcBillInfo).get(currentProp) != null) {
                currentObject = ((IObjectValue)srcBillInfo).get(currentProp);
            } else {
                try {
                    Class<?> clazz = srcBillInfo.getClass();
                    Field[] fields = clazz.getFields();
                    boolean isFoundInField = false;
                    for (Field currentField : fields) {
                        String fieldName = currentField.getName();
                        if (!currentProp.equals(fieldName)) continue;
                        isFoundInField = true;
                        currentObject = currentField.get(srcBillInfo);
                    }
                    if (!isFoundInField) {
                        Method[] methods = clazz.getMethods();
                        String getterMethodName = "get" + currentProp;
                        for (Method currentMethod : methods) {
                            if (!currentMethod.getName().equalsIgnoreCase(getterMethodName) || currentMethod.getParameterTypes() != null && currentMethod.getParameterTypes().length != 0) continue;
                            currentObject = currentMethod.invoke(srcBillInfo, new Object[0]);
                        }
                    }
                }
                catch (IllegalAccessException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (currentObject != null) {
                if (dotIndex == -1) {
                    if (currentObject != null) {
                        List<String> idList;
                        String weakId = currentObject.toString();
                        BOSUuid uuid = BOSUuid.read((String)weakId);
                        BOSObjectType bosType = uuid.getType();
                        if (entityToIdList.containsKey(bosType.toString())) {
                            idList = (List)entityToIdList.get(bosType.toString());
                        } else {
                            idList = new ArrayList();
                            entityToIdList.put(bosType.toString(), idList);
                        }
                        if (!idList.contains(weakId)) {
                            idList.add(weakId);
                        }
                    }
                } else {
                    BOTPTools.getWeakId(ctx, currentObject, nextProp, entityToIdList);
                }
            }
        }
    }

    public static List getFilterPropertiesInBotMapping(Context ctx, String srcBosType, String destBosType) throws BOSException {
        ArrayList filterProps = new ArrayList();
        List filterList = BOTPTools.getAllFilterInBotMapping(ctx, srcBosType, destBosType);
        for (String filter : filterList) {
            try {
                EntityViewInfo evi = new EntityViewInfo(filter);
                BOTPTools.parsePropertiesInEvi(evi, filterProps);
            }
            catch (ParserException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return filterProps;
    }

    private static List getAllFilterInBotMapping(Context ctx, String srcBosType, String destBosType) throws BOSException {
        ArrayList<String> filterList = new ArrayList<String>();
        StringBuffer sqlToGetAllBotFilter = new StringBuffer("SELECT EXT.FFILTER, EXT.FDATAFILTER FROM T_BOT_EXTMAPPING EXT JOIN T_BOT_MAPPING M ON EXT.FID = M.FEXTMAPPINGID WHERE EXT.FISEFFECTED = 1 ");
        ArrayList<String> objToGetAllBotFilter = new ArrayList<String>();
        if (srcBosType != null) {
            sqlToGetAllBotFilter.append(" AND M.FSRCENTITYNAME = ?");
            objToGetAllBotFilter.add(srcBosType);
        }
        if (destBosType != null) {
            sqlToGetAllBotFilter.append(" AND M.DESTENTTIYNAME = ?");
            objToGetAllBotFilter.add(destBosType);
        }
        try {
            IRowSet rsToGetAllBotFilter = DbUtil.executeQuery((Context)ctx, (String)sqlToGetAllBotFilter.toString(), (Object[])objToGetAllBotFilter.toArray());
            while (rsToGetAllBotFilter.next()) {
                String filter = rsToGetAllBotFilter.getString("FFILTER");
                String dataFilter = rsToGetAllBotFilter.getString("FDATAFILTER");
                if (filter != null && filter.trim().length() > 0 && !filter.trim().equalsIgnoreCase("null")) {
                    filterList.add(filter);
                }
                if (dataFilter == null || dataFilter.trim().length() <= 0 || dataFilter.trim().equalsIgnoreCase("null")) continue;
                filterList.add(dataFilter);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return filterList;
    }

    private static void parsePropertiesInEvi(EntityViewInfo evi, List filterProps) {
        if (evi != null) {
            FilterCollection entryFilterCols;
            FilterInfo filter = evi.getFilter();
            if (filter != null) {
                for (FilterItemInfo filterItemInfo : filter.getFilterItems()) {
                    String billProp = filterItemInfo.getCompareExpression().trim();
                    if (filterProps.contains(billProp)) continue;
                    filterProps.add(billProp);
                }
            }
            if ((entryFilterCols = evi.getEntryFilters()) != null) {
                for (FilterInfo entryFilterInfo : entryFilterCols) {
                    String entryName = entryFilterInfo.getEntryName();
                    for (FilterItemInfo filterItemInfo : entryFilterInfo.getFilterItems()) {
                        String billProp = entryName + "." + filterItemInfo.getCompareExpression().trim();
                        if (filterProps.contains(billProp)) continue;
                        filterProps.add(billProp);
                    }
                }
            }
        }
    }

    public static Class getProviderClass(String serviceName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        SPManager spManager = SPManager.getInstance();
        SPInfo spInfo = spManager.getSeviceProvider(serviceName);
        if (spInfo == null) {
            logger.error((Object)("The provider class isn't configed : " + serviceName), new Throwable());
            return null;
        }
        Class clz = spInfo.getProviderClass();
        if (clz == null) {
            logger.error((Object)("The provider class isn't exist : " + serviceName + ",  class name:" + spInfo.getProviderClassName()), new Throwable());
        }
        return clz;
    }

    public static Object getProviderClassObject(String serviceName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class cls = BOTPTools.getProviderClass(serviceName);
        if (cls == null) {
            return null;
        }
        return cls.newInstance();
    }

    public static String getEntityObjectInfoExtendPro(Context ctx, String bosTypeString, String extendProName) throws BOSException, BTPException {
        try {
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            EntityObjectInfo tempObj = loader.getEntity(BOSObjectType.create((String)bosTypeString));
            return tempObj.getExtendedProperty(extendProName) == null ? null : tempObj.getExtendedProperty(extendProName).toString();
        }
        catch (Exception e) {
            throw new BTPException(BTPException.GETEXTENDPROPERROR, e);
        }
    }

    public static String getEntityObjectInfoExtendProClient(String bosTypeString, String extendProName) throws BOSException, BTPException {
        return BOTPTools.getEntityObjectInfoExtendPro(null, bosTypeString, extendProName);
    }

    public static boolean getExtendPropertyBooleanValue(Context ctx, IObjectValue model, String extPropertyName, boolean defaultValue) throws BOSException, EASBizException {
        boolean bValue = defaultValue;
        if (model == null) {
            throw new BOSException("Illegal argument error, model:" + model);
        }
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = loader.getEntity(model.getBOSType());
        String extendProperty = entity.getExtendedProperty(extPropertyName);
        if (!StringUtils.isEmpty((String)extendProperty)) {
            bValue = Boolean.valueOf(extendProperty);
        }
        return bValue;
    }

    public static boolean getExtendPropertyBooleanValue(Context ctx, BOSObjectType bosType, String extPropertyName, boolean defaultValue) throws BOSException, EASBizException {
        boolean bValue = defaultValue;
        if (bosType == null) {
            throw new BOSException("Illegal argument error, bosType:" + bosType);
        }
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = loader.getEntity(bosType);
        String extendProperty = entity.getExtendedProperty(extPropertyName);
        if (!StringUtils.isEmpty((String)extendProperty)) {
            bValue = Boolean.valueOf(extendProperty);
        }
        return bValue;
    }

    public static boolean getExtendPropertyBooleanValue(Context ctx, EntityObjectInfo entity, String extPropertyName, boolean defaultValue) throws BOSException, EASBizException {
        boolean bValue = defaultValue;
        if (entity == null) {
            throw new BOSException("Illegal argument error, bosType:" + entity);
        }
        String extendProperty = entity.getExtendedProperty(extPropertyName);
        if (!StringUtils.isEmpty((String)extendProperty)) {
            bValue = Boolean.valueOf(extendProperty);
        }
        return bValue;
    }

    public static String getExtendPropertyStringValue(Context ctx, BOSObjectType bosType, String extPropertyName) throws BOSException, EASBizException {
        String bValue = null;
        if (bosType == null) {
            throw new BOSException("Illegal argument error, bosType:" + bosType);
        }
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = loader.getEntity(bosType);
        bValue = entity.getExtendedProperty(extPropertyName);
        return bValue;
    }

    public static IUIObject createUIObjectNoInit(String name) throws UIException {
        try {
            Class<?> c = null;
            try {
                c = Class.forName(name + "CTEx", false, AbstractUIFactory.class.getClassLoader());
            }
            catch (ClassNotFoundException ex) {
                try {
                    c = Class.forName(name + "PIEx", false, AbstractUIFactory.class.getClassLoader());
                }
                catch (ClassNotFoundException _) {
                    c = Class.forName(name);
                }
            }
            IUIObject uiObj = (IUIObject)c.newInstance();
            return uiObj;
        }
        catch (Exception e) {
            throw new UIException("Can not create ui object!", (Throwable)e);
        }
    }

    private static void addBOTPFormulaFunction(Context ctx, BOTTransform botTransform) throws DataAccessException, IOException, KScriptException {
        botTransform.addFunctionProvider((IFunctionProvider)new BotpFormulaFunctions(ctx.getLocale()));
        if (SPManager.isEASInstalled()) {
            Object clz = null;
            try {
                clz = BOTPTools.getProviderClassObject("BOTP_EXTENDFUNCIONS");
                if (clz != null && clz instanceof IFormulaFunctions) {
                    botTransform.addFunctionProvider((IFunctionProvider)((IFormulaFunctions)clz));
                }
            }
            catch (Exception e) {
                logger.error((Object)"The ExtendFormulaFunction class is not found!", (Throwable)e);
            }
        }
    }

    public static String getCurrentTime() {
        Calendar calendar = GregorianCalendar.getInstance();
        Date date = calendar.getTime();
        SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String str = d.format(date);
        return str;
    }

    public static Object invokeDynMethod(Object obj, String methodName, Class[] clzs, Object[] params) throws BOSException {
        if (obj == null) {
            return null;
        }
        Method mothod = null;
        try {
            mothod = obj.getClass().getMethod(methodName, clzs);
            if (mothod == null) {
                return null;
            }
            return mothod.invoke(obj, params);
        }
        catch (Exception e) {
            throw new BOSException("InvokeDynMethod error!  obj=" + obj + ",  methodName=" + methodName + ", clzs=" + clzs + ", params=" + params, (Throwable)e);
        }
    }

    static void preProcessMappingScript(Context ctx, BOTTransform botTransform, IObjectCollection srcObjCols, BOTMappingInfo mappingInfo) throws BOSException {
        BotpScriptAnalyzeUtils analyze = new BotpScriptAnalyzeUtils();
        analyze.analyzeScriptMapping(ctx, mappingInfo);
        Map thirdBizObjPropertyMap = analyze.getThirdBizObjPropertyMap();
        Map funcMap = analyze.getFuncMap();
        EntityObjectInfo srcEntity = mappingInfo.getSrcEntity();
        if (BOTPConfigInfo.getConfigInstance().isOpenBatchPreCache()) {
            BOTPTools.preCacheThirdPartObj(ctx, srcObjCols, thirdBizObjPropertyMap);
        }
        if (mappingInfo == null || mappingInfo.getRules() == null) {
            return;
        }
        if (botTransform != null) {
            BOTPTools.preCacheBatchFunciton(ctx, botTransform, srcObjCols, funcMap, srcEntity);
        }
    }

    static void preCacheBatchFunciton(Context ctx, BOTTransform botTransform, IObjectCollection srcObjCols, Map funcMap, EntityObjectInfo srcEntity) throws BOSException {
        if (funcMap == null || funcMap.size() <= 0 || srcObjCols == null || srcObjCols.size() <= 0) {
            return;
        }
        List providerList = botTransform.getFunctionProviderList();
        IObjectValue obj = srcObjCols.getObject(0);
        BOSObjectType bosType = obj.getBOSType();
        if (providerList == null || providerList.size() <= 0) {
            logger.error((Object)("providerLis=" + providerList), new Throwable());
            return;
        }
        block0: for (BotpScriptFuncDeclare func : funcMap.values()) {
            IBotpBatchFormulaFunctions batchProvider = null;
            String funcName = func.getFuncName();
            Map paramsMap = func.getParamsMap();
            for (int i = 0; i < providerList.size(); ++i) {
                IFunctionProvider funcProvider = (IFunctionProvider)providerList.get(i);
                if (funcProvider == null || !funcProvider.existFunction(funcName) || !(funcProvider instanceof IBotpBatchFormulaFunctions) || !(batchProvider = (IBotpBatchFormulaFunctions)funcProvider).isBatchFucntion(funcName)) continue;
                BOTPTools.preEvalBatchFunciton(ctx, batchProvider, srcObjCols, funcName, paramsMap, srcEntity);
                continue block0;
            }
        }
    }

    private static boolean isAllConstExpr(List paramExprList) throws BOSException {
        boolean bIsConst = true;
        for (int i = 0; i < paramExprList.size(); ++i) {
            CodeExpr expr = (CodeExpr)paramExprList.get(i);
            if (expr instanceof IdentifierExpr) {
                bIsConst = false;
                continue;
            }
            if (expr instanceof MethodInvokeExpr) {
                bIsConst = false;
                continue;
            }
            if (expr instanceof BigDecimalExpr || expr instanceof StringExpr || expr instanceof IntExpr || expr instanceof FloatExpr || expr instanceof BoolExpr || expr instanceof DoubleExpr || expr instanceof LongExpr || expr instanceof NullExpr) continue;
            bIsConst = false;
        }
        return bIsConst;
    }

    private static Object getParamValue(Context ctx, Object srcObj, String pramExpr) throws BOSException {
        HashMap<String, Object> localCtx = new HashMap<String, Object>();
        localCtx.put("__src", srcObj);
        Interpreter interpreter = new Interpreter(ctx);
        localCtx.put("__bosContext", ctx);
        interpreter.setProperyExprOwnerNullIgore(true);
        interpreter.setForBot(true);
        interpreter.setDefaultObject(srcObj);
        String expr = pramExpr.toString();
        if (expr == null || expr.length() == 0) {
            return null;
        }
        Object paramVal = interpreter.eval(expr, localCtx);
        return paramVal;
    }

    static void preEvalBatchFunciton(Context ctx, IBotpBatchFormulaFunctions batchProvider, IObjectCollection srcObjCols, String funcName, Map paramsMap, EntityObjectInfo srcEntity) throws BOSException {
        if (batchProvider == null) {
            return;
        }
        ArrayList paramListColl = new ArrayList();
        HashMap<String, String> existMap = new HashMap<String, String>();
        for (List paramExprList : paramsMap.values()) {
            boolean bIsConst = BOTPTools.isAllConstExpr(paramExprList);
            if (bIsConst) {
                Object srcObj = null;
                ArrayList<Object> paramList = new ArrayList<Object>(paramExprList.size());
                paramList.add(ctx);
                for (int j = 0; j < paramExprList.size(); ++j) {
                    CodeExpr pramExpr = (CodeExpr)paramExprList.get(j);
                    Object param = BOTPTools.getParamValue(ctx, srcObj, pramExpr.toString());
                    paramList.add(param);
                }
                StringBuffer sb = new StringBuffer();
                int size = paramList.size();
                for (int k = 0; k < size; ++k) {
                    if (paramList.get(k) instanceof Context) {
                        sb.append(((Context)paramList.get(k)).getContextID());
                        continue;
                    }
                    sb.append(paramList.get(k));
                }
                String key = sb.toString();
                if (existMap.containsKey(key)) continue;
                existMap.put(key, key);
                paramListColl.add(paramList);
                continue;
            }
            BotpScriptUtils utils = new BotpScriptUtils();
            ArrayList<String> exprList = new ArrayList<String>(paramExprList.size());
            for (int j = 0; j < paramExprList.size(); ++j) {
                CodeExpr paramExpr = (CodeExpr)paramExprList.get(j);
                if (paramExpr instanceof StringExpr) {
                    exprList.add(((StringExpr)paramExpr).getJavaString());
                    continue;
                }
                exprList.add(paramExpr.toString());
            }
            List valListColl = utils.getPropertyValueByScript(srcObjCols, srcEntity, exprList);
            logger.debug((Object)valListColl);
            StringBuffer sb = new StringBuffer("");
            for (int j = 0; j < valListColl.size(); ++j) {
                List valList = (List)valListColl.get(j);
                ArrayList<Context> paramList = new ArrayList<Context>(paramExprList.size());
                paramList.add(ctx);
                paramList.addAll(valList);
                sb.setLength(0);
                int size = paramList.size();
                for (int k = 0; k < size; ++k) {
                    if (paramList.get(k) instanceof IObjectValue) {
                        sb.append(((IObjectValue)paramList.get(k)).get("id").toString());
                        continue;
                    }
                    if (paramList.get(k) instanceof IObjectCollection) {
                        Iterator it = ((IObjectCollection)paramList.get(k)).iterator();
                        while (it.hasNext()) {
                            sb.append(((IObjectValue)it.next()).get("id").toString());
                        }
                        continue;
                    }
                    if (paramList.get(k) instanceof Context) {
                        sb.append(((Context)paramList.get(k)).getContextID());
                        continue;
                    }
                    sb.append(paramList.get(k));
                }
                String key = sb.toString();
                if (existMap.containsKey(key)) continue;
                existMap.put(key, key);
                paramListColl.add(paramList);
            }
        }
        BotpBatchFuncResultCollection resultColl = null;
        if (paramListColl.size() > 0) {
            resultColl = batchProvider.batchEvalFunction(ctx, funcName, paramListColl);
        }
        if (resultColl == null || resultColl.size() <= 0) {
            return;
        }
        int size = resultColl.size();
        for (int i = 0; i < size; ++i) {
            resultColl.get(i).setFuncName(funcName);
            resultColl.get(i).setFuncProvider((IFunctionProvider)batchProvider);
        }
        BotpBatchFuncHandler.cacheBatchResult(resultColl);
    }

    static void preCacheThirdPartObj(Context ctx, IObjectCollection srcObjCols, Map thirdBizObjPropertyMap) throws KScriptException, DataAccessException {
        if (thirdBizObjPropertyMap == null || thirdBizObjPropertyMap.size() <= 0) {
            return;
        }
        try {
            HashMap<BOSObjectType, HashMap<String, String>> typeIDMap = new HashMap<BOSObjectType, HashMap<String, String>>();
            HashMap typeSelectorMap = new HashMap();
            Interpreter interpreter = new Interpreter();
            for (String propName : thirdBizObjPropertyMap.keySet()) {
                Map valuesMap = (Map)thirdBizObjPropertyMap.get(propName);
                propName = propName.substring(0, propName.indexOf("&"));
                if (valuesMap == null || valuesMap.size() <= 0) continue;
                int idx = propName.lastIndexOf(".");
                String ownName = propName.substring(0, idx);
                String idName = propName.substring(idx + 1, propName.length());
                BOSObjectType bosType = null;
                for (int j = 0; j < srcObjCols.size(); ++j) {
                    HashMap<String, IObjectValue> tempCtx = new HashMap<String, IObjectValue>();
                    IObjectValue srcObj = srcObjCols.getObject(j);
                    tempCtx.put("__src", srcObj);
                    Object obj = interpreter.eval(ownName, tempCtx);
                    if (obj instanceof IObjectValue) {
                        String id = BOTPTools.readIdFromBizObj((IObjectValue)obj, idName);
                        if (StringUtils.isEmpty((String)id)) continue;
                        bosType = BOSUuid.read((String)id).getType();
                        HashMap selectorMap = (HashMap)typeSelectorMap.get(bosType);
                        if (selectorMap == null) {
                            selectorMap = new HashMap();
                            typeSelectorMap.put(bosType, selectorMap);
                        }
                        selectorMap.putAll(valuesMap);
                        HashMap<String, String> tmpIDmap = (HashMap<String, String>)typeIDMap.get(bosType);
                        if (tmpIDmap == null) {
                            tmpIDmap = new HashMap<String, String>();
                            typeIDMap.put(bosType, tmpIDmap);
                        }
                        tmpIDmap.put(id, id);
                        continue;
                    }
                    if (!(obj instanceof IObjectCollection)) continue;
                    IObjectCollection coll = (IObjectCollection)obj;
                    for (int k = 0; k < coll.size(); ++k) {
                        String id = BOTPTools.readIdFromBizObj(coll.getObject(k), idName);
                        if (StringUtils.isEmpty((String)id)) continue;
                        bosType = BOSUuid.read((String)id).getType();
                        HashMap selectorMap = (HashMap)typeSelectorMap.get(bosType);
                        if (selectorMap == null) {
                            selectorMap = new HashMap();
                            typeSelectorMap.put(bosType, selectorMap);
                        }
                        selectorMap.putAll(valuesMap);
                        HashMap<String, String> tmpIDmap = (HashMap<String, String>)typeIDMap.get(bosType);
                        if (tmpIDmap == null) {
                            tmpIDmap = new HashMap<String, String>();
                            typeIDMap.put(bosType, tmpIDmap);
                        }
                        tmpIDmap.put(id, id);
                    }
                }
            }
            for (BOSObjectType bosType : typeSelectorMap.keySet()) {
                ArrayList<String> srcIdList = new ArrayList<String>();
                SelectorItemCollection selectors = new SelectorItemCollection();
                Map currSelectorsMap = (Map)typeSelectorMap.get(bosType);
                for (String selectorName : currSelectorsMap.keySet()) {
                    selectors.add(new SelectorItemInfo(selectorName));
                }
                Map currIdMap = (Map)typeIDMap.get(bosType);
                for (String currID : currIdMap.keySet()) {
                    srcIdList.add(currID);
                }
                BOTPTools.preCacheThirdPartObjStep(ctx, bosType, srcIdList, selectors);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Execute preCacheThirdPartObj faild! " + e.getMessage()), (Throwable)e);
        }
    }

    private static String readIdFromBizObj(IObjectValue obj, String idName) {
        if (obj == null || StringUtils.isEmpty((String)idName)) {
            return null;
        }
        Object val = obj.get(idName);
        if (val instanceof String) {
            return (String)val;
        }
        if (val instanceof IObjectValue) {
            return (String)((IObjectValue)val).get("id");
        }
        if (val instanceof IObjectPK) {
            return ((IObjectPK)val).toString();
        }
        if (val instanceof BOSUuid) {
            return ((BOSUuid)val).toString();
        }
        return null;
    }

    private static void preCacheThirdPartObjStep(Context ctx, BOSObjectType bosType, List srcIdList, SelectorItemCollection selectors) throws KScriptException, DataAccessException {
        int step = 800;
        int totalNum = 0;
        if (srcIdList != null && srcIdList.size() > 0) {
            totalNum = srcIdList.size();
            if (totalNum <= step) {
                BOTObjectCache.getInstance(ctx).prepareObjectByID(bosType, srcIdList, selectors);
            } else {
                int max = totalNum % step == 0 ? totalNum / step : totalNum / step + 1;
                for (int i = 1; i <= max; ++i) {
                    ArrayList newIdList = new ArrayList();
                    int start = (i - 1) * step;
                    int end = i == max ? totalNum : i * step;
                    for (int j = start; j < end; ++j) {
                        newIdList.add(srcIdList.get(j));
                    }
                    BOTObjectCache.getInstance(ctx).prepareObjectByID(bosType, newIdList, selectors);
                }
            }
        }
    }

    public static boolean isSQLDAPHGUIClassIsInstalled() {
        if (SQLDAP_HGUI_INSTALLED == null) {
            SQLDAP_HGUI_INSTALLED = new Boolean(false);
            String className = "com.kingdee.eas.base.dap.client.ExtHGRuleSegDefUI";
            try {
                Class.forName(className);
                SQLDAP_HGUI_INSTALLED = new Boolean(true);
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return SQLDAP_HGUI_INSTALLED;
    }

    public static boolean isEnableSQLEngine(Context ctx) {
        try {
            String value = ParamManager.getParamValue((Context)ctx, null, (String)BOTP_ENABLE_SQLENGINE);
            if ("TRUE".equalsIgnoreCase(value)) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static boolean isAllEntriesSelected(Context ctx) {
        try {
            String value = ParamManager.getParamValue((Context)ctx, null, (String)BOTP_ALLENTRIES_SELECTED);
            if ("TRUE".equalsIgnoreCase(value)) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static boolean isCtrlUintAuthor(Context ctx) {
        try {
            String value = ParamManager.getParamValue((Context)ctx, null, (String)BOTP_CTRLUNIT_AUTHOR);
            if ("TRUE".equalsIgnoreCase(value)) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static boolean isEnableDBLock(Context ctx) {
        try {
            String value = ParamManager.getParamValue((Context)ctx, null, (String)BOTP_ENABLE_DBLOCK);
            if ("TRUE".equalsIgnoreCase(value)) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static boolean isEnableDAPCrossSystem(Context ctx) {
        try {
            String value = ParamManager.getParamValue((Context)ctx, null, (String)DAP_ENABLE_CrossSystem);
            if ("TRUE".equalsIgnoreCase(value)) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static boolean isExistCrossSysRelation(Context ctx, BOTRelationCollection botRelationCollection) throws BOSException, EASBizException {
        int batchSize = 1000;
        Object params = null;
        Object rs = null;
        if (botRelationCollection.size() == 0) {
            return false;
        }
        if (botRelationCollection.size() <= batchSize) {
            return BOTPTools.isExistCrossSysRelation2(ctx, botRelationCollection);
        }
        BOTRelationCollection tempCol = new BOTRelationCollection();
        int count = 0;
        for (int i = 0; i < botRelationCollection.size(); ++i) {
            tempCol.add(botRelationCollection.get(i));
            if (++count < batchSize) continue;
            count = 0;
            if (BOTPTools.isExistCrossSysRelation2(ctx, tempCol)) {
                return true;
            }
            tempCol = new BOTRelationCollection();
        }
        if (tempCol.size() > 0) {
            return BOTPTools.isExistCrossSysRelation2(ctx, tempCol);
        }
        return false;
    }

    private static boolean isExistCrossSysRelation2(Context ctx, BOTRelationCollection botRelationCollection) throws BOSException {
        ArrayList<String> params = new ArrayList<String>();
        IRowSet rs = null;
        StringBuffer sqlBuffer = new StringBuffer("SELECT FID FROM T_BOT_RELATION4CrossSys where FID in (");
        for (int i = 0; i < botRelationCollection.size(); ++i) {
            BOTRelationInfo relation = botRelationCollection.get(i);
            sqlBuffer.append("?");
            if (i < botRelationCollection.size() - 1) {
                sqlBuffer.append(",");
            }
            params.add(relation.getId().toString());
        }
        sqlBuffer.append(")");
        rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString(), (Object[])params.toArray());
        return rs.size() > 0;
    }

    public static boolean isExistCrossSysRelation(Context ctx, String billIds) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)billIds)) {
            return false;
        }
        String[] billIdsArray = billIds.split(",");
        ArrayList<String> params = new ArrayList<String>();
        StringBuffer sqlBuffer1 = new StringBuffer("SELECT FID FROM T_BOT_RELATION4CrossSys where FDESTOBJECTID in (");
        StringBuffer sqlBuffer2 = new StringBuffer("SELECT FID FROM T_BOT_RELATION4CrossSys where FSRCOBJECTID in (");
        for (int i = 0; i < billIdsArray.length; ++i) {
            String billId = billIdsArray[i];
            sqlBuffer1.append("?");
            sqlBuffer2.append("?");
            if (i < billIdsArray.length - 1) {
                sqlBuffer1.append(",");
                sqlBuffer2.append(",");
            }
            params.add(billId);
        }
        sqlBuffer1.append(")");
        sqlBuffer2.append(")");
        IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer1.toString(), (Object[])params.toArray());
        if (rs1.size() > 0) {
            return true;
        }
        IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer2.toString(), (Object[])params.toArray());
        return rs2.size() > 0;
    }

    public static void deleteRelation4CrossSystem(Context ctx, BOTRelationCollection botRelationCollection) throws BOSException, EASBizException {
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            Iterator iter = botRelationCollection.iterator();
            int tmpRelationSize = 0;
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            String sql = "delete from T_BOT_RELATION4CrossSys where FID = ?";
            while (iter.hasNext()) {
                BOTRelationInfo dapRelationInfo = (BOTRelationInfo)iter.next();
                Object[] params = new Object[]{dapRelationInfo.getId().toString()};
                paramList.add(params);
                tmpRelationSize = paramList.size();
                if (tmpRelationSize <= 2000) continue;
                DbUtil.executeBatch((Context)ctx, (String)sql, paramList);
                paramList.clear();
                tmpRelationSize = 0;
            }
            if (tmpRelationSize != 0) {
                DbUtil.executeBatch((Context)ctx, (String)sql, paramList);
                paramList.clear();
            }
        }
        catch (Exception e) {
            throw new BOSException("\u5220\u9664\u8de8\u7cfb\u7edf\u989d\u5916\u5173\u7cfb\u5931\u8d25", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    public static Map getParamFromBOTPConfig(Context ctx) throws BOSException {
        Map botpConfig = BTPManagerFactory.getLocalInstance(ctx).getBotpConfig();
        Object dcNameObject = botpConfig.get("DAPDcName");
        Object dcNameObject2 = botpConfig.get("DAPDcName2");
        Object languageObject = botpConfig.get("DAPLanguage");
        Object serverUrlObject = botpConfig.get("DAPServerUrl");
        Object port = botpConfig.get("port");
        Object serverUrl2Object = botpConfig.get("DAPServerUrl2");
        Object port2 = botpConfig.get("port2");
        Object accessObject = botpConfig.get("DAPAccess");
        if (BOTPTools.isEnableDAPCrossSystem(ctx) && (dcNameObject == null || dcNameObject2 == null || languageObject == null || serverUrlObject == null || port == null || serverUrl2Object == null || port2 == null || accessObject == null)) {
            throw new BOSException("\u8de8\u7cfb\u7edf\u914d\u7f6e\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        if (BOTPTools.isEnableDAPCrossSystem(ctx)) {
            botpConfig.put("dcName", botpConfig.get("DAPDcName").toString());
            botpConfig.put("dcName2", botpConfig.get("DAPDcName2").toString());
            botpConfig.put("language", botpConfig.get("DAPLanguage").toString());
            botpConfig.put("serverUrl", botpConfig.get("DAPServerUrl").toString());
            botpConfig.put("port", botpConfig.get("port").toString());
            botpConfig.put("serverUrl2", botpConfig.get("DAPServerUrl2").toString());
            botpConfig.put("port2", botpConfig.get("port2").toString());
            String access = "";
            try {
                access = URLEncoder.encode((String)botpConfig.get("DAPAccess"), "utf-8");
                botpConfig.put("access", access);
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return botpConfig;
    }

    public static String invokeMethod4CrossSys(Context ctx, String api, String methodName, String taskId, List voucherIdList, boolean idNeedLog, boolean SERVER_CONSUMER, List invokeDatas, Map params) throws BOSException, BizException, LoginException, InvokeNetworkException {
        Map paramMap = BOTPTools.getParamFromBOTPConfig(ctx);
        LoginContext loginContext = new LoginContext(paramMap.get("DAPServerUrl").toString(), new Integer(paramMap.get("port").toString()).intValue(), ctx.getUserName(), LtpaTokenManager.generate((String)ctx.getUserName(), (String)LtpaTokenManager.getDefaultLtpaConfig()).toString(), paramMap.get("DAPDcName").toString(), paramMap.get("DAPLanguage").toString(), "BaseTrdLtpaToken");
        OpenApiInfo info = new OpenApiInfo();
        ArrayList data = new ArrayList();
        info.setApi(api);
        info.setMethod(methodName);
        info.setTaskId(taskId);
        info.setAccess(paramMap.get("DAPAccess").toString());
        for (int i = 0; i < invokeDatas.size(); ++i) {
            data.add(invokeDatas.get(i));
        }
        String jsonData = "";
        try {
            jsonData = JSONUtils.convertObjectToJson((Context)ctx, data);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException("json\u6570\u636e\u8f6c\u6362\u5f02\u5e38" + e.getMessage(), (Throwable)e);
        }
        info.setData(jsonData);
        Method method = null;
        if (idNeedLog) {
            try {
                Class<?> clz = Class.forName("com.kingdee.eas.base.dap.app.AbstractDAPTransformerControllerBean");
                method = clz.getDeclaredMethod("saveInvokeLog", Context.class, Map.class, List.class);
                if (method == null) {
                    idNeedLog = false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                idNeedLog = false;
            }
        }
        if (idNeedLog) {
            params = new HashMap<String, Object>();
            params.put("DAPServerUrl", paramMap.get("DAPServerUrl").toString());
            params.put("port", new Integer(paramMap.get("port").toString()));
            params.put("DAPUsername", ctx.getUserName());
            params.put("DAPDcName", paramMap.get("DAPDcName").toString());
            params.put("DAPLanguage", paramMap.get("DAPLanguage").toString());
            params.put("api", api);
            params.put("method", methodName);
            params.put("taskid", taskId);
            params.put("SERVER_CONSUMER", SERVER_CONSUMER ? "Caller" : "Server");
            String uuid = BOTPTools.saveInvokeLogByReflect(ctx, voucherIdList, params, method);
            params.put("uuid", uuid);
        }
        OpenApi openApi = OpenApiFactory.getService((AbstractLoginContext)loginContext);
        String result = "";
        try {
            result = openApi.invoke(info);
        }
        catch (BizException e1) {
            if (idNeedLog) {
                params.put("status", "BizException");
                BOTPTools.saveInvokeLogByReflect(ctx, voucherIdList, params, method);
            }
            throw e1;
        }
        catch (LoginException e1) {
            if (idNeedLog) {
                params.put("status", "LoginException");
                BOTPTools.saveInvokeLogByReflect(ctx, voucherIdList, params, method);
            }
            throw e1;
        }
        catch (InvokeNetworkException e1) {
            if (idNeedLog) {
                params.put("status", "InvokeNetworkException");
                BOTPTools.saveInvokeLogByReflect(ctx, voucherIdList, params, method);
            }
            throw e1;
        }
        catch (Exception e1) {
            if (idNeedLog) {
                params.put("status", "OtherException");
                BOTPTools.saveInvokeLogByReflect(ctx, voucherIdList, params, method);
            }
            throw new BOSException((Throwable)e1);
        }
        if (idNeedLog) {
            BOTPTools.saveInvokeLogByReflect(ctx, voucherIdList, params, method);
        }
        return result;
    }

    private static String saveInvokeLogByReflect(Context ctx, List voucherIdList, Map params, Method method) throws BOSException {
        String uuid;
        ObjectFactory.Bridge bridge = new ObjectFactory.Bridge();
        Class<?> clz = null;
        Method m = null;
        try {
            clz = Class.forName("com.kingdee.eas.base.dap.app.DAPTransformerControllerBean");
            m = ObjectFactory.Bridge.class.getMethod("invoke", Object.class, Method.class, Object[].class);
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        Object[] params2 = new Object[]{ctx, params, voucherIdList};
        EJBTransactionProxy proxy = EJBFactory.getEJBTransactionProxy((Object)bridge);
        try {
            uuid = (String)proxy.invoke(m, new Object[]{clz.newInstance(), method, params2}, 3);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new BOSException("\u8c03\u7528\u65e5\u5fd7\u5165\u5e93\u5931\u8d25");
        }
        return uuid;
    }

    public static EntityViewInfo getEntityViewInfoFromMapping(BOTMappingInfo mappingInfo, int filterType) throws BOSException {
        if (mappingInfo == null || filterType != 0 && filterType != 1 && filterType != 2) {
            throw new BOSException("error params in method BOTPTools.getEntityViewInfoFromMapping!");
        }
        EntityViewInfo entityViewInfo = null;
        try {
            String filterStr = null;
            switch (filterType) {
                case 0: {
                    filterStr = mappingInfo.getExtRule().getFilter();
                    break;
                }
                case 1: {
                    filterStr = mappingInfo.getExtRule().getDataFilter();
                    break;
                }
                case 2: {
                    filterStr = mappingInfo.getExtRule().getFilter4Pre();
                }
            }
            if (StringUtils.isEmpty(filterStr)) {
                return new EntityViewInfo();
            }
            if (!BOTPTools.isHasSpecialDateEnum(filterStr)) {
                return new EntityViewInfo(filterStr);
            }
            entityViewInfo = new EntityViewInfo(filterStr);
            FilterInfo headFilterInfo = BOTPTools.rebuildFilterInfo(entityViewInfo.getFilter());
            entityViewInfo.setFilter(headFilterInfo);
            FilterCollection entryFilterCol = entityViewInfo.getEntryFilters();
            for (int i = 0; i < entryFilterCol.size(); ++i) {
                FilterInfo entryFilter = entryFilterCol.get(i);
                entryFilter = BOTPTools.rebuildFilterInfo(entryFilter);
                entityViewInfo.getEntryFilters().set(i, entryFilter);
            }
        }
        catch (ParserException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return entityViewInfo;
    }

    private static boolean isHasSpecialDateEnum(String filterStr) {
        boolean result = false;
        String TODAY = "'today'";
        String BEFORETODAY = "'beforetoday'";
        String AFTERTODAY = "'aftertoday'";
        if (filterStr.contains(TODAY) || filterStr.contains(BEFORETODAY) || filterStr.contains(AFTERTODAY)) {
            result = true;
        }
        return result;
    }

    private static FilterInfo rebuildFilterInfo(FilterInfo filter) {
        String TODAY = "TODAY";
        String BEFORETODAY = "BEFORETODAY";
        String AFTERTODAY = "AFTERTODAY";
        String maskString = filter.getMaskString();
        FilterItemCollection filterItems = filter.getFilterItems();
        FilterInfo newFilterInfo = new FilterInfo();
        ArrayList<Integer> replaceItemsIndex = new ArrayList<Integer>();
        ArrayList<String> replaceItemsType = new ArrayList<String>();
        FilterItemInfo filterItemInfo = null;
        String condition = null;
        for (int i = 0; i < filterItems.size(); ++i) {
            String compareValue = null;
            filterItemInfo = filterItems.get(i);
            condition = filterItemInfo.getPropertyName();
            if (filterItemInfo.getCompareValue() != null) {
                compareValue = filterItemInfo.getCompareValue().toString();
            } else if (filterItemInfo.getCompareType() == CompareType.NOTEQUALS && filterItemInfo.getCompareValue() == null) {
                compareValue = null;
            }
            if (TODAY.equalsIgnoreCase(compareValue)) {
                newFilterInfo = QueryUtils.getTodayFilterInfo((FilterInfo)newFilterInfo, (String)condition);
                replaceItemsIndex.add(i);
                replaceItemsType.add(TODAY);
                continue;
            }
            if (BEFORETODAY.equalsIgnoreCase(compareValue)) {
                newFilterInfo = QueryUtils.getBeforetoDayFilterInfo((FilterInfo)newFilterInfo, (String)condition);
                replaceItemsIndex.add(i);
                replaceItemsType.add(BEFORETODAY);
                continue;
            }
            if (AFTERTODAY.equalsIgnoreCase(compareValue)) {
                newFilterInfo = QueryUtils.getAftertoDayFilterInfo((FilterInfo)newFilterInfo, (String)condition);
                replaceItemsIndex.add(i);
                replaceItemsType.add(AFTERTODAY);
                continue;
            }
            newFilterInfo.getFilterItems().add(filterItemInfo);
        }
        int index = 0;
        int changIndex = 0;
        Integer replaceIndex = null;
        String replaceType = null;
        if (replaceItemsIndex.size() > 0 && replaceItemsType.size() > 0) {
            while (maskString.contains("#" + index) && changIndex < replaceItemsIndex.size()) {
                replaceIndex = (Integer)replaceItemsIndex.get(changIndex);
                replaceType = (String)replaceItemsType.get(changIndex);
                if (index == replaceIndex) {
                    maskString = TODAY.equals(replaceType) ? maskString.replaceFirst("#" + index, "(#X AND #X)") : maskString.replace("#" + index, "#X");
                    ++changIndex;
                } else {
                    maskString = maskString.replace("#" + index, "#X");
                }
                ++index;
            }
            String[] maskStringArray = maskString.split("#");
            StringBuffer newMaskString = new StringBuffer(maskStringArray[0]);
            for (int i = 0; i < maskStringArray.length - 1; ++i) {
                newMaskString.append("#" + i + maskStringArray[i + 1].substring(1));
            }
            newFilterInfo.setMaskString(newMaskString.toString());
        } else {
            newFilterInfo.setMaskString(filter.getMaskString());
        }
        String entryName = filter.getEntryName();
        if (!StringUtils.isEmpty((String)entryName)) {
            newFilterInfo.setEntryName(entryName);
        }
        return newFilterInfo;
    }

    public static boolean isEnableBOTEngineNew2(Context ctx) {
        try {
            String value = ParamManager.getParamValue((Context)ctx, null, (String)BOTP_ENABLE_EngineNew2);
            if ("TRUE".equalsIgnoreCase(value)) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }
}

