/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.btp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.ext.FilterInfoProducerFactory;
import com.kingdee.bos.ctrl.extendcontrols.ext.OrgUnitFilterInfoProducer;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgSwitchFacade;
import com.kingdee.eas.basedata.org.NewOrgUnitFacadeFactory;
import com.kingdee.eas.basedata.org.OrgSwitchFacadeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.TransportOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.util.ObjectUtils;
import java.util.HashMap;
import java.util.Map;

public class BOTOrgUtils {
    public static final String strDataBase_Assistant = "com.kingdee.eas.basedata.assistant";
    public static final String strDataBase_Master = "com.kingdee.eas.basedata.master";
    public static final String CURRENT_COMPANY = "CurCompanyId";
    public static final String CURRENT_COMPANYINFO = "CompanyInfo";

    private BOTOrgUtils() {
    }

    public static IMetaDataLoader createMetaDataLoader() {
        return MetaDataLoaderFactory.getRemoteMetaDataLoader();
    }

    public static String getPropertyAlias(ObjectBaseInfo dataBaseInfo, String propertyName) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entity = null;
        entity = loader.getEntity(dataBaseInfo.getBOSType());
        PropertyInfo property = null;
        property = entity.getPropertyByName(propertyName);
        if (property == null) {
            return "";
        }
        return property.getAlias();
    }

    public static String getClassAlias(CoreBaseInfo dataBaseInfo) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entity = null;
        if (dataBaseInfo == null) {
            return "";
        }
        entity = loader.getEntity(dataBaseInfo.getBOSType());
        String name = entity.getAlias();
        if (name == null) {
            name = entity.getName();
        }
        return name;
    }

    public static String getEntityExtendProperty(ObjectBaseInfo info) {
        String extendProperty = null;
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        extendProperty = loader.getEntity(info.getBOSType()).getExtendedProperty("OrgType");
        return extendProperty;
    }

    public static String getCodeRuleClient(BillBaseInfo billInfo) throws CodingRuleException, EASBizException, BOSException {
        String companyID = billInfo.getCompany().getId().toString();
        return BOTOrgUtils.getCodeRuleClient((CoreBillBaseInfo)billInfo, companyID);
    }

    public static String getCodeRuleClient(CoreBillBaseInfo coreBillInfo, String companyID) throws CodingRuleException, EASBizException, BOSException {
        String sysNumber = null;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        if (iCodingRuleManager.isExist((IObjectValue)coreBillInfo, companyID) && iCodingRuleManager.isAddView((IObjectValue)coreBillInfo, companyID)) {
            sysNumber = iCodingRuleManager.getNumber((IObjectValue)coreBillInfo, companyID);
        }
        return sysNumber;
    }

    public static String getCodeRuleClient(CoreBaseInfo info, String companyID) throws CodingRuleException, EASBizException, BOSException {
        String sysNumber = null;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        if (iCodingRuleManager.isExist((IObjectValue)info, companyID) && iCodingRuleManager.isAddView((IObjectValue)info, companyID)) {
            sysNumber = iCodingRuleManager.getNumber((IObjectValue)info, companyID);
        }
        return sysNumber;
    }

    public static String getCodeRuleServer(Context ctx, CoreBaseInfo info, String companyID) throws CodingRuleException, EASBizException, BOSException {
        String sysNumber = null;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        RuleStatus rStatus = iCodingRuleManager.getRuleStatus((IObjectValue)info, companyID);
        if (rStatus != null && rStatus.isExist() && !rStatus.isAddView()) {
            sysNumber = iCodingRuleManager.getNumber((IObjectValue)info, companyID);
        }
        return sysNumber;
    }

    public static FilterInfo getF7FilterInfoByAuthorizedOrg(OrgType orgType, String orgFieldName) {
        return BOTOrgUtils.getF7FilterInfoByAuthorizedOrg(orgType, orgFieldName, false);
    }

    public static FilterInfo getF7FilterInfoByAuthorizedOrg(OrgType orgType, String orgFieldName, boolean includeNull) {
        OrgUnitFilterInfoProducer oufip = (OrgUnitFilterInfoProducer)FilterInfoProducerFactory.getOrgUnitFilterInfoProducer((OrgType)orgType);
        FilterInfo filterInfo = oufip.getFilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        int num = filterItems.size();
        for (int i = 0; i < num; ++i) {
            filterItems.get(i).setPropertyName(orgFieldName);
        }
        if (includeNull) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo(orgFieldName, null, CompareType.EQUALS));
            try {
                filter.mergeFilter(filterInfo, "OR");
            }
            catch (BOSException e) {
                return filterInfo;
            }
            return filter;
        }
        return filterInfo;
    }

    public static Context switchOrg(Context ctx, String orgID) throws Exception {
        Context newCtx = (Context)ObjectUtils.createCopy((Object)ctx);
        IOrgSwitchFacade iswitch = OrgSwitchFacadeFactory.getLocalInstance((Context)ctx);
        HashMap map = iswitch.getSwitchOrgs(orgID);
        FullOrgUnitInfo ouInfo = (FullOrgUnitInfo)map.get("CurOU");
        CtrlUnitInfo cuInfo = (CtrlUnitInfo)map.get(OrgType.ControlUnit);
        CompanyOrgUnitInfo fiInfo = (CompanyOrgUnitInfo)map.get(OrgType.Company);
        AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)map.get(OrgType.Admin);
        ProfitCenterOrgUnitInfo profitCenterInfo = (ProfitCenterOrgUnitInfo)map.get(OrgType.ProfitCenter);
        CostCenterOrgUnitInfo costCenterInfo = (CostCenterOrgUnitInfo)map.get(OrgType.CostCenter);
        SaleOrgUnitInfo saleOrgInfo = (SaleOrgUnitInfo)map.get(OrgType.Sale);
        StorageOrgUnitInfo storageOrgInfo = (StorageOrgUnitInfo)map.get(OrgType.Storage);
        PurchaseOrgUnitInfo purchaseOrgInfo = (PurchaseOrgUnitInfo)map.get(OrgType.Purchase);
        HROrgUnitInfo hroui = (HROrgUnitInfo)map.get(OrgType.HRO);
        TransportOrgUnitInfo tou = (TransportOrgUnitInfo)map.get(OrgType.Transport);
        QualityOrgUnitInfo qou = (QualityOrgUnitInfo)map.get(OrgType.Quality);
        BOTOrgUtils.setCurrentAdminUnit(newCtx, adminInfo);
        BOTOrgUtils.setCurrentCostUnit(newCtx, costCenterInfo);
        BOTOrgUtils.setCurrentCtrlUnit(newCtx, cuInfo);
        BOTOrgUtils.setCurrentFIUnit(newCtx, fiInfo);
        BOTOrgUtils.setCurrentProfitUnit(newCtx, profitCenterInfo);
        BOTOrgUtils.setCurrentPurchaseUnit(newCtx, purchaseOrgInfo);
        BOTOrgUtils.setCurrentSaleUnit(newCtx, saleOrgInfo);
        BOTOrgUtils.setCurrentStorageUnit(newCtx, storageOrgInfo);
        BOTOrgUtils.setCurrentOrgUnit(newCtx, (OrgUnitInfo)ouInfo);
        BOTOrgUtils.setCurrentHRUnit(newCtx, hroui);
        BOTOrgUtils.setCurrentTransportUnit(newCtx, tou);
        BOTOrgUtils.setCurrentQualityOrgUnitUnit(newCtx, qou);
        return newCtx;
    }

    public static void setCurrentTransportUnit(Context ctx, TransportOrgUnitInfo tou) {
        BOTOrgUtils.setCurrentOrgUnit(ctx, OrgType.Transport, (OrgUnitInfo)tou);
    }

    public static CtrlUnitInfo getCurrentCtrlUnit(Context ctx) {
        return (CtrlUnitInfo)BOTOrgUtils.getCurrentOrgUnit(ctx, OrgType.ControlUnit);
    }

    public static void setCurrentCtrlUnit(Context ctx, CtrlUnitInfo cu) {
        BOTOrgUtils.setCurrentOrgUnit(ctx, OrgType.ControlUnit, (OrgUnitInfo)cu);
    }

    public static CompanyOrgUnitInfo getCurrentFIUnit(Context ctx) {
        return (CompanyOrgUnitInfo)BOTOrgUtils.getCurrentOrgUnit(ctx, OrgType.Company);
    }

    public static void setCurrentFIUnit(Context ctx, CompanyOrgUnitInfo company) {
        BOTOrgUtils.setCurrentOrgUnit(ctx, OrgType.Company, (OrgUnitInfo)company);
    }

    public static AdminOrgUnitInfo getCurrentAdminUnit(Context ctx) {
        return (AdminOrgUnitInfo)BOTOrgUtils.getCurrentOrgUnit(ctx, OrgType.Admin);
    }

    public static void setCurrentAdminUnit(Context ctx, AdminOrgUnitInfo adminUnit) {
        BOTOrgUtils.setCurrentOrgUnit(ctx, OrgType.Admin, (OrgUnitInfo)adminUnit);
    }

    public static ProfitCenterOrgUnitInfo getCurrentProfitUnit(Context ctx) {
        return (ProfitCenterOrgUnitInfo)BOTOrgUtils.getCurrentOrgUnit(ctx, OrgType.ProfitCenter);
    }

    public static void setCurrentProfitUnit(Context ctx, ProfitCenterOrgUnitInfo profitCenter) {
        BOTOrgUtils.setCurrentOrgUnit(ctx, OrgType.ProfitCenter, (OrgUnitInfo)profitCenter);
    }

    public static CostCenterOrgUnitInfo getCurrentCostUnit(Context ctx) {
        return (CostCenterOrgUnitInfo)BOTOrgUtils.getCurrentOrgUnit(ctx, OrgType.CostCenter);
    }

    public static void setCurrentCostUnit(Context ctx, CostCenterOrgUnitInfo costCenter) {
        BOTOrgUtils.setCurrentOrgUnit(ctx, OrgType.CostCenter, (OrgUnitInfo)costCenter);
    }

    public static SaleOrgUnitInfo getCurrentSaleUnit(Context ctx) {
        return (SaleOrgUnitInfo)BOTOrgUtils.getCurrentOrgUnit(ctx, OrgType.Sale);
    }

    public static void setCurrentSaleUnit(Context ctx, SaleOrgUnitInfo saleUnit) {
        BOTOrgUtils.setCurrentOrgUnit(ctx, OrgType.Sale, (OrgUnitInfo)saleUnit);
    }

    public static QualityOrgUnitInfo getCurrentQualityUnit(Context ctx) {
        return (QualityOrgUnitInfo)BOTOrgUtils.getCurrentOrgUnit(ctx, OrgType.Quality);
    }

    public static void setCurrentQualityOrgUnitUnit(Context ctx, QualityOrgUnitInfo qualityUnit) {
        BOTOrgUtils.setCurrentOrgUnit(ctx, OrgType.Quality, (OrgUnitInfo)qualityUnit);
    }

    public static StorageOrgUnitInfo getCurrentStorageUnit(Context ctx) {
        return (StorageOrgUnitInfo)BOTOrgUtils.getCurrentOrgUnit(ctx, OrgType.Storage);
    }

    public static void setCurrentStorageUnit(Context ctx, StorageOrgUnitInfo storageUnit) {
        BOTOrgUtils.setCurrentOrgUnit(ctx, OrgType.Storage, (OrgUnitInfo)storageUnit);
    }

    public static PurchaseOrgUnitInfo getCurrentPurchaseUnit(Context ctx) {
        return (PurchaseOrgUnitInfo)BOTOrgUtils.getCurrentOrgUnit(ctx, OrgType.Purchase);
    }

    public static void setCurrentPurchaseUnit(Context ctx, PurchaseOrgUnitInfo purchaseUnit) {
        BOTOrgUtils.setCurrentOrgUnit(ctx, OrgType.Purchase, (OrgUnitInfo)purchaseUnit);
    }

    public static OrgUnitInfo getCurrentOrgUnit(Context ctx, OrgType orgType) {
        return (OrgUnitInfo)ctx.get((Object)orgType);
    }

    public static void setCurrentOrgUnit(Context ctx, OrgType orgType, OrgUnitInfo orgUnit) {
        ctx.put((Object)orgType, (Object)orgUnit);
        if (orgType.equals((Object)OrgType.Company)) {
            ctx.put((Object)CURRENT_COMPANYINFO, (Object)orgUnit);
            if (orgUnit != null && orgUnit.getId() != null) {
                ctx.put((Object)CURRENT_COMPANY, (Object)orgUnit.getId().toString());
            }
        }
    }

    public static OrgUnitInfo getCurrentOrgUnit(Context ctx) {
        return (OrgUnitInfo)ctx.get((Object)"CurOU");
    }

    public static void setCurrentOrgUnit(Context ctx, OrgUnitInfo orgUnit) {
        ctx.put((Object)"CurOU", (Object)orgUnit);
    }

    public static HROrgUnitInfo getCurrentHRUnit(Context ctx) {
        return (HROrgUnitInfo)BOTOrgUtils.getCurrentOrgUnit(ctx, OrgType.HRO);
    }

    public static void setCurrentHRUnit(Context ctx, HROrgUnitInfo hroInfo) {
        BOTOrgUtils.setCurrentOrgUnit(ctx, OrgType.HRO, (OrgUnitInfo)hroInfo);
    }

    public static void checkIsOUSealUp(Context ctx, BOSObjectType type, Context mainOrgContext) throws Exception {
        int orgTypeValue = 0;
        String ouID = null;
        OrgUnitInfo org = null;
        if (ctx == null) {
            orgTypeValue = BOTOrgUtils.getOrgTypeExtendedPropertyies(ctx, type);
            if (orgTypeValue < 0) {
                return;
            }
            org = BOTOrgUtils.getCurrentOrgUnit(mainOrgContext, OrgType.getEnum((int)orgTypeValue));
            String string = ouID = org != null ? org.getId().toString() : null;
            if (ouID == null) {
                throw new FrameWorkException(FrameWorkException.ORGNOTEQUAL);
            }
            NewOrgUnitFacadeFactory.getRemoteInstance().checkIsOUSealUp(ouID, orgTypeValue);
        } else {
            orgTypeValue = BOTOrgUtils.getOrgTypeExtendedPropertyies(ctx, type);
            if (orgTypeValue < 0) {
                return;
            }
            org = BOTOrgUtils.getCurrentOrgUnit(ctx, OrgType.getEnum((int)orgTypeValue));
            String string = ouID = org != null ? org.getId().toString() : null;
            if (ouID == null) {
                throw new FrameWorkException(FrameWorkException.ORGNOTEQUAL);
            }
            NewOrgUnitFacadeFactory.getLocalInstance((Context)ctx).checkIsOUSealUp(ouID, orgTypeValue);
        }
    }

    public static void checkIsOUSealUp(Context ctx, BOSObjectType type, SysContext sysContext) throws Exception {
        int orgTypeValue = 0;
        String ouID = null;
        OrgUnitInfo org = null;
        if (ctx == null) {
            orgTypeValue = BOTOrgUtils.getOrgTypeExtendedPropertyies(ctx, type);
            if (orgTypeValue < 0) {
                return;
            }
            org = sysContext.getCurrentOrgUnit(OrgType.getEnum((int)orgTypeValue));
            String string = ouID = org != null ? org.getId().toString() : null;
            if (ouID == null) {
                throw new FrameWorkException(FrameWorkException.ORGNOTEQUAL);
            }
            NewOrgUnitFacadeFactory.getRemoteInstance().checkIsOUSealUp(ouID, orgTypeValue);
        } else {
            orgTypeValue = BOTOrgUtils.getOrgTypeExtendedPropertyies(ctx, type);
            if (orgTypeValue < 0) {
                return;
            }
            org = BOTOrgUtils.getCurrentOrgUnit(ctx, OrgType.getEnum((int)orgTypeValue));
            String string = ouID = org != null ? org.getId().toString() : null;
            if (ouID == null) {
                throw new FrameWorkException(FrameWorkException.ORGNOTEQUAL);
            }
            NewOrgUnitFacadeFactory.getLocalInstance((Context)ctx).checkIsOUSealUp(ouID, orgTypeValue);
        }
    }

    public static EntityObjectInfo getEntity(Context ctx, BOSObjectType type) throws Exception {
        IMetaDataLoader loader = null;
        EntityObjectInfo entity = null;
        loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        entity = loader.getEntity(type);
        return entity;
    }

    public static int getOrgTypeExtendedPropertyies(Context ctx, BOSObjectType type) throws Exception {
        int orgTypeValue = 0;
        EntityObjectInfo entity = null;
        entity = BOTOrgUtils.getEntity(ctx, type);
        String orgType = (String)entity.getExtendedProperties().get("OrgType");
        if (orgType != null) {
            if (OrgType.Admin.getName().equalsIgnoreCase(orgType)) {
                orgType = OrgType.Admin.getName();
            } else if (OrgType.Company.getName().equalsIgnoreCase(orgType)) {
                orgType = OrgType.Company.getName();
            } else if (OrgType.Sale.getName().equalsIgnoreCase(orgType)) {
                orgType = OrgType.Sale.getName();
            } else if (OrgType.Purchase.getName().equalsIgnoreCase(orgType)) {
                orgType = OrgType.Purchase.getName();
            } else if (OrgType.Storage.getName().equalsIgnoreCase(orgType)) {
                orgType = OrgType.Storage.getName();
            } else if (OrgType.CostCenter.getName().equalsIgnoreCase(orgType)) {
                orgType = OrgType.CostCenter.getName();
            } else if (OrgType.ProfitCenter.getName().equalsIgnoreCase(orgType)) {
                orgType = OrgType.ProfitCenter.getName();
            } else if (OrgType.UnionDebt.getName().equalsIgnoreCase(orgType)) {
                orgType = OrgType.UnionDebt.getName();
            } else if (OrgType.ControlUnit.getName().equalsIgnoreCase(orgType)) {
                orgType = OrgType.ControlUnit.getName();
            } else if (OrgType.HRO.getName().equalsIgnoreCase(orgType)) {
                orgType = OrgType.HRO.getName();
            } else if (OrgType.Transport.getName().equalsIgnoreCase(orgType)) {
                orgType = OrgType.Transport.getName();
            } else if (OrgType.Quality.getName().equalsIgnoreCase(orgType)) {
                orgType = OrgType.Quality.getName();
            }
        } else {
            orgType = "NONE";
        }
        OrgType orgT = OrgType.getEnum((String)orgType);
        orgTypeValue = orgT.getValue();
        return orgTypeValue;
    }

    public static String getOrgTypePropertyies(Context ctx, BOSObjectType type) throws Exception {
        EntityObjectInfo entity = null;
        entity = BOTOrgUtils.getEntity(ctx, type);
        String orgType = (String)entity.getExtendedProperties().get("OrgType");
        if (orgType != null) {
            if (OrgType.Admin.getName().equalsIgnoreCase(orgType)) {
                orgType = OrgType.Admin.getName();
            } else if (OrgType.Company.getName().equalsIgnoreCase(orgType)) {
                orgType = OrgType.Company.getName();
            } else if (OrgType.Sale.getName().equalsIgnoreCase(orgType)) {
                orgType = OrgType.Sale.getName();
            } else if (OrgType.Purchase.getName().equalsIgnoreCase(orgType)) {
                orgType = OrgType.Purchase.getName();
            } else if (OrgType.Storage.getName().equalsIgnoreCase(orgType)) {
                orgType = OrgType.Storage.getName();
            } else if (OrgType.CostCenter.getName().equalsIgnoreCase(orgType)) {
                orgType = OrgType.CostCenter.getName();
            } else if (OrgType.ProfitCenter.getName().equalsIgnoreCase(orgType)) {
                orgType = OrgType.ProfitCenter.getName();
            } else if (OrgType.UnionDebt.getName().equalsIgnoreCase(orgType)) {
                orgType = OrgType.UnionDebt.getName();
            } else if (OrgType.ControlUnit.getName().equalsIgnoreCase(orgType)) {
                orgType = OrgType.ControlUnit.getName();
            } else if (OrgType.HRO.getName().equalsIgnoreCase(orgType)) {
                orgType = OrgType.HRO.getName();
            } else if (OrgType.Transport.getName().equalsIgnoreCase(orgType)) {
                orgType = OrgType.Transport.getName();
            } else if (OrgType.Quality.getName().equalsIgnoreCase(orgType)) {
                orgType = OrgType.Quality.getName();
            }
        } else {
            orgType = "NONE";
        }
        return orgType;
    }

    public static String getOrgPropertyNameByCoreBillBaseInfo(CoreBillBaseInfo vo) {
        String orgPropertyName = null;
        if (vo != null) {
            orgPropertyName = vo.getBizOrgPropertyName();
        }
        return orgPropertyName;
    }

    public static IObjectPK getOrgPKByCoreBillBaseInfo(CoreBillBaseInfo vo, String orgPropertyName) {
        CoreBillBaseInfo abstractObjectValue;
        if (vo != null && orgPropertyName != null && orgPropertyName.length() != 0 && (abstractObjectValue = vo).containsKey(orgPropertyName)) {
            Object orgValue = abstractObjectValue.get(orgPropertyName);
            if (orgValue == null) {
                return null;
            }
            OrgUnitInfo orgUnitInfo = (OrgUnitInfo)orgValue;
            if (orgUnitInfo.getId() == null) {
                return null;
            }
            return new ObjectUuidPK(orgUnitInfo.getId());
        }
        return null;
    }

    public static Context switchOrgIfNeed(Context ctx, CoreBillBaseInfo destBillInfo, String orgPropertyName, Map contextMap) throws BOSException {
        Context bosctx = ctx;
        IObjectPK pk = null;
        try {
            if (orgPropertyName != null) {
                pk = BOTOrgUtils.getOrgPKByCoreBillBaseInfo(destBillInfo, orgPropertyName);
            }
            if (pk != null) {
                Object existContext = contextMap.get(pk.toString());
                if (existContext != null) {
                    bosctx = (Context)existContext;
                } else {
                    bosctx = BOTOrgUtils.switchOrg(ctx, pk.toString());
                    contextMap.put(pk.toString(), bosctx);
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return bosctx;
    }
}

