/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.common;

import com.kingdee.bos.sql.DbType;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.db.SQLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.List;
import javax.sql.RowSet;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class DCManager {
    private static DCManager instance = new DCManager();
    private ArrayList dcList;
    private String driverName = "com.kingdee.bos.sql.shell.Driver";
    private long dcxmlLastModify = 0L;

    private DCManager() {
    }

    public void reloadDCList() throws Exception {
        File dccFile;
        String dcc = System.getProperty("datacenter.config");
        if (dcc != null && (dccFile = new File(dcc)).exists()) {
            this.dcxmlLastModify = dccFile.lastModified();
            this.dcList = this.getDataCentersFromXml(dccFile);
            return;
        }
        this.dcList = new ArrayList();
        Connection conn = null;
        Configuration cfg = Configuration.getInstance();
        ConfigurationItem dmcItem = cfg.getConfigItem("DMC");
        String url = dmcItem.getProperty("url");
        url = KSqlUtil.decodeUrl((String)url);
        String userName = dmcItem.getProperty("UserName");
        String password = dmcItem.getProperty("Password");
        password = KSqlUtil.decodePassword((String)password);
        try {
            Driver driver = (Driver)Class.forName(this.driverName).newInstance();
            DriverManager.registerDriver(driver);
            conn = DriverManager.getConnection(url, userName, password);
            String sql = "select * from T_DMC_Datacenter where FLocked=1";
            RowSet rs = SQLUtils.getJdbcRowSet((Connection)conn, (String)sql);
            while (rs.next()) {
                DCInfo info = new DCInfo();
                info.setNumber(rs.getString("FNumber"));
                info.tb.put("L1", rs.getString("FName_L1") == null ? "" : rs.getString("FName_L1"));
                info.tb.put("L2", rs.getString("FName_L2") == null ? "" : rs.getString("FName_L2"));
                info.tb.put("L3", rs.getString("FName_L3") == null ? "" : rs.getString("FName_L3"));
                info.setSolutionName(rs.getString("FSolutionName"));
                info.setDataSource(rs.getString("FDataSource"));
                info.setDBName(rs.getString("FDBName"));
                info.setDBType(Integer.parseInt(rs.getString("FDBType")));
                info.setUserName(rs.getString("FDBAdminUser"));
                info.setPassword(rs.getString("FDBAdminPassword"));
                info.setPassword(KSqlUtil.decodePassword((String)info.getPassword()));
                String version = "";
                version = rs.getString("FVersion");
                info.setVersion(version);
                this.dcList.add(info);
            }
        }
        catch (Exception err) {
            throw err;
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static DCManager getInstance() {
        return instance;
    }

    public synchronized ArrayList getDCList() throws Exception {
        if (this.dcList == null || this.dcList.size() == 0 || this.needReload()) {
            this.reloadDCList();
        }
        return this.dcList;
    }

    private boolean needReload() {
        File dccFile;
        String dcc = System.getProperty("datacenter.config");
        if (dcc != null && (dccFile = new File(dcc)).exists()) {
            return this.dcxmlLastModify < dccFile.lastModified();
        }
        return false;
    }

    public ArrayList getDataCentersFromXml(File dccFile) throws Exception {
        ArrayList<DCInfo> dcList = new ArrayList<DCInfo>();
        SAXBuilder builder = new SAXBuilder();
        FileInputStream input = new FileInputStream(dccFile);
        Document dcmDoc = builder.build((InputStream)input);
        input.close();
        List eles = dcmDoc.getRootElement().getChildren("datacenter");
        if (eles != null) {
            for (int i = 0; i < eles.size(); ++i) {
                Element ele = (Element)eles.get(i);
                if ("true".equalsIgnoreCase(ele.getAttributeValue("isAffiliated", "false"))) continue;
                DCInfo dc = new DCInfo();
                dc.setNumber(ele.getAttributeValue("id"));
                dc.setDefaultDC(ele.getAttributeValue("defaultDC"));
                String dbType = ele.getAttributeValue("dbtype");
                if (dbType == null) {
                    dbType = "sqlserver";
                }
                dbType = dbType.toLowerCase();
                int dbtype = DbType.getValue((String)dbType);
                dc.setDBType(dbtype);
                dc.setSolutionName("eas");
                dc.setVersion(ele.getAttributeValue("version"));
                dc.setBOSVersion(ele.getAttributeValue("BOSVersion"));
                String disable = ele.getAttributeValue("disable");
                List names = ele.getChildren("name");
                if (names != null) {
                    for (int k = 0; k < names.size(); ++k) {
                        Element name = (Element)names.get(k);
                        String locale = name.getAttributeValue("locale");
                        if ("en".equalsIgnoreCase(locale)) {
                            dc.tb.put("L1", name.getText());
                            continue;
                        }
                        if ("zh_CN".equalsIgnoreCase(locale)) {
                            dc.tb.put("L2", name.getText());
                            continue;
                        }
                        if (!"zh_TW".equalsIgnoreCase(locale)) continue;
                        dc.tb.put("L3", name.getText());
                    }
                }
                if (dc.tb.get("L1") == null) {
                    dc.tb.put("L1", "");
                }
                if (dc.tb.get("L2") == null) {
                    dc.tb.put("L2", "");
                }
                if (dc.tb.get("L3") == null) {
                    dc.tb.put("L3", "");
                }
                if (!"false".equalsIgnoreCase(disable)) continue;
                dcList.add(dc);
            }
        }
        return dcList;
    }
}

