/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.common.configuredfield;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.service.AbstractServiceAdapter;
import com.kingdee.bos.service.IServiceAdapter;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.common.configuredfield.ConfigFieldModuleConfigInfo;
import com.kingdee.eas.base.common.configuredfield.EntityRefRegisterFactory;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.util.PermissionUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ConfigFieldServiceAdapter
extends AbstractServiceAdapter
implements IServiceAdapter {
    private static Logger logger = Logger.getLogger((String)ConfigFieldServiceAdapter.class.getName());

    public int getPriority() {
        return 0;
    }

    public String getName() {
        return "ConfigFieldServiceAdapter";
    }

    public void execute(IServiceContext serviceContext) throws BOSException {
        try {
            ConfigFieldModuleConfigInfo cfmcInfo;
            if (serviceContext.getExecutionMode() != 1) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"wellcome to ConfigFieldServiceAdapter.execute");
            }
            if (this.isEmptyConfig(cfmcInfo = ConfigFieldModuleConfigInfo.getInstance())) {
                return;
            }
            String keyStr = this.getCallKey(serviceContext);
            this.processAddnew(serviceContext, keyStr, cfmcInfo.getAllNeedAddMethod());
            this.processUpdate(serviceContext, keyStr, cfmcInfo.getAllNeedUpdateMethod());
            this.processDelete(serviceContext, keyStr, cfmcInfo.getAllNeedDelMethod());
            this.processOther(serviceContext, keyStr, cfmcInfo.getAllOtherMethod());
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            return;
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            return;
        }
        catch (Throwable e) {
            logger.error((Object)"", e);
            return;
        }
    }

    private void processAddnew(IServiceContext serviceContext, String operKey, Map needAddMap) throws EASBizException, BOSException {
        if (!this.isNeedProcess(operKey, needAddMap)) {
            return;
        }
        Object[] params = serviceContext.getOperationParameters();
        if (needAddMap.get(operKey).equals("standard_addew_1")) {
            CoreBaseInfo cbInfo = this.getInfoFromParam(params);
            IObjectPK pk = (IObjectPK)serviceContext.getMethodReturnValue();
            cbInfo.setId(BOSUuid.read((String)pk.toString()));
            this.addEntityRef(serviceContext, new CoreBaseInfo[]{cbInfo});
        } else if (needAddMap.get(operKey).equals("standard_addew_2")) {
            CoreBaseInfo cbInfo = this.getInfoFromParam(params);
            IObjectPK pk = this.getPKFromParam(params);
            cbInfo.setId(BOSUuid.read((String)pk.toString()));
            this.addEntityRef(serviceContext, new CoreBaseInfo[]{cbInfo});
        }
    }

    private CoreBaseInfo getInfoFromParam(Object[] params) {
        for (int i = 0; i < params.length; ++i) {
            if (!(params[i] instanceof CoreBaseInfo)) continue;
            return (CoreBaseInfo)params[i];
        }
        return null;
    }

    private IObjectPK getPKFromParam(Object[] params) {
        for (int i = 0; i < params.length; ++i) {
            if (!(params[i] instanceof IObjectPK)) continue;
            return (IObjectPK)params[i];
        }
        return null;
    }

    private void addEntityRef(IServiceContext serviceContext, CoreBaseInfo[] iObjectValues) throws EASBizException, BOSException {
        for (int i = 0; i < iObjectValues.length; ++i) {
            if (!iObjectValues[i].getBOSType().equals((Object)serviceContext.getBoType())) continue;
            EntityRefRegisterFactory.create(serviceContext.getBoType().toString()).register((IObjectValue)iObjectValues[i], serviceContext.getContext());
        }
    }

    private void updateEntityRef(IServiceContext serviceContext, CoreBaseInfo[] iObjectValues) throws EASBizException, BOSException {
        for (int i = 0; i < iObjectValues.length; ++i) {
            if (!iObjectValues[i].getBOSType().equals((Object)serviceContext.getBoType())) continue;
            EntityRefRegisterFactory.create(serviceContext.getBoType().toString()).registerUpdate((IObjectValue)iObjectValues[i], serviceContext.getContext());
        }
    }

    private void processUpdate(IServiceContext serviceContext, String operKey, Map needUpdateMap) throws EASBizException, BOSException {
        if (!this.isNeedProcess(operKey, needUpdateMap)) {
            return;
        }
        Object[] params = serviceContext.getOperationParameters();
        if (needUpdateMap.get(operKey).equals("standard_update_2")) {
            CoreBaseInfo cbInfo = this.getInfoFromParam(params);
            IObjectPK pk = this.getPKFromParam(params);
            cbInfo.setId(BOSUuid.read((String)pk.toString()));
            this.updateEntityRef(serviceContext, new CoreBaseInfo[]{cbInfo});
        }
    }

    private void processDelete(IServiceContext serviceContext, String operKey, Map needDeleteMap) throws EASBizException, BOSException {
        if (!this.isNeedProcess(operKey, needDeleteMap)) {
            return;
        }
        Object returnValue = serviceContext.getMethodReturnValue();
        String bosType = serviceContext.getBoType().toString();
        if (returnValue instanceof IObjectPK[]) {
            IObjectPK[] pks = (IObjectPK[])returnValue;
            this.deleteEntityRefInfo(bosType, pks, serviceContext.getContext());
        } else if (returnValue instanceof IObjectPK) {
            IObjectPK pk = (IObjectPK)returnValue;
            this.deleteEntityRefInfo(bosType, new IObjectPK[]{pk}, serviceContext.getContext());
        }
    }

    private void deleteEntityRefInfo(String bosType, IObjectPK[] objectPks, Context ctx) throws BOSException {
        EntityRefRegisterFactory.create(bosType).unRegister(objectPks, ctx);
    }

    private void processOther(IServiceContext serviceContext, String operKey, Map needOtherMap) throws EASBizException, BOSException {
        if (!this.isNeedProcess(operKey, needOtherMap)) {
            return;
        }
        String bosType = serviceContext.getBoType().toString();
        EntityRefRegisterFactory.create(bosType).processOtherRegister(serviceContext);
    }

    private boolean isNeedProcess(String operKey, Map needMap) {
        return needMap.containsKey(operKey);
    }

    private boolean isEmptyConfig(ConfigFieldModuleConfigInfo cfmcInfo) {
        if (cfmcInfo.getAllNeedAddMethod().isEmpty() && cfmcInfo.getAllNeedDelMethod().isEmpty() && cfmcInfo.getAllNeedUpdateMethod().isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"not config configurefield service enity and method info by configfieldmoduleconfig.xml");
            }
            return true;
        }
        return false;
    }

    private String getCallKey(IServiceContext serviceContext) {
        String entityBosType = this.getEnityBosType(serviceContext);
        String methodPK = this.getMethodPK(serviceContext);
        if (StringUtils.isEmpty((String)entityBosType) || StringUtils.isEmpty((String)methodPK)) {
            logger.info((Object)("entity or method is null, entity type is " + entityBosType + " method is :" + methodPK));
            return "";
        }
        String keyStr = entityBosType + ":" + methodPK;
        return keyStr;
    }

    private String getPwdFromCtx(IServiceContext serviceContext, String userId, int pwdPos) {
        Object[] obj = serviceContext.getOperationParameters();
        Object paramObj = obj[pwdPos];
        try {
            if (paramObj instanceof String) {
                IUser iUser = UserFactory.getLocalInstance((Context)serviceContext.getContext());
                UserInfo userInfo = iUser.getUserInfo((IObjectPK)new ObjectStringPK(userId));
                return PermissionUtil.decrypt((String)userInfo.getNumber(), (String)paramObj.toString());
            }
            if (paramObj instanceof UserInfo) {
                UserInfo userInfo = (UserInfo)paramObj;
                return PermissionUtil.decrypt((String)userInfo.getNumber(), (String)userInfo.getPassword());
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return null;
    }

    private List getObjectValueFromCtx(IServiceContext serviceContext, String specialDealStr) {
        ArrayList<String> idList = new ArrayList<String>();
        Object[] obj = serviceContext.getOperationParameters();
        if (obj == null || obj.length == 0) {
            return null;
        }
        BOSObjectType bosType = serviceContext.getBoType();
        block2: for (int i = 0; i < obj.length; ++i) {
            List paramIdList = null;
            if (paramIdList != null && !paramIdList.isEmpty()) {
                idList.addAll(paramIdList);
                continue;
            }
            if (!(obj[i] instanceof Object[])) continue;
            Object[] objAry = (Object[])obj[i];
            for (int j = 0; j < objAry.length; ++j) {
                try {
                    if (!(objAry[j] instanceof IObjectPK) && !(objAry[j] instanceof String) || !BOSUuid.read((String)objAry[j].toString()).getType().toString().equals(bosType.toString())) continue block2;
                    idList.add(objAry[j].toString());
                    continue;
                }
                catch (Exception e) {
                    logger.info((Object)"read id error!", (Throwable)e);
                    continue block2;
                }
            }
        }
        return idList;
    }

    private List getObjectValueFromParam(IServiceContext serviceContext, BOSObjectType bosType, Object oneParam, String specialDealStr) {
        CoreBaseInfo iObjectValue;
        Context ctx = serviceContext.getContext();
        ArrayList<String> idList = new ArrayList<String>();
        if (oneParam instanceof CoreBaseInfo && (iObjectValue = (CoreBaseInfo)oneParam).getBOSType().toString().equals(bosType.toString())) {
            if (this.needRelationMap(specialDealStr)) {
                logger.info((Object)(" prepare getValue from iObjectValue, specialDealStr is:" + specialDealStr));
                List tempList = this.getIdFromRelationObj(ctx, iObjectValue, specialDealStr);
                if (tempList != null && !tempList.isEmpty()) {
                    idList.addAll(tempList);
                    logger.info((Object)("get some data, count is:" + tempList.size()));
                } else {
                    logger.info((Object)"prepare getValue from iObjectValue ,no data fetch!");
                }
            } else if (iObjectValue.getId() != null) {
                idList.add(StringUtils.cnulls((Object)iObjectValue.getId()));
            } else {
                Object retObj = serviceContext.getMethodReturnValue();
                if (retObj instanceof IObjectPK) {
                    idList.add(StringUtils.cnulls((Object)retObj));
                }
            }
        }
        return idList;
    }

    private List getIdFromRelationObj(Context ctx, CoreBaseInfo oneParam, String specialDealStr) {
        return null;
    }

    private boolean needRelationMap(String specialDealStr) {
        if (StringUtils.isEmpty((String)specialDealStr)) {
            return false;
        }
        return specialDealStr.indexOf(":") != -1;
    }

    private String getMethodPK(IServiceContext serviceContext) {
        return StringUtils.cnulls((Object)serviceContext.getOperationPK());
    }

    private String getEnityBosType(IServiceContext serviceContext) {
        return StringUtils.cnulls((Object)serviceContext.getBoType());
    }
}

