/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.common.configuredfield;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.config.EntityRefInfo;
import com.kingdee.bos.config.IMetadataRef;
import com.kingdee.bos.config.MetadataRefFactory;
import com.kingdee.bos.config.ModuleEnum;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.util.StringUtils;

public class RegisterManager {
    public void register(EntityRefInfo eref, Context ctx) throws BOSException {
        if (eref.getDetails().size() > 0) {
            this.getMetadataRefInterface(ctx).registerEntityRef(eref);
        }
    }

    public IMetadataRef getMetadataRefInterface(Context ctx) throws BOSException {
        if (ctx == null) {
            return MetadataRefFactory.getRemoteInstance();
        }
        return MetadataRefFactory.getLocalInstance((Context)ctx);
    }

    public void register(EntityRefInfo[] erefs, Context ctx) throws BOSException {
        for (int i = 0; i < erefs.length; ++i) {
            if (erefs[i].getDetails().size() <= 0) continue;
            this.getMetadataRefInterface(ctx).registerEntityRef(erefs[i]);
        }
    }

    public void unRegister(EntityRefInfo eref, Context ctx) throws BOSException {
        if (eref.getDetails().size() > 0) {
            this.getMetadataRefInterface(ctx).unregisterEntityRef(eref);
        }
    }

    public void unRegister(EntityRefInfo[] erefs, Context ctx) throws BOSException {
        for (int i = 0; i < erefs.length; ++i) {
            if (erefs[i].getDetails().size() <= 0) continue;
            this.getMetadataRefInterface(ctx).unregisterEntityRef(erefs[i]);
        }
    }

    public void unRegister(IObjectPK[] objectKeys, Context ctx) throws BOSException {
        if (objectKeys == null || objectKeys.length == 0) {
            return;
        }
        String keys = StringUtils.arrayToString((Object[])objectKeys, (String)",");
        StringBuffer oql = new StringBuffer("where objectKey in  (");
        oql.append(keys).append(")");
        this.getMetadataRefInterface(ctx).delete(keys);
    }

    public boolean isMetaDataRef(Context ctx) {
        return false;
    }

    public static EntityRefInfo createEntityRef(ModuleEnum module, String type, String objectKey, String desc) {
        EntityRefInfo eref = new EntityRefInfo();
        eref.setObjectKey(objectKey);
        return eref;
    }
}

