/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.commonquery.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.cache.CustomCacheService;
import com.kingdee.bos.framework.cache.Utils;
import com.kingdee.bos.util.MultiParamKeyString;
import com.kingdee.eas.base.commonquery.PermissionChecker;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.QueryUtils;
import com.kingdee.eas.base.commonquery.ShareTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;

public class QuerySolutionCacheUtils {
    private static CustomCacheService defaultSolutionCache = new CustomCacheService("commonquery.defaultSolution");
    private static CustomCacheService mySolutionsCache = new CustomCacheService("commonquery.mySolutions");

    public static QuerySolutionInfo getDefaultQuerySolutionFromCache(String userId, String orgId, String parentUIName, String queryName) {
        if (userId == null || orgId == null || parentUIName == null || queryName == null) {
            return null;
        }
        Object[] args = new Object[]{userId, orgId, parentUIName, queryName};
        String key = Utils.transMD5((String)MultiParamKeyString.toString(null, (Object[])args));
        return (QuerySolutionInfo)defaultSolutionCache.get(key);
    }

    public static void putDefaultQuerySolutionToCache(String userId, String orgId, String parentUIName, String queryName, QuerySolutionInfo querySolutionInfo) {
        if (userId == null || orgId == null || parentUIName == null || queryName == null) {
            return;
        }
        Object[] args = new Object[]{userId, orgId, parentUIName, queryName};
        String key = Utils.transMD5((String)MultiParamKeyString.toString(null, (Object[])args));
        defaultSolutionCache.put(key, (Object)querySolutionInfo);
    }

    public static void removeDefaultQuerySolutionFromCache(String userId, String orgId, String parentUIName, String queryName) {
        if (userId == null || orgId == null || parentUIName == null || queryName == null) {
            return;
        }
        Object[] args = new Object[]{userId, orgId, parentUIName, queryName};
        String key = Utils.transMD5((String)MultiParamKeyString.toString(null, (Object[])args));
        defaultSolutionCache.remove(key);
    }

    public static QuerySolutionCollection getMytQuerySolutionsFromCache(Context ctx, String userId, String orgId, String parentUIName, String queryName) {
        if (userId == null || orgId == null || parentUIName == null || queryName == null) {
            return null;
        }
        boolean hasQueryManagePerm = PermissionChecker.hasEditOtherCQSolutionPerm(ctx);
        Object[] args = new Object[]{userId, orgId, parentUIName, queryName, hasQueryManagePerm};
        String key = Utils.transMD5((String)MultiParamKeyString.toString(null, (Object[])args));
        return (QuerySolutionCollection)((Object)mySolutionsCache.get(key));
    }

    public static void putMyQuerySolutionsToCache(Context ctx, String userId, String orgId, String parentUIName, String queryName, QuerySolutionCollection querySolutionCollection) {
        if (userId == null || orgId == null || parentUIName == null || queryName == null) {
            return;
        }
        boolean hasQueryManagePerm = PermissionChecker.hasEditOtherCQSolutionPerm(ctx);
        Object[] args = new Object[]{userId, orgId, parentUIName, queryName, hasQueryManagePerm};
        String key = Utils.transMD5((String)MultiParamKeyString.toString(null, (Object[])args));
        mySolutionsCache.put(key, (Object)querySolutionCollection);
    }

    public static void removeMyQuerySolutionsFromCache(Context ctx, String userId, String orgId, String parentUIName, String queryName) {
        if (userId == null || orgId == null || parentUIName == null || queryName == null) {
            return;
        }
        boolean hasQueryManagePerm = PermissionChecker.hasEditOtherCQSolutionPerm(ctx);
        Object[] args = new Object[]{userId, orgId, parentUIName, queryName, hasQueryManagePerm};
        String key = Utils.transMD5((String)MultiParamKeyString.toString(null, (Object[])args));
        mySolutionsCache.remove(key);
    }

    public static void removeQuerySolutionCache(Context ctx, QuerySolutionInfo solutionInfo) throws BOSException, EASBizException {
        String userId = StringUtils.cnulls((Object)solutionInfo.getOwner());
        String orgId = StringUtils.cnulls((Object)solutionInfo.getOrgID());
        String parentUIName = StringUtils.cnulls((String)solutionInfo.getParentUIName());
        String queryName = StringUtils.cnulls((String)solutionInfo.getQueryObjectName());
        if (StringUtils.isEmpty((String)orgId)) {
            orgId = StringUtils.cnulls((Object)QueryUtils.getOrgID(queryName, ctx));
        }
        if (ShareTypeEnum.USER_NOORG_LEVEL.equals((Object)solutionInfo.getShareType()) || !userId.equals(ctx.getCaller().toString())) {
            mySolutionsCache.removeAll();
            defaultSolutionCache.removeAll();
        } else {
            QuerySolutionCacheUtils.removeDefaultQuerySolutionFromCache(userId, orgId, parentUIName, queryName);
            QuerySolutionCacheUtils.removeMyQuerySolutionsFromCache(ctx, userId, orgId, parentUIName, queryName);
        }
    }
}

