/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.commonquery.upgrade;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Manifest;

public class CreateClassPathJar {
    private static final Logger logger = Logger.getLogger(CreateClassPathJar.class);

    public static void create(String eas_home) {
        for (int i = 0; i < 3; ++i) {
            String needJarPath = CreateClassPathJar.getJarPath(eas_home, i);
            CreateClassPathJar.generateJarFile(needJarPath, eas_home, i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateJarFile(String cp, String destFilePath, int i) {
        if (cp == null || cp.length() == 0) {
            return;
        }
        PrintWriter writer = null;
        try {
            File dir = new File(destFilePath + "/META-INF");
            if (!dir.exists()) {
                dir.mkdir();
            }
            Manifest manifest = new Manifest();
            manifest.addConfiguredAttribute(new Manifest.Attribute("Manifest-Version", "1.0"));
            manifest.addConfiguredAttribute(new Manifest.Attribute("Built-By", "MXN"));
            SimpleDateFormat myFmt = new SimpleDateFormat("yyyyMMddHHmmss");
            manifest.addConfiguredAttribute(new Manifest.Attribute("BuildNumber", myFmt.format(new Date(System.currentTimeMillis()))));
            manifest.addConfiguredAttribute(new Manifest.Attribute("Class-Path", cp));
            writer = new PrintWriter(new FileWriter(destFilePath + "/META-INF/MANIFEST.MF"));
            manifest.write(writer);
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {
                    logger.error((Object)"close printWriter fail...", (Throwable)e);
                }
            }
            String upgradeJarName = null;
            switch (i) {
                case 0: {
                    upgradeJarName = "upgrade1_classpath.jar";
                    break;
                }
                case 1: {
                    upgradeJarName = "upgrade2_classpath.jar";
                    break;
                }
                case 2: {
                    upgradeJarName = "upgrade3_classpath.jar";
                }
            }
            File file = new File(destFilePath + "/" + upgradeJarName);
            if (file.exists()) {
                file.delete();
            }
            Project project = new Project();
            Jar zip = new Jar();
            zip.setProject(project);
            zip.setDestFile(new File(destFilePath + "/" + upgradeJarName));
            zip.setManifest(new File(destFilePath + "/META-INF/MANIFEST.MF"));
            zip.execute();
        }
        catch (Exception e) {
            logger.error((Object)"generate JarFile fail...", (Throwable)e);
        }
        finally {
            CreateClassPathJar.clearMetaInfFile(destFilePath);
        }
    }

    private static void clearMetaInfFile(String baseFile) {
        File metaInfFile;
        File file = new File(baseFile);
        if (file.isDirectory() && (metaInfFile = new File(baseFile + "/META-INF")).exists()) {
            File[] filelist = metaInfFile.listFiles();
            for (int i = 0; i < filelist.length; ++i) {
                filelist[i].delete();
            }
            metaInfFile.delete();
        }
    }

    private static String getJarPath(String eas_home, int i) {
        StringBuffer sb = new StringBuffer();
        switch (i) {
            case 0: {
                sb.append(CreateClassPathJar.getFilePath(eas_home, "/admin/upgradesolution/tmpOld"));
                break;
            }
            case 1: {
                sb.append(CreateClassPathJar.getFilePath(eas_home, "/server/lib/common/trd"));
                sb.append(CreateClassPathJar.getFilePath(eas_home, "/server/lib/common/bos"));
                sb.append(CreateClassPathJar.getFilePath(eas_home, "/server/lib/common/eas"));
                sb.append(CreateClassPathJar.getFilePath(eas_home, "/server/lib/server/trd"));
                sb.append(CreateClassPathJar.getFilePath(eas_home, "/server/lib/server/bos"));
                sb.append(CreateClassPathJar.getFilePath(eas_home, "/server/lib/server/eas"));
                sb.append(CreateClassPathJar.getFilePath(eas_home, "/server/lib/web/portal"));
                sb.append(CreateClassPathJar.getFilePath(eas_home, "/server/lib/web/trd"));
                break;
            }
            case 2: {
                sb.append(CreateClassPathJar.getFilePath(eas_home, "/server/deploy/fileserver.ear/easWebClient/lib/patch"));
                sb.append(CreateClassPathJar.getFilePath(eas_home, "/server/deploy/fileserver.ear/easWebClient/lib/common/trd"));
                sb.append(CreateClassPathJar.getFilePath(eas_home, "/server/deploy/fileserver.ear/easWebClient/lib/common/bos"));
                sb.append(CreateClassPathJar.getFilePath(eas_home, "/server/deploy/fileserver.ear/easWebClient/lib/common/eas"));
                sb.append(CreateClassPathJar.getFilePath(eas_home, "/server/deploy/fileserver.ear/easWebClient/lib/client/trd"));
                sb.append(CreateClassPathJar.getFilePath(eas_home, "/server/deploy/fileserver.ear/easWebClient/lib/client/bos"));
                sb.append(CreateClassPathJar.getFilePath(eas_home, "/server/deploy/fileserver.ear/easWebClient/lib/client/eas"));
            }
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private static String getFilePath(String eas_home, String dirPath) {
        File dir = new File(eas_home + dirPath);
        String tmp = dirPath.substring(1);
        StringBuffer sb = new StringBuffer();
        if (dir.exists() && dir.isDirectory()) {
            String[] fileList = dir.list();
            for (int i = 0; i < fileList.length; ++i) {
                if (!fileList[i].toLowerCase(Locale.ENGLISH).endsWith(".jar")) continue;
                sb.append(tmp).append("/").append(fileList[i]);
                sb.append(" ");
            }
        }
        return sb.toString();
    }
}

