/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.app.apiservice.process;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.evs.app.apiservice.api.DataProcessUtil;
import com.kingdee.eas.base.evs.app.apiservice.api.Message;
import com.kingdee.eas.base.evs.app.apiservice.process.IProcessor;
import com.kingdee.eas.base.evs.app.datapool.BkerInvoiceUnitCollection;
import com.kingdee.eas.base.evs.app.datapool.BkerInvoiceUnitFactory;
import com.kingdee.eas.base.evs.app.datapool.BkerInvoiceUnitInfo;
import com.kingdee.eas.base.evs.app.datapool.BkerVoucherEntryUnitCollection;
import com.kingdee.eas.base.evs.app.datapool.BkerVoucherEntryUnitInfo;
import com.kingdee.eas.base.evs.app.datapool.CompanyInfo;
import com.kingdee.eas.base.evs.util.AS;
import com.kingdee.eas.base.evs.util.CheckUtil;
import com.kingdee.eas.base.evs.util.EVSSet;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class BkerProcessor
implements IProcessor {
    private Logger logger = Logger.getLogger(BkerProcessor.class);

    @Override
    public void checkRequired(Context ctx, JSONObject jsonObject) throws EASBizException {
        EVSSet evsSet = EVSSet.builder().add("Vouchers").add("WhetherReceiptHasBeenBooked").add("DateOfIssue").add("Currency").add("TransactionAmountInFigures").add("PK").add("BillPK").add("IdentifyingCode");
        JSONArray datas = (JSONArray)jsonObject.get((Object)"Datas");
        for (int i = 0; i < datas.size(); ++i) {
            Map bill = (Map)datas.get(i);
            CheckUtil.checkNULL(ctx, bill, evsSet.get());
        }
        HashSet<String> checkDupDateSet = new HashSet<String>();
        for (int i = 0; i < datas.size(); ++i) {
            Map bill = (Map)datas.get(i);
            if (checkDupDateSet.contains(bill.get("PK") + "")) {
                this.logger.error((Object)("BkerProcessor\u88ab\u4e22\u5f03\u7684\u91cd\u590d\u6570\u636e\uff1a" + bill.get("PK")));
                datas.remove(i);
                --i;
            }
            checkDupDateSet.add(bill.get("PK") + "");
        }
    }

    @Override
    public String process(Context ctx, JSONObject jsonObject) throws BOSException, EASBizException {
        CoreBaseCollection colls = new CoreBaseCollection();
        CompanyInfo companyInfo = DataProcessUtil.processCompany(ctx, jsonObject);
        JSONArray datas = (JSONArray)jsonObject.get((Object)"Datas");
        ArrayList<String> voucherIds = new ArrayList<String>(datas.size());
        for (int i = 0; i < datas.size(); ++i) {
            Map bill = (Map)datas.get(i);
            BkerInvoiceUnitCollection oldUnit = BkerInvoiceUnitFactory.getLocalInstance(ctx).getBkerInvoiceUnitCollection("where uniquePK = '" + bill.get("PK") + "'");
            BkerInvoiceUnitInfo unitInfo = new BkerInvoiceUnitInfo();
            if (oldUnit != null && oldUnit.size() > 0) {
                unitInfo.setId(oldUnit.get(0).getId());
            }
            unitInfo.setUniquePK(bill.get("PK") + "");
            unitInfo.setIsClaimed(AS.valueOf(bill.get("WhetherInvoiceHasBeenClaimed"), ""));
            unitInfo.setUniqueCode(AS.valueOf(bill.get("UniqueCodeOfInvoice"), ""));
            unitInfo.setTransToBank(AS.valueOf(bill.get("WhetherReceiptHasBeenTransferredToBank"), ""));
            unitInfo.setIsReconciled(AS.valueOf(bill.get("WhetherReceiptHasBeenReconciled"), ""));
            unitInfo.setContractNumber(AS.valueOf(bill.get("ContractNumber"), ""));
            unitInfo.setIsBooked(AS.valueOf(bill.get("WhetherReceiptHasBeenBooked"), ""));
            unitInfo.setDateOfIssue(AS.valueOf(bill.get("DateOfIssue"), ""));
            unitInfo.setCurrency(AS.valueOf(bill.get("Currency"), ""));
            unitInfo.setPaymentAmount(AS.valueOf(bill.get("AmountPayableAndReceivable"), ""));
            unitInfo.setTransAmount(AS.valueOf(bill.get("TransactionAmountInFigures"), ""));
            unitInfo.setBillPK(AS.valueOf(bill.get("BillPK"), ""));
            unitInfo.setBillNumber(AS.valueOf(bill.get("BillNumber"), ""));
            unitInfo.setInvoiceType(AS.valueOf(bill.get("TypeOfInvoice"), ""));
            unitInfo.setIdentifyingCode(AS.valueOf(bill.get("IdentifyingCode"), ""));
            unitInfo.setFileName(AS.valueOf(bill.get("FileName"), ""));
            BkerVoucherEntryUnitCollection voucherEntry = new BkerVoucherEntryUnitCollection();
            String[] vouchers = AS.valueOf(bill.get("Vouchers"), "").split(",");
            for (int j = 0; j < vouchers.length; ++j) {
                BkerVoucherEntryUnitInfo info = new BkerVoucherEntryUnitInfo();
                info.setVoucherId(vouchers[j]);
                voucherIds.add(vouchers[j]);
                voucherEntry.add(info);
            }
            unitInfo.put("voucherEntry", (Object)voucherEntry);
            unitInfo.setCompany(companyInfo);
            DataProcessUtil.fillAuditData(ctx, unitInfo);
            colls.add((CoreBaseInfo)unitInfo);
        }
        if (!colls.isEmpty()) {
            BkerInvoiceUnitFactory.getLocalInstance(ctx).saveBatchData(colls);
        }
        return Message.success();
    }
}

