/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.app.converter.thread;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.evs.app.apiservice.api.DataProcessUtil;
import com.kingdee.eas.base.evs.app.converter.ConverterDataFactory;
import com.kingdee.eas.base.evs.app.converter.ConverterDataInfo;
import com.kingdee.eas.base.evs.app.converter.DataConverterEngine;
import com.kingdee.eas.base.evs.app.converter.Msg;
import com.kingdee.eas.base.evs.app.converter.Status;
import com.kingdee.eas.base.evs.util.SQLUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ConverterThread
implements Runnable {
    private static Logger logger = Logger.getLogger(ConverterThread.class);
    private Context ctx;
    private CompanyOrgUnitInfo companyInfo;
    private int periodYear;
    private int periodNumber;
    private List<String> pks;
    private List<String> standardTypes;
    private int retryNum = 0;

    public ConverterThread(Context ctx, CompanyOrgUnitInfo companyInfo, int periodYear, int periodNumber, List<String> pks, List<String> standardTypes) {
        this.ctx = ctx;
        this.companyInfo = companyInfo;
        this.periodYear = periodYear;
        this.periodNumber = periodNumber;
        this.standardTypes = standardTypes;
        this.pks = pks;
    }

    public ConverterThread(Context ctx, CompanyOrgUnitInfo companyInfo, int periodYear, int periodNumber, List<String> pks, List<String> standardTypes, int retryNum) {
        this.ctx = ctx;
        this.companyInfo = companyInfo;
        this.periodYear = periodYear;
        this.periodNumber = periodNumber;
        this.pks = pks;
        this.standardTypes = standardTypes;
        this.retryNum = retryNum;
    }

    @Override
    public void run() {
        this.callConverterMethod(this.ctx, this.companyInfo, this.periodYear, this.periodNumber, this.standardTypes, this.pks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callConverterMethod(Context ctx, CompanyOrgUnitInfo companyInfo, int periodYear, int periodNumber, List<String> standardTypes, List<String> pks) {
        CoreBaseCollection collection = new CoreBaseCollection();
        do {
            try {
                Msg msg = DataConverterEngine.converter(ctx, companyInfo, periodYear, periodNumber, standardTypes, pks);
                if (msg.getStatus().equals((Object)Status.ALLSUCCESS)) break;
                for (Map.Entry<String, String> entry : msg.getError().entrySet()) {
                    ConverterDataInfo info = new ConverterDataInfo();
                    info.setCreaditCode(companyInfo.getTaxNumber());
                    info.setYear(periodYear);
                    info.setMonth(periodNumber);
                    info.setErrMsg(entry.getValue());
                    info.setSuccess(msg.getStatus().ordinal());
                    info.setRetryNum(this.retryNum);
                    info.setXbrlType(entry.getKey());
                    info.setParams(SQLUtils.getSQL(pks));
                    DataProcessUtil.fillAuditData(ctx, info);
                    collection.add((CoreBaseInfo)info);
                }
            }
            finally {
                --this.retryNum;
            }
        } while (this.retryNum >= 0);
        try {
            if (!collection.isEmpty()) {
                ConverterDataFactory.getLocalInstance(ctx).addnewBatchData(collection);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

