/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.app.converter.voucher;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.evs.app.converter.IDataConverter;
import com.kingdee.eas.base.evs.app.datapool.VoucherEntryUnitCollection;
import com.kingdee.eas.base.evs.app.datapool.VoucherEntryUnitInfo;
import com.kingdee.eas.base.evs.app.datapool.VoucherUnitCollection;
import com.kingdee.eas.base.evs.app.datapool.VoucherUnitFactory;
import com.kingdee.eas.base.evs.app.datapool.VoucherUnitInfo;
import com.kingdee.eas.base.evs.util.SQLUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractVoucherDataConverter
implements IDataConverter {
    public Map<String, JSONObject> getInformationOfAccountingDocumentsTuple(Context ctx, List<String> voucherIds) throws BOSException {
        String oql = "select *,entry.*,dataRange.* where voucherPK in (" + SQLUtils.getSQL(voucherIds) + ")";
        VoucherUnitCollection voucherUnitCollection = VoucherUnitFactory.getLocalInstance(ctx).getVoucherUnitCollection(oql);
        return this.getInformationOfAccountingDocumentsTuple(ctx, voucherUnitCollection);
    }

    public Map<String, JSONObject> getInformationOfAccountingDocumentsTuple(Context ctx, VoucherUnitCollection voucherUnitCollection) {
        int size = voucherUnitCollection.size();
        HashMap<String, JSONObject> result = new HashMap<String, JSONObject>(size);
        for (int i = 0; i < size; ++i) {
            VoucherUnitInfo unitInfo = voucherUnitCollection.get(i);
            JSONObject retJson = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            retJson.put("NumberOfAccountingDocuments", (Object)unitInfo.getVoucherNumber());
            retJson.put("PostingDate", (Object)unitInfo.getPostingDate());
            retJson.put("AccountingPeriod", (Object)(unitInfo.getDataRange().getPeriodYear() + "-" + (unitInfo.getDataRange().getPeriodNumber() < 10 ? "0" + unitInfo.getDataRange().getPeriodNumber() : Integer.valueOf(unitInfo.getDataRange().getPeriodNumber()))));
            retJson.put("SummaryOfAccountingDocuments", (Object)unitInfo.getSummary());
            VoucherEntryUnitCollection entries = unitInfo.getEntry();
            for (int j = 0; j < entries.size(); ++j) {
                JSONObject entryJson = new JSONObject();
                VoucherEntryUnitInfo entry = entries.get(j);
                entryJson.put("DebitOrCredit", (Object)entry.getDebitOrCredit());
                entryJson.put("NameOfGeneralLedgerSubject", (Object)entry.getGlSubject());
                entryJson.put("NameOfSubsidiaryLedgerSubject", (Object)entry.getSlSubject());
                entryJson.put("RecordedAmount", (Object)entry.getRecordedAmount());
                jsonArray.add((Object)entryJson);
            }
            retJson.put("InformationOfDebitAndCreditEntryTuple", (Object)jsonArray);
            result.put(unitInfo.getVoucherPK(), retJson);
        }
        return result;
    }

    public Map<String, Map<String, JSONObject>> getInformationOfAccountingDocumentsTuple0(Context ctx, IRowSet rs) throws Exception {
        HashMap relations = new HashMap();
        ArrayList<String> voucherIds = new ArrayList<String>();
        while (rs.next()) {
            String code = rs.getString(1);
            String voucherId = rs.getString(2);
            voucherIds.add(voucherId);
            if (!relations.containsKey(code)) {
                relations.put(code, new ArrayList());
            }
            ((List)relations.get(code)).add(voucherId);
        }
        Map<String, JSONObject> informationOfAccountingDocumentsTuple = this.getInformationOfAccountingDocumentsTuple(ctx, voucherIds);
        HashMap<String, Map<String, JSONObject>> result = new HashMap<String, Map<String, JSONObject>>();
        for (Map.Entry entry : relations.entrySet()) {
            if (!result.containsKey(entry.getKey())) {
                result.put((String)entry.getKey(), new HashMap());
            }
            List vouchers = (List)entry.getValue();
            for (String voucheId : vouchers) {
                ((Map)result.get(entry.getKey())).put(voucheId, informationOfAccountingDocumentsTuple.get(voucheId));
            }
        }
        return result;
    }

    @Override
    public void converter(Context ctx, CompanyOrgUnitInfo companyInfo, int periodYear, int periodNumber) throws Exception {
        this.converter(ctx, companyInfo, periodYear, periodNumber, null);
    }

    @Override
    public void converter(Context ctx, CompanyOrgUnitInfo companyInfo, int periodYear, int periodNumber, List<String> ids) throws Exception {
        String sql1 = this.getSql();
        sql1 = sql1 + "where g.FCompanyCreaditCode = '" + companyInfo.getTaxNumber() + "' and f.FPeriodYear = " + periodYear + " and f.FPeriodNumber = " + periodNumber + " ";
        if (ids != null && !ids.isEmpty()) {
            sql1 = sql1 + " and e.FVoucherPK in (" + SQLUtils.getSQL(ids) + ")";
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql1);
        Map<String, Map<String, JSONObject>> informationOfAccountingDocumentsTuple = this.getInformationOfAccountingDocumentsTuple(ctx, rowSet);
        rowSet.beforeFirst();
        this.saveData(ctx, periodYear, periodNumber, rowSet, informationOfAccountingDocumentsTuple);
    }

    public abstract String getSql();

    public abstract Map<String, Map<String, JSONObject>> getInformationOfAccountingDocumentsTuple(Context var1, IRowSet var2) throws Exception;

    public abstract void saveData(Context var1, int var2, int var3, IRowSet var4, Map<String, Map<String, JSONObject>> var5) throws Exception;
}

