/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.unitdata.pcloud.fpSys;

import com.alibaba.fastjson.JSONArray;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.evs.cache.EVSCache;
import com.kingdee.eas.base.evs.unitdata.billData.InvoiceDoc;
import com.kingdee.eas.base.evs.unitdata.pcloud.fpSys.AES128;
import com.kingdee.eas.base.evs.unitdata.pcloud.fpSys.FpSysHelper;
import com.kingdee.eas.base.evs.unitdata.pcloud.fpSys.MD5;
import com.kingdee.eas.base.evs.unitdata.pcloud.fpSys.PiaoPostUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class FpSysHelper_KD
extends FpSysHelper {
    private Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.evs.unitdata.pcloud.fpSys.FpSysHelper_KD");
    private static Map<String, TokenInfo> tokenInfos = new HashMap<String, TokenInfo>();
    private static String ip = "https://api.piaozone.com";
    private static final String KD_SIGN = "sign";
    private static final String KD_TIMESTAMP = "timestamp";
    private static final String KD_CLIENT_ID = "client_id";

    @Override
    public Map<InvoiceDoc, com.alibaba.fastjson.JSONObject> getInvoiceInfos(Context ctx, List<InvoiceDoc> numCodes, CompanyOrgUnitInfo orgUnitInfo) throws EASBizException {
        if (numCodes == null || numCodes.size() == 0) {
            return Collections.EMPTY_MAP;
        }
        TokenInfo tokenInfo = this.getAccessToken(ctx, orgUnitInfo);
        String url = this.getUrl(ctx, "") + "/m6/bill/invoice/serialnos/query?access_token=" + tokenInfo.getToken();
        HashMap<InvoiceDoc, com.alibaba.fastjson.JSONObject> result = new HashMap<InvoiceDoc, com.alibaba.fastjson.JSONObject>(numCodes.size());
        for (int i = 0; i < numCodes.size(); ++i) {
            InvoiceDoc invoiceDoc = numCodes.get(i);
            com.alibaba.fastjson.JSONObject param = new com.alibaba.fastjson.JSONObject();
            param.put("invoiceCode", (Object)invoiceDoc.getCode());
            param.put("invoiceNo", (Object)invoiceDoc.getNumber());
            param.put("serialNos", (Object)invoiceDoc.getSerialNum());
            this.logger.error((Object)param.toString());
            String encrypt = "";
            try {
                encrypt = AES128.encrypt(param.toString(), tokenInfo.getEncryptKey());
            }
            catch (Exception e) {
                throw new EASBizException(new NumericExceptionSubItem("00", "AES128\u52a0\u7b7e\u5931\u8d25\uff01"), (Throwable)e);
            }
            com.alibaba.fastjson.JSONObject successData = PiaoPostUtils.getSuccessJSON(url, encrypt);
            JSONArray data = (JSONArray)successData.get((Object)"data");
            if (data == null || data.isEmpty()) {
                this.logger.error((Object)(param.toString() + ":\u53d1\u7968\u7cfb\u7edf\u8fd4\u56de\u4e3a\u7a7a,\u7ee7\u7eed\u83b7\u53d6\u5176\u4ed6\u53d1\u7968\u4fe1\u606f"));
                continue;
            }
            result.put(invoiceDoc, (com.alibaba.fastjson.JSONObject)data.get(0));
        }
        return result;
    }

    protected TokenInfo getAccessToken(Context ctx, CompanyOrgUnitInfo companyInfo) throws EASBizException {
        String token;
        TokenInfo tokenInfo = tokenInfos.get((String)companyInfo.get("authorizationCode"));
        if (null != tokenInfo && !StringUtils.isEmpty((String)(token = tokenInfo.getToken(companyInfo)))) {
            return tokenInfo;
        }
        String accessToken = "";
        Map<String, String> authorizationInfo = this.getAuthorizationInfo(ctx, companyInfo);
        String sign = "";
        String timestamp = System.currentTimeMillis() + "";
        sign = authorizationInfo.get("fp.sys.kd.appAccount") + authorizationInfo.get("fp.sys.kd.appSecret") + timestamp;
        try {
            sign = MD5.md5crypt(sign);
        }
        catch (Exception e) {
            this.logger.error((Object)("\u52a0\u7b7e\u5931\u8d25" + e.getMessage()));
            throw new EASBizException(new NumericExceptionSubItem("00", "\u52a0\u7b7e\u5931\u8d25\uff01"), (Throwable)e);
        }
        String ip = this.getUrl(ctx, "");
        JSONObject param = new JSONObject();
        param.put((Object)KD_CLIENT_ID, (Object)authorizationInfo.get("fp.sys.kd.appAccount"));
        param.put((Object)KD_SIGN, (Object)sign);
        param.put((Object)KD_TIMESTAMP, (Object)timestamp);
        String access_token = "/base/oauth/token";
        String url = ip + access_token;
        int expireTime = 0;
        try {
            JSONObject successData = PiaoPostUtils.getSuccessData(url, param.toString());
            accessToken = (String)successData.get("access_token");
            Integer expireTimeS = (Integer)successData.get("expires_in");
            if (null != expireTimeS) {
                expireTime = expireTimeS;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("accessToken error:" + param.toString() + "--" + url), (Throwable)e);
            throw new EASBizException(new NumericExceptionSubItem("00", "\u53d1\u7968\u7cfb\u7edf\u8ba4\u8bc1\u7801\u5931\u8d25 " + e.getMessage() + " +,url:" + url), (Throwable)e);
        }
        TokenInfo newTokenInfo = new TokenInfo(accessToken, expireTime, authorizationInfo.get("fp.sys.kd.encryptKey"));
        tokenInfos.put(authorizationInfo.get("fp.sys.kd.appAccount"), newTokenInfo);
        return newTokenInfo;
    }

    @Override
    public void clearTokenCache() {
        tokenInfos.clear();
    }

    public String getUrl(Context ctx, String defUrl) throws EASBizException {
        String httpsEnable = EVSCache.getPropValue(ctx, "fp.sys.kd.httpsEnable");
        String ip = EVSCache.getPropValue(ctx, "fp.sys.kd.ip");
        String port = EVSCache.getPropValue(ctx, "fp.sys.kd.port");
        if (StringUtils.isEmpty((String)ip)) {
            if (StringUtils.isEmpty((String)defUrl)) {
                throw new EASBizException(new NumericExceptionSubItem("00", "\u6ca1\u6709\u914d\u7f6e\u53d1\u7968\u7cfb\u7edf\u7cfb\u7edf\u5730\u5740"));
            }
            return defUrl;
        }
        if (!ip.startsWith("http")) {
            ip = "1".equals(httpsEnable) ? "https://" + ip : "http://" + ip;
        }
        if (!StringUtils.isEmpty((String)port)) {
            ip = ip + ":" + port;
        }
        return ip;
    }

    public Map<String, String> getAuthorizationInfo(Context ctx, CompanyOrgUnitInfo orgUnitInfo) throws EASBizException {
        HashMap<String, String> result = new HashMap<String, String>(2);
        if (orgUnitInfo == null) {
            throw new EASBizException(new NumericExceptionSubItem("00", "\u7ec4\u7ec7\u4fe1\u606f\u4e3anull \u8bf7\u6392\u67e5\uff01\uff01"));
        }
        String authorizationCode = (String)orgUnitInfo.get("authorizationCode");
        String authorizationKey = (String)orgUnitInfo.get("authorizationKey");
        String encryptionKey = (String)orgUnitInfo.get("encryptionKey");
        if (StringUtils.isEmpty((String)encryptionKey)) {
            PropertyCollection properties = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(BOSObjectType.create((String)"16FD9F90")).getProperties();
            for (int i = 0; i < properties.size(); ++i) {
                if (!"encryptionKey".equals(properties.get(i).getName())) continue;
                throw new EASBizException(new NumericExceptionSubItem("00", "\u8bf7\u914d\u7f6e\u53d1\u7968\u4e91\u52a0\u5bc6\u79d8\u94a5"));
            }
            throw new EASBizException(new NumericExceptionSubItem("00", "\u7ec4\u7ec7\u4fe1\u606f\u7f3a\u5c11 \u52a0\u5bc6\u79d8\u94a5 \u5b57\u6bb5\uff0c\u8bf7\u66f4\u65b0\u57fa\u7840\u8865\u4e01 PT173177 \u6216\u66f4\u65b0\u7684\u8865\u4e01\uff0c\u5e76\u914d\u7f6e\u52a0\u5bc6\u79d8\u94a5"));
        }
        if (StringUtils.isEmpty((String)authorizationCode) || StringUtils.isEmpty((String)authorizationKey)) {
            throw new EASBizException(new NumericExceptionSubItem("00", "\u8bf7\u914d\u7f6e \u6388\u6743\u7801\uff0c\u6388\u6743\u79d8\u94a5"));
        }
        result.put("fp.sys.kd.appAccount", authorizationCode);
        result.put("fp.sys.kd.appSecret", authorizationKey);
        result.put("fp.sys.kd.encryptKey", encryptionKey);
        return result;
    }

    private class TokenInfo {
        private String token = "";
        private Date expiresTime;
        private String encryptKey;

        public TokenInfo() {
        }

        public TokenInfo(String token, int expiresT, String encryptKey) {
            this.token = token;
            this.encryptKey = encryptKey;
            expiresT = 0 == expiresT ? 5400 : expiresT;
            this.expiresTime = new Date(new Date().getTime() + (long)((expiresT - 60) * 1000));
        }

        public String getToken() {
            if (StringUtils.isEmpty((String)this.token)) {
                return "";
            }
            Date now = new Date();
            if (now.after(this.expiresTime)) {
                return "";
            }
            return this.token;
        }

        public String getToken(CompanyOrgUnitInfo companyOrgUnitInfo) {
            if (!this.encryptKey.equals(companyOrgUnitInfo.get("encryptionKey"))) {
                return "";
            }
            return this.getToken();
        }

        public String getEncryptKey() {
            return this.encryptKey;
        }
    }
}

