/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.xbrlBuild;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.evs.app.converter.ConverterManager;
import com.kingdee.eas.base.evs.app.elcertificate.BkrsInvoiceCollection;
import com.kingdee.eas.base.evs.app.elcertificate.BkrsInvoiceFactory;
import com.kingdee.eas.base.evs.util.EvsUtil;
import com.kingdee.eas.base.evs.xbrlBuild.EVSInfo;
import com.kingdee.eas.base.evs.xbrlBuild.assembler.CompanyAssemblerDecorator;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DataAssemblyEngine {
    private static Logger logger = Logger.getLogger(DataAssemblyEngine.class);

    public static Map<String, Map<String, Map<String, List<EVSInfo>>>> getDataStandards(Context ctx, CompanyOrgUnitInfo companyInfo, int periodYear, int periodNumber) throws Exception {
        ArrayList<String> fileTypes = new ArrayList<String>();
        fileTypes.add("issuerOFD");
        fileTypes.add("issuerXbrl");
        fileTypes.add("receiverJson");
        fileTypes.add("receiverXbrl");
        fileTypes.add("receiverOFD");
        return DataAssemblyEngine.getDataStandards(ctx, companyInfo, periodYear, periodNumber, fileTypes);
    }

    public static Map<String, Map<String, Map<String, List<EVSInfo>>>> getDataStandards(Context ctx, CompanyOrgUnitInfo companyInfo, int periodYear, int periodNumber, List<String> fileTypes) throws Exception {
        Map<String, Map<String, Map<String, List<EVSInfo>>>> voucherDataStandards = DataAssemblyEngine.getVoucherDataStandards(ctx, companyInfo, periodYear, periodNumber, fileTypes);
        Map<String, Map<String, Map<String, List<EVSInfo>>>> bkrsDataStandards = DataAssemblyEngine.getBkrsDataStandards(ctx, companyInfo, periodYear, periodNumber, fileTypes);
        voucherDataStandards.putAll(bkrsDataStandards);
        return voucherDataStandards;
    }

    public static Map<String, Map<String, Map<String, List<EVSInfo>>>> getVoucherDataStandards(Context ctx, CompanyOrgUnitInfo companyInfo, int periodYear, int periodNumber) throws Exception {
        ArrayList<String> fileTypes = new ArrayList<String>();
        fileTypes.add("issuerOFD");
        fileTypes.add("issuerXbrl");
        fileTypes.add("receiverJson");
        fileTypes.add("receiverXbrl");
        fileTypes.add("receiverOFD");
        return DataAssemblyEngine.getVoucherDataStandards(ctx, companyInfo, periodYear, periodNumber, fileTypes);
    }

    public static Map<String, Map<String, Map<String, List<EVSInfo>>>> getVoucherDataStandards(Context ctx, CompanyOrgUnitInfo companyInfo, int periodYear, int periodNumber, List<String> fileTypes) throws Exception {
        List<String> voucherIds = EvsUtil.getVoucherIds(ctx, companyInfo, periodYear, periodNumber);
        return DataAssemblyEngine.getVoucherDataStandards(ctx, companyInfo, periodYear, periodNumber, fileTypes, voucherIds);
    }

    public static Map<String, Map<String, Map<String, List<EVSInfo>>>> getVoucherDataStandards(Context ctx, CompanyOrgUnitInfo companyInfo, int periodYear, int periodNumber, List<String> fileTypes, List<String> voucherIds) throws Exception {
        return DataAssemblyEngine.getVoucherDataStandards(ctx, companyInfo, periodYear, periodNumber, fileTypes, voucherIds, EvsUtil.getVoucherStandardTypes(ctx));
    }

    public static Map<String, Map<String, Map<String, List<EVSInfo>>>> getVoucherDataStandards(Context ctx, CompanyOrgUnitInfo companyInfo, int periodYear, int periodNumber, List<String> fileTypes, List<String> voucherIds, List<String> standardTypes) throws BOSException, EASBizException {
        ConverterManager.voucherDataConverter(ctx, companyInfo, periodYear, periodNumber, voucherIds, standardTypes);
        HashMap<String, Map<String, Map<String, List<EVSInfo>>>> result = new HashMap<String, Map<String, Map<String, List<EVSInfo>>>>();
        HashMap<String, Object> otherParam = new HashMap<String, Object>();
        otherParam.put("voucherIds", voucherIds);
        otherParam.put("fileTypes", fileTypes);
        for (int i = 0; i < standardTypes.size(); ++i) {
            CompanyAssemblerDecorator decorator = new CompanyAssemblerDecorator(ctx, standardTypes.get(i));
            Map<String, Map<String, Map<String, List<EVSInfo>>>> dataStandards = decorator.getDataStandards(ctx, companyInfo.getTaxNumber(), periodYear, periodNumber, otherParam);
            for (Map.Entry<String, Map<String, Map<String, List<EVSInfo>>>> entry : dataStandards.entrySet()) {
                if (!result.containsKey(entry.getKey())) {
                    result.put(entry.getKey(), entry.getValue());
                    continue;
                }
                ((Map)result.get(entry.getKey())).putAll(entry.getValue());
            }
        }
        return result;
    }

    public static Map<String, Map<String, Map<String, List<EVSInfo>>>> getBkrsDataStandards(Context ctx, CompanyOrgUnitInfo companyInfo, int periodYear, int periodNumber) throws Exception {
        List<String> fileTypes = EvsUtil.getAllFileTypes(ctx);
        return DataAssemblyEngine.getBkrsDataStandards(ctx, companyInfo, periodYear, periodNumber, fileTypes);
    }

    public static Map<String, Map<String, Map<String, List<EVSInfo>>>> getBkrsDataStandards(Context ctx, CompanyOrgUnitInfo companyInfo, int periodYear, int periodNumber, List<String> fileTypes) throws BOSException, EASBizException {
        ArrayList<String> bankAccounts = new ArrayList<String>();
        BkrsInvoiceCollection bkrsInvoiceCollection = BkrsInvoiceFactory.getLocalInstance(ctx).getBkrsInvoiceCollection("select customerBankAccount where creditCode = '" + companyInfo.getTaxNumber() + "' and periodYear = '" + periodYear + "' and periodNumber = '" + periodNumber + "'");
        for (int i = 0; i < bkrsInvoiceCollection.size(); ++i) {
            bankAccounts.add(bkrsInvoiceCollection.get(i).getCustomerBankAccount());
        }
        return DataAssemblyEngine.getBkrsDataStandards(ctx, companyInfo, periodYear, periodNumber, fileTypes, bankAccounts);
    }

    public static Map<String, Map<String, Map<String, List<EVSInfo>>>> getBkrsDataStandards(Context ctx, CompanyOrgUnitInfo companyInfo, int periodYear, int periodNumber, List<String> fileTypes, List<String> bankAccounts) throws BOSException, EASBizException {
        ArrayList<String> standardTypes = new ArrayList<String>(1);
        standardTypes.add("bkrs");
        ConverterManager.getInstance().process(ctx, companyInfo, periodYear, periodNumber, bankAccounts, standardTypes);
        HashMap<String, Object> otherParam = new HashMap<String, Object>();
        otherParam.put("bankAccounts", bankAccounts);
        otherParam.put("fileTypes", fileTypes);
        CompanyAssemblerDecorator bkrs = new CompanyAssemblerDecorator(ctx, "bkrs");
        return bkrs.getDataStandards(ctx, companyInfo.getTaxNumber(), periodYear, periodNumber, otherParam);
    }
}

