/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.xbrlBuild.assembler;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.base.evs.app.elcertificate.BkrsInvoiceCollection;
import com.kingdee.eas.base.evs.app.elcertificate.BkrsInvoiceFactory;
import com.kingdee.eas.base.evs.app.elcertificate.BkrsInvoiceInfo;
import com.kingdee.eas.base.evs.util.OfdUtil;
import com.kingdee.eas.base.evs.util.SQLUtils;
import com.kingdee.eas.base.evs.xbrlBuild.AbstractEVSInfo;
import com.kingdee.eas.base.evs.xbrlBuild.EVSInfo;
import com.kingdee.eas.base.evs.xbrlBuild.IssuerOFD;
import com.kingdee.eas.base.evs.xbrlBuild.IssuerXbrl;
import com.kingdee.eas.base.evs.xbrlBuild.ReceiverJson;
import com.kingdee.eas.base.evs.xbrlBuild.ReceiverXbrl;
import com.kingdee.eas.base.evs.xbrlBuild.assembler.ICompanyAssembler;
import com.kingdee.eas.base.evs.xbrlBuild.assembler.IssureInputStreamFactory;
import com.kingdee.eas.base.evs.xbrlBuild.assembler.IssureInputStreamable;
import com.kingdee.eas.common.EASBizException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BkrsXbrlAssembler
implements ICompanyAssembler,
IssureInputStreamable {
    private static Logger logger = Logger.getLogger((String)BkrsXbrlAssembler.class.getName());

    @Override
    public IObjectCollection getOriDataCollection(Context ctx, String companyPk, int year, int month, Map<String, Object> otherParam) throws BOSException, EASBizException {
        String oql = "where periodYear = " + year + " and periodNumber = " + month + " and creditCode = '" + companyPk + "'";
        if (otherParam.containsKey("bankAccounts") && otherParam.get("bankAccounts") instanceof List) {
            List list = (List)otherParam.get("bankAccounts");
            oql = oql + " and customerBankAccount in (" + SQLUtils.getSQL(list) + ")";
        }
        return BkrsInvoiceFactory.getLocalInstance(ctx).getBkrsInvoiceCollection(oql);
    }

    @Override
    public Map<String, Map<String, Map<String, List<EVSInfo>>>> createEVSInfo(Context ctx, IObjectCollection colls, Map<String, Object> otherParam) throws EASBizException {
        HashMap<String, Map<String, Map<String, List<EVSInfo>>>> result = new HashMap<String, Map<String, Map<String, List<EVSInfo>>>>();
        BkrsInvoiceCollection bkrss = (BkrsInvoiceCollection)colls;
        List fileTypes = new ArrayList();
        if (otherParam.containsKey("fileTypes") && otherParam.get("fileTypes") instanceof List) {
            fileTypes = (List)otherParam.get("fileTypes");
        }
        for (int i = 0; i < bkrss.size(); ++i) {
            Map<String, byte[]> maps;
            Iterator<Map.Entry<String, byte[]>> iterator;
            Map<String, Object> map;
            BkrsInvoiceInfo info = bkrss.get(i);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("IdentificationCodeOfIssuer", (Object)info.getIdentificationCode());
            jsonObject.put("NumberOfBankBranch", (Object)info.getBankBranchNumber());
            jsonObject.put("Currency", (Object)info.getCurrency());
            jsonObject.put("CustomerSettlementBankAccount", (Object)info.getCustomerBankAccount());
            jsonObject.put("NameOfCustomerAccount", (Object)info.getCustomerAccountName());
            jsonObject.put("CodeOfBankCustomer", (Object)info.getBankCustomerCode());
            jsonObject.put("YearOfBankReconciliationStatement", (Object)info.getYear());
            jsonObject.put("MonthOfBankReconciliationStatement", (Object)info.getMonth());
            jsonObject.put("PrintTimes", (Object)info.getPrintTimes());
            jsonObject.put("PrintDate", (Object)info.getPrintDate());
            jsonObject.put("AccountBalanceAtTheEndOfReconciliationCycleAmount", (Object)info.getAccountBalanceEnd());
            jsonObject.put("ReserveBalanceAtTheEndOfReconciliationCycle", (Object)info.getReserveBalanceEnd());
            jsonObject.put("FrozenBalanceAtTheEndOfReconciliationCycle", (Object)info.getFrozenBalanceEnd());
            jsonObject.put("OverdraftBalanceAtEndOfReconciliationCycle", (Object)info.getOverdraftBalanceEnd());
            jsonObject.put("AvailableBalanceAtTheEndOfReconciliationCycleAmount", (Object)info.getAvailableBalanceEnd());
            jsonObject.put("InformationOfReconcileDetailsTuple", (Object)JSONArray.parseArray((String)info.getReconcileDetailsTuple()));
            for (Map.Entry entry : jsonObject.entrySet()) {
                if (entry.getValue() != null) continue;
                entry.setValue("");
            }
            String date = info.getPrintDate().replace("-", "");
            if (!result.containsKey(info.getBillPK())) {
                HashMap map1 = new HashMap();
                map1.put("bkrs", new HashMap());
                result.put(info.getBillPK(), map1);
            }
            Map typeMap = (Map)((Map)result.get(info.getBillPK())).get("bkrs");
            ArrayList<AbstractEVSInfo> evsInfos = new ArrayList<AbstractEVSInfo>();
            typeMap.put(info.getCustomerBankAccount(), evsInfos);
            if (fileTypes.contains("receiverJson")) {
                ReceiverJson receiverJson = new ReceiverJson("bkrs_receiver_" + date + "_" + info.getCustomerBankAccount() + ".json", new ByteArrayInputStream(jsonObject.toJSONString().getBytes()), "bkrs", date);
                evsInfos.add(receiverJson);
            }
            if (fileTypes.contains("receiverXbrl")) {
                ReceiverXbrl receiverXbrl = new ReceiverXbrl("bkrs_receiver_" + date + "_" + info.getCustomerBankAccount() + ".xml", new ByteArrayInputStream(OfdUtil.json2Xbrl(jsonObject, this.getCinfigId()).getBytes()), "bkrs", date);
                evsInfos.add(receiverXbrl);
            }
            ArrayList<String> billIds = new ArrayList<String>(1);
            billIds.add(info.getBillPK());
            if (fileTypes.contains("issuerXbrl") && (map = IssureInputStreamFactory.getInstance(ctx, "bkrs").getIs(ctx, billIds)) != null && !map.isEmpty()) {
                Object o = map.get(info.getBillPK());
                InputStream is = null;
                if (o != null) {
                    if (o instanceof InputStream) {
                        is = (InputStream)o;
                    } else if (o instanceof byte[]) {
                        is = new ByteArrayInputStream((byte[])o);
                    }
                }
                IssuerXbrl issuerXbrl = new IssuerXbrl("bkrs_issuer_" + date + "_" + info.getCustomerBankAccount() + ".xml", is, "bkrs", date);
                evsInfos.add(issuerXbrl);
            }
            if (!fileTypes.contains("issuerOFD") || !(iterator = (maps = this.getOfdInputStream(ctx, billIds)).entrySet().iterator()).hasNext()) continue;
            Map.Entry<String, byte[]> entry = iterator.next();
            IssuerOFD issuerOfd = new IssuerOFD("bkrs_" + date + "_" + info.getCustomerBankAccount() + ".ofd", new ByteArrayInputStream(entry.getValue()), "bkrs", date);
            evsInfos.add(issuerOfd);
        }
        return result;
    }

    @Override
    public Map<String, Object> getIs(Context ctx, List<String> billIds) {
        if (billIds.isEmpty()) {
            return null;
        }
        try {
            Map<String, byte[]> map = this.getOfdInputStream(ctx, billIds);
            if (map != null) {
                HashMap<String, Object> result = new HashMap<String, Object>(1);
                Map<String, byte[]> xbrlMap = OfdUtil.getxbrlBytes(map.get(billIds.get(0)));
                Iterator<Map.Entry<String, byte[]>> iterator = xbrlMap.entrySet().iterator();
                if (iterator.hasNext()) {
                    Map.Entry<String, byte[]> entry = iterator.next();
                    byte[] value = entry.getValue();
                    result.put(billIds.get(0), value);
                    return result;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u62ff\u6587\u4ef6\u4fe1\u606f\u51fa\u9519\uff1a" + billIds), (Throwable)e);
        }
        return null;
    }

    private Map<String, byte[]> getOfdInputStream(Context ctx, List<String> billIds) {
        try {
            Class<?> serviceClz = Class.forName("com.kingdee.eas.fm.common.ElStatementCommonHelper");
            Method method = serviceClz.getMethod("getFilesByElStateIdList", Context.class, List.class, Boolean.class);
            Map maps = (Map)method.invoke(serviceClz.newInstance(), ctx, billIds, false);
            return maps;
        }
        catch (Exception e) {
            logger.error((Object)("\u62ff\u4e0d\u5230\u6587\u4ef6\u4fe1\u606f\uff1a" + billIds), (Throwable)e);
            return null;
        }
    }

    @Override
    public String getCinfigId() {
        return "bkrs";
    }
}

