/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.job.util;

import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.bo.ParameterInfo;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.AbstractKpdlElement;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ActualParameterCollection;
import com.kingdee.bos.workflow.define.ActualParameterDef;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.ApplicationType;
import com.kingdee.bos.workflow.define.BasicType;
import com.kingdee.bos.workflow.define.DataFieldCollection;
import com.kingdee.bos.workflow.define.DataFieldDef;
import com.kingdee.bos.workflow.define.DataType;
import com.kingdee.bos.workflow.define.FormalParameterCollection;
import com.kingdee.bos.workflow.define.FormalParameterDef;
import com.kingdee.bos.workflow.define.FormalParameterMode;
import com.kingdee.bos.workflow.define.FunctionDef;
import com.kingdee.bos.workflow.define.IExecuteObject;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ProcessType;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.define.ScheduleType;
import com.kingdee.bos.workflow.define.ToolActivityDef;
import com.kingdee.eas.base.job.util.JobProcessUtil;
import com.kingdee.eas.base.job.util.JobUtils;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class JobProcessDef {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.job.util.JobProcessDef");
    private ProcessDef relatedProcessDef;

    public JobProcessDef() throws WfException {
        ProcessDef pdef;
        ScheduleDef sdef = new ScheduleDef(null);
        String sdefs = KpdlParser.scheduleToString((ScheduleDef)sdef);
        this.relatedProcessDef = pdef = KpdlParser.createJobProcess((String)"ProcessName", null, null, null, (String)sdefs, (Locale)JobProcessUtil.getCurrentLocale());
        this.relatedProcessDef.setType(ProcessType.BACKGROUNDJOB);
    }

    public JobProcessDef(ProcessDef pdef) {
        if (pdef == null) {
            throw new IllegalArgumentException();
        }
        this.relatedProcessDef = pdef;
        this.relatedProcessDef.setType(ProcessType.BACKGROUNDJOB);
        Locale currentLocale = JobProcessUtil.getCurrentLocale();
        this.relatedProcessDef.setLocale(currentLocale);
    }

    public ProcessDef getRelatedProcess() {
        return this.relatedProcessDef;
    }

    public ToolActivityDef getJobActivity() {
        ActivityCollection tempAC = this.relatedProcessDef.getActivitys();
        if (tempAC != null && tempAC.size() == 3) {
            for (int i = 0; i <= tempAC.size() - 1; ++i) {
                ActivityDef tempADEF = tempAC.get(i);
                if (tempADEF == null || !(tempADEF instanceof ToolActivityDef)) continue;
                return (ToolActivityDef)tempADEF;
            }
        }
        throw new IllegalArgumentException();
    }

    public void setName(String name) {
        try {
            this.relatedProcessDef.setName(name);
        }
        catch (Exception error) {
            ExceptionHandler.handle((Throwable)error);
        }
    }

    public void setCreated(Date date) {
        try {
            this.relatedProcessDef.getProcessHeader().setCreated(date);
        }
        catch (Exception error) {
            ExceptionHandler.handle((Throwable)error);
        }
    }

    public void setAuthor(String author) {
        try {
            this.relatedProcessDef.getProcessHeader().setAuthor(author);
        }
        catch (Exception error) {
            ExceptionHandler.handle((Throwable)error);
        }
    }

    public String getName() {
        try {
            return this.relatedProcessDef.getName();
        }
        catch (Exception error) {
            ExceptionHandler.handle((Throwable)error);
            return "";
        }
    }

    public String getID() {
        try {
            return this.relatedProcessDef.getID();
        }
        catch (Exception error) {
            ExceptionHandler.handle((Throwable)error);
            return "";
        }
    }

    public String toXml() {
        try {
            return this.relatedProcessDef.toXml();
        }
        catch (Exception error) {
            ExceptionHandler.handle((Throwable)error);
            return "";
        }
    }

    public String getFunctionName() {
        try {
            FunctionDef tempFDEF;
            ApplicationDef tempADEF;
            ToolActivityDef tempTADEF = this.getJobActivity();
            if (tempTADEF != null && (tempADEF = tempTADEF.getRelatedApplication()) != null && (tempFDEF = tempADEF.getFunction()) != null) {
                return tempFDEF.getName();
            }
            return "";
        }
        catch (Exception error) {
            ExceptionHandler.handle((Throwable)error);
            return "";
        }
    }

    public String getTaskName() {
        try {
            FunctionDef tempFDEF;
            ApplicationDef tempADEF;
            ToolActivityDef tempTADEF = this.getJobActivity();
            if (tempTADEF != null && (tempADEF = tempTADEF.getRelatedApplication()) != null && (tempFDEF = tempADEF.getFunction()) != null) {
                return tempFDEF.getName() + "-" + tempFDEF.getOperation();
            }
            return "";
        }
        catch (Exception error) {
            ExceptionHandler.handle((Throwable)error);
            return "";
        }
    }

    public void setPackage(String dstPackage) {
        if (dstPackage == null || dstPackage.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.relatedProcessDef.getProcessHeader().setPackageName(dstPackage);
    }

    public void setBizPackage(String dstbizPackage) throws WfException {
        if (dstbizPackage == null || dstbizPackage.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.relatedProcessDef.getProcessHeader().setBizPackage(dstbizPackage);
    }

    public void setDescription(String destDescription) {
        try {
            this.relatedProcessDef.getProcessHeader().setDescription(destDescription);
        }
        catch (Exception error) {
            ExceptionHandler.handle((Throwable)error);
        }
    }

    public void setTask(FunctionObjectInfo function, OperationInfo operation) {
        try {
            if (function == null || operation == null) {
                throw new IllegalArgumentException();
            }
            this.getJobActivity().getActualParameters().clear();
            FunctionDef func = new FunctionDef();
            func.setPackageName(function.getPackage());
            func.setName(function.getName());
            func.setOperation(operation.getName());
            ApplicationDef application = new ApplicationDef(this.relatedProcessDef);
            application.setFunction(func);
            application.setType(ApplicationType.TOOL);
            this.getJobActivity().setRelatedApplication(application);
            String operAlias = StringUtils.cnulls((String)operation.getAlias(this.relatedProcessDef.getLocale()), (String)operation.getName());
            Locale[] locales = JobUtils.getLocales();
            if (locales != null) {
                for (int i = 0; i <= locales.length - 1; ++i) {
                    Locale locale = locales[i];
                    String alias = operation.getAlias(locale);
                    if (alias == null) continue;
                    this.getJobActivity().setName(locale, alias);
                }
            }
            this.getJobActivity().setName(operAlias);
            ParameterCollection pc = null;
            this.relatedProcessDef.getDataFields().clear();
            if (operation.getFacadeObjectRef() != null) {
                if (operation.getFacadeMethodRef() != null) {
                    pc = operation.getFacadeMethodRef().getParameters();
                }
            } else if (operation.getEntityObjectRef() != null && operation.getEntityMethodRef() != null) {
                pc = operation.getEntityMethodRef().getParameters();
            }
            if (pc != null && pc.size() > 0) {
                for (int i = 0; i < pc.size(); ++i) {
                    ParameterInfo pi = pc.get(i);
                    DataType dt = JobProcessUtil.convertTypeReferenceToDataType(pi.getDataType());
                    DataFieldDef df = null;
                    df = new DataFieldDef(this.relatedProcessDef);
                    df.setName(pi.getName());
                    if (!StringUtils.isEmpty((String)pi.getAlias())) {
                        df.setDescription(JobProcessUtil.getCurrentLocale(), pi.getAlias());
                    }
                    df.setDataType(dt);
                    this.relatedProcessDef.addDataFieldDef(df);
                    FormalParameterDef fp = new FormalParameterDef((AbstractKpdlElement)this.relatedProcessDef);
                    fp.setName(pi.getName());
                    if (!StringUtils.isEmpty((String)pi.getAlias())) {
                        fp.setDescription(JobProcessUtil.getCurrentLocale(), pi.getAlias());
                    }
                    fp.setDataType(dt);
                    fp.setMode(FormalParameterMode.IN);
                    fp.setIndex(i);
                    application.getFormalParameters().add(fp.getID(), fp);
                    ActualParameterDef ap = new ActualParameterDef((IExecuteObject)this.relatedProcessDef);
                    ap.setExpr(df.getID());
                    ap.setIndex(i);
                    this.getJobActivity().getActualParameters().add(ap);
                }
            }
        }
        catch (Exception error) {
            ExceptionHandler.handle((Throwable)error);
        }
    }

    public void setTask(FacadeInfo facade, MethodInfo method) {
        try {
            if (facade == null || method == null) {
                throw new IllegalArgumentException();
            }
            this.getJobActivity().getActualParameters().clear();
            FunctionDef func = new FunctionDef();
            func.setPackageName(facade.getPackage());
            func.setName(facade.getName());
            func.setOperation(method.getName());
            ApplicationDef application = new ApplicationDef(this.relatedProcessDef);
            application.setFunction(func);
            application.setType(ApplicationType.TOOL);
            this.getJobActivity().setRelatedApplication(application);
            String methodAlias = StringUtils.cnulls((String)method.getAlias(), (String)method.getName());
            Locale[] locales = JobUtils.getLocales();
            if (locales != null) {
                for (int i = 0; i <= locales.length - 1; ++i) {
                    Locale locale = locales[i];
                    String alias = method.getAlias();
                    if (alias == null) continue;
                    this.getJobActivity().setName(locale, alias);
                }
            }
            this.getJobActivity().setName(methodAlias);
            ParameterCollection pc = null;
            this.relatedProcessDef.getDataFields().clear();
            pc = method.getParameters();
            if (pc != null && pc.size() > 0) {
                for (int i = 0; i < pc.size(); ++i) {
                    ParameterInfo pi = pc.get(i);
                    DataType dt = JobProcessUtil.convertTypeReferenceToDataType(pi.getDataType());
                    DataFieldDef df = null;
                    df = new DataFieldDef(this.relatedProcessDef);
                    df.setName(pi.getName());
                    if (!StringUtils.isEmpty((String)pi.getAlias())) {
                        df.setDescription(JobProcessUtil.getCurrentLocale(), pi.getAlias());
                    }
                    df.setDataType(dt);
                    this.relatedProcessDef.addDataFieldDef(df);
                    FormalParameterDef fp = new FormalParameterDef((AbstractKpdlElement)this.relatedProcessDef);
                    fp.setName(pi.getName());
                    if (!StringUtils.isEmpty((String)pi.getAlias())) {
                        fp.setDescription(JobProcessUtil.getCurrentLocale(), pi.getAlias());
                    }
                    fp.setDataType(dt);
                    fp.setMode(FormalParameterMode.IN);
                    fp.setIndex(i);
                    application.getFormalParameters().add(fp.getID(), fp);
                    ActualParameterDef ap = new ActualParameterDef((IExecuteObject)this.relatedProcessDef);
                    ap.setExpr(df.getID());
                    ap.setIndex(i);
                    this.getJobActivity().getActualParameters().add(ap);
                }
            }
        }
        catch (Exception error) {
            ExceptionHandler.handle((Throwable)error);
        }
    }

    public void setParameterValue(Map value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        DataFieldCollection dfc = this.relatedProcessDef.getDataFields();
        int count = dfc.size();
        if (dfc != null && count > 0) {
            for (int i = 0; i <= count - 1; ++i) {
                DataFieldDef df = dfc.get(i);
                String strValue = (String)value.get(df.getName());
                if (df.getDataType().equals(BasicType.BOOLEAN)) {
                    if (strValue != null) {
                        strValue = strValue.toLowerCase();
                    }
                    df.setInitValue(strValue);
                    continue;
                }
                df.setInitValue(strValue);
            }
        }
    }

    public String getScheduleExpression() {
        ScheduleDef tempSDEF = this.relatedProcessDef.getProcessHeader().getScheduale();
        if (tempSDEF != null) {
            return tempSDEF.getDefine();
        }
        return null;
    }

    public ScheduleDef getSchedule() {
        return this.relatedProcessDef.getProcessHeader().getScheduale();
    }

    public ScheduleType getScheduleType() {
        ScheduleDef tempSDEF = this.relatedProcessDef.getProcessHeader().getScheduale();
        if (tempSDEF != null) {
            return tempSDEF.getType();
        }
        return null;
    }

    public void setSchedule(ScheduleDef value) {
        this.relatedProcessDef.getProcessHeader().setScheduale(value);
    }

    public FormalParameterCollection getFormalParameters() {
        ApplicationDef ap;
        ToolActivityDef ta = this.getJobActivity();
        if (ta != null && (ap = ta.getRelatedApplication()) != null) {
            return ap.getFormalParameters();
        }
        return null;
    }

    public ActualParameterCollection getActualParameters() {
        ToolActivityDef ta = this.getJobActivity();
        if (ta != null) {
            return ta.getActualParameters();
        }
        return null;
    }

    public String getDataFieldValue(String name) {
        ProcessDef ps = this.relatedProcessDef;
        if (ps != null) {
            DataFieldCollection dc = ps.getDataFields();
            int count = dc.size();
            for (int i = 0; i <= count - 1; ++i) {
                DataFieldDef df = dc.get(i);
                if (!df.getName().equals(name)) continue;
                return df.getInitValue();
            }
        }
        return "";
    }

    public void setProcessValidateToDate(Date date) {
        if (date == null) {
            date = new Date(System.currentTimeMillis());
        }
        try {
            this.relatedProcessDef.getProcessHeader().setValidTo(date);
        }
        catch (WfException e) {
            logger.error((Object)"error:", (Throwable)e);
        }
    }

    public void setProcessValidateFromDate(Date date) {
        if (date == null) {
            date = new Date(System.currentTimeMillis());
        }
        try {
            this.relatedProcessDef.getProcessHeader().setValidFrom(date);
        }
        catch (WfException e) {
            logger.error((Object)"error:", (Throwable)e);
        }
    }

    public void setInstructionType(int buttonGroupValue) {
        if (this.getSchedule() != null) {
            this.getSchedule().setInstructionType(buttonGroupValue);
        }
    }

    public int getInstructionType() {
        if (this.getSchedule() != null) {
            return this.getSchedule().getInstructionType();
        }
        return 0;
    }
}

