/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.job.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.service.scheduler.util.SchedulerUtils;
import com.kingdee.bos.util.rpc.RpcProxy;
import com.kingdee.eas.base.job.IJobServiceUIFacade;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.quartz.CronScheduleBuilder;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.impl.triggers.SimpleTriggerImpl;

public class JobUtils {
    private static long startTM = 0L;
    private static long previousCurrentTM = 0L;

    public static Locale[] getLocales() {
        LanguageCollection langs;
        Locale[] locales = null;
        SolutionInfo solu = MetaDataLoaderFactory.getRemoteMetaDataLoader().getSolution();
        if (solu != null && (langs = solu.getLanguages()) != null) {
            locales = new Locale[langs.size()];
            for (int i = 0; i < langs.size(); ++i) {
                locales[i] = langs.get(i).getLocale();
            }
        }
        return locales;
    }

    public static boolean isWorkDay(Context ctx, String orgUnitID, Date d, boolean isCastBack) throws BOSException {
        return SchedulerUtils.isWorkDay((Context)ctx, (String)orgUnitID, (Date)d, (boolean)isCastBack);
    }

    public static void resetStartTimeMillis() {
        startTM = System.currentTimeMillis();
        previousCurrentTM = System.currentTimeMillis();
    }

    public static void printTimeMillis(String work) {
        long currentTM;
        if (startTM == 0L) {
            JobUtils.resetStartTimeMillis();
        }
        previousCurrentTM = currentTM = System.currentTimeMillis();
    }

    public static IJobServiceUIFacade getJobServiceFacade() throws BOSException {
        return (IJobServiceUIFacade)RpcProxy.wrapRequired(IJobServiceUIFacade.class);
    }

    static String narrow(String plan) {
        int i = plan.indexOf(":");
        if (i >= 0) {
            plan = plan.substring(i + 1);
        }
        return plan;
    }

    public static Date truncateDate(Date d) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return sdf.parse(sdf.format(d));
        }
        catch (ParseException e) {
            return d;
        }
    }

    public static Date getLastMissedTime(Date validFrom, Date validTo, String plan) throws ParseException {
        Trigger quartzTrigger;
        Date startDate = JobUtils.truncateDate(validFrom);
        Date expireDate = new Date(JobUtils.truncateDate(validTo).getTime() + 86400000L - 1L);
        if (plan.indexOf(32) >= 0) {
            quartzTrigger = TriggerBuilder.newTrigger().withIdentity("test", "test").forJob("test", "test").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)plan)).startAt(startDate).endAt(expireDate).build();
        } else {
            String[] array = plan.split("/");
            long interval = Long.parseLong(array[0]);
            int count = Integer.parseInt(array[1]);
            if (count <= 0) {
                count = Integer.MAX_VALUE;
            }
            quartzTrigger = TriggerBuilder.newTrigger().withIdentity("test", "test").forJob("test", "test").withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withRepeatCount(count).withIntervalInMilliseconds(interval)).startAt(startDate).endAt(expireDate).build();
        }
        if (quartzTrigger != null) {
            if (quartzTrigger instanceof CronTriggerImpl) {
                Date nextFireTime;
                Date tmp = null;
                CronTriggerImpl cti = (CronTriggerImpl)quartzTrigger;
                CronTriggerImpl c = (CronTriggerImpl)cti.clone();
                c.setEndTime(null);
                Date now = new Date();
                Date clone = (Date)now.clone();
                Date lastFireTime = null;
                while ((nextFireTime = c.getFireTimeAfter(clone)) != null) {
                    clone = nextFireTime;
                    long interval = nextFireTime.getTime() - now.getTime();
                    Date date = new Date(now.getTime() - interval - 1L);
                    if (date.before(startDate)) {
                        date = startDate;
                    }
                    if ((lastFireTime = cti.getFireTimeAfter(date)) == null || !lastFireTime.before(now)) continue;
                    break;
                }
                while (lastFireTime != null && lastFireTime.before(now)) {
                    tmp = lastFireTime;
                    lastFireTime = cti.getFireTimeAfter(lastFireTime);
                }
                return tmp;
            }
            if (quartzTrigger instanceof SimpleTriggerImpl) {
                SimpleTriggerImpl sti = (SimpleTriggerImpl)quartzTrigger;
                return sti.getFireTimeBefore(new Date());
            }
        }
        return null;
    }
}

