/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.multiapprove;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.LoginUtils;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.permission.NumberSignCollection;
import com.kingdee.eas.base.permission.NumberSignException;
import com.kingdee.eas.base.permission.NumberSignInfo;
import com.kingdee.eas.base.permission.numbersign.NumberImageSignService;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class NumberSignUtils {
    public static String findLastSignLongNumber(Context ctx, String procInstId, String currentActDefId) throws NumberSignException {
        String longNumber;
        NumberImageSignService svc = new NumberImageSignService();
        String oql = "where flowInstanceId='" + procInstId + "'";
        NumberSignCollection signs = svc.findSignInfoNoVerify(ctx, oql);
        if (signs.size() == 0) {
            return currentActDefId;
        }
        String prefix = "";
        boolean hasExpiredSign = false;
        for (int i = 0; i < signs.size(); ++i) {
            NumberSignInfo info = signs.get(i);
            String tmp = info.getLongnumber();
            if (tmp == null) continue;
            if (tmp.indexOf(currentActDefId) >= 0) {
                hasExpiredSign = true;
                continue;
            }
            if (tmp.length() <= prefix.length()) continue;
            prefix = tmp;
        }
        String string = longNumber = prefix.length() == 0 ? currentActDefId : prefix + ";" + currentActDefId;
        if (hasExpiredSign) {
            oql = "where flowInstanceId='" + procInstId + "' and longnumber like '" + longNumber + "%'";
            svc.delete(ctx, oql);
        }
        return longNumber;
    }

    public static void deleteExpiredSignInfo(Context ctx, String procInstId, String actDefId) throws BOSException, NumberSignException {
        HashSet visited;
        ProcessInstInfo procInst;
        IEnactmentService service = ctx == null ? EnactmentServiceFactory.createRemoteEnactService() : EnactmentServiceProxy.getEnacementService((Context)ctx);
        ProcessDef procDef = service.getProcessDefByDefineHashValue((procInst = service.getProcessInstInfo(procInstId)).getProcDefHashValue());
        ActivityDef actDef = procDef.getActivityDef(actDefId);
        ApproveActivityDef approveAct = NumberSignUtils.findNextApproveActivity(actDef, visited = new HashSet());
        if (approveAct == null) {
            return;
        }
        NumberSignUtils.findLastSignLongNumber(ctx, procInstId, approveAct.getID());
    }

    private static ApproveActivityDef findNextApproveActivity(ActivityDef actDef, Set visited) throws WfException {
        String id = actDef.getID();
        if (visited.contains(id)) {
            return null;
        }
        visited.add(id);
        if (actDef instanceof ApproveActivityDef) {
            return (ApproveActivityDef)actDef;
        }
        ActivityCollection activities = actDef.getPostActivities();
        if (activities == null) {
            return null;
        }
        for (int i = 0; i < activities.size(); ++i) {
            ApproveActivityDef act = NumberSignUtils.findNextApproveActivity(activities.get(i), visited);
            if (act == null) continue;
            return act;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        LoginUtils.login((String)"tcp://127.0.0.1:11034", (String)"wangj", (String)"", (String)"eas", (String)"db530", (Locale)new Locale("L2"));
        NumberSignUtils.deleteExpiredSignInfo(null, "26e35795-011c-1000-e000-76e9c0a83d06WFPCINST", "c3971d82-010d-1000-e000-0fb9c0a812dfWFACTDEF");
    }
}

