/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.multiapprove.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.returns.Delay;
import com.kingdee.bos.service.job.util.Ctx;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.AcceptOption;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.engine.core.thread.WfJobHandler;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.service.EngineUtil;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.util.ApplicationUtil;
import com.kingdee.bos.workflow.util.ProcessParamUtils;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.InputType;
import com.kingdee.eas.base.multiapprove.MultiApprove;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.base.multiapprove.MultiApproveStatusEnum;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class DeadLineAutoApprove
extends WfJobHandler
implements IJobHandler {
    private static final long serialVersionUID = -6950957563327584805L;
    private static Logger logger = Logger.getLogger(DeadLineAutoApprove.class);
    Map info;
    String procInstId;
    String actInstId;

    public DeadLineAutoApprove(Map info, String procInstId, String actInstId, String userId) {
        super(userId);
        this.info = info;
        this.procInstId = procInstId;
        this.actInstId = actInstId;
    }

    protected String getProcInstId() {
        return this.procInstId;
    }

    public void run(Context ctx) throws Exception {
        WfEngine engine;
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
        AssignmentInfo[] assigns = svc.getAssignmentByActInstId(this.actInstId);
        WfActivity act = null;
        if (assigns.length > 0 && !(act = (engine = EngineUtil.getEngine((Context)ctx)).getActivityInst(assigns[0].getActInstId())).getMeta().getState().startsWith("open.")) {
            return;
        }
        boolean oneSubmit = this.oneSubmit(act);
        HashSet<String> idSet = new HashSet<String>();
        AssignmentInfo assign = null;
        for (int index = 0; index < assigns.length; ++index) {
            AssignmentInfo tmp = assigns[index];
            if (!WfAssignmentState.ASSIGNED.equals((Object)tmp.getState()) && !WfAssignmentState.ACCEPTED.equals((Object)tmp.getState()) || !idSet.add((assign = tmp).getEmployeeId())) continue;
            MultiApproveInfo info = this.getMultiApprove(assign, svc, ctx);
            new MultiApprove(Ctx.getContext((String)ctx.getAIS(), (String)assign.getUserId(), null, null)).submit((CoreBaseInfo)info);
            if (oneSubmit) break;
        }
        if (assign == null) {
            return;
        }
        Message msg = this.getMsg(ctx, assign);
        svc.sendMessage(msg);
    }

    private boolean oneSubmit(WfActivity act) throws WfException {
        boolean b;
        if (act.enableCountersign()) {
            return false;
        }
        ActivityDef def = act.getDefinition();
        boolean bl = b = ((ApproveActivityDef)def).getAcceptOption() == AcceptOption.ALL;
        return !b;
    }

    private Message getMsg(Context ctx, AssignmentInfo assign) {
        String is_mobile;
        Map titles = (Map)this.info.get("titles");
        Map bodies = (Map)this.info.get("bodies");
        String receiver = (String)this.info.get("receivers");
        String databaseCenter = (String)this.info.get("databaseCenter");
        String solution = (String)this.info.get("solution");
        Message msg = this.createMessage(ctx, titles, bodies, receiver);
        String[] initiatorName = (String[])this.info.get("initiatorName");
        Locale[] locales = (Locale[])this.info.get("locales");
        msg.setStringHeader("databaseCenter", databaseCenter);
        msg.setStringHeader("solution", solution);
        msg.setStringHeader("sender", "WfAdmin");
        for (int ii = 0; ii < locales.length; ++ii) {
            Locale locale = locales[ii];
            msg.setLocaleStringHeader("initiatorName", initiatorName[ii], locale);
        }
        String initiatorId = (String)this.info.get("initiatorId");
        String processDefId = (String)this.info.get("processDefId");
        String processInstId = (String)this.info.get("processInstId");
        String activityDefId = (String)this.info.get("activityDefId");
        String activityInstId = (String)this.info.get("activityInstId");
        String processDefHashValue = (String)this.info.get("processDefHashValue");
        msg.setStringHeader("initiatorId", initiatorId);
        msg.setStringHeader("ProcessDefId", processDefId);
        msg.setStringHeader("ProcessInstId", processInstId);
        msg.setStringHeader("activityDefId", activityDefId);
        msg.setStringHeader("activityInstId", activityInstId);
        msg.setStringHeader("databaseCenter", databaseCenter);
        msg.setStringHeader("processDefHashValue", processDefHashValue);
        msg.setStringHeader("sourceIDs", "|" + processInstId + "|" + assign.getBizObjectIds() + "|");
        msg.setBooleanHeader("isSendCommon", true);
        String is_mail = (String)this.info.get("is_mail");
        if ("true".equals(is_mail)) {
            msg.setBooleanHeader("isSendEmail", "true".equals(is_mail));
        }
        if ("true".equals(is_mobile = (String)this.info.get("is_mobile"))) {
            msg.setBooleanHeader("isSendMobile", "true".equals(is_mobile));
        }
        return msg;
    }

    private MultiApproveInfo getMultiApprove(AssignmentInfo assign, IEnactmentService svc, Context ctx) throws WfException {
        String s;
        Map extendedAttributeMap = svc.getExtendedAttributesFromAssignment(assign.getAssignmentId());
        boolean IsMailNotifyNext = false;
        boolean IsMobelNotifyNext = false;
        if (extendedAttributeMap.get("isSendMail") != null && "true".equalsIgnoreCase((String)extendedAttributeMap.get("isSendMail"))) {
            IsMailNotifyNext = true;
        }
        if (extendedAttributeMap.get("isSendSMS") != null && "true".equalsIgnoreCase((String)extendedAttributeMap.get("isSendSMS"))) {
            IsMobelNotifyNext = true;
        }
        MultiApproveInfo info = new MultiApproveInfo();
        info.setAssignment(assign.getAssignmentId());
        info.setBillId(BOSUuid.read((String)assign.getBizObjectIds()));
        info.setExtendedProperty("businuessObjectId", assign.getBizObjectIds());
        info.setExtendedProperty("assignmentID", assign.getAssignmentId());
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)assign.getUserId()));
        info.setCreator(userInfo);
        info.setLastUpdateUser(userInfo);
        info.setExtendedProperty("isAddNew", "isAddNew");
        info.setIsMailNotifyNext(IsMailNotifyNext);
        info.setIsMobelNotifyNext(IsMobelNotifyNext);
        String opinion = (String)this.info.get("opinion");
        String language = ctx.getLocale().toString();
        String suffix = "\uff08\u81ea\u52a8\u5ba1\u6279\uff09";
        if (language.equals(LocaleUtils.locale_L1.toString()) || language.equals(LocaleUtils.locale_l1.toString()) || language.equals("en_US".toString())) {
            suffix = "(auto approve)";
        } else if (language.equals(LocaleUtils.locale_L3.toString()) || language.equals(LocaleUtils.locale_l3.toString()) || language.equals("zh_TW".toString())) {
            suffix = "\uff08\u81ea\u52d5\u5be9\u6279\uff09";
        }
        info.setOpinion(opinion + suffix);
        info.setIsPass("true".equals(this.info.get("isPass")) ? ApproveResult.PASS : ApproveResult.NOT_PASS);
        boolean isEsignature = ProcessParamUtils.isSatisfyThisParam((Context)ctx, (String)assign.getProcDefId(), (String)"esignature");
        if (isEsignature) {
            String personid = assign.getEmployeeId();
            if (personid == null) {
                personid = assign.getUserId();
            }
            String sql = "select fid from T_WFR_ESIGNATURE where fpersonid = ? and fenable='0' order by ftime desc";
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{personid});
                if (rs.next()) {
                    info.setEsignatureId(rs.getString("fid"));
                }
            }
            catch (Exception e) {
                logger.error((Object)"\u8d85\u671f\u81ea\u52a8\u5ba1\u6279\u83b7\u53d6\u7535\u5b50\u7b7e\u540d\u62a5\u9519", (Throwable)e);
            }
        }
        info.setInputType(InputType.DEADLINE);
        int i = 0;
        Object o = this.info.get("handlerOpinion");
        if (o != null && (s = o.toString().trim()).length() > 0) {
            i = Integer.parseInt(s);
        }
        info.setHandlerOpinion(i);
        info.setHandlerContent((String)this.info.get("handlerContent"));
        info.setStatus(MultiApproveStatusEnum.SUBMIT);
        return info;
    }

    private Object errorHandle(Job job, Exception e) throws Exception {
        Integer count = (Integer)job.getParameters();
        if (count == null) {
            count = new Integer(1);
        } else {
            if (count >= 5) {
                throw e;
            }
            count = new Integer(count + 1);
        }
        job.setParameters((Object)count);
        logger.warn((Object)("\u81ea\u52a8\u5ba1\u6279(" + job.getId() + ")\u83b7\u53d6\u4efb\u52a1\u5931\u8d25\uff01"), (Throwable)e);
        return new Delay(10);
    }

    private Message createMessage(Context ctx, Map titles, Map bodies, String receiver) {
        Locale[] locales;
        Message message = MessageFactory.newMessage();
        message.setDomian("kingdee.workflow");
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 0);
        message.setIntHeader("priority", 10);
        message.setIntHeader("sourceStatus", 0);
        message.setStringHeader("receiver", receiver);
        for (Locale locale : locales = ApplicationUtil.getContextLocales((Context)ctx)) {
            if (titles.get(locale) != null) {
                message.setLocaleStringHeader("title", titles.get(locale).toString(), locale);
            }
            if (bodies.get(locale) == null) continue;
            message.setLocaleStringHeader("body", bodies.get(locale).toString(), locale);
        }
        return message;
    }

    protected boolean requiresTran() {
        return false;
    }

    class AssignmentInfoComparator
    implements Comparator {
        AssignmentInfoComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 != null && obj2 != null && obj1 instanceof AssignmentInfo && obj2 instanceof AssignmentInfo) {
                AssignmentInfo info1 = (AssignmentInfo)obj1;
                AssignmentInfo info2 = (AssignmentInfo)obj2;
                return info1.getUserId().compareTo(info2.getUserId());
            }
            return 0;
        }
    }
}

