/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.multiapprove.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterCollection;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ext.Config;
import com.kingdee.bos.workflow.ext.ConfigLoader;
import com.kingdee.bos.workflow.ext.IMultiApproveServerExt;
import com.kingdee.bos.workflow.metas.IOption;
import com.kingdee.bos.workflow.metas.OptionFactory;
import com.kingdee.bos.workflow.metas.OptionInfo;
import com.kingdee.bos.workflow.metas.OptionType;
import com.kingdee.bos.workflow.metas.WorkflowLogItem;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.util.WorkflowLogUtil;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.InputType;
import com.kingdee.eas.base.multiapprove.MultiApproveControllerBeanUtil;
import com.kingdee.eas.base.multiapprove.MultiApproveHstCollection;
import com.kingdee.eas.base.multiapprove.MultiApproveHstInfo;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.base.multiapprove.MultiApproveStatusEnum;
import com.kingdee.eas.base.multiapprove.MultiapproveUtils;
import com.kingdee.eas.base.multiapprove.OptionEnum;
import com.kingdee.eas.base.multiapprove.app.AbstractMultiApproveControllerBean;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.base.wssc.IBillImageFacade;
import com.kingdee.eas.base.wssc.ImageStateEnum;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Locale;
import org.apache.log4j.Logger;

public class MultiApproveControllerBean
extends AbstractMultiApproveControllerBean {
    private static final long serialVersionUID = -2504344925244866254L;
    private static Logger log = Logger.getLogger((String)"com.kingdee.eas.base.multiapprove.app.MultiApproveControllerBean");
    private static Config extConfig = null;
    private int minBatchCount = 1000;
    private int maxBatchCount = 3000;
    private int minDay = 5;

    protected BOSObjectType getMainBOSType() {
        return BOSObjectType.create((String)"63D30103");
    }

    protected BOSObjectType getHstBOSType() {
        return BOSObjectType.create((String)"F0F145B6");
    }

    protected IORMappingDAO getMainDAO(Context ctx, Connection cn) throws BOSException {
        return new ORMappingDAO(this.getMainBOSType(), ctx, cn);
    }

    protected IORMappingDAO getHstDAO(Context ctx, Connection cn) throws BOSException {
        return new ORMappingDAO(this.getHstBOSType(), ctx, cn);
    }

    @Override
    protected IObjectCollection _getApproveList(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)billId.toString()));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return super.getMultiApproveCollection(ctx, evi);
    }

    @Override
    protected IObjectPK _approve(Context ctx, BOSUuid billId, boolean isPass, OptionEnum handlerOpinion, String opinion) throws BOSException, EASBizException {
        return this._approveWithDecision(ctx, billId, isPass, handlerOpinion.getValue(), handlerOpinion.getAlias(), opinion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadExtConfig() {
        if (extConfig != null) {
            return;
        }
        Class<MultiApproveControllerBean> clazz = MultiApproveControllerBean.class;
        synchronized (MultiApproveControllerBean.class) {
            if (extConfig != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            extConfig = new ConfigLoader().getConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private Timestamp getTime() {
        return new Timestamp(System.currentTimeMillis());
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        MultiApproveControllerBean.loadExtConfig();
        MultiApproveInfo info = (MultiApproveInfo)model;
        this.checkNull(ctx, info);
        if (!info.containsKey("inputType")) {
            info.setInputType(InputType.OTHER);
        }
        String billId = info.getBillId().toString();
        this.checkForImage(ctx, info, billId);
        String assignmentId = info.getAssignment();
        IMultiApproveServerExt ext = extConfig.getMultiApproveServerExt(billId);
        if (ext != null) {
            ext.beforeSubmit(billId, assignmentId, info, ctx);
        }
        AssignmentInfo assign = this.handleResponsible(ctx, assignmentId, info);
        this.setHandlerPositionAndOrgName(ctx, info);
        Timestamp createtime = this.getTime();
        info.setLastUpdateTime(createtime);
        info.setCreateTime(createtime);
        info.setStatus(MultiApproveStatusEnum.SUBMIT);
        super._submit(ctx, pk, model);
        this.saveOperation(info, assign, ctx);
        if (info.getCreator() != null && info.getCreator().getId() != null && !assign.getUserId().equals(info.getCreator().getId().toString())) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"47_MultiApproveControllerBean", (Locale)ctx.getLocale()) + info.getCreator() + ResourceBase.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"48_MultiApproveControllerBean", (Locale)ctx.getLocale()) + assign.getUserId() + ResourceBase.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"49_MultiApproveControllerBean", (Locale)ctx.getLocale()));
        }
        if (ext != null) {
            ext.afterSubmit(billId, assignmentId, info, ctx);
        }
        if (!WfEventListenerStateManager.getInstance().isEnable()) {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    private void checkNull(Context ctx, MultiApproveInfo info) {
        if (info.getIsPass() == null) {
            throw new RuntimeException(ResourceBase.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"50_MultiApproveControllerBean", (Locale)ctx.getLocale()) + info.getAssignment() + ResourceBase.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"51_MultiApproveControllerBean", (Locale)ctx.getLocale()));
        }
    }

    private void checkForImage(Context ctx, MultiApproveInfo info, String billId) throws BOSException {
        String cantPassWhenImageIsRescan = ConfigLoader.getConfig4Server().getString("cantPassWhenImageIsRescan", null, null);
        if ("true".equals(cantPassWhenImageIsRescan) && ApproveResult.PASS == info.getIsPass()) {
            ImageStateEnum imageStateEnum = null;
            try {
                IBillImageFacade billimage = BillImageFacadeFactory.getLocalInstance((Context)ctx);
                imageStateEnum = billimage.getImageState(null, billId);
            }
            catch (Exception e) {
                log.error((Object)("\u8c03\u7528\u5f71\u50cf\u72b6\u6001\u63a5\u53e3\u51fa\u9519" + e.getMessage()));
            }
            if (ImageStateEnum.RESCAN_IAMGE == imageStateEnum) {
                throw new BOSException("\u9000\u626b\u72b6\u6001\u4e0d\u5141\u8bb8\u5ba1\u6279\u901a\u8fc7");
            }
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MultiApproveControllerBean.loadExtConfig();
        MultiApproveInfo info = (MultiApproveInfo)model;
        IObjectPK logPk = null;
        if (null != info.getExtendedProperties() && !info.getExtendedProperties().containsKey("quickApprove") && info.getInputType() != InputType.PROC_ASSIST) {
            logPk = null != info.getExtendedProperties() && info.getExtendedProperties().containsKey("workflowLog_batchSubmit") ? WorkflowLogUtil.beginLogByLocal((Context)ctx, (WorkflowLogItem)WorkflowLogItem.TO_DO_LIST_BATCH_APPROVAL, (Object)info) : WorkflowLogUtil.beginLogByLocal((Context)ctx, (WorkflowLogItem)WorkflowLogItem.TO_DO_LIST_HANDLE, (Object)info);
        }
        this.checkNull(ctx, info);
        if (!info.containsKey("inputType")) {
            info.setInputType(InputType.OTHER);
        }
        String billId = info.getBillId().toString();
        this.checkForImage(ctx, info, billId);
        String assignmentId = info.getAssignment();
        IMultiApproveServerExt ext = extConfig.getMultiApproveServerExt(billId);
        if (ext != null) {
            ext.beforeSubmit(billId, assignmentId, info, ctx);
        }
        AssignmentInfo assign = this.handleResponsible(ctx, assignmentId, info);
        this.setHandlerPositionAndOrgName(ctx, info);
        Timestamp createtime = this.getTime();
        info.setLastUpdateTime(createtime);
        info.setCreateTime(createtime);
        IObjectPK o = super._submit(ctx, model);
        if (info.getCreator() != null && info.getCreator().getId() != null && !assign.getUserId().equals(info.getCreator().getId().toString())) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"47_MultiApproveControllerBean", (Locale)ctx.getLocale()) + info.getCreator() + ResourceBase.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"48_MultiApproveControllerBean", (Locale)ctx.getLocale()) + assign.getUserId() + ResourceBase.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"49_MultiApproveControllerBean", (Locale)ctx.getLocale()));
        }
        this.saveOperation(info, assign, ctx);
        if (ext != null) {
            ext.afterSubmit(billId, assignmentId, info, ctx);
        }
        if (!WfEventListenerStateManager.getInstance().isEnable()) {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
        WorkflowLogUtil.endLogByLocal((Context)ctx, (IObjectPK)logPk);
        return o;
    }

    public void saveOperation(MultiApproveInfo tMultiApproveInfo, AssignmentInfo assign, Context ctx) {
        try {
            IOption Wfoption = OptionFactory.getLocalInstance((Context)ctx);
            OptionInfo opinfo = new OptionInfo();
            try {
                opinfo.setOption(tMultiApproveInfo.getOpinion(new Locale("L1")), new Locale("L1"));
                opinfo.setOption(tMultiApproveInfo.getOpinion(new Locale("L2")), new Locale("L2"));
                opinfo.setOption(tMultiApproveInfo.getOpinion(new Locale("L3")), new Locale("L3"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            opinfo.setOption(tMultiApproveInfo.getOpinion());
            opinfo.setBillID(tMultiApproveInfo.getBillId());
            opinfo.setType(OptionType.MULTIAPPROVE);
            opinfo.setPersonID(BOSUuid.read((String)ctx.getCaller().toString()));
            opinfo.setNextHandlerPersonID(null);
            opinfo.setAssignmentID(BOSUuid.read((String)tMultiApproveInfo.getAssignment()));
            opinfo.setNextAssignid(null);
            opinfo.setCurrentAcinstID(BOSUuid.read((String)assign.getActInstId()));
            opinfo.setActinstID(null);
            opinfo.setResult(tMultiApproveInfo.getIsPass().getAlias() + "," + tMultiApproveInfo.getHandlerContent());
            opinfo.setProcinstID(BOSUuid.read((String)assign.getProcInstId()));
            opinfo.setCreateTime(this.getTime());
            Wfoption.addnew(opinfo);
        }
        catch (Exception e) {
            log.error((Object)"\u4fdd\u5b58\u5ba1\u6279\u8bb0\u5f55\u4fe1\u606f\u51fa\u9519", (Throwable)e);
        }
    }

    @Override
    protected boolean _hasApproveResult(Context ctx, String bosid) throws BOSException, EASBizException {
        return this.hasResult(ctx, "billId", bosid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHandlerPositionAndOrgName(Context ctx, MultiApproveInfo info) {
        try {
            BOSUuid adminOrgId;
            UserInfo u = info.getCreator();
            if (u == null) {
                u = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
            }
            if (u.getPerson() == null || u.getPerson().getId() == null || StringUtils.isEmpty((String)u.getPerson().getId().toString())) {
                return;
            }
            IObjectValue personPosition = null;
            BOSUuid primaryPositionId = null;
            String personID = u.getPerson().getId().toString();
            PositionInfo position = this.getPersonPositionByOrg(ctx, personID);
            if (position == null) {
                IORMappingDAO dao = null;
                IObjectCollection colletcion = null;
                Connection cn = null;
                try {
                    cn = EJBFactory.getConnection((Context)ctx);
                    dao = ORMappingDAO.getInstance((BOSObjectType)BOSObjectType.create((String)"0127BD68"), (Context)ctx, (Connection)cn);
                    colletcion = dao.getCollection("where person = '" + personID + "' and isprimary = 1");
                }
                catch (Exception e) {
                    log.warn((Object)("get PersonPositionCollection Error: " + e.getMessage()));
                    colletcion = null;
                }
                finally {
                    SQLUtils.cleanup((Connection)cn);
                }
                if (colletcion != null && colletcion.size() == 1) {
                    personPosition = colletcion.getObject(0);
                }
                if (personPosition == null) {
                    log.warn((Object)"MultiApproveControllerBean's method setHandlerPositionAndOrgName getPersonSition error ");
                    return;
                }
                primaryPositionId = personPosition.get("position") != null ? ((PositionInfo)personPosition.get("position")).getId() : null;
            } else {
                primaryPositionId = position.getId();
            }
            PositionInfo positionInfo = null;
            AdminOrgUnitInfo adminOrgInfo = null;
            if (primaryPositionId != null && (positionInfo = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(primaryPositionId))).getAdminOrgUnit() != null && (adminOrgId = positionInfo.getAdminOrgUnit().getId()) != null) {
                adminOrgInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrgId));
            }
            info.setOrgName(adminOrgInfo != null ? adminOrgInfo.getName() : "");
            info.setOrgDisplayName(adminOrgInfo != null ? adminOrgInfo.getDisplayName() : "");
            info.setPositionName(positionInfo != null ? positionInfo.getName() : "");
        }
        catch (Exception e) {
            log.error((Object)"\u751f\u6210\u5ba1\u6279\u4fe1\u606f\u4e2d\u5ba1\u6279\u4eba\u804c\u4f4d\u7ec4\u7ec7\u76f8\u5173\u4fe1\u606f\u51fa\u9519", (Throwable)e);
        }
    }

    private PositionInfo getPersonPositionByOrg(Context ctx, String personID) throws BOSException, EASBizException {
        PositionCollection positionCol = PersonFactory.getLocalInstance((Context)ctx).getPositions(BOSUuid.read((String)personID));
        OrgUnitInfo orgUnitInfo = (OrgUnitInfo)ctx.get((Object)"CurOU");
        if (orgUnitInfo == null) {
            return null;
        }
        BOSUuid curOu = orgUnitInfo.getId();
        for (int i = 0; i < positionCol.size(); ++i) {
            PositionInfo positioninfo = positionCol.get(i);
            BOSUuid adminOrgUnitId = positioninfo.getAdminOrgUnit().getId();
            if (curOu == null || !curOu.equals((Object)adminOrgUnitId)) continue;
            return positioninfo;
        }
        return null;
    }

    private AssignmentInfo handleResponsible(Context ctx, String assignmentId, MultiApproveInfo info) throws BOSException, EASBizException {
        PersonCollection pc;
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
        AssignmentInfo assign = svc.getAssignmentById(assignmentId);
        if (info.getCreator() != null && info.getCreator().getId() != null && !assign.getUserId().equals(info.getCreator().getId().toString())) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"47_MultiApproveControllerBean", (Locale)ctx.getLocale()) + info.getCreator() + ResourceBase.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"48_MultiApproveControllerBean", (Locale)ctx.getLocale()) + assign.getUserId() + ResourceBase.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"49_MultiApproveControllerBean", (Locale)ctx.getLocale()));
        }
        AssignmentInfo tempAssign = assign;
        while (tempAssign.getSourceAssignId() != null) {
            tempAssign = svc.getAssignmentById(tempAssign.getSourceAssignId());
        }
        String personId = tempAssign.getEmployeeId();
        if (personId != null && (pc = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection("where id='" + personId + "'")).size() > 0) {
            BOSUuid o;
            UserInfo u = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
            PersonInfo tmp = u.getPerson();
            String agentPersonId = null;
            if (tmp != null && (o = tmp.getId()) != null) {
                agentPersonId = o.toString();
            }
            if (!personId.equals(agentPersonId)) {
                String agentName = u.getName(ctx.getLocale());
                String responsibleName = pc.get(0).getName(ctx.getLocale());
                Locale[] l = new Locale[]{new Locale("l1"), new Locale("l2"), new Locale("l3")};
                for (int i = 0; i < l.length; ++i) {
                    String t = "  (" + agentName + ResourceBase.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"52_MultiApproveControllerBean", (Locale)l[i]) + responsibleName + ")";
                    String s = info.getOpinion(l[i]);
                    if (s == null) {
                        s = "";
                    }
                    if (!s.endsWith(t)) {
                        s = s + t;
                    }
                    info.setOpinion(s, l[i]);
                }
            }
        }
        return assign;
    }

    @Override
    protected boolean _isMultiApproveAdopted(Context ctx, String bostype) throws BOSException, EASBizException {
        return this.hasResult(ctx, "bosTypeStr", bostype);
    }

    @Override
    protected void _adjustMultiapproveData(Context ctx, int day, int batchCount) throws BOSException {
        log.info((Object)"MultiApproveControllerBean._adjustMultiapproveData() start!");
        if (day < this.minDay) {
            day = 5;
        }
        if (batchCount < this.minBatchCount) {
            batchCount = this.minBatchCount;
        }
        if (batchCount > this.maxBatchCount) {
            batchCount = this.maxBatchCount;
        }
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            String procInstIdSet = this.getMultiapproveIdSet(cn, batchCount, day);
            while (!StringUtils.isEmpty((String)procInstIdSet)) {
                this.adjustMultiapproveDataBatch(cn, procInstIdSet);
                procInstIdSet = this.getMultiapproveIdSet(cn, batchCount, day);
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQLException", (Throwable)e);
        }
        finally {
            try {
                cn.close();
            }
            catch (SQLException e) {
                throw new BOSException("SQLException", (Throwable)e);
            }
        }
        log.info((Object)"MultiApproveControllerBean._adjustMultiapproveData() end!");
    }

    private void adjustMultiapproveDataBatch(Connection cn, String multiapproveIdSet) throws SQLException {
        if (StringUtils.isEmpty((String)multiapproveIdSet)) {
            return;
        }
        this.clearMultiapproveDataBatch(cn, multiapproveIdSet);
        this.transferMultiapproveDataBatch(cn, multiapproveIdSet);
    }

    private void clearMultiapproveDataBatch(Connection cn, String multiapproveIdSet) throws SQLException {
        if (StringUtils.isEmpty((String)multiapproveIdSet)) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("DELETE T_BAS_MultiApproveHst");
        buffer.append(" WHERE (FID IN " + multiapproveIdSet + ")");
        String sql = buffer.toString();
        cn.prepareStatement(sql).execute();
    }

    private void transferMultiapproveDataBatch(Connection cn, String procInstIdSet) throws SQLException {
        if (StringUtils.isEmpty((String)procInstIdSet)) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("INSERT INTO  T_BAS_MultiApproveHst  (FID,FIsPass,FOpinion_L1,FOpinion_L2,FOpinion_L3,FHandlerOption,FHandlerContent,FBillID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FBosType,FControlUnitID,FNEXTHANDLERPERSONID,FASSIGNMENTID,FSTATUS,FTYPE,FNUMBER,FIsMailNotifyNext,FIsMobelNotifyNext,FOrgName_l1,FOrgName_l2,FOrgName_l3,FPositionName_l1,FPositionName_l2,FPositionName_l3,FOrgDisplayName_l1,FOrgDisplayName_l2,FOrgDisplayName_l3,FInputType) SELECT FID,FIsPass,FOpinion_L1,FOpinion_L2,FOpinion_L3,FHandlerOption,FHandlerContent\uff0cFBillID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FBosType,FControlUnitID,FNEXTHANDLERPERSONID,FASSIGNMENTID,FSTATUS,FTYPE,FNUMBER,FIsMailNotifyNext,FIsMobelNotifyNext,FOrgName_l1,FOrgName_l2,FOrgName_l3,FPositionName_l1,FPositionName_l2,FPositionName_l3,FOrgDisplayName_l1,FOrgDisplayName_l2,FOrgDisplayName_l3,FInputType FROM T_BAS_MultiApprove");
        buffer.append(" WHERE");
        buffer.append("  (FID IN " + procInstIdSet + ")");
        String sql = buffer.toString();
        cn.prepareStatement(sql).execute();
        buffer = new StringBuffer();
        buffer.append("DELETE T_BAS_MultiApprove");
        buffer.append(" WHERE (FID IN " + procInstIdSet + ")");
        sql = buffer.toString();
        cn.prepareStatement(sql).execute();
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        MultiApproveInfo info = (MultiApproveInfo)model;
        this.checkNull(ctx, info);
        info.setBosTypeStr(info.getBillId().getType().toString());
        if (info.get("handleropinion") == null) {
            info.setHandlerOpinion(0);
            info.setHandlerContent(OptionEnum.NULL.getAlias());
        }
        super._addnew(ctx, pk, (IObjectValue)info);
        if (!StringUtils.isEmpty((String)info.getAssignment())) {
            IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
            AssignmentInfo assign = svc.getAssignmentById(info.getAssignment());
            this.checkUser(ctx, info, assign);
        }
    }

    private void checkUser(Context ctx, MultiApproveInfo info, AssignmentInfo assign) throws BOSException {
        if (info.getCreator() != null && info.getCreator().getId() != null && assign.getUserId().equals(info.getCreator().getId().toString())) {
            return;
        }
        if (info.getCreator() != null && info.getCreator().getPerson() != null && info.getCreator().getPerson().getId() != null && assign.getEmployeeId().equals(info.getCreator().getPerson().getId().toString())) {
            return;
        }
        throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"53_MultiApproveControllerBean", (Locale)ctx.getLocale()) + info.getCreator() + ResourceBase.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"48_MultiApproveControllerBean", (Locale)ctx.getLocale()) + assign.getUserId() + ResourceBase.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"49_MultiApproveControllerBean", (Locale)ctx.getLocale()));
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MultiApproveInfo info = (MultiApproveInfo)model;
        this.checkNull(ctx, info);
        info.setBosTypeStr(info.getBillId().getType().toString());
        IObjectPK rtn = super._addnew(ctx, (IObjectValue)info);
        if (!StringUtils.isEmpty((String)info.getAssignment())) {
            IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
            AssignmentInfo assign = svc.getAssignmentById(info.getAssignment());
            this.checkUser(ctx, info, assign);
        }
        return rtn;
    }

    @Override
    protected void _deleteByBillId(Context ctx, String billId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)billId)) {
            throw new IllegalArgumentException();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("where");
        buffer.append(" (billId='" + billId + "')");
        String oql = buffer.toString();
        this.delete(ctx, oql);
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        return this._innerGetValue(ctx, pk, selector);
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return this._innerGetValue(ctx, pk);
    }

    protected IObjectValue _getValue(Context ctx, String oql) throws BOSException, EASBizException {
        return this._innerGetValue(ctx, oql);
    }

    @Override
    protected IObjectCollection _getCollection(Context ctx, IServiceContext svcCtx, EntityViewInfo view) throws BOSException {
        return this._innerGetCollection(ctx, svcCtx, view);
    }

    @Override
    protected IObjectCollection _getCollection(Context ctx, IServiceContext svcCtx, String oql) throws BOSException {
        return this._innerGetCollection(ctx, svcCtx, oql);
    }

    @Override
    protected IObjectCollection _getCollection(Context ctx, IServiceContext svcCtx) throws BOSException {
        return this._innerGetCollection(ctx, svcCtx);
    }

    protected IObjectPK[] _getPKList(Context ctx, FilterInfo filter, SorterItemCollection sorter) throws BOSException, EASBizException {
        return this._innerGetPKList(ctx, filter, sorter);
    }

    protected IObjectPK[] _getPKList(Context ctx, String oql) throws BOSException, EASBizException {
        return this._innerGetPKList(ctx, oql);
    }

    protected IObjectPK[] _getPKList(Context ctx) throws BOSException, EASBizException {
        return this._innerGetPKList(ctx);
    }

    protected boolean _exists(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        return this._innerExists(ctx, filter);
    }

    protected boolean _exists(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return this._innerExists(ctx, pk);
    }

    protected boolean _exists(Context ctx, String oql) throws BOSException, EASBizException {
        return this._innerExists(ctx, oql);
    }

    protected IObjectPK[] _delete(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        return this._innerDelete(ctx, filter);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._innerDelete(ctx, pk);
    }

    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        this._innerDelete(ctx, arrayPK);
    }

    protected IObjectPK[] _delete(Context ctx, String oql) throws BOSException, EASBizException {
        return this._innerDelete(ctx, oql);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._innerUpdate(ctx, pk, model);
    }

    protected void _updatePartial(Context ctx, IObjectValue model, SelectorItemCollection selector) throws BOSException, EASBizException {
        this._innerUpdatePartial(ctx, model, selector);
    }

    private IObjectPK[] concat(IObjectPK[] array1, IObjectPK[] array2) {
        int length1 = 0;
        if (array1 != null) {
            length1 = array1.length;
        }
        int length2 = 0;
        if (array2 != null) {
            length2 = array2.length;
        }
        IObjectPK[] result = new IObjectPK[length1 + length2];
        if (array1 != null && array1.length > 0) {
            System.arraycopy(array1, 0, result, 0, array1.length);
        }
        if (array2 != null && array2.length > 0) {
            System.arraycopy(array2, 0, result, length1, array2.length);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _innerUpdate(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            if (this._innerExists_Main(ctx, pk)) {
                this.getMainDAO(ctx, cn).update(pk, model);
            } else {
                this.getHstDAO(ctx, cn).update(pk, model);
            }
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _innerUpdatePartial(Context ctx, IObjectValue model, SelectorItemCollection selector) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            this.getMainDAO(ctx, cn).updatePartial(model, selector);
            this.getHstDAO(ctx, cn).updatePartial(model, selector);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IObjectValue _innerGetValue(Context ctx, IObjectPK pk) throws BOSException {
        Connection cn = null;
        try {
            IObjectValue main;
            cn = this.getConnection(ctx);
            if (this._innerExists_Main(ctx, pk) && (main = this.getMainDAO(ctx, cn).getValue(pk)) != null) {
                IObjectValue iObjectValue = main;
                return iObjectValue;
            }
            MultiApproveHstInfo hst = (MultiApproveHstInfo)this.getHstDAO(ctx, cn).getValue(pk);
            MultiApproveInfo multiApproveInfo = hst.toMultiApproveInfo();
            return multiApproveInfo;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IObjectValue _innerGetValue(Context ctx, String oql) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            IObjectValue main = this.getDAO(ctx, cn).getValue(oql);
            if (main != null) {
                IObjectValue iObjectValue = main;
                return iObjectValue;
            }
            MultiApproveHstInfo hst = (MultiApproveHstInfo)this.getHstDAO(ctx, cn).getValue(oql);
            MultiApproveInfo multiApproveInfo = hst.toMultiApproveInfo();
            return multiApproveInfo;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IObjectValue _innerGetValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException {
        Connection cn = null;
        try {
            IObjectValue main;
            cn = this.getConnection(ctx);
            if (this._innerExists_Main(ctx, pk) && (main = this.getDAO(ctx, cn).getValue(pk, selector)) != null) {
                IObjectValue iObjectValue = main;
                return iObjectValue;
            }
            MultiApproveHstInfo hst = (MultiApproveHstInfo)this.getHstDAO(ctx, cn).getValue(pk, selector);
            MultiApproveInfo multiApproveInfo = hst.toMultiApproveInfo();
            return multiApproveInfo;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    private IObjectCollection _innerGetCollection(Context ctx, IServiceContext svCtx) throws BOSException {
        return this._innerGetCollection(ctx, svCtx, (EntityViewInfo)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IObjectCollection _innerGetCollection(Context ctx, IServiceContext svCtx, EntityViewInfo view) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            FilterInfo filter = (FilterInfo)svCtx.getServiceResult("PERMISSION_SERVICE");
            FilterCollection fc = (FilterCollection)svCtx.getServiceResult("PERMISSION_ENTRYS_SERVICE");
            if (view == null) {
                view = new EntityViewInfo();
            }
            if (filter != null) {
                if (view.getFilter() == null) {
                    view.setFilter(filter);
                } else {
                    view.getFilter().mergeFilter(filter, "and");
                }
            }
            if (fc != null) {
                if (view.getEntryFilters().size() == 0) {
                    view.getEntryFilters().addObjectCollection((IObjectCollection)fc);
                } else {
                    view.getEntryFilters().merge(fc, "and");
                }
            }
            IObjectCollection main = this.getMainDAO(ctx, cn).getCollection(view);
            MultiApproveHstCollection hst = (MultiApproveHstCollection)this.getHstDAO(ctx, cn).getCollection(view);
            main.addObjectCollection((IObjectCollection)MultiapproveUtils.toMultiApproveCollection(hst));
            IObjectCollection iObjectCollection = main;
            return iObjectCollection;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    private IObjectCollection _innerGetCollection(Context ctx, IServiceContext svCtx, String oql) throws BOSException {
        EntityViewInfo view;
        try {
            view = new EntityViewInfo(oql);
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        return this._innerGetCollection(ctx, svCtx, view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IObjectPK[] _innerGetPKList(Context ctx) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            IObjectPK[] main = this.getMainDAO(ctx, cn).getPKList();
            IObjectPK[] hst = this.getHstDAO(ctx, cn).getPKList();
            IObjectPK[] iObjectPKArray = this.concat(main, hst);
            return iObjectPKArray;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IObjectPK[] _innerGetPKList(Context ctx, String oql) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            IObjectPK[] main = this.getMainDAO(ctx, cn).getPKList(oql);
            IObjectPK[] hst = this.getHstDAO(ctx, cn).getPKList(oql);
            IObjectPK[] iObjectPKArray = this.concat(main, hst);
            return iObjectPKArray;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IObjectPK[] _innerGetPKList(Context ctx, FilterInfo filter, SorterItemCollection sorter) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            IObjectPK[] main = this.getMainDAO(ctx, cn).getPKList(filter, sorter);
            IObjectPK[] hst = this.getHstDAO(ctx, cn).getPKList(filter, sorter);
            IObjectPK[] iObjectPKArray = this.concat(main, hst);
            return iObjectPKArray;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _innerExists(Context ctx, IObjectPK pk) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            boolean main = this.getMainDAO(ctx, cn).exists(pk);
            boolean hst = this.getHstDAO(ctx, cn).exists(pk);
            boolean bl = main || hst;
            return bl;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _innerExists_Main(Context ctx, IObjectPK pk) throws BOSException {
        Connection cn = null;
        try {
            boolean main;
            cn = this.getConnection(ctx);
            boolean bl = main = this.getMainDAO(ctx, cn).exists(pk);
            return bl;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _innerExists(Context ctx, FilterInfo filter) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            boolean main = this.getMainDAO(ctx, cn).exists(filter);
            boolean hst = this.getHstDAO(ctx, cn).exists(filter);
            boolean bl = main || hst;
            return bl;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _innerExists(Context ctx, String oql) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            boolean main = this.getMainDAO(ctx, cn).exists(oql);
            boolean hst = this.getHstDAO(ctx, cn).exists(oql);
            boolean bl = main || hst;
            return bl;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _innerDelete(Context ctx, IObjectPK pk) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            if (this._innerExists_Main(ctx, pk)) {
                this.getMainDAO(ctx, cn).delete(pk);
            }
            this.getHstDAO(ctx, cn).delete(pk);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IObjectPK[] _innerDelete(Context ctx, FilterInfo filter) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            IObjectPK[] main = this.getMainDAO(ctx, cn).delete(filter);
            IObjectPK[] hst = this.getHstDAO(ctx, cn).delete(filter);
            IObjectPK[] iObjectPKArray = this.concat(main, hst);
            return iObjectPKArray;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IObjectPK[] _innerDelete(Context ctx, String oql) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            IObjectPK[] main = this.getMainDAO(ctx, cn).delete(oql);
            IObjectPK[] hst = this.getHstDAO(ctx, cn).delete(oql);
            IObjectPK[] iObjectPKArray = this.concat(main, hst);
            return iObjectPKArray;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _innerDelete(Context ctx, IObjectPK[] arrayPK) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            this.getMainDAO(ctx, cn).delete(arrayPK);
            this.getHstDAO(ctx, cn).delete(arrayPK);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasResult(Context ctx, String field, String value) throws BOSException {
        boolean hasResult = false;
        BOSObjectType bosType = BOSObjectType.create((String)"63D30103");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(field, (Object)value));
        IORMappingDAO dao = null;
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            dao = ORMappingDAO.getInstance((BOSObjectType)bosType, (Context)ctx, (Connection)cn);
            hasResult = dao.exists(filter);
            if (!hasResult) {
                bosType = BOSObjectType.create((String)"F0F145B6");
                dao = ORMappingDAO.getInstance((BOSObjectType)bosType, (Context)ctx, (Connection)cn);
                hasResult = dao.exists(filter);
            }
        }
        catch (DataAccessException e) {
            log.error((Object)"hasResult throw DataAccessException error", (Throwable)e);
        }
        catch (SQLException e) {
            log.error((Object)"hasResult throw SQLException error", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        return hasResult;
    }

    private String getMultiapproveIdSet(Connection cn, int batchCount, int day) throws SQLException {
        if (cn == null) {
            throw new IllegalArgumentException();
        }
        String days = String.valueOf(day);
        String sql = "";
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT");
        buffer.append(" TOP " + batchCount);
        buffer.append(" *");
        buffer.append(" FROM T_BAS_MultiApprove");
        buffer.append(" WHERE");
        if (day > 0) {
            buffer.append(" (DATEDIFF(Day,FLastUpdateTime,GETDATE()) >= " + days + ")");
        }
        sql = buffer.toString();
        PreparedStatement ps = cn.prepareStatement(sql);
        ResultSet rs = ps.executeQuery();
        String processIds = "";
        StringBuffer buffer2 = new StringBuffer();
        while (rs.next()) {
            String processId = rs.getString("FID");
            if (buffer2.length() > 0) {
                buffer2.append("','");
            }
            buffer2.append(processId);
        }
        processIds = buffer2.toString();
        String multiapproveIdSet = "";
        if (!"".equals(processIds)) {
            StringBuffer buffer3 = new StringBuffer();
            buffer3.append("('");
            buffer3.append(processIds);
            buffer3.append("')");
            multiapproveIdSet = buffer3.toString();
        }
        log.debug((Object)("\"multiapproveIdSet\" is \"" + multiapproveIdSet + "\"!"));
        return multiapproveIdSet;
    }

    @Override
    protected void _bizSubmit(Context ctx, IObjectValue bizObject) throws BOSException, EASBizException {
        if (bizObject != null && bizObject instanceof CoreBaseInfo) {
            ctx.put((Object)"isFromWF", (Object)Boolean.TRUE);
            ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
            CoreBaseInfo vo = (CoreBaseInfo)bizObject;
            BOSUuid id = vo.getId();
            WfEventListenerStateManager.getInstance().disableEventListener();
            try {
                IBOSObject obj = BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)id.getType());
                Class[] parameterTypes = new Class[]{ObjectUuidPK.class, vo.getClass()};
                Method[] methods = obj.getClass().getMethods();
                Object[] args = new Object[]{new ObjectUuidPK(id), vo};
                Method method = null;
                for (int i = 0; i < methods.length; ++i) {
                    Method m = methods[i];
                    if (!m.getName().equals("submit") || m.getParameterTypes().length != parameterTypes.length) continue;
                    Class<?>[] params = m.getParameterTypes();
                    boolean flag = true;
                    for (int j = 0; j < params.length; ++j) {
                        if (params[j].isAssignableFrom(parameterTypes[j])) continue;
                        flag = false;
                        break;
                    }
                    if (!flag) continue;
                    method = m;
                }
                if (method != null) {
                    method.invoke((Object)obj, args);
                }
            }
            catch (IllegalArgumentException e) {
                throw new BOSException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new BOSException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof EASBizException) {
                    throw (EASBizException)t;
                }
                if (t instanceof BOSException) {
                    throw (BOSException)t;
                }
                throw new BOSException(t);
            }
            finally {
                WfEventListenerStateManager.getInstance().enableEventListener();
                ctx.put((Object)"isFromWF", (Object)Boolean.FALSE);
                ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.FALSE);
            }
        }
    }

    @Override
    protected boolean _isMailNotifyNext(Context ctx, String assignmentId) throws BOSException, EASBizException {
        CoreBaseCollection col = this.getCollection(ctx, "where assignment = '" + assignmentId + "'");
        if (col == null || col.size() <= 0) {
            return false;
        }
        for (int i = 0; i < col.size(); ++i) {
            MultiApproveInfo info = (MultiApproveInfo)col.get(i);
            if (!info.isIsMailNotifyNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean _isMobelNotifyNext(Context ctx, String assignmentId) throws BOSException, EASBizException {
        CoreBaseCollection col = this.getCollection(ctx, "where assignment = '" + assignmentId + "'");
        if (col == null || col.size() <= 0) {
            return false;
        }
        for (int i = 0; i < col.size(); ++i) {
            MultiApproveInfo info = (MultiApproveInfo)col.get(i);
            if (!info.isIsMobelNotifyNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected IObjectPK _approveWithDecision(Context ctx, BOSUuid billId, boolean isPass, int handlerOption, String handlerContent, String option) throws BOSException, EASBizException {
        MultiApproveInfo info = new MultiApproveInfo();
        info.setBillId(billId);
        if (isPass) {
            info.setIsPass(ApproveResult.PASS);
        } else {
            info.setIsPass(ApproveResult.NOT_PASS);
        }
        info.setHandlerOpinion(handlerOption);
        info.setHandlerContent(handlerContent);
        info.setOpinion(option);
        this.setHandlerPositionAndOrgName(ctx, info);
        info.setStatus(MultiApproveStatusEnum.SUBMIT);
        return super._addnew(ctx, (IObjectValue)info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _exist(Context ctx, BOSUuid id) throws BOSException {
        assert (id != null);
        boolean flag = false;
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            IORMappingDAO dao = ORMappingDAO.getInstance((BOSObjectType)id.getType(), (Context)ctx, (Connection)cn);
            flag = dao.exists((IObjectPK)new ObjectUuidPK(id));
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        return flag;
    }

    @Override
    protected String[] _batchSubmit(Context ctx, String[] billIds, String[] assignmentIds, String[] billNumbers, ApproveResult isPass, String handlerOption, String handlerContent, Object approveContent, boolean sendMail, boolean sendSMS, boolean checkPostParticipants) throws BOSException, EASBizException {
        String msg;
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
        AssignmentInfo[] assigns = new AssignmentInfo[assignmentIds.length];
        for (int i = 0; i < assigns.length; ++i) {
            assigns[i] = svc.getAssignmentById(assignmentIds[i]);
            MultiApproveControllerBeanUtil.checkAssignmentState(assigns[i]);
        }
        if (checkPostParticipants && (msg = MultiApproveControllerBeanUtil.checkPostParticipants(svc, assigns, billNumbers)) != null) {
            throw new BOSException("NeedAssignParticipantsWarnException::" + msg);
        }
        String[] results = MultiApproveControllerBeanUtil.batchSubmit(ctx, billIds, assignmentIds, isPass, handlerOption, handlerContent, approveContent, sendMail, sendSMS, this);
        return results;
    }
}

