/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.multiapprove.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.WfBizEvent;
import com.kingdee.bos.workflow.enactment.message.WfMessage;
import com.kingdee.bos.workflow.exception.AlreadyBindProcessInstanceException;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import com.kingdee.bos.workflow.message.IWfMessage;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.bos.workflow.util.ApplicationUtil;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.IPassComment;
import com.kingdee.eas.base.multiapprove.MultiApproveCollection;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.base.multiapprove.MultiApproveResultInfo;
import com.kingdee.eas.base.multiapprove.MultiApproveStatusEnum;
import com.kingdee.eas.base.multiapprove.MultiapproveUtils;
import com.kingdee.eas.base.multiapprove.OptionEnum;
import com.kingdee.eas.base.multiapprove.PassCommentFactory;
import com.kingdee.eas.base.multiapprove.PassCommentInfo;
import com.kingdee.eas.base.multiapprove.app.AbstractMultiApproveManageControllerBean;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class MultiApproveManageControllerBean
extends AbstractMultiApproveManageControllerBean {
    private static final long serialVersionUID = 6570319509352633569L;
    protected static final Logger log = Logger.getLogger((String)"com.kingdee.eas.base.multiapprove.app");

    @Override
    protected Map _multiApprove(Context ctx, Map billIds, ApproveResult isPass, OptionEnum option, String content) throws BOSException, EASBizException {
        return this._multiApproveWithDecision(ctx, billIds, isPass, option.getValue(), option.getAlias(), content);
    }

    private void checkInQueue(Context ctx, String assignmentId) throws WfException, BOSException, AlreadyBindProcessInstanceException {
        long beginTime = System.currentTimeMillis();
        boolean isInQueue = false;
        EnactmentServiceProxy service = new EnactmentServiceProxy();
        isInQueue = service.isAssignmentInQueue(assignmentId);
        if (isInQueue) {
            throw new AlreadyInProcessQueueException("Assignment[" + assignmentId + "] already put in eventQueue.");
        }
        AssignmentInfo assignmentInfo = service.getAssignmentById(assignmentId);
        if (assignmentInfo == null) {
            throw new WfException("assiment is null");
        }
        if (!WfAssignmentState.ACCEPTED.equals((Object)assignmentInfo.getState()) && !WfAssignmentState.ASSIGNED.equals((Object)assignmentInfo.getState())) {
            throw new AlreadyInProcessQueueException("Assignment[" + assignmentId + "] already put in eventQueue.");
        }
        long endTime = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u83b7\u53d6\u4efb\u52a1\u8017\u65f6:" + (endTime - beginTime)));
        }
    }

    @Override
    protected boolean _approve(Context ctx, BOSUuid billId, boolean isAgree, String approveOpinion, BOSUuid auditorId) throws BOSException, EASBizException {
        if (billId == null) {
            throw new IllegalArgumentException("BillId is null!");
        }
        if (auditorId == null) {
            auditorId = BOSUuid.read((String)ctx.getCaller().toString());
        }
        MultiApproveInfo approveInfo = new MultiApproveInfo();
        UserInfo user = new UserInfo();
        user.setId(auditorId);
        approveInfo.setCreator(user);
        if (isAgree) {
            approveInfo.setIsPass(ApproveResult.PASS);
        } else {
            approveInfo.setIsPass(ApproveResult.NOT_PASS);
        }
        CtrlUnitInfo cuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        approveInfo.setOpinion(approveOpinion);
        approveInfo.setHandlerOpinion(0);
        approveInfo.setBillId(billId);
        if (cuInfo != null) {
            approveInfo.setCU(cuInfo);
        }
        MultiApproveFactory.getLocalInstance(ctx).submit((CoreBaseInfo)approveInfo);
        return true;
    }

    @Override
    protected void _sendPassAroundMsg(Context ctx, IObjectValue multiApproveInfo, String[] recievers) throws BOSException, EASBizException {
        this._sendPassAroundMsgWithOption(ctx, multiApproveInfo, recievers, new HashMap());
    }

    private String getPassAroundSuffix(Locale locale, boolean auto) {
        if (locale.toString().toLowerCase(Locale.ENGLISH).equals("l1")) {
            return auto ? "\u3010Auto Pass Around\u3011" : "Pass Around";
        }
        if (locale.toString().toLowerCase(Locale.ENGLISH).equals("l2")) {
            return auto ? "\u3010\u81ea\u52a8\u4f20\u9605\u3011" : "\u4f20\u9605";
        }
        if (locale.toString().toLowerCase(Locale.ENGLISH).equals("l3")) {
            return auto ? "\u3010\u50b3\u95b1\u3011" : "\u81ea\u52d5\u50b3\u95b1";
        }
        return auto ? "\u3010\u81ea\u52a8\u4f20\u9605\u3011" : "\u4f20\u9605";
    }

    @Override
    protected List _getMultiApproveResult(Context ctx, String billId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)billId)) {
            throw new IllegalArgumentException();
        }
        String oql = "select id,isPass,opinion,handlerOpinion,handlerContent,createTime,creator.id,creator.number where billId='" + billId + "' order by createtime desc";
        MultiApproveCollection col = MultiApproveFactory.getLocalInstance(ctx).getMultiApproveCollection(oql);
        ArrayList<MultiApproveResultInfo> list = new ArrayList<MultiApproveResultInfo>();
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            MultiApproveInfo info = col.get(i);
            MultiApproveResultInfo resultInfo = new MultiApproveResultInfo();
            resultInfo.setApproveDate(info.getCreateTime());
            resultInfo.setApproveResult(info.getIsPass());
            resultInfo.setApproverId(info.getCreator().getId().toString());
            resultInfo.setApproverUserName(info.getCreator().getName());
            resultInfo.setHandlerOpinion(info.getHandlerContent());
            resultInfo.setHandlerOpinionKey(info.getHandlerOpinion());
            resultInfo.setMultiApproveId(info.getId().toString());
            resultInfo.setOption(info.getOpinion());
            list.add(resultInfo);
        }
        return list;
    }

    @Override
    protected Map _multiApproveWithDecision(Context ctx, Map billIds, ApproveResult isPass, int handlerOption, String handlerContent, String approveContent) throws BOSException, EASBizException {
        return this._multiApproveWithDecisionInner(ctx, billIds, isPass, handlerOption, handlerContent, approveContent);
    }

    protected Map _multiApproveWithDecisionInner(Context ctx, Map billIds, ApproveResult isPass, int handlerOption, String handlerContent, Object approveContent) throws BOSException, EASBizException {
        HashMap<String, BOSUuid> successIds = new HashMap<String, BOSUuid>(20);
        if (log.isDebugEnabled()) {
            log.info((Object)("Multiapprove Test:" + this.getClass().getClassLoader().getResource("com/kingdee/eas/base/multiapprove/app/MultiApproveManageControllerBean.class")));
        }
        long beginTime = System.currentTimeMillis();
        if (billIds != null && billIds.size() > 0) {
            BOSUuid boId = null;
            MultiApproveInfo approveInfo = null;
            CtrlUnitInfo cuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            IObjectPK approvePk = null;
            Iterator it = billIds.entrySet().iterator();
            EnactmentServiceProxy service = new EnactmentServiceProxy();
            while (it.hasNext()) {
                WfBizEvent wfEvent = new WfBizEvent();
                Map.Entry entry = it.next();
                long entryBeginTime = System.currentTimeMillis();
                if (entry.getValue() == null || entry.getValue().toString().trim().length() == 0) {
                    throw new WfException("can not get related Assignment boid:" + boId);
                }
                String assignmentId = entry.getValue().toString();
                this.checkInQueue(ctx, assignmentId);
                boId = BOSUuid.read((String)entry.getKey().toString());
                approveInfo = new MultiApproveInfo();
                approveInfo.setIsPass(isPass);
                if (approveContent instanceof Map) {
                    Map approveContentMap = (Map)approveContent;
                    for (Locale locale : approveContentMap.keySet()) {
                        approveInfo.setOpinion((String)approveContentMap.get(locale), locale);
                    }
                } else if (approveContent != null) {
                    approveInfo.setOpinion(approveContent.toString());
                }
                approveInfo.setHandlerOpinion(handlerOption);
                approveInfo.setHandlerContent(handlerContent);
                approveInfo.setBillId(boId);
                approveInfo.setAssignment(assignmentId);
                approveInfo.setStatus(MultiApproveStatusEnum.SUBMIT);
                if (cuInfo != null) {
                    approveInfo.setCU(cuInfo);
                }
                wfEvent.setId(BOSUuid.create((String)"WFBIZEVT").toString());
                wfEvent.setAssignmentId(assignmentId);
                wfEvent.setUserId(ctx.getCaller().toString());
                wfEvent.setOperationName("ActionSubmit");
                wfEvent.setFuncName("com.kingdee.eas.base.multiapprove.client.MultiApproveUIFunction");
                wfEvent.setEventName("submitEvent");
                try {
                    ServiceStateManager.getInstance().disableNextCallServices();
                    approvePk = MultiApproveFactory.getLocalInstance(ctx).submit((CoreBaseInfo)approveInfo);
                    wfEvent.setBoId(approvePk.toString());
                    service.putEventQueue(wfEvent);
                }
                catch (BOSException e) {
                    log.error((Object)e);
                }
                catch (EASBizException e) {
                    log.error((Object)e);
                }
                successIds.put(boId.toString(), approveInfo.getId());
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("approve sucessed, [billId:" + boId + "] [approveId" + approveInfo.getId() + "][assignId:" + entry.getValue().toString() + "]]"));
                log.debug((Object)("approve completed. time:[" + (System.currentTimeMillis() - entryBeginTime) + "] billId:" + boId));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("approve cost:" + (System.currentTimeMillis() - beginTime)));
        }
        return successIds;
    }

    @Override
    public Map _multiApproveWithDecision(Context ctx, Map billIds, ApproveResult isPass, int handlerOption, String handlerContent, Map approveContent) throws BOSException, EASBizException {
        return this._multiApproveWithDecisionInner(ctx, billIds, isPass, handlerOption, handlerContent, approveContent);
    }

    private void savePassAssignInfo(Context ctx, String billId, String procInstId, String passId, PersonInfo initiator, Map passaroundOption, String userId) {
        PassCommentInfo info = new PassCommentInfo();
        if (initiator == null) {
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            userInfo = this.getUserInfoById(ctx, userId, userInfo);
            info.setUserID(userInfo.getId().toString());
            info.setInitiator(userInfo.getName(ctx.getLocale()));
        } else {
            info.setUserID(initiator.getId().toString());
            info.setInitiator(initiator.getName(ctx.getLocale()));
        }
        info.setPassId(passId);
        info.setType("initiate");
        info.setBillId(billId);
        info.setProcInstId(procInstId);
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setUpdateTime(new Timestamp(System.currentTimeMillis()));
        Locale locale = new Locale("l1");
        info.setComment((String)passaroundOption.get("opinion" + locale.getDisplayName()), locale);
        locale = new Locale("l2");
        info.setComment((String)passaroundOption.get("opinion" + locale.getDisplayName()), locale);
        locale = new Locale("l3");
        info.setComment((String)passaroundOption.get("opinion" + locale.getDisplayName()), locale);
        try {
            IPassComment service = PassCommentFactory.getLocalInstance(ctx);
            service.addnew(info);
            this.addPassFeedBackRecords(ctx, service, billId, procInstId, passId, initiator, passaroundOption, userId);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void addPassFeedBackRecords(Context ctx, IPassComment pc, String billId, String procInstId, String passId, PersonInfo initiator, Map passaroundOption, String userId) throws Exception {
        List list = (List)passaroundOption.get("personIdList");
        IPerson personService = PersonFactory.getLocalInstance((Context)ctx);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        for (int i = 0; i < list.size(); ++i) {
            String personId = (String)list.get(i);
            PassCommentInfo info = new PassCommentInfo();
            if (initiator == null) {
                UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
                userInfo = this.getUserInfoById(ctx, userId, userInfo);
                info.setUserID(userInfo.getId().toString());
            } else {
                info.setUserID(initiator.getId().toString());
            }
            info.setPassId(passId);
            info.setType("feedback");
            info.setBillId(billId);
            info.setProcInstId(procInstId);
            info.setCreateTime(new Timestamp(System.currentTimeMillis()));
            info.setPersonId(personId);
            info.setCreateTime(now);
            PersonInfo personInfo = personService.getPersonInfo((IObjectPK)new ObjectStringPK(personId));
            info.setPersonName(personInfo != null ? personInfo.getName(ctx.getLocale()) : "");
            pc.addnew(info);
        }
    }

    private UserInfo getUserInfoById(Context ctx, String userId, UserInfo userInfo) {
        if ("00000000-0000-0000-0000-00000000000013B7DE7F".equals(userInfo.getId().toString())) {
            try {
                userInfo = MultiapproveUtils.getUserInfo(userId, ctx);
            }
            catch (BOSException | EASBizException e) {
                log.error((Object)("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25" + e.getMessage()), e);
            }
        }
        return userInfo;
    }

    @Override
    protected void _sendPassAroundMsgWithOption(Context ctx, IObjectValue multiApproveInfo, String[] recievers, Map passaroundOption) throws BOSException {
        if (!(multiApproveInfo instanceof MultiApproveInfo)) {
            throw new IllegalArgumentException();
        }
        if (recievers == null || recievers.length == 0 || StringUtils.isEmpty((String)recievers[0])) {
            return;
        }
        String packageName = "com.kingdee.eas.base.multiapprove.client";
        String funcName = "MultiApproveUIFunction";
        String operName = "ActionSubmit";
        MultiApproveInfo info = (MultiApproveInfo)multiApproveInfo;
        String assignId = info.getAssignment();
        EnactmentServiceProxy service = new EnactmentServiceProxy(ctx);
        AssignmentInfo assignInfo = null;
        ProcessInstInfo procInstInfo = null;
        if (assignId.endsWith("WFPCINST")) {
            AssignmentInfo[] AssignmentInfo2 = service.getAssignmentAllByProcInstId(assignId);
            if (AssignmentInfo2.length == 0) {
                procInstInfo = service.getProcessInstInfo(assignId);
            } else {
                assignInfo = AssignmentInfo2[0];
            }
        } else {
            assignInfo = service.getAssignmentById(assignId);
        }
        boolean autopass = false;
        if (passaroundOption.get("autoPassAround") != null) {
            autopass = (Boolean)passaroundOption.get("autoPassAround");
        }
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        Person person = null;
        if (autopass) {
            try {
                userInfo = MultiapproveUtils.getUserInfo(assignInfo.getUserId(), ctx);
                person = service.getPersonByUserID(assignInfo.getUserId());
            }
            catch (EASBizException e) {
                log.error((Object)("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25" + e.getMessage()), (Throwable)e);
            }
            catch (Exception e) {
                log.error((Object)("\u83b7\u53d6\u804c\u5458\u4fe1\u606f\u5931\u8d25" + e.getMessage()), (Throwable)e);
            }
        }
        PersonInfo personInfo = userInfo.getPerson();
        Locale[] locales = ApplicationUtil.getContextLocales((Context)ctx);
        if (person != null) {
            for (int i = 0; i < locales.length; ++i) {
                personInfo.setName(person.getEmployeeName(locales[i]), locales[i]);
            }
        }
        WfMessage message = new WfMessage();
        message.setContext(ctx);
        message.setContentType(this.getMessageContentType(passaroundOption));
        String sourceId = passaroundOption.get("sourceIds").toString();
        String oldpassId = sourceId.substring(sourceId.lastIndexOf(":") + 1);
        String passId = "";
        if (oldpassId.endsWith("PASSID")) {
            passId = oldpassId;
            passaroundOption.put("sourceIds", sourceId.substring(0, sourceId.lastIndexOf(":")));
        } else {
            passId = BOSUuid.create((String)"PASSID").toString();
        }
        if (assignId.endsWith("WFPCINST")) {
            String userId = null;
            if (assignInfo != null) {
                userId = assignInfo.getUserId();
            }
            this.savePassAssignInfo(ctx, info.getBillId().toString(), assignId, passId, personInfo, passaroundOption, userId);
        } else {
            this.savePassAssignInfo(ctx, info.getBillId().toString(), assignInfo.getProcInstId(), passId, personInfo, passaroundOption, assignInfo.getUserId());
        }
        for (int i = 0; i < locales.length; ++i) {
            String subject;
            Locale locale = locales[i];
            String sub = "";
            if (procInstInfo != null) {
                sub = "[" + procInstInfo.getInstTopic(locale) + "]";
            } else if (!StringUtils.isEmpty((String)assignInfo.getSubject(locale))) {
                sub = "[" + assignInfo.getSubject(locale) + "]";
            }
            String body = subject = this.getPassAroundSuffix(locale, autopass) + sub;
            if (passaroundOption != null && passaroundOption.size() > 0) {
                body = passaroundOption.get(locale) != null ? body + "\r\n\r\n" + (String)passaroundOption.get(locale) : body;
            }
            String initatorName = "";
            initatorName = personInfo == null ? userInfo.getName(locale) : personInfo.getName(locale);
            message.addContent(body, locale);
            message.addSubject(subject, locale);
            message.addInitiatorName(initatorName, locale);
        }
        message.setInitiatorId(userInfo.getId().toString());
        message.setSourceId(info.getBillId().toString());
        message.setBizPackage(packageName);
        message.setFunction(funcName);
        message.setOperation(operName);
        String reciever = "";
        for (int i = 0; i < recievers.length; ++i) {
            reciever = reciever + recievers[i] + ";";
        }
        String sourceIds = (String)passaroundOption.get("sourceIds");
        if (sourceIds != null) {
            sourceIds = sourceIds + ":" + passId;
            message.setSourceIds(sourceIds);
        }
        service.sendPassAroundMsg((IWfMessage)message, reciever);
    }

    public int getMessageContentType(Map map) {
        int type = 1;
        String is_mail = (String)map.get("is_mail");
        String is_mobile = (String)map.get("is_mobile");
        if ("true".equals(is_mail)) {
            type |= 2;
        }
        if ("true".equals(is_mobile)) {
            type |= 4;
        }
        return type;
    }
}

