/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.multiapprove.ext.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobInstanceConfig;
import com.kingdee.bos.service.job.core.JobIsolationLevel;
import com.kingdee.bos.service.job.util.Ctx;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.define.ActivityEvent;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.enactment.IWfActivity;
import com.kingdee.bos.workflow.enactment.IWfAssignment;
import com.kingdee.bos.workflow.enactment.handler.AbstractActivityEventHandler;
import com.kingdee.bos.workflow.engine.core.thread.WfJobHandler;
import com.kingdee.bos.workflow.ext.ConfigLoader;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.base.multiapprove.MultiApproveStatusEnum;
import com.kingdee.eas.base.multiapprove.ext.app.AutoApproveHandler;
import com.kingdee.eas.base.multiapprove.ext.app.AutoApproveHandler2;
import com.kingdee.util.LocaleUtils;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class AutoApproveForInitiator
extends AbstractActivityEventHandler {
    private static final long serialVersionUID = -6950957563327584805L;

    public void execute(ActivityEvent event, IWfActivity activity) throws Exception {
        if (!event.equals((Object)ActivityEvent.OnActivitiyInit)) {
            return;
        }
        if (!(activity.getDefinition() instanceof ApproveActivityDef)) {
            return;
        }
        String initiator = activity.getProcess().getInstanceInfo().getInitiatorId();
        List list = activity.getAssignments();
        AssignmentInfo assign = null;
        for (int i = 0; i < list.size(); ++i) {
            AssignmentInfo tmp = ((IWfAssignment)list.get(i)).getAssignmentInfo();
            if (!initiator.equals(tmp.getUserId())) continue;
            assign = tmp;
            break;
        }
        if (assign == null) {
            return;
        }
        String language = activity.getProcess().getContext().getLocale().getLanguage();
        String agreeAuto = "";
        String none = "";
        if (language.equals(LocaleUtils.locale_L2.toString()) || language.equals(LocaleUtils.locale_l2.toString()) || language.equals("zh_CN".toString())) {
            String opinion;
            agreeAuto = opinion = ConfigLoader.getConfig4Server().getString("auto.approve.opinion", assign.getBizObjectIds(), "\u540c\u610f\uff08\u81ea\u52a8\u5ba1\u6279\uff09");
            none = "\u65e0";
        } else if (language.equals(LocaleUtils.locale_L3.toString()) || language.equals(LocaleUtils.locale_l3.toString()) || language.equals("zh_TW".toString())) {
            agreeAuto = "\u540c\u610f\uff08\u81ea\u52d5\u5be9\u6279\uff09";
            none = "\u7121";
        } else {
            agreeAuto = "agree(auto approve)";
            none = "none";
        }
        MultiApproveInfo info = new MultiApproveInfo();
        info.setAssignment(assign.getAssignmentId());
        info.setBillId(BOSUuid.read((String)assign.getBizObjectIds()));
        info.setExtendedProperty("businuessObjectId", assign.getBizObjectIds());
        info.setExtendedProperty("assignmentID", assign.getAssignmentId());
        info.setExtendedProperty("isAddNew", "isAddNew");
        info.setIsMailNotifyNext(false);
        info.setIsMobelNotifyNext(false);
        info.setOpinion(agreeAuto);
        info.setIsPass(ApproveResult.PASS);
        info.setHandlerOpinion(0);
        info.setHandlerContent(none);
        info.setStatus(MultiApproveStatusEnum.SUBMIT);
        AutoApproveHandler2 h = new AutoApproveHandler2(info, assign.getProcInstId(), assign.getUserId());
        if (WfJobHandler.join((WfJobHandler)h)) {
            return;
        }
        Context ctx = Ctx.generateContext((String)activity.getContext().getAIS(), (String)assign.getUserId(), null, null);
        ctx.setLocale(new Locale(language));
        JobInstanceConfig cfg = new JobInstanceConfig((IJobHandler)new AutoApproveHandler(), true, true, 500, null, null, JobIsolationLevel.Instance);
        Job job = new Job(ctx, "~\u81ea\u52a8\u5ba1\u6279(" + assign.getAssignmentId() + ")", cfg, (Object)info);
        int delay = ConfigLoader.getConfig4Server().getInt("auto.approve.delay", assign.getBizObjectIds(), "0") * 1000;
        job.setScheduledTime(new Date(System.currentTimeMillis() + (long)delay));
        JobServiceFactory.getLocalInstance((Context)ctx).createJobInstance(job);
    }
}

