/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.netctrl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.netctrl.ObjectUpdateLock;
import com.kingdee.eas.base.netctrl.app.IMutexService;
import com.kingdee.eas.base.netctrl.dao.MutexServiceDaoImpl;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class MutexServiceDB
implements IMutexService {
    private static Logger logger = Logger.getLogger(MutexServiceDB.class);
    private Map mutexList;

    private MutexServiceDB() {
    }

    public static IMutexService getInstance() {
        return new MutexServiceDB();
    }

    @Override
    public boolean requestMutex(Context ctx, MutexParameter mutexParameter) throws BOSException {
        logger.error((Object)(" mutexParameter = " + mutexParameter));
        this.mutexList = MutexServiceDaoImpl.getInstance(ctx).getMutexList(mutexParameter.getMutexName(), ctx.getAIS());
        logger.error((Object)("mutexParameter.getMutexName() = " + mutexParameter.getMutexName() + " mutexList.size = " + this.mutexList.size()));
        Collection values = this.mutexList.values();
        MutexParameter currentLock2 = null;
        for (MutexParameter currentLock2 : values) {
            logger.error((Object)("currentLock =  " + currentLock2));
            if (currentLock2.getOrgUnitID() == null) {
                if (currentLock2.getMutexLockType() == MutexLockType.EXCLUSIVE_LOCK) {
                    return false;
                }
                if (mutexParameter.getMutexLockType() != MutexLockType.EXCLUSIVE_LOCK) break;
                return false;
            }
            if (mutexParameter.getOrgUnitID() != null) {
                if (!StringUtils.equalsIgnoreCase((String)currentLock2.getOrgUnitID().toString().trim(), (String)StringUtils.cnulls((Object)mutexParameter.getOrgUnitID()).toString().trim())) continue;
                if (currentLock2.getMutexLockType() == MutexLockType.EXCLUSIVE_LOCK) {
                    return false;
                }
                if (mutexParameter.getMutexLockType() != MutexLockType.EXCLUSIVE_LOCK) break;
                return false;
            }
            if (mutexParameter.getOrgUnitID() != null) continue;
            if (mutexParameter.getMutexLockType() == MutexLockType.EXCLUSIVE_LOCK) {
                return false;
            }
            if (currentLock2.getMutexLockType() != MutexLockType.EXCLUSIVE_LOCK) continue;
            return false;
        }
        mutexParameter.setCreateTime(new Date());
        mutexParameter.setAIX(ctx.getAIS());
        mutexParameter.setSessionID(this.getSessionIDFromContext(ctx));
        MutexServiceDaoImpl.getInstance(ctx).addNewFuctionMutex(mutexParameter);
        return true;
    }

    @Override
    public void releaseMutex(Context ctx, Uuid requestId) throws BOSException {
        MutexServiceDaoImpl.getInstance(ctx).releaseMutex(requestId.toString());
    }

    @Override
    public Map getMutexList(Context ctx) throws BOSException {
        return MutexServiceDaoImpl.getInstance(ctx).getMutexList();
    }

    @Override
    public void clearAllMutex(Context ctx) throws BOSException {
        MutexServiceDaoImpl.getInstance(ctx).clearAllMutex();
    }

    @Override
    public void delMutex(Context ctx, String requestId) throws BOSException {
        MutexServiceDaoImpl.getInstance(ctx).delMutex(requestId);
    }

    @Override
    public Map getObjIDForUpdateList(Context ctx) throws BOSException {
        return MutexServiceDaoImpl.getInstance(ctx).getObjIDForUpdateList();
    }

    @Override
    public void delObjIDForUpdate(Context ctx, String id) throws BOSException {
        String objID = id;
        if (id.indexOf(ctx.getAIS()) != -1) {
            objID = id.replaceAll(ctx.getAIS(), "").trim();
        }
        MutexServiceDaoImpl.getInstance(ctx).releaseObjIDForUpdate(objID, ctx.getAIS());
    }

    @Override
    public boolean requestObjIDForUpdate(Context ctx, String id) throws BOSException {
        return this.requestObjIDForUpdate(ctx, id, true);
    }

    private String getObjectNumber(Context ctx, String id) {
        try {
            IMutexServiceControl ms = MutexServiceControlFactory.getLocalInstance(ctx);
            String strNumber = ms.getObjectNumber(id);
            if (strNumber == null) {
                strNumber = "";
            }
            return strNumber;
        }
        catch (BOSException e) {
            return "";
        }
    }

    @Override
    public boolean requestObjIDForUpdate(Context ctx, String id, boolean isBatchRequest) throws BOSException {
        String key;
        Map objLockList = MutexServiceDaoImpl.getInstance(ctx).getObjIDForUpdateList(id);
        if (objLockList.containsKey(key = id + ctx.getAIS())) {
            ObjectUpdateLock lock = (ObjectUpdateLock)objLockList.get(key);
            return lock.getContextID() != null && lock.getContextID().trim().length() > 0 && lock.getContextID().equals(ctx.getContextID()) && isBatchRequest;
        }
        ObjectUpdateLock objLock = new ObjectUpdateLock(ctx.getUserName(), new Date(), ctx.getAIS(), ctx.getContextID());
        if (ContextUtil.getCurrentOrgUnit((Context)ctx) != null) {
            objLock.setOrgUnitID(ContextUtil.getCurrentOrgUnit((Context)ctx).getId());
        }
        objLock.setObjectID(id);
        String objNumber = this.getObjectNumber(ctx, id);
        objLock.setObjNumber(objNumber);
        MutexServiceDaoImpl.getInstance(ctx).addNewObjUpdateMutex(objLock);
        return true;
    }

    @Override
    public boolean requestBizObjIDForUpdate(Context ctx, String id) throws BOSException {
        String key;
        Map objLockList = MutexServiceDaoImpl.getInstance(ctx).getObjIDForUpdateList(id);
        if (objLockList.containsKey(key = id + ctx.getAIS())) {
            ObjectUpdateLock lock = (ObjectUpdateLock)objLockList.get(key);
            if (lock.getContextID() != null && lock.getContextID().trim().length() > 0 && lock.getContextID().equals(ctx.getContextID())) {
                return false;
            }
            return false;
        }
        ObjectUpdateLock objLock = new ObjectUpdateLock(ctx.getUserName(), new Date(), ctx.getAIS(), ctx.getContextID());
        if (ContextUtil.getCurrentOrgUnit((Context)ctx) != null) {
            objLock.setOrgUnitID(ContextUtil.getCurrentOrgUnit((Context)ctx).getId());
        }
        objLock.setObjectID(id);
        String objNumber = this.getObjectNumber(ctx, id);
        objLock.setObjNumber(objNumber);
        MutexServiceDaoImpl.getInstance(ctx).addNewObjUpdateMutex(objLock);
        return true;
    }

    @Override
    public boolean requestObjIDForUpdate(Context ctx, String id, String userId) throws BOSException {
        return this.requestObjIDForUpdate(ctx, id, userId, ctx.getAIS(), null);
    }

    @Override
    public boolean requestObjIDForUpdate(Context ctx, String id, String userId, String dcName) throws BOSException {
        return this.requestObjIDForUpdate(ctx, id, userId, ctx.getAIS(), null);
    }

    @Override
    public boolean requestObjIDForUpdate(Context ctx, String id, String userId, String dcName, String objectDescription) throws BOSException {
        String key;
        Map objLockList = MutexServiceDaoImpl.getInstance(ctx).getObjIDForUpdateList(id);
        if (objLockList.containsKey(key = id + ctx.getAIS())) {
            ObjectUpdateLock lock = (ObjectUpdateLock)objLockList.get(key);
            return lock.getContextID() != null && lock.getContextID().trim().length() > 0 && lock.getContextID().equals(ctx.getContextID());
        }
        ObjectUpdateLock objLock = new ObjectUpdateLock(userId, new Date(), dcName, objectDescription, ctx.getContextID());
        if (ContextUtil.getCurrentOrgUnit((Context)ctx) != null) {
            objLock.setOrgUnitID(ContextUtil.getCurrentOrgUnit((Context)ctx).getId());
        }
        objLock.setObjectID(id);
        String objNumber = this.getObjectNumber(ctx, id);
        objLock.setObjNumber(objNumber);
        MutexServiceDaoImpl.getInstance(ctx).addNewObjUpdateMutex(objLock);
        return true;
    }

    @Override
    public boolean requestObjIDForUpdate(Context ctx, String id, String userId, Uuid uuid) throws BOSException {
        String key;
        Map objLockList = MutexServiceDaoImpl.getInstance(ctx).getObjIDForUpdateList(id);
        if (objLockList.containsKey(key = id + ctx.getAIS())) {
            if (uuid == null) {
                return false;
            }
            ObjectUpdateLock lock = (ObjectUpdateLock)objLockList.get(key);
            if (lock.getUuid() == null) {
                return false;
            }
            return lock.getUuid().toString().equals(uuid.toString());
        }
        String objNumber = this.getObjectNumber(ctx, id);
        if (uuid == null) {
            ObjectUpdateLock objLock = new ObjectUpdateLock(userId, new Date(), ctx.getContextID());
            if (ContextUtil.getCurrentOrgUnit((Context)ctx) != null) {
                objLock.setOrgUnitID(ContextUtil.getCurrentOrgUnit((Context)ctx).getId());
            }
            objLock.setObjectID(id);
            objLock.setObjNumber(objNumber);
            MutexServiceDaoImpl.getInstance(ctx).addNewObjUpdateMutex(objLock);
        } else {
            ObjectUpdateLock objLock = new ObjectUpdateLock(userId, new Date(), uuid, ctx.getContextID());
            if (ContextUtil.getCurrentOrgUnit((Context)ctx) != null) {
                objLock.setOrgUnitID(ContextUtil.getCurrentOrgUnit((Context)ctx).getId());
            }
            objLock.setObjectID(id);
            objLock.setObjNumber(objNumber);
            MutexServiceDaoImpl.getInstance(ctx).addNewObjUpdateMutex(objLock);
        }
        return true;
    }

    @Override
    public void releaseObjIDForUpdate(Context ctx, String objID) throws BOSException {
        MutexServiceDaoImpl.getInstance(ctx).releaseObjIDForUpdate(objID, ctx.getAIS());
    }

    @Override
    public void releaseObjIDForUpdate(Context ctx, String id, Uuid uuid) throws BOSException {
        MutexServiceDaoImpl.getInstance(ctx).releaseObjIDForUpdate(id, ctx.getAIS());
    }

    @Override
    public void clearAllObjId(Context ctx) throws BOSException {
        MutexServiceDaoImpl.getInstance(ctx).clearAllObjId();
    }

    @Override
    public void releaseAllFuncMutexAndObjLocks(Context ctx, String sessionID) throws BOSException {
        String sid = sessionID;
        if (sid == null) {
            sid = this.getSessionIDFromContext(ctx);
        }
        MutexServiceDaoImpl.getInstance(ctx).releaseAllFuncMutexAndObjLocks(sid);
    }

    private String getSessionIDFromContext(Context ctx) {
        return ctx.getContextID();
    }

    @Override
    public ObjectUpdateLock getObjectUpdateLock(Context ctx, String id) throws BOSException {
        return MutexServiceDaoImpl.getInstance(ctx).getObjectUpdateLockByObjectID(id);
    }
}

