/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.report;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.report.IReportServer;
import com.kingdee.eas.base.report.ReportBase;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.VirtualRowSet;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import java.util.HashMap;

public class DefaultReportImp
extends ReportBase {
    protected Integer sortClickType;
    protected Integer totalRowCount;
    protected Boolean isSort;
    private Context webContext;
    protected String tableName;

    public Integer getSortClickType() {
        return this.sortClickType;
    }

    @Override
    public Integer sortClickType() {
        return this.getSortClickType();
    }

    public Integer getTotalRowCount() {
        return this.totalRowCount;
    }

    @Override
    public Integer totalRowCount() {
        return this.getTotalRowCount();
    }

    public Boolean getIsSort() {
        return this.isSort;
    }

    @Override
    public Boolean isSort() {
        return this.getIsSort();
    }

    @Override
    public void setWebContext(Context webContext) {
        this.webContext = webContext;
    }

    public Context getWebContext() {
        return this.webContext;
    }

    @Override
    public void Refresh() throws Exception {
        this.innerRefresh();
    }

    protected void innerRefresh() throws BOSException, Exception {
        IReportServer server = (IReportServer)BOSObjectFactory.createRemoteBOSObject((String)this.reportProperty.getRptSvrClassName(), IReportServer.class);
        server.setWebContext(this.webContext);
        HashMap result = this.getReportProperty().isVirtualMode() ? server.prepareData(this.reportProperty.getReportID(), this.getFilter(), this.tableName) : server.getData(this.reportProperty.getReportID(), this.getFilter());
        this.setReportData(result);
    }

    @Override
    public ReportTitles getReportTitles(String reportID, RptParams params) throws BOSException, Exception {
        IReportServer server = (IReportServer)BOSObjectFactory.createRemoteBOSObject((String)this.reportProperty.getRptSvrClassName(), IReportServer.class);
        server.setWebContext(this.webContext);
        return server.getReportTitlesExt(reportID, params);
    }

    protected void setReportData(HashMap result) {
        this.data = new VirtualRowSet();
        if (this.getReportProperty().isVirtualMode()) {
            this.tableName = (String)result.get("tablename");
        } else {
            this.data.addAllData((IRowSet)result.get("reportdata"));
        }
        this.reportHeader = (ReportHeader)result.get("reportheader");
        this.reportTitles = (ReportTitles)result.get("reporttitle");
        this.reportFormatConditions = (ReportFormatConditions)result.get("reportformatconditions");
        this.isSort = (Boolean)result.get("issort");
        this.totalRowCount = (Integer)result.get("totalrowcount");
        this.sortClickType = (Integer)result.get("sortclicktype");
    }

    @Override
    public IRowSet getDataForOnePage(int start, int rows) throws Exception {
        IReportServer server = (IReportServer)BOSObjectFactory.createRemoteBOSObject((String)this.reportProperty.getRptSvrClassName(), IReportServer.class);
        server.setWebContext(this.webContext);
        IRowSet rs = server.getDataForOnePage(this.reportProperty.getReportID(), this.getFilter(), this.tableName, start, rows);
        return rs;
    }

    @Override
    public void closeReport() throws BaseException {
        this.dropTempTable();
    }

    protected void dropTempTable() throws BaseException {
        if (this.getReportProperty().isVirtualMode()) {
            IReportServer server = (IReportServer)BOSObjectFactory.createRemoteBOSObject((String)this.reportProperty.getRptSvrClassName(), IReportServer.class);
            if (this.tableName == null || this.tableName.trim().length() == 0) {
                return;
            }
            server.setWebContext(this.webContext);
            server.dropTempTable(this.reportProperty.getReportID(), this.getFilter(), this.tableName);
        }
    }

    @Override
    public IRowSet getData(int start, int rows) throws Exception {
        if (this.getReportProperty().isVirtualMode() && !this.data.isExists(start)) {
            IRowSet rs = this.getDataForOnePage(start, rows);
            this.data.addOnePageData(start, rows, rs);
        }
        return super.getData(start, rows);
    }

    @Override
    public IRowSet getData() {
        return this.data;
    }

    @Override
    public IRowSet getHiberarchyData(String reportID, RptParams filter, HashMap rowData) throws BaseException {
        IReportServer server = (IReportServer)BOSObjectFactory.createRemoteBOSObject((String)this.reportProperty.getRptSvrClassName(), IReportServer.class);
        server.setWebContext(this.webContext);
        IRowSet rs = server.getHiberarchyData(this.reportProperty.getReportID(), this.getFilter(), rowData);
        return rs;
    }

    @Override
    public Integer getRowCount() throws BOSException {
        int rowCount = 0;
        IReportServer server = (IReportServer)BOSObjectFactory.createRemoteBOSObject((String)this.reportProperty.getRptSvrClassName(), IReportServer.class);
        server.setWebContext(this.webContext);
        rowCount = server.getRowCount(this.tableName);
        if (!this.getReportProperty().isVirtualMode() && rowCount > 0) {
            rowCount = this.data.size();
        }
        return rowCount;
    }
}

