/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.report;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.ReportTreeBase;
import com.kingdee.eas.base.report.ReportTreeNode;
import com.kingdee.eas.base.report.ReportTreeNodeInfo;
import com.kingdee.eas.base.report.VirtualRowSet;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DefaultTreeReportImp
extends ReportTreeBase {
    protected String tableName;

    @Override
    public void Refresh() throws Exception {
        this.innerRefresh();
    }

    protected void innerRefresh() throws BOSException, Exception {
        RptParams filter = this.getFilter();
        if (filter == null || filter.getObject("current_node_info") == null || !(filter.getObject("current_node_info") instanceof ReportTreeNodeInfo)) {
            return;
        }
        ReportTreeNodeInfo treeNodeInfo = (ReportTreeNodeInfo)filter.getObject("current_node_info");
        String key = treeNodeInfo.getId();
        HashMap result = new HashMap();
        if (this.cacheSimpleDataSource.containsKey(key)) {
            result = (HashMap)this.cacheSimpleDataSource.get(key);
        } else {
            result = this.getReportProperty().isVirtualMode() ? this.getServerInterface().prepareData(this.reportProperty.getReportID(), filter, this.tableName) : this.getServerInterface().getData(this.reportProperty.getReportID(), filter);
            this.cacheSimpleDataSource.put(key, result);
        }
        this.setReportData(result);
    }

    protected void setReportData(HashMap result) {
        this.data = new VirtualRowSet();
        if (this.getReportProperty().isVirtualMode()) {
            this.tableName = (String)result.get("tablename");
        } else {
            this.data.addAllData((IRowSet)result.get("reportdata"));
        }
        this.reportHeader = (ReportHeader)result.get("reportheader");
        this.reportTitles = (ReportTitles)result.get("reporttitle");
        this.reportFormatConditions = (ReportFormatConditions)result.get("reportformatconditions");
    }

    @Override
    public IRowSet getDataForOnePage(int start, int rows) throws Exception {
        IRowSet rs = null;
        rs = this.getServerInterface().getDataForOnePage(this.reportProperty.getReportID(), this.filter, this.tableName, start, rows);
        return rs;
    }

    @Override
    public void closeReport() throws BaseException {
        this.dropTempTable();
    }

    protected void dropTempTable() throws BaseException {
        if (this.getReportProperty().isVirtualMode()) {
            if (this.tableName == null || this.tableName.trim().length() == 0) {
                return;
            }
            this.getServerInterface().dropTempTable(this.reportProperty.getReportID(), this.getFilter(), this.tableName);
        }
    }

    @Override
    public IRowSet getData(int start, int rows) throws Exception {
        RptParams filter;
        if (this.getReportProperty().isVirtualMode() && (filter = this.getFilter()) != null && filter.getObject("current_node_info") != null) {
            ReportTreeNodeInfo nodeInfo = (ReportTreeNodeInfo)filter.getObject("current_node_info");
            String key = nodeInfo.getId();
            this.data = this.cacheDataSource.containsKey(key) ? (VirtualRowSet)this.cacheDataSource.get(key) : new VirtualRowSet();
            if (!this.data.isExists(start)) {
                IRowSet rs = this.getDataForOnePage(start, rows);
                this.data.addOnePageData(start, rows, rs);
            }
            this.removeOtioseData(key);
            this.cacheDataSource.put(key, this.data);
        }
        return super.getData(start, rows);
    }

    @Override
    public IRowSet getData() {
        return this.data;
    }

    @Override
    public IRowSet getHiberarchyData(String reportID, RptParams filter, HashMap rowData) throws BaseException {
        IRowSet rs = this.getServerInterface().getHiberarchyData(this.reportProperty.getReportID(), this.getFilter(), rowData);
        return rs;
    }

    @Override
    protected List doExpandNode(ReportTreeNode node) {
        List childList = new ArrayList();
        try {
            if (node.isNeedExpanded()) {
                ReportTreeNodeInfo nodeInfo = (ReportTreeNodeInfo)node.getUserObject();
                childList = this.getServerInterface().getChildReportTreeNodeData(this.reportProperty.getReportID(), this.getFilter(), nodeInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return childList;
    }

    @Override
    public ReportTreeNode buildTreeNode() {
        ReportTreeNode node = null;
        try {
            node = this.getServerInterface().buildTreeNode(this.reportProperty.getReportID(), this.getFilter());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (BaseException e) {
            e.printStackTrace();
        }
        return node;
    }
}

