/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.report;

import com.kingdee.jdbc.rowset.IRowSet;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;

public class ReportHeader
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean visible = true;
    private String caption;
    private String fieldName;
    private String decimalField = null;
    private int decimal = -1;
    private int type = 1;
    private int index = 0;
    private int width = 100;
    private int align = 0;
    private int level = 0;
    private boolean mergeable = false;
    private ArrayList childs = null;
    private HashMap allchilds;
    private String fullParentCaption = "";
    private String formatstring = "";
    private boolean ishiberarchy = false;
    private String fleaffield = "";

    public String getFleaffield() {
        return this.fleaffield;
    }

    public void setFleaffield(String fleaffield) {
        this.fleaffield = fleaffield.toString().trim();
    }

    public String getFullCaption() {
        return this.fullParentCaption == null || this.fullParentCaption.equals("") ? this.getCaption() : this.fullParentCaption + "_" + this.getCaption();
    }

    private void populateAllChilds(HashMap allchilds) {
        if (this.childs != null) {
            for (int i = 0; i < this.childs.size(); ++i) {
                ReportHeader childHeader = (ReportHeader)this.childs.get(i);
                childHeader.fullParentCaption = this.fullParentCaption == null || this.fullParentCaption.equals("") ? this.caption : this.fullParentCaption + "_" + this.caption;
                childHeader.populateAllChilds(allchilds);
            }
        } else {
            allchilds.put(this.fieldName, this);
        }
    }

    public HashMap getAllChilds() {
        if (this.allchilds == null) {
            this.allchilds = new HashMap();
            this.populateAllChilds(this.allchilds);
        }
        return this.allchilds;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getDecimalField() {
        return this.decimalField;
    }

    public void setDecimalField(String decimalField) {
        this.decimalField = decimalField;
    }

    public int getType() {
        return this.type;
    }

    public ReportHeader setType(int type) {
        this.type = type;
        return this;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getWidth() {
        return this.width;
    }

    public ReportHeader setWidth(int width) {
        this.width = width;
        return this;
    }

    public int getAlign() {
        return this.align;
    }

    public ReportHeader setAlign(int align) {
        this.align = align;
        return this;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public boolean isLeaf() {
        return this.childs == null;
    }

    public int getAllLeafCount() {
        int n = 0;
        for (int i = 0; i < this.childs.size(); ++i) {
            ReportHeader r = (ReportHeader)this.childs.get(i);
            if (r.isLeaf()) {
                ++n;
                continue;
            }
            n += r.getAllLeafCount();
        }
        return n;
    }

    public ArrayList getChilds() {
        return this.childs;
    }

    public ReportHeader(String fieldName, String caption) {
        this.fieldName = fieldName;
        this.caption = caption;
        this.fullParentCaption = "";
        this.align = 1;
        this.width = 100;
        this.ishiberarchy = false;
        this.fleaffield = "";
    }

    public ReportHeader() {
        this.fieldName = "";
        this.caption = "";
        this.fullParentCaption = "";
        this.align = 1;
        this.width = 100;
        this.ishiberarchy = false;
        this.fleaffield = "";
    }

    public ReportHeader addChild() {
        return this.addChild("", "");
    }

    public ReportHeader addChild(String fieldName, String caption) {
        ReportHeader header = new ReportHeader(fieldName, caption);
        header.level = this.level + 1;
        if (this.childs == null) {
            this.childs = new ArrayList();
        }
        this.childs.add(header);
        return header;
    }

    public ReportHeader addChild(int index) {
        return this.addChild("", "", index);
    }

    public ReportHeader addChild(String fieldName, String caption, int index) {
        ReportHeader header = new ReportHeader(fieldName, caption);
        header.level = this.level + 1;
        if (this.childs == null) {
            this.childs = new ArrayList();
        }
        this.childs.add(index, header);
        return header;
    }

    public int getMaxLevel() {
        int n = this.level;
        int c = 0;
        if (this.childs != null) {
            for (int i = 0; i < this.childs.size(); ++i) {
                c = ((ReportHeader)this.childs.get(i)).getMaxLevel();
                if (n >= c) continue;
                n = c;
            }
        }
        return n;
    }

    public int getChildCount() {
        return this.childs == null ? 0 : this.childs.size();
    }

    public ReportHeader getMostLeftChild() {
        if (this.childs == null) {
            return null;
        }
        ReportHeader header = (ReportHeader)this.childs.get(0);
        if (header.isLeaf()) {
            return header;
        }
        return header.getMostLeftChild();
    }

    public int getDecimal() {
        return this.decimal;
    }

    public void setDecimal(int decimal) {
        this.decimal = decimal;
    }

    public static ReportHeader createReportHeader(IRowSet rsHeader) throws Exception {
        ReportHeader header = new ReportHeader();
        Hashtable<String, ReportHeader> dctHeader = new Hashtable<String, ReportHeader>();
        dctHeader.put("root", header);
        rsHeader.beforeFirst();
        while (rsHeader.next()) {
            String parentField = rsHeader.getString("FParentFieldName");
            ReportHeader parent = (ReportHeader)(parentField == null || parentField.trim().equals("") ? dctHeader.get("root") : dctHeader.get(parentField));
            if (parent != null) {
                ReportHeader child = parent.addChild();
                child.readData(rsHeader);
                dctHeader.put(child.getFieldName(), child);
                continue;
            }
            throw new Exception("\u65e0\u6cd5\u83b7\u53d6[" + rsHeader.getString("FFieldName") + "]\u7684\u7236\u9879[" + parentField + "]\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\uff08T_SYSRPTHEADER\uff09\u8bbe\u7f6e\u6b63\u786e\u3002");
        }
        return header;
    }

    public void readData(IRowSet rs) throws SQLException {
        this.setCaption(rs.getString("FCaption"));
        this.setFieldName(rs.getString("FFieldName"));
        this.setWidth(rs.getInt("FWidth"));
        this.setDecimal(rs.getInt("FDecimal"));
        this.setDecimalField(rs.getString("FDecimalField"));
        this.setType(rs.getInt("FColType"));
        this.setAlign(rs.getInt("FAlign"));
        this.setMergeable(rs.getBoolean("FMergeable"));
        this.setFormatstring(rs.getString("FFormatString"));
        this.setIndex(rs.getInt("FIndex"));
        this.setIshiberarchy(rs.getBoolean("fishiberarchy"));
        this.setFleaffield(rs.getString("fleaffield"));
    }

    public void readData(String caption, String fieldName, int width, int decimal, String decimalField, int colType, int align, boolean mergeable, String formatString, int index, boolean fishiberarchy, String leafField) throws SQLException {
        this.setCaption(caption);
        this.setFieldName(fieldName);
        this.setWidth(width);
        this.setDecimal(decimal);
        this.setDecimalField(decimalField);
        this.setType(colType);
        this.setAlign(align);
        this.setMergeable(mergeable);
        this.setFormatstring(formatString);
        this.setIndex(index);
        this.setIshiberarchy(fishiberarchy);
        this.setFleaffield(leafField);
    }

    public boolean isMergeable() {
        return this.mergeable;
    }

    public void setMergeable(boolean mergeable) {
        this.mergeable = mergeable;
    }

    public String getFormatstring() {
        if (this.formatstring == null) {
            this.formatstring = " ";
        }
        return this.formatstring;
    }

    public void setFormatstring(String formatstring) {
        if (formatstring == null) {
            formatstring = " ";
        }
        this.formatstring = formatstring;
    }

    public boolean isIshiberarchy() {
        return this.ishiberarchy;
    }

    public void setIshiberarchy(boolean ishiberarchy) {
        this.ishiberarchy = ishiberarchy;
    }
}

