/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.report.demo.app;

import com.kingdee.eas.base.report.demo.app.MonthTotal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompanyExpenseList {
    private String companyName;
    private String companId;
    private int level;
    private Map expenseMap;
    private int fOrder;
    public static final Log log = LogFactory.getLog(CompanyExpenseList.class);

    public CompanyExpenseList(String companyName) {
        this.companyName = companyName;
        this.expenseMap = new HashMap();
    }

    public CompanyExpenseList(String companyName, String companyId) {
        this.companyName = companyName;
        this.companId = companyId;
        this.expenseMap = new HashMap();
    }

    public void addExpenseTotal(int year, int month, float payValue, float unpayValue, String expenseName, int fOrder) {
        Map<String, MonthTotal> monthMap = null;
        MonthTotal monthTotal = null;
        this.fOrder = fOrder;
        String yearMonthKey = year + "-" + month;
        if (this.expenseMap.containsKey(expenseName)) {
            monthMap = (Map)this.expenseMap.get(expenseName);
            if (monthMap.containsKey(yearMonthKey)) {
                monthTotal = (MonthTotal)monthMap.get(yearMonthKey);
                monthTotal.add(payValue, unpayValue);
            } else {
                monthTotal = new MonthTotal(year, month, expenseName, payValue, unpayValue, payValue + unpayValue);
                monthMap.put(yearMonthKey, monthTotal);
            }
        } else {
            monthMap = new HashMap();
            monthTotal = new MonthTotal(year, month, expenseName, payValue, unpayValue, payValue + unpayValue);
            monthMap.put(yearMonthKey, monthTotal);
            this.expenseMap.put(expenseName, monthMap);
        }
    }

    public void addSummayExpenseTotal(CompanyExpenseList summayList) {
        if (log.isInfoEnabled()) {
            log.info((Object)"Add child Summary Expense Total");
        }
        for (String expenseKey : summayList.getExpenseMap().keySet()) {
            Map monthTotalMap = (Map)summayList.getExpenseMap().get(expenseKey);
            if (this.expenseMap.containsKey(expenseKey)) {
                Map expenseMapItem = (Map)this.expenseMap.get(expenseKey);
                HashMap<String, MonthTotal> newExpenseMap = new HashMap<String, MonthTotal>();
                this.expenseMap.remove(expenseKey);
                for (String tempMonthKey : expenseMapItem.keySet()) {
                    MonthTotal oneTotal = (MonthTotal)expenseMapItem.get(tempMonthKey);
                    MonthTotal tempNewTotal = new MonthTotal(oneTotal);
                    newExpenseMap.put(tempMonthKey, tempNewTotal);
                }
                this.expenseMap.put(expenseKey, newExpenseMap);
                for (String oneMonthKey : monthTotalMap.keySet()) {
                    MonthTotal oneTotal = (MonthTotal)monthTotalMap.get(oneMonthKey);
                    if (newExpenseMap.containsKey(oneMonthKey)) {
                        MonthTotal beforeTotal = (MonthTotal)newExpenseMap.get(oneMonthKey);
                        beforeTotal.add(oneTotal);
                        newExpenseMap.remove(oneMonthKey);
                        newExpenseMap.put(oneMonthKey, beforeTotal);
                        continue;
                    }
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)("=======================######################## Exist Expense MonthKey:" + oneMonthKey + ",only in child,not in parent "));
                }
                continue;
            }
            this.expenseMap.put(expenseKey, monthTotalMap);
        }
    }

    public List getCompanyExpensList() {
        ArrayList expensList = new ArrayList();
        for (String expenseKey : this.expenseMap.keySet()) {
            Map monthTotalMap = (Map)this.expenseMap.get(expenseKey);
            Iterator iter = monthTotalMap.keySet().iterator();
            ArrayList<MonthTotal> monTotalList = new ArrayList<MonthTotal>();
            while (iter.hasNext()) {
                String oneMonthKey = (String)iter.next();
                MonthTotal oneTotal = (MonthTotal)monthTotalMap.get(oneMonthKey);
                monTotalList.add(oneTotal);
            }
            expensList.add(monTotalList);
        }
        return expensList;
    }

    public int getFOrder() {
        return this.fOrder;
    }

    public void setFOrder(int order) {
        this.fOrder = order;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getCompanId() {
        return this.companId;
    }

    public void setCompanId(String companId) {
        this.companId = companId;
    }

    public Map getExpenseMap() {
        return this.expenseMap;
    }

    public void setExpenseMapByClone(Map expenseMap) {
        this.expenseMap = new HashMap();
        for (Object oneKey : expenseMap.keySet()) {
            this.expenseMap.put(oneKey, expenseMap.get(oneKey));
        }
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }
}

