/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.report.demo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.base.report.demo.app.MonthTotal;
import com.kingdee.eas.base.report.demo.app.RptFilterParameter;
import com.kingdee.eas.base.report.demo.app.RptServerUtils;
import com.kingdee.eas.base.report.demo.app.SummaryColumnList;
import com.kingdee.eas.base.report.demo.app.SummaryUnit;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SummaryReportBaseServer
extends ReportServerBase {
    public static final Log log = LogFactory.getLog(SummaryReportBaseServer.class);
    public static final String INIT_BEGIN_DATE = RptServerUtils.getThisYearFirstDay();
    public static final String INIT_END_DATE = RptServerUtils.getThisYearLastDay();
    public static final String WEB_FILTER_PARAM_Custom_MAP = "customMap";
    public static final String FILTERFIELD_BEGIN_DATE = "FBEGINDATE";
    public static final String FILTERFIELD_END_DATE = "FENDDATE";
    public static final int DECIMAL_SIZE = 2;
    public static final int DECIMALFIELD_WIDTH = 80;
    public static final int STRING_COLUMN_TYPE = 1;
    public static final int DECIMAL_COLUMN_TYPE = 2;
    private StringBuffer dynamicColSB = null;
    private StringBuffer insertColSB = null;
    private Map monthKeyPosMap = null;
    protected ReportHeader header = null;
    protected String beginDateStr = "";
    protected String endDateStr = "";
    private RptParams lastParams = null;
    protected SummaryUnit summaryUnit;
    protected Map summaryMap;
    public static final String TOTAL_COLUMN_Id = "Total_Column_Id";
    public static final String SUMMARY_LEVEL_NAME = "FSummaryRptLevel";
    protected RptFilterParameter rptFilterParameter;

    public RptFilterParameter getFtpFilterParameter() {
        return this.rptFilterParameter;
    }

    private void parseRptParamsDate(RptParams filter) {
        if (this.rptFilterParameter == null) {
            this.rptFilterParameter = new RptFilterParameter(filter);
        }
        this.parseRptParamsDate();
    }

    protected void parseRptParamsDate() {
        if (this.rptFilterParameter != null) {
            this.beginDateStr = this.rptFilterParameter.getCustomFilterValueByKey(FILTERFIELD_BEGIN_DATE);
            if (RptServerUtils.isBlankString(this.beginDateStr)) {
                this.beginDateStr = RptServerUtils.getThisYearFirstDay();
            }
            this.endDateStr = this.rptFilterParameter.getCustomFilterValueByKey(FILTERFIELD_END_DATE);
            if (RptServerUtils.isBlankString(this.endDateStr)) {
                this.endDateStr = RptServerUtils.getThisYearLastDay();
            }
        } else {
            this.beginDateStr = RptServerUtils.getThisYearFirstDay();
            this.endDateStr = RptServerUtils.getThisYearLastDay();
        }
    }

    @Override
    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BOSException {
        if (this.rptFilterParameter == null) {
            this.rptFilterParameter = new RptFilterParameter(filter);
        }
        return this.getReportTitleByRptFilterParamter();
    }

    protected abstract ReportTitles getReportTitleByRptFilterParamter() throws BOSException;

    @Override
    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        if (this.header == null) {
            this.header = this.createReportHeader(reportID, filter);
            this.lastParams = filter;
        } else if (this.lastParams != null && !this.lastParams.equals((Object)filter)) {
            this.header = this.createReportHeader(reportID, filter);
            this.lastParams = filter;
        }
        return this.header;
    }

    protected ReportHeader createReportHeader(String reportID, RptParams filter) throws Exception {
        int beginMonth = 1;
        int endMonth = 1;
        int beginYear = -1;
        int endYear = -1;
        this.rptFilterParameter = new RptFilterParameter(filter);
        this.parseRptParamsDate();
        String[] beginDate = this.beginDateStr.split("-");
        beginYear = Integer.parseInt(beginDate[0]);
        beginMonth = Integer.parseInt(beginDate[1]);
        String[] endDate = this.endDateStr.split("-");
        endYear = Integer.parseInt(endDate[0]);
        endMonth = Integer.parseInt(endDate[1]);
        Locale locale = this.getContext().getLocale();
        String strSQL = "";
        strSQL = "SELECT T_BAS_REPORTHEADER.FID,FParentFieldName,FReportID,FCaption_" + locale + " as FCaption,FFieldName,FDecimalField,FDecimal, FColType,FWidth,FAlign,FLevel,FIndex,FMergeable,FFormatString,fishiberarchy,fleaffield   FROM T_BAS_REPORTHEADER  LEFT JOIN T_BAS_RptDataType ON T_BAS_RptDataType.FParentID=T_BAS_REPORTHEADER.FID  WHERE  FReportID = ?  Order By FIndex,FLevel,FParentFieldName ";
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)strSQL, (Object[])new Object[]{reportID});
        return rs.next() ? this.createReportHeader(rs, beginYear, endYear, beginMonth, endMonth) : new ReportHeader();
    }

    private ReportHeader createReportHeader(IRowSet rsHeader, int beginYear, int endYear, int beginMonth, int endMonth) throws Exception {
        ReportHeader header = new ReportHeader();
        Hashtable<String, ReportHeader> dctHeader = new Hashtable<String, ReportHeader>();
        dctHeader.put("root", header);
        rsHeader.beforeFirst();
        while (rsHeader.next()) {
            ReportHeader child;
            String parentField = rsHeader.getString("FParentFieldName");
            int level = rsHeader.getInt("FIndex");
            ReportHeader parent = (ReportHeader)(parentField == null || parentField.trim().equals("") ? dctHeader.get("root") : dctHeader.get(parentField));
            if (parent != null) {
                child = parent.addChild();
                child.readData(rsHeader);
                if (rsHeader.getString("FFieldName").equals(SUMMARY_LEVEL_NAME)) {
                    child.setVisible(false);
                }
            } else {
                throw new Exception("\u65e0\u6cd5\u83b7\u53d6[" + rsHeader.getString("FFieldName") + "]\u7684\u7236\u9879[" + parentField + "]\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\uff08T_SYSRPTHEADER\uff09\u8bbe\u7f6e\u6b63\u786e\u3002");
            }
            dctHeader.put(child.getFieldName(), child);
            if (level < 3) continue;
            break;
        }
        int monthCount = 0;
        String caption = "";
        String fieldName = "";
        int width = 80;
        int decimal = 2;
        String decimalField = "";
        int colType = 2;
        int align = 3;
        boolean mergeable = false;
        String formatString = "";
        int index = 4;
        boolean fishiberarchy = false;
        String leafField = "";
        this.dynamicColSB = new StringBuffer();
        this.insertColSB = new StringBuffer();
        this.monthKeyPosMap = new HashMap();
        for (int year = beginYear; year <= endYear; ++year) {
            int month;
            if (year == beginYear) {
                if (beginYear < endYear) {
                    for (month = beginMonth; month <= 12; ++month) {
                        this.addOneMonthHeader(dctHeader, year, month, monthCount, width, decimal, decimalField, colType, align, mergeable, formatString, index, fishiberarchy, leafField);
                        ++monthCount;
                        index += 4;
                    }
                    continue;
                }
                for (month = beginMonth; month <= endMonth; ++month) {
                    this.addOneMonthHeader(dctHeader, year, month, monthCount, width, decimal, decimalField, colType, align, mergeable, formatString, index, fishiberarchy, leafField);
                    ++monthCount;
                    index += 4;
                }
                continue;
            }
            if (year < endYear) {
                for (month = 1; month <= 12; ++month) {
                    this.addOneMonthHeader(dctHeader, year, month, monthCount, width, decimal, decimalField, colType, align, mergeable, formatString, index, fishiberarchy, leafField);
                    ++monthCount;
                    index += 4;
                }
                continue;
            }
            for (month = 1; month <= endMonth; ++month) {
                this.addOneMonthHeader(dctHeader, year, month, monthCount, width, decimal, decimalField, colType, align, mergeable, formatString, index, fishiberarchy, leafField);
                ++monthCount;
                index += 4;
            }
        }
        return header;
    }

    private void addOneMonthHeader(Hashtable dctHeader, int year, int month, int monthCount, int width, int decimal, String decimalField, int colType, int align, boolean mergeable, String formatString, int index, boolean fishiberarchy, String leafField) throws SQLException {
        String oneMonthStr = year + "\u5e74" + month;
        this.monthKeyPosMap.put(year + "-" + month, new Integer(monthCount));
        ReportHeader parent = (ReportHeader)dctHeader.get("root");
        if (this.dynamicColSB.toString().length() > 0) {
            this.dynamicColSB.append(",");
        }
        if (this.insertColSB.toString().length() > 0) {
            this.insertColSB.append(",");
        }
        String[] headerUnitNames = this.getReportHeaderUnitName();
        String[] headerUnitIDs = this.getReportHeaderUnitID();
        ReportHeader child = parent.addChild();
        String caption = oneMonthStr;
        String fieldName = "FQuarter" + monthCount;
        child.readData(caption, fieldName, width, decimal, decimalField, colType, align, mergeable, formatString, index++, fishiberarchy, leafField);
        dctHeader.put(fieldName, child);
        String parentField = "FQuarter" + monthCount;
        parent = (ReportHeader)dctHeader.get(parentField);
        child = parent.addChild();
        caption = headerUnitNames[0];
        fieldName = headerUnitIDs[0] + monthCount;
        this.dynamicColSB.append(fieldName);
        this.insertColSB.append(fieldName + " Decimal(21,8) default 0");
        child.readData(caption, fieldName, width, decimal, decimalField, colType, align, mergeable, formatString, index++, fishiberarchy, leafField);
        child = parent.addChild();
        caption = headerUnitNames[1];
        fieldName = headerUnitIDs[1] + monthCount;
        this.dynamicColSB.append("," + fieldName);
        this.insertColSB.append("," + fieldName + " Decimal(21,8) default 0");
        child.readData(caption, fieldName, width, decimal, decimalField, colType, align, mergeable, formatString, index++, fishiberarchy, leafField);
        child = parent.addChild();
        caption = headerUnitNames[2];
        fieldName = headerUnitIDs[2] + monthCount;
        this.dynamicColSB.append("," + fieldName);
        this.insertColSB.append("," + fieldName + " Decimal(21,8) default 0");
        child.readData(caption, fieldName, width, decimal, decimalField, colType, align, mergeable, formatString, index++, fishiberarchy, leafField);
    }

    protected abstract String[] getReportHeaderUnitName();

    protected abstract String[] getReportHeaderUnitID();

    @Override
    protected IRowSet getReportData(String reportID, RptParams filter) throws BOSException {
        if (this.header == null) {
            try {
                this.header = this.createReportHeader(reportID, filter);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.lastParams = filter;
        } else if (this.lastParams != null && !this.lastParams.equals((Object)filter)) {
            try {
                this.header = this.createReportHeader(reportID, filter);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.lastParams = filter;
        }
        String sql = null;
        sql = this.getFilterSQL();
        IRowSet rs = null;
        rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql);
        String dynamicColumns = this.dynamicColSB.toString();
        String insertColumns = this.insertColSB.toString();
        String insertFixColumns = this.getInsertColumns();
        String queryFixColumns = this.getQueryColumns();
        String insertColumnSQL = insertFixColumns + " " + SUMMARY_LEVEL_NAME + " Int," + insertColumns + ",FOrder Int";
        String queryColumnSQL = queryFixColumns + " " + SUMMARY_LEVEL_NAME + "," + dynamicColumns + "";
        return this.buildReportDataFromTempTable(insertColumnSQL, queryColumnSQL, rs);
    }

    protected abstract String getFilterSQL();

    protected abstract String getInsertColumns();

    protected abstract String getQueryColumns();

    protected abstract String[] getSummaryColumnInfo();

    protected abstract String[] getAllTotalColumnInfo();

    public Map getMonthExpenceRowSet(IRowSet rowSet) throws SQLException {
        HashMap<String, SummaryColumnList> summaryColumnMap = new HashMap<String, SummaryColumnList>();
        String[] summaryColumnInfo = this.getSummaryColumnInfo();
        String COLUMN_CompanyName = summaryColumnInfo[0];
        String COLUMN_CompanyId = summaryColumnInfo[1];
        String COLUMN_ExpenseTypeName = summaryColumnInfo[2];
        String COLUMN_BizReqDate = summaryColumnInfo[3];
        String[] sutotlColumnInfo = this.getReportHeaderUnitID();
        String COLUMN_Pay = sutotlColumnInfo[0];
        String COLUMN_UnPay = sutotlColumnInfo[1];
        String COLUMN_SubTotal = sutotlColumnInfo[2];
        String[] allTotalColumnInfo = this.getAllTotalColumnInfo();
        String TOTAL_COLUMN_Name = allTotalColumnInfo[0];
        String TOTAL_COLUMN_ExpenseName = allTotalColumnInfo[1];
        SummaryColumnList totalExpenseList = new SummaryColumnList(TOTAL_COLUMN_Name, TOTAL_COLUMN_Id);
        int cmpIndex = 1;
        int maxLevel = 0;
        try {
            while (rowSet.next()) {
                String firstColumnName = rowSet.getString(COLUMN_CompanyName);
                String secondColumnName = rowSet.getString(COLUMN_ExpenseTypeName);
                String firstColumnId = rowSet.getString(COLUMN_CompanyId);
                SummaryUnit oneUnit = (SummaryUnit)this.summaryMap.get(firstColumnId);
                float payValue = rowSet.getFloat(COLUMN_Pay);
                float unPayValue = rowSet.getFloat(COLUMN_UnPay);
                String bizDate = rowSet.getString(COLUMN_BizReqDate);
                String[] dateInfo = bizDate.split("-");
                int year = Integer.parseInt(dateInfo[0]);
                int month = Integer.parseInt(dateInfo[1]);
                SummaryColumnList expenseList = null;
                if (summaryColumnMap.containsKey(firstColumnId)) {
                    expenseList = (SummaryColumnList)summaryColumnMap.get(firstColumnId);
                } else {
                    expenseList = new SummaryColumnList(firstColumnName, firstColumnId);
                    int oneLevel = (Integer)oneUnit.getAttribute("level");
                    if (oneLevel > maxLevel) {
                        maxLevel = oneLevel;
                    }
                    expenseList.setLevel(oneLevel);
                    summaryColumnMap.put(firstColumnId, expenseList);
                }
                expenseList.addExpenseTotal(year, month, payValue, unPayValue, secondColumnName, cmpIndex++);
                totalExpenseList.addExpenseTotal(year, month, payValue, unPayValue, TOTAL_COLUMN_ExpenseName, -1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        totalExpenseList.setFOrder(cmpIndex);
        totalExpenseList.setLevel(maxLevel + 1);
        summaryColumnMap.put(TOTAL_COLUMN_Id, totalExpenseList);
        return summaryColumnMap;
    }

    public IRowSet buildReportDataFromTempTable(String createTableSql, String queryTableSql, IRowSet initRowSet) throws BOSException {
        String createSQL = "CREATE TABLE t1 (" + createTableSql + ") ";
        IRowSet retRowSet = null;
        try {
            TempTablePool pool = TempTablePool.getInstance((Context)this.getContext());
            String tableName = pool.createTempTable(createSQL);
            String queryColumns = this.getQueryColumns();
            String insertFormatSql = "insert into " + tableName + "(" + queryColumns + "" + SUMMARY_LEVEL_NAME + ",{0})values({1})";
            Map compayMap = this.getMonthExpenceRowSet(initRowSet);
            if (this.summaryMap != null && this.summaryUnit != null) {
                compayMap = this.mergeMapData(compayMap, this.summaryMap, this.summaryUnit);
            }
            for (String companyId : compayMap.keySet()) {
                SummaryColumnList oneList = (SummaryColumnList)compayMap.get(companyId);
                List expenseList = oneList.getCompanyExpensList();
                for (int i = 0; i < expenseList.size(); ++i) {
                    StringBuffer insertColumnSB = new StringBuffer();
                    StringBuffer insertValues = new StringBuffer();
                    String companyName = oneList.getFistColumnName();
                    insertValues.append("'" + companyName + "'");
                    List oneMonthTotalList = (List)expenseList.get(i);
                    for (int j = 0; j < oneMonthTotalList.size(); ++j) {
                        MonthTotal oneTotal = (MonthTotal)oneMonthTotalList.get(j);
                        String oneMonth = oneTotal.getYear() + "-" + oneTotal.getMonth();
                        float payValue = oneTotal.getPay();
                        float unPayValue = oneTotal.getUnpay();
                        float subTotalValue = oneTotal.getSubTotal();
                        String expenseName = oneTotal.getExpenseTypeName();
                        if (j == 0) {
                            insertValues.append(",'" + expenseName + "'");
                            insertValues.append("," + oneList.getLevel() + "");
                        }
                        int monPos = (Integer)this.monthKeyPosMap.get(oneMonth);
                        if (insertColumnSB.toString().length() > 0) {
                            insertColumnSB.append(",");
                        }
                        insertColumnSB.append("FPay" + monPos + ",FUnPay" + monPos + ",FSubTotal" + monPos);
                        if (insertValues.toString().length() > 0) {
                            insertValues.append(",");
                        }
                        insertValues.append(payValue + "," + unPayValue + "," + subTotalValue);
                    }
                    insertColumnSB.append(",FOrder");
                    insertValues.append("," + oneList.getFOrder());
                    String insertSql = MessageFormat.format(insertFormatSql, insertColumnSB.toString(), insertValues.toString());
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Insert Temp Sql is\n" + insertSql));
                    }
                    DbUtil.execute((Context)this.getContext(), (String)insertSql);
                }
            }
            String sql = "select " + queryTableSql + " from " + tableName + " order by " + SUMMARY_LEVEL_NAME + ",FOrder, FCompanyName,FExpenseTypeName \n";
            retRowSet = DbUtil.executeQuery((Context)this.getContext(), (String)sql);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retRowSet;
    }

    public Map mergeMapData(Map basicData, Map summayUnitMap, SummaryUnit topUnit) {
        HashMap<String, SummaryColumnList> retMap = new HashMap<String, SummaryColumnList>();
        int topLevel = (Integer)topUnit.getAttribute("level");
        for (String companyId : basicData.keySet()) {
            SummaryColumnList oneList = (SummaryColumnList)basicData.get(companyId);
            int listLevel = oneList.getLevel();
            if (!retMap.containsKey(companyId)) {
                SummaryColumnList oneParentList = new SummaryColumnList(oneList.getFistColumnName(), oneList.getFirstColumnId());
                oneParentList.setFOrder(oneList.getFOrder());
                oneParentList.setExpenseMapByClone(oneList.getSecondColumnMap());
                oneParentList.setLevel(oneList.getLevel());
                retMap.put(companyId, oneList);
            } else {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Exist parent CompanyExpenseList:" + companyId + " level " + listLevel + " ,has child CompanyExpenseList in basic Map"));
                }
                SummaryColumnList existList = (SummaryColumnList)retMap.get(companyId);
                existList.addSummayExpenseTotal(oneList);
            }
            if (listLevel <= topLevel || companyId.equals(TOTAL_COLUMN_Id)) continue;
            String oneId = companyId;
            for (int i = listLevel - 1; i >= topLevel; --i) {
                SummaryColumnList oneParentList;
                SummaryUnit oneUnit = (SummaryUnit)summayUnitMap.get(oneId);
                SummaryUnit parentUnit = oneUnit.getParent();
                String pid = parentUnit.getId();
                if (retMap.containsKey(pid)) {
                    oneParentList = null;
                    oneParentList = (SummaryColumnList)retMap.get(pid);
                    oneParentList.addSummayExpenseTotal((SummaryColumnList)retMap.get(oneId));
                } else {
                    oneParentList = new SummaryColumnList(parentUnit.getName(), pid);
                    SummaryColumnList subParentList = (SummaryColumnList)retMap.get(oneId);
                    oneParentList.setFOrder(subParentList.getFOrder());
                    oneParentList.setExpenseMapByClone(subParentList.getSecondColumnMap());
                    oneParentList.setLevel(i);
                    retMap.put(pid, oneParentList);
                }
                oneId = pid;
            }
        }
        return retMap;
    }
}

