/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.provider;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.rpc.RPCEngine;
import com.kingdee.bos.rpc.RPCSession;
import com.kingdee.eas.base.security.provider.IPKIConfig;
import com.kingdee.eas.base.security.provider.IPKIServerExtProvider;
import com.kingdee.eas.base.security.provider.PKIConfigFactory;
import com.kingdee.eas.base.security.provider.app.imp.DemoPKIServerProvider;
import com.kingdee.eas.base.security.provider.client.IPKIClientExt2Provider;
import com.kingdee.eas.base.security.provider.client.imp.DemoPKIClientProvider;
import org.apache.log4j.Logger;

public class PKIServerAndClientExtFactory {
    private static Logger logger = Logger.getLogger(PKIServerAndClientExtFactory.class);

    public static IPKIServerExtProvider getServerExtProvider() {
        return PKIServerAndClientExtFactory.getServerExtProvider(null);
    }

    public static IPKIServerExtProvider getServerExtProvider(Context ctx) {
        String providerClass = DemoPKIServerProvider.class.getName();
        IPKIConfig instance = null;
        instance = ctx == null ? PKIConfigFactory.getLocalInstance() : PKIConfigFactory.getLocalInstance(ctx);
        if (instance != null) {
            providerClass = instance.getConfigItem("provider.server");
        } else {
            logger.error((Object)"\u8bfbCA\u914d\u7f6e\u5931\u8d25\uff0cca\u4f9b\u5e94\u5546\u63a5\u53e3\u5c06\u53d6\u9ed8\u8ba4\u914d\u7f6e");
        }
        try {
            logger.info((Object)("load class is:" + providerClass));
            return (IPKIServerExtProvider)Class.forName(providerClass).newInstance();
        }
        catch (InstantiationException e) {
            logger.error((Object)"PKIServerExtProvider init error:", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"PKIServerExtProvider init error:", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"PKIServerExtProvider init error:", (Throwable)e);
        }
        return null;
    }

    public static IPKIClientExt2Provider getClientExtProvider() {
        return PKIServerAndClientExtFactory.getClientExtProvider(null);
    }

    public static IPKIClientExt2Provider getClientExtProvider(Context ctx) {
        String providerClass = DemoPKIClientProvider.class.getName();
        IPKIConfig instance = null;
        try {
            instance = ctx == null ? PKIConfigFactory.getRemoteInstance() : PKIConfigFactory.getRemoteInstanceWithObjectContext(ctx);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (instance != null) {
            providerClass = instance.getConfigItem("provider.client");
        } else {
            logger.error((Object)"\u8bfbCA\u914d\u7f6e\u5931\u8d25\uff0cca\u4f9b\u5e94\u5546\u63a5\u53e3\u5c06\u53d6\u9ed8\u8ba4\u914d\u7f6e");
        }
        try {
            logger.info((Object)("load class is:" + providerClass));
            return (IPKIClientExt2Provider)Class.forName(providerClass).newInstance();
        }
        catch (InstantiationException e) {
            logger.error((Object)"PKIServerExtProvider init error:", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"PKIServerExtProvider init error:", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"PKIServerExtProvider init error:", (Throwable)e);
        }
        return null;
    }

    public static IPKIServerExtProvider getServerExtProviderRemote() {
        return PKIServerAndClientExtFactory.getServerExtProviderRemote(null);
    }

    public static IPKIServerExtProvider getServerExtProviderRemote(Context ctx) {
        try {
            IPKIServerExtProvider pkiServerExtProvider = (IPKIServerExtProvider)BOSObjectFactory.createRemoteBOSObject((String)PKIServerAndClientExtFactory.getServerProviderClass(ctx), IPKIServerExtProvider.class);
            return pkiServerExtProvider;
        }
        catch (BOSException e) {
            logger.error((Object)"IPKIServerExtProvider getServerExtProviderRemote", (Throwable)e);
            logger.error((Object)"IPKIServerExtProvider getServerExtProviderRemote return null.");
            return null;
        }
    }

    public static IPKIServerExtProvider getRemote(String strURL) {
        RPCSession session = RPCEngine.createSession((String)strURL);
        return (IPKIServerExtProvider)session.createObject(PKIServerAndClientExtFactory.getServerProviderClass(null), IPKIServerExtProvider.class);
    }

    private static String getServerProviderClass(Context ctx) {
        String providerClass = "";
        IPKIConfig instance = null;
        try {
            instance = ctx == null ? PKIConfigFactory.getRemoteInstance() : PKIConfigFactory.getRemoteInstanceWithObjectContext(ctx);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (instance != null) {
            providerClass = instance.getConfigItem("provider.server");
        } else {
            logger.error((Object)"\u8bfbCA\u914d\u7f6e\u5931\u8d25\uff0cca\u4f9b\u5e94\u5546\u63a5\u53e3\u5c06\u53d6\u9ed8\u8ba4\u914d\u7f6e");
        }
        return providerClass;
    }
}

