/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.provider.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.framework.session.ApplicationInfo;
import com.kingdee.bos.framework.session.SessionManager;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.orm.template.ORMObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.LoginAuthorWayEnum;
import com.kingdee.eas.base.permission.USBKeyFactory;
import com.kingdee.eas.base.permission.USBKeyInfo;
import com.kingdee.eas.base.permission.UsbKeyException;
import com.kingdee.eas.base.permission.UsbKeyUserMapFactory;
import com.kingdee.eas.base.permission.UsbKeyUserMapInfo;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.security.CertificateStatusEnum;
import com.kingdee.eas.base.security.EASCertificateFactory;
import com.kingdee.eas.base.security.EASCertificateInfo;
import com.kingdee.eas.base.security.IEASCertificate;
import com.kingdee.eas.base.security.provider.IPKICommonService;
import com.kingdee.eas.base.security.provider.IPKIConfig;
import com.kingdee.eas.base.security.provider.IPKIServerProvider;
import com.kingdee.eas.base.security.provider.PKIConfigFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.IFrameHelperFacade;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import java.io.FileNotFoundException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import org.apache.log4j.Logger;

public class PKICommonService
extends ORMObject
implements IPKICommonService {
    private static Logger logger = Logger.getLogger(PKICommonService.class);
    private static IFrameHelperFacade facade = null;
    String name;
    private static String RANDOM_NO_4_LOGIN = "randomNo4login_";

    public PKICommonService(String _name) {
        this.name = _name;
        this.registerInterface(IPKIServerProvider.class, this);
    }

    public PKICommonService() {
        this.registerInterface(IPKIServerProvider.class, this);
    }

    public String getName() throws ORMCoreException {
        return this.name;
    }

    @Override
    public String initRandomNo(Context ctx, String userNumber) throws BOSException, UsbKeyException {
        String ksql = "SELECT u.FLoginAuthorWay FROM T_PM_User u WHERE u.FNumber = ? ";
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)ksql, (Object[])new Object[]{userNumber});
        try {
            int loginAuthorWay;
            if (result.next() && 1 != (loginAuthorWay = result.getInt("FLoginAuthorWay"))) {
                throw new UsbKeyException(UsbKeyException.NOT_START_USE_USBKEY);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"getLoginAuthorWay error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        logger.info((Object)"initRandomNo generate start...");
        String randomNo4login = null;
        IPKIConfig iPKIConfig = PKIConfigFactory.getLocalInstance(ctx);
        try {
            if (iPKIConfig.isItrusProvider()) {
                ApplicationInfo applicationInfo = SessionManager.getInstance().getApplication(ctx.getAIS());
                randomNo4login = Uuid.randomUUID().toString();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("randomNo4login is:" + randomNo4login));
                }
                applicationInfo.put((Object)(RANDOM_NO_4_LOGIN + userNumber), (Object)randomNo4login);
            } else {
                logger.info((Object)"initRandomNo isItrusProvider return false.");
            }
        }
        catch (Exception ex) {
            if (FileNotFoundException.class.isInstance(ex)) {
                return null;
            }
            logger.error((Object)"iPKIConfig.isItrusProvider error", (Throwable)ex);
        }
        return randomNo4login;
    }

    @Override
    public String getRandomNo(Context ctx, String userNumber) throws BOSException, EASBizException {
        String key;
        ApplicationInfo applicationInfo = SessionManager.getInstance().getApplication(ctx.getAIS());
        String randomNo4login = (String)applicationInfo.get((Object)(key = RANDOM_NO_4_LOGIN + userNumber));
        if (randomNo4login == null) {
            logger.info((Object)(RANDOM_NO_4_LOGIN + userNumber + " in applicationInfo is null."));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("randomNo is:" + randomNo4login));
        }
        return randomNo4login;
    }

    public LoginAuthorWayEnum getLoginAuthorWay(Context ctx, String userNumber) throws BOSException, EASBizException {
        String ksql = "SELECT u.loginAuthorWay FROM T_PM_User u WHERE u.FNumber = ? ";
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)ksql, (Object[])new Object[]{userNumber});
        LoginAuthorWayEnum loginAuthorWayEnum = null;
        try {
            if (result.next()) {
                int loginAuthorWay = result.getInt("FAuthorizeType");
                loginAuthorWayEnum = LoginAuthorWayEnum.getEnum((int)loginAuthorWay);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"getLoginAuthorWay error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return loginAuthorWayEnum;
    }

    @Override
    public void cacheEASCertificateInfo(Context ctx, String userNumber, byte[] cert, String usbKeyNo) {
        logger.info((Object)("PKISignInfoCache putSignInfo: userNumber=" + userNumber));
        try {
            UsbKeyUserMapInfo usbKeyUserMapInfo = (UsbKeyUserMapInfo)UsbKeyUserMapFactory.getLocalInstance((Context)ctx).getValue("select * where user.number='" + userNumber + "'");
            if (usbKeyUserMapInfo == null) {
                logger.error((Object)("Not find user [" + userNumber + "] in T_PM_USBKEYUSERMAP, ignore cache certificate info"));
                return;
            }
            if (usbKeyUserMapInfo.getUsbkey() == null) {
                logger.error((Object)("Find user [" + userNumber + "] in T_PM_USBKEYUSERMAP, but not init ignore cache certificate info"));
                return;
            }
            IEASCertificate iEASCertificate = EASCertificateFactory.getLocalInstance((Context)ctx);
            EASCertificateInfo easCertificateInfo = null;
            try {
                easCertificateInfo = (EASCertificateInfo)iEASCertificate.getValue("select * where user.number='" + userNumber + "'");
            }
            catch (ObjectNotFoundException on) {
                logger.error((Object)("putSignInfo ObjectNotFoundException" + on.getMessage()));
                easCertificateInfo = null;
            }
            if (easCertificateInfo == null || !this.isCertSame(cert, easCertificateInfo)) {
                if (easCertificateInfo != null) {
                    iEASCertificate.delete("where user.number='" + userNumber + "'");
                }
                logger.info((Object)"PKISignInfoCache putSignInfo: create new EASCertificateInfo start.");
                EASCertificateInfo newEASCertificateInfo = new EASCertificateInfo();
                IUser iUser = UserFactory.getLocalInstance((Context)ctx);
                newEASCertificateInfo.setUser(iUser.getUser(userNumber));
                newEASCertificateInfo.setCertificate(cert);
                newEASCertificateInfo.setValidDate(new Date());
                newEASCertificateInfo.setInvalidDate(new Date());
                newEASCertificateInfo.setStatus(CertificateStatusEnum.VALID);
                newEASCertificateInfo.setNumber("fake number");
                iEASCertificate.addnew((CoreBaseInfo)newEASCertificateInfo);
                logger.info((Object)"PKISignInfoCache putSignInfo: create new EASCertificateInfo finish.");
            }
            this.initUsbkeyInfo(ctx, userNumber, usbKeyNo);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    private void initUsbkeyInfo(Context userContext, String userNumber, String usbKeyNo) throws EASBizException, BOSException {
        USBKeyInfo usbKeyInfo;
        if ("true".equalsIgnoreCase(System.getProperty("initUsbKeyWhenCacheSignInfo", "true")) && usbKeyNo != null && (usbKeyInfo = USBKeyFactory.getLocalInstance((Context)userContext).getUsbKeyInfoByNumber(usbKeyNo)) == null) {
            String usbkey_fid = BOSUuid.create((String)"0366DBEF").toString();
            logger.info((Object)("Try to init t_pm_usbkey, fid=" + usbkey_fid + " and keyNO=" + usbKeyNo));
            DbUtil.execute((Context)userContext, (String)("insert into t_pm_usbkey values('" + usbkey_fid + "', '" + usbKeyNo + "')"));
            logger.info((Object)("Try to update t_pm_usbkeyusermap, usernumber=" + userNumber));
            DbUtil.execute((Context)userContext, (String)("UPDATE T_PM_UsbKeyUserMap SET FUsbkeyID='" + usbkey_fid + "' WHERE FUserID=(select FID from t_pm_user where fnumber='" + userNumber + "')"));
            logger.warn((Object)"VerifyUsbKeyNoInServer: usbKeyInfo is null\uff0c ignore compare");
        }
    }

    private boolean isCertSame(byte[] newCert, EASCertificateInfo easCertificateInfo) {
        if ("true".equalsIgnoreCase(System.getProperty("compareCertWhenCacheSignInfo", "true"))) {
            byte[] cert = easCertificateInfo.getCertificate();
            boolean result = Arrays.equals(newCert, cert);
            logger.info((Object)("compareCertWhenCacheSignInfo=true and result=" + result));
            return result;
        }
        return true;
    }
}

