/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.shrssc.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.shrssc.ShrTaskOperation;
import com.kingdee.eas.base.ssc.SatisfactionDimensionEntryFactory;
import com.kingdee.eas.base.ssc.SatisfactionDimensionEntryInfo;
import com.kingdee.eas.base.ssc.tool.H;
import com.kingdee.eas.base.ssc.tool.ShareCenterPermissionOrgUtil;
import com.kingdee.eas.base.ssc.tool.ShareCenterUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShrTaskOperation_GETSATISFACTIONDATA
implements ShrTaskOperation {
    private static final Logger logger = LoggerFactory.getLogger(ShrTaskOperation_GETSATISFACTIONDATA.class);
    private static final String TOTAL_SATIS = "totalSatis";

    @Override
    public Object operation(Context ctx, Map<String, Object> params) throws BOSException, EASBizException {
        logger.debug("ShrTaskOperation_GETSATISFACTIONDATA params:" + params);
        String startDate = (String)params.get("startDate");
        String endDate = (String)params.get("endDate");
        String shareCenter = (String)params.get("shareCenter");
        String dimensionId = (String)params.get("dimensionId");
        boolean defaultDimension = this.isDefaultDimension(ctx, dimensionId);
        String billTypeId = (String)params.get("billTypeId");
        StringBuffer sql = this.getSql(ctx, startDate, endDate, shareCenter, dimensionId, defaultDimension, billTypeId);
        logger.debug("ShrTaskOperation_GETSATISFACTIONDATA sql:" + sql);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList list = new ArrayList();
        try {
            while (rowSet.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                String fmy = StringUtils.cnulls((String)rowSet.getString("fmy"), (String)"0");
                String my = StringUtils.cnulls((String)rowSet.getString("my"), (String)"0");
                String yb = StringUtils.cnulls((String)rowSet.getString("yb"), (String)"0");
                String bmy = StringUtils.cnulls((String)rowSet.getString("bmy"), (String)"0");
                String fbmy = StringUtils.cnulls((String)rowSet.getString("fbmy"), (String)"0");
                map.put("exellent", fmy);
                map.put("contentment", my);
                map.put("ordinary", yb);
                map.put("dissatisfied", bmy);
                map.put("worst", fbmy);
                list.add(map);
            }
        }
        catch (SQLException e) {
            logger.error("ShrTaskOperation_GETSATISFACTIONDATA operation:" + e.getMessage(), (Throwable)e);
        }
        return list;
    }

    private StringBuffer getSql(Context ctx, String startDate, String endDate, String shareCenter, String dimensionId, boolean defaultDimension, String billTypeId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select max(temp.fmy) fmy,max(temp.my) my,max(temp.yb) yb,max(temp.bmy) bmy,max(temp.fbmy) fbmy from ( ");
        if (!defaultDimension) {
            sql.append(" select case when T2.FEvaluateResult = '0' then  sum(1) end as fmy, ");
            sql.append(" case when T2.FEvaluateResult = '1' then sum(1) end  as my, ");
            sql.append(" case when T2.FEvaluateResult = '2' then sum(1) end  as yb, ");
            sql.append(" case when T2.FEvaluateResult = '3' then sum(1)  end  as bmy, ");
            sql.append(" case when T2.FEvaluateResult = '4' then sum(1)  end  as fbmy ");
            sql.append(" from T_SSC_SatisfactionBillInquire T1 left join T_SSC_StfcBillInquireDimsEntry T2 on T1.FID = T2.FParent where FIsEvaluate='1' ");
        } else {
            sql.append(" select case when T1.FEvaluateResult = '0' then  sum(1) end as fmy, ");
            sql.append(" case when T1.FEvaluateResult = '1' then sum(1) end  as my, ");
            sql.append(" case when T1.FEvaluateResult = '2' then sum(1) end  as yb, ");
            sql.append(" case when T1.FEvaluateResult = '3' then sum(1)  end  as bmy, ");
            sql.append(" case when T1.FEvaluateResult = '4' then sum(1)  end  as fbmy ");
            sql.append(" from T_SSC_SatisfactionBillInquire T1 where FIsEvaluate='1' ");
        }
        if (!StringUtils.isEmpty((String)billTypeId)) {
            sql.append(" and fbilltypeid in ('");
            sql.append(billTypeId.replaceAll(",", "','")).append("') ");
        }
        if (!StringUtils.isEmpty((String)startDate)) {
            sql.append(" and fevaluateOfdate >=").append(this.dateToTsDate(startDate));
            sql.append(" and fevaluateOfdate <=").append(this.dateToTsDate(endDate));
        }
        if (!StringUtils.isEmpty((String)shareCenter)) {
            sql.append(" and fshareCenterId in (" + shareCenter + ")");
        } else {
            String EASUserId = ShareCenterUtils.getEASUserInfoByCtx((Context)ctx);
            String shareCenterIDs = ShareCenterPermissionOrgUtil.getPermissionOrg((Context)ctx, (String)EASUserId, (String)"fffffff0-ffff-efff-e22e-000000050525PERMITEM");
            sql.append(" and fshareCenterId in (" + shareCenterIDs + ")");
        }
        if (!defaultDimension) {
            sql.append(" and T2.FDimension = '" + dimensionId + "'");
            sql.append(" group by T2.FEvaluateResult )temp ");
        } else {
            sql.append(" group by T1.FEvaluateResult )temp ");
        }
        return sql;
    }

    private String dateToTsDate(String dateStr) {
        String result = null;
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date parse = format.parse(dateStr);
            result = "{ts'" + format.format(parse) + "'}";
        }
        catch (Exception e) {
            logger.error("dateToTsDate :" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private boolean isDefaultDimension(Context ctx, String dimensionId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)dimensionId)) {
            return true;
        }
        SatisfactionDimensionEntryInfo satisfactionDimensionEntryInfo = SatisfactionDimensionEntryFactory.getLocalInstance((Context)ctx).getSatisfactionDimensionEntryInfo(H.PK((Object)dimensionId));
        return satisfactionDimensionEntryInfo.getNumber().equals(TOTAL_SATIS);
    }
}

