/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.shrssc.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.shrssc.ShrTaskOperation;
import com.kingdee.eas.base.shrssc.util.ShrTaskOperationUtil;
import com.kingdee.eas.base.ssc.UserFactory;
import com.kingdee.eas.base.ssc.UserInfo;
import com.kingdee.eas.base.ssc.tool.FormatUtils;
import com.kingdee.eas.base.ssc.tool.H;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShrTaskOperation_GETUSERTASKRANK
implements ShrTaskOperation {
    private static final Logger logger = LoggerFactory.getLogger(ShrTaskOperation_GETUSERTASKRANK.class);

    @Override
    public Object operation(Context ctx, Map<String, Object> params) throws BOSException, EASBizException {
        int rows = params.get("rows") == null ? 5 : Integer.parseInt(params.get("rows").toString());
        int page = params.get("page") == null ? 1 : Integer.parseInt(params.get("page").toString());
        int begin = (page - 1) * rows + 1;
        String startDate = (String)params.get("startDate");
        String endDate = (String)params.get("endDate");
        String adminId = (String)params.get("userId");
        String bussAttr = (String)params.get("bussAttr");
        boolean isManageOrgControl = ShrTaskOperationUtil.isManageOrgControl(ctx);
        String planing = "";
        planing = isManageOrgControl ? FormatUtils.list2Sql((List)this.getUserByAdminBizAndOrg(ctx, adminId)) : FormatUtils.list2Sql(this.getBizByAdminPlaning(ctx, adminId));
        planing = StringUtils.isEmpty((String)planing) ? "('')" : planing;
        StringBuffer sb = new StringBuffer();
        int beginSql = begin - 1;
        String userDealSql = "SELECT top " + rows + "," + beginSql + "  u.FNAME_l2 as userName,count(jobhis.FID) as dealNum,u.FNUMBER as userNum ";
        sb.append("  from T_SSC_JobHis jobhis ");
        sb.append("  left outer join  t_ssc_user u ");
        sb.append("  on jobhis.FPersonnelIDID = u.fid ");
        sb.append(" where u.fid in" + planing);
        if (!StringUtils.isEmpty((String)bussAttr)) {
            sb.append(" and jobhis.FBussAttrIDID in ('" + bussAttr.replaceAll(",", "','") + "') ");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (!StringUtils.isEmpty((String)"startDate") && StringUtils.isEmpty((String)"endDate")) {
            startDate = this.dateToTsDate(startDate);
            sb.append(" and jobhis.FCompleteTme >= " + startDate);
        } else if (StringUtils.isEmpty((String)"startDate") && !StringUtils.isEmpty((String)"endDate")) {
            endDate = this.dateToTsDate(endDate);
            sb.append(" and jobhis.FCompleteTme <= " + endDate);
        } else if (!StringUtils.isEmpty((String)"startDate") && !StringUtils.isEmpty((String)"endDate")) {
            startDate = this.dateToTsDate(startDate);
            endDate = this.dateToTsDate(endDate);
            sb.append(" and jobhis.FCompleteTme <= " + endDate + " and jobhis.FCompleteTme >= " + startDate);
        }
        String whereCauseSql = sb.toString();
        sb.append(" group by u.FNAME_l2,u.FNUMBER ");
        sb.append(" order by dealNum desc,u.FNUMBER desc");
        userDealSql = userDealSql + sb.toString();
        String groupCountSql = "select count(distinct u.FNUMBER) " + whereCauseSql;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)userDealSql, (Object[])new Object[0]);
        IRowSet grouprs = DbUtil.executeQuery((Context)ctx, (String)groupCountSql, (Object[])new Object[0]);
        logger.debug("sql:" + sb.toString());
        ArrayList efficiencyList = new ArrayList();
        int total = 0;
        try {
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("userName", rs.getString(1));
                map.put("dealNum", rs.getString(2));
                map.put("userNum", rs.getString(3));
                efficiencyList.add(map);
            }
            while (grouprs.next()) {
                total = grouprs.getInt(1);
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (efficiencyList.size() > 0) {
            String rankSql = "/*dialect*/ SELECT u.FNUMBER as userName,dense_rank() OVER(order by count(jobhis.FID) desc) as rank " + whereCauseSql + " group by u.FNUMBER";
            IRowSet rank = DbUtil.executeQuery((Context)ctx, (String)rankSql, (Object[])new Object[0]);
            HashMap<String, String> rankMap = new HashMap<String, String>();
            try {
                while (rank.next()) {
                    rankMap.put(rank.getString(1), rank.getString(2));
                }
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            for (int i = 0; i < efficiencyList.size(); ++i) {
                Map efficientMap = (Map)efficiencyList.get(i);
                Object userName = efficientMap.get("userNum");
                efficientMap.put("rank", rankMap.get(userName));
            }
        }
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        result.put("efficiencyPaging", efficiencyList);
        result.put("total", Integer.valueOf(total));
        return result;
    }

    private List getUserByAdminBizAndOrg(Context ctx, String adminId) throws EASBizException {
        ArrayList<String> bizList = new ArrayList<String>();
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("select distinct a.FID from t_ssc_user a ");
            sb.append("inner join T_SSC_ROLEUSER b on a.FID = b.FUSERIDID ");
            sb.append("inner join T_SSC_ROLE role  on role.fid = b.FROLEIDID ");
            sb.append("inner join T_SSC_RoleType c on c.FID = role.FROLETYPEIDID ");
            sb.append("inner join t_ssc_roleorg d on b.FROLEIDID = d.FROLEIDID ");
            sb.append("inner join T_SSC_ROLEBUSSATTR rb on rb.FPARENTID = role.FID  ");
            sb.append("where c.fid = 'F68lZzqpRWC1K1nV8ZYPgS0WZ4A=' and role.FNUMBER NOT LIKE '%addForCompel%' and a.FSHARECENTERID = ? ");
            sb.append("and exists ( ");
            sb.append("select 1 from ( ");
            sb.append("select  rb.FBUSSNAMEID,d.FORGIDID  from t_ssc_user a ");
            sb.append("inner join T_SSC_ROLEUSER b on a.FID = b.FUSERIDID ");
            sb.append("inner join T_SSC_ROLE role  on role.fid = b.FROLEIDID ");
            sb.append("inner join T_SSC_RoleType c on c.FID = role.FROLETYPEIDID ");
            sb.append("inner join t_ssc_roleorg d on b.FROLEIDID = d.FROLEIDID ");
            sb.append("inner join T_SSC_ROLEBUSSATTR rb on rb.FPARENTID = role.FID  ");
            sb.append("where a.fid = ? and c.fid = 'hEw8bwRNR8qPRPajcUdX4C0WZ4A=' and role.FNUMBER NOT LIKE '%addForCompel%'  and a.FSHARECENTERID = ? ");
            sb.append(") temp where rb.FBUSSNAMEID = temp.FBUSSNAMEID  and d.FORGIDID = temp.FORGIDID ");
            sb.append(") ");
            UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo(H.PK((Object)adminId));
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{userInfo.getShareCenterId(), adminId, userInfo.getShareCenterId()});
            while (rs.next()) {
                bizList.add(rs.getString(1));
            }
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return bizList;
    }

    private List<String> getBizByAdminPlaning(Context ctx, String adminId) throws EASBizException {
        long startTime = System.currentTimeMillis();
        ArrayList<String> bizList = new ArrayList<String>();
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("  select distinct users.FID id ");
            sb.append("    from t_ssc_user users ");
            sb.append("   inner join T_SSC_ROLEUSER ru ");
            sb.append("      on users.fid = ru.FUSERIDID ");
            sb.append("   inner join T_SSC_ROLE role ");
            sb.append("      on role.fid = ru.FROLEIDID ");
            sb.append("   inner join T_SSC_ROLETYPE ty ");
            sb.append("      on ty.fid = role.FROLETYPEIDID ");
            sb.append("   inner join T_SSC_ROLEBUSSATTR rb ");
            sb.append("      on rb.FPARENTID = role.FID ");
            sb.append("   inner join T_SSC_BUSSINESSATTRIBUTE bs ");
            sb.append("      on bs.fid = rb.FBUSSNAMEID ");
            sb.append("   where users.FSHARECENTERID = ? ");
            sb.append("     and ty.FID = 'F68lZzqpRWC1K1nV8ZYPgS0WZ4A=' ");
            sb.append("     and role.FNUMBER NOT LIKE '%addForCompel%' ");
            sb.append("     and bs.FID in ");
            sb.append("         (select distinct bs.FID ");
            sb.append("            from t_ssc_user users ");
            sb.append("           inner join T_SSC_ROLEUSER ru ");
            sb.append("              on users.fid = ru.FUSERIDID ");
            sb.append("           inner join T_SSC_ROLE role ");
            sb.append("              on role.fid = ru.FROLEIDID ");
            sb.append("           inner join T_SSC_ROLETYPE ty ");
            sb.append("              on ty.fid = role.FROLETYPEIDID ");
            sb.append("           inner join T_SSC_ROLEBUSSATTR rb ");
            sb.append("              on rb.FPARENTID = role.FID ");
            sb.append("           inner join T_SSC_BUSSINESSATTRIBUTE bs ");
            sb.append("              on bs.fid = rb.FBUSSNAMEID ");
            sb.append("          where users.FID = ? ");
            sb.append("            and ty.FID = 'hEw8bwRNR8qPRPajcUdX4C0WZ4A=' ");
            sb.append("            and role.fnumber not like '%addForCompel%') ");
            UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo(H.PK((Object)adminId));
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{userInfo.getShareCenterId(), adminId});
            while (rs.next()) {
                bizList.add(rs.getString(1));
            }
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        long endTime = System.currentTimeMillis();
        return bizList;
    }

    private String dateToTsDate(String dateStr) {
        String result = null;
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date parse = format.parse(dateStr);
            result = "{ts'" + format.format(parse) + "'}";
        }
        catch (Exception e) {
            logger.error("dateToTsDate :" + e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

